function [me, s2] = ddm_pred_mc2(sd, covfunc, affine)
%
% Predict the regression values at testing inputs. Usage:
%     [me, s2] = ddm_pred_mc2(sd, covfunc, affine)
% where 
%     sd:      a structure containing information about a subdomain 
%     covfunc: prior covariance function 
%     affine:  affine transformation function that transforms the global
%              coordinates into the local coordinates in sd
%     me:      prediction mean values
%     s2:      prediction variances
% 
% Copyright (c) by Chiwoo Park, 2011-06-07

if size(sd.tx, 1) == 0
    me = []; s2 = [];
    return;
end

x    = affine(sd.x, sd); % training inputs
xt   = affine(sd.tx, sd); % testing inputs

[Kxx, K_ix] = feval(covfunc{:}, sd.logtheta, x, xt);
[Kxx, K_qx] = feval(covfunc{:}, sd.logtheta, affine(sd.gx, sd), xt);

xx1    = diag(1./sqrt(diag(K_qx' * K_qx))) * K_qx';  
xx2    = diag(1./diag(K_ix' * K_ix)) * K_ix' * sd.K_iq;
xx     = xx1.*xx2;
me     = K_ix' * sd.h_i + xx*sd.S';

if nargout > 1
    sig2 = exp(2*sd.logtheta(end));
    v    = sd.S * xx'; 
    s2   = sig2 + Kxx - diag(K_ix' *  sd.isigK * K_ix - v' * v / sd.yKy);
end
