function [mu, s2, elapsed] = ddm_pred_mc(xs, model)

% ddm_pred: predictive distribution for the domain decomposition approach
% given hyperparameters
%
% xs       test inputs
% model    trained model
% mu       predictive mean
% s2       predictive variance of latent function
% elapsed  the total time spent on prediction
%
% Copyright (c) by Chiwoo Park, 2011-06-07

cv_param = model.cv_param;
affine   = model.affine;

subdomains = addTestSet(model.subdomains, model.memberFunc, xs);
ns = size(xs,1);
N  = size(subdomains, 1);
mu = zeros(ns, 1); s2 = zeros(ns, 1);
tic;
for i = 1:N
    sd = subdomains{i};
    if sum(sd.tsegI) > 0   %update if there are test inputs in the current 
                           %                                     subdomain
        [mu_i, s2_i] = ddm_pred_mc2(sd, cv_param.covfunc, affine);
        mu(sd.tsegI, :) = mu_i; s2(sd.tsegI, :) = s2_i;
    end
end
elapsed = toc;