function [sd] = ddm_local_mc(sd, param, bpts, dof, V, affine)
% 
% Perform all pre-computations necessary for learning local models for
% subdomains; estimating the local hyperparameters of the prior covariance 
% function and computing some inverses of kernel matrices. Usage:
%     [sd] = ddm_local_mc(sd, param, bpts, affine)
%
% where 
%      
%     sd:    a structure containing information about a subdomain 
%     param: a structure containing information about the prior covariance
%            function used for Gaussian process regression.
%     bpts:  the number of locations to check the continuity of 
%            predictions on a boundary
%     affine:  affine transformation function that transforms the global
%              coordinates into the local coordinates in sd
%
% Copyright (c) by Chiwoo Park, 2011-06-07

iTk     = @(x1, x2, n) [x1(1) + (x2(1) - x1(1))*(1:1:(n-1))'/n, x1(2) + ...
                                           (x2(2) - x1(2))*(1:1:(n-1))'/n];

if param.local == 0 % local hyperparameter learning
    ra = 1/param.frachyper;
    while true
        [dum, idx] = sort(rand(sd.n,1)); clear dum;
        idx = idx(1:round(sd.n/ra));
        sd.logtheta = minimize(param.logtheta, 'loglikelihood',param.nIter, ...
                    param.covfunc, affine(sd.x(idx, :), sd), sd.y(idx, :));
        sd.sigK     = feval(param.covfunc{:}, sd.logtheta, affine(sd.x, sd)); 
        if rcond(sd.sigK) < 1e-9
            disp('retry...');
            ra = ra + 0.1;
            continue;
        end
        break;
    end
else % use global hyperparameter 
    sd.logtheta = param.logtheta;
    % evaluate the kernel covariance matrix at training inputs
    sd.sigK     = feval(param.covfunc{:}, sd.logtheta, affine(sd.x,sd));
end

n_intf   = sd.int_idx(length(sd.int_idx));
gx_block = cell(1,n_intf); 
rx_block = cell(1,n_intf); int_pts = dof - 1; 
gx = zeros(n_intf*(bpts-1), 2);  temp = zeros(n_intf, 2); r = 0;                               
for j = 1:n_intf
    interface = sd.interface{j};
    [twoends, ia] = intersect(sd.T, interface.x);
    temp(j, :) = ia;
    gx((j-1)*(bpts-1)+(1:bpts-1), :) = iTk(sd.box(ia(1),:), ...
                                                   sd.box(ia(2),:), bpts);
    mask = zeros(1, bpts+1);
    mask(2:bpts) = r + (1:(bpts-1));
    gx_block{j} = mask;
    mask = zeros(1, int_pts+2);
    mask(:) = [interface.x(1), V+int_pts*(sd.int_idx(j)-1)+(1:int_pts), ...
                                                       interface.x(2)];
    rx_block{j} = mask;
    r = r + bpts - 1;
end
sd.gx_idx   = unique(temp(:));
gx = [gx; sd.box(sd.gx_idx,:)];
sd.gx = gx;

for j = 1:n_intf
    qi = find(sd.gx_idx == temp(j,1));
    qj = find(sd.gx_idx == temp(j,2));
        gx_block{j}(1) = r + qi;
    gx_block{j}(length(gx_block{j})) = r + qj;
end
sd.q        = size(gx, 1);
sd.gx_block = gx_block;
sd.rx_block = rx_block;

[dum, K_iq]   = feval(param.covfunc{:}, sd.logtheta, affine(sd.x, sd),...
                       affine(gx, sd));
[dum, K_qq]   = feval(param.covfunc{:}, sd.logtheta, affine(gx, sd), ...
                       affine(gx, sd));
B1 = K_qq * diag(1./sqrt(diag(K_qq' * K_qq)));
B2 = K_iq'* K_iq * diag(1./diag(K_iq' * K_iq));

sd.K_iq   = K_iq;
sd.G_i    = inv(B1.*B2);
sd.isigK  = inv(sd.sigK);
sd.h_i    = sd.isigK * sd.y;
sd.yKy    = sd.y' * sd.h_i;
end