function r = ddm_bound_mc(subdomains, interfaces, dof, bpts, iT_q2, covfunc, affine)
% 
% Compute the common prediction values at bpts boundary points
% by taking the weighted average of predictions from two neighboring local
% Gaussian process regression models. In order to understand the rationale 
% behind the weighted average, please refer to the following paper:
%
%   Park et al. (2011), 'Domain Decomposition Approach for Fast Gaussian 
%     Process Regression of Large Spatial Datasets', Journal of Machine 
%     Learning Research, vol 12.
%
% Copyright (c) by Chiwoo Park, 2011-06-07

global M
global V

int_pts= dof-1;
rowIdx = @(m) [interfaces{m}.x(1), V+int_pts*(m-1)+(1:int_pts), interfaces{m}.x(2)];
iTk    = @(x1, x2, n) [x1(1) + (x2(1) - x1(1))*(0:n)'/n, x1(2) + ...
                                           (x2(2) - x1(2))*(0:n)'/n];
r = zeros(V+int_pts*M, 1);
for m = 1:M
    interface = interfaces{m};
    o_i       = subdomains{interface.i};  
    o_j       = subdomains{interface.j};
    interface.rowI = rowIdx(m); interfaces{m} = interface;
    [twoends, ia] = intersect(o_i.T, interface.x);
    x0 = iTk(o_i.box(ia(1),:), o_i.box(ia(2),:), bpts);
                             
    me_i = localGP_pred_mc(x0, o_i, covfunc, affine);
    me_j = localGP_pred_mc(x0, o_j, covfunc, affine);
    r(rowIdx(m), :) = iT_q2 * (o_j.yKy * me_i + o_i.yKy * me_j)/(o_i.yKy + o_j.yKy);
end