% This page explains how to write your own mesh generation function for
% domain decomposition. The mesh generation function (mgf) should have the
% following format:
% 
% [subdomains, interfaces, vertices, memberFunc, affine] 
%                                          = meshFunction(param, x, y, idx)
% 
% which has the input parameters 
%     x         : n by 2 matrix of training inputs
%     y         : column vector of length n of training targets
%     idx       : n by 1 logical mask to indicate the subset of training 
%                 data used for learning the hyperparameters.
%     param     : a structure containing additional parameters used for
%                 generating meshes in your own way; so this structure can
%                 be defined in your own way. 
% 
% 1) The first job which 'meshFunction' needs to do is to define individual 
% meshes. The definition is stored in the first output value of 'meshFunction', 
% 'subdomains'. The output is of cell array type in MATLAB. Each element of 
% the cell array is of 'structure' data type, which contains the definition
% of a mesh (or so called subdomain). In other words, 
%
%      if sd_i is a structure containing the definition of the ith
%      subdomain, subdomains{i} = sd_i.
% 
% A subdomain has a polygonal boundary, and the boundary is defined by a 
% set of vertex coordinates of the polygon. The 'vertices' output value of
% the mgf MUST be a V-by-2 matrix, containing a set of all vertex
% coordinates of all subdomains. 
%
%    vertices  a set of all vertex coordinates of all subdomains
% 
% The vertex coordinates of the ith subdomain's boundary are indexed by 
% field 'T' of sd_i,
%
% sd_i.T       a row vector containing the indices of the vertices at 
%              'vertices' output value, which corresponds to polygon 
%              vertices of the ith subdomain boundary
%
% The fields of sd_i related to sd_i.T are:
%
% sd_i.n       the number of the training inputs inside the polygonal
%              boundary specified by sd_i.T
% sd_i.x       sd_i.n by 2 matrix of the training inputs
% sd_i.y       column vector of length sd_i.n of the training targets
%              corresponding to sd_i.x
% sd_i.hx      a subset of sd_i.x used for the hyperparameter learning
% sd_i.hy      the training targets corresponding to sd_i.hx
% 
% 2) The second job performed by 'meshFunction' is to define a set of the
% common boundaries shared by pairs of neighboring subdomains. Each common
% boundary is called 'interface'. The second output value of 'meshFunction'
% is a M-by-1 cell array, containing a set of interfaces. The jth element 
% of the cell array, denoted by int_j, is of structure data type, 
% containing the definition of the jth interface. In other words, 
% 
%     interfaces{j} = int_j 
%
% int_j has several fields: 
% 
%    int_j.i   the index for the first one of two neighboring subdomains
%              within 'subdomains' output value
%    int_j.j   the index for the second subdomain (always, int_j.i < int_j.j)
%    int_j.x   a 1-by-2 array containing the vertex indices at 'vertices' 
%              output value, which corresponds to two end points of the jth 
%              interface
% 
% 3) In addition, 'meshFunction' stores the indices of the interfaces 
% related to the ith subdomain into sd_i as follows:
%  
%    sd_i.int_idx   a row vector containing the interface indices at 
%                   'interfaces' output value, which are parts of the ith 
%                   subdomain boundaries; its last element is the number of
%                   the interface indices stored in this row vector.
%    sd_i.neighbors a row vector containing the subdomain indices at
%                   'subdomain' output value, which corresponds to the 
%                   subdomains neighboring to the ith subdomain; its last
%                   element is the number of the subdomain indices stored
%                   in this row vector. 
%
% 4) 'meshFunction' returns the following MATLAB function references:
%
%     memberFunc: a membership function to check if data x belongs to 
%                 subdomain sd (usage: memberFunc(x, sd))
%     affine    : affine transformation that transforms the global 
%                 coordinates x  into the local coordinates in subdomain sd 
%                 (usage: affine(x, sd))
% 
% Copyright (c) by Chiwoo Park, 2011-06-07