function [mu, s2, elapsed] = lpr_pred(xs, model)

% lpr_pred: predictive distribution for the local probablistic regression 
% approach given hyperparameters
%
% xs       test inputs
% model    training model
% mu       predictive mean
% s2       predictive variance of latent function
% elapsed  the total time spent on prediction
%
% Copyright (c) by Chiwoo Park, 2011-06-07

param = model.param;
x     = model.x; y = model.y;
Tree_x = model.Tree_x;
Tree_r = model.Tree_r;
logtheta = model.logtheta;
covfunc  = param.covfunc;
T = param.T;
S = param.S; 

ver = version('-release');
if isempty(str2num(ver(1:4)))
    KdtreeInMatlab = 0;
else
    KdtreeInMatlab = (str2num(ver(1:4)) >= 2011);
end

ns = size(xs, 1); mu = zeros(ns, 1); s2 = zeros(ns, 1);
tic
for i = 1:ns
    mu_i = zeros(T, 1); s2_i = zeros(T, 1);
    if KdtreeInMatlab
        eta = knnsearch(Tree_x, xs(i, :),'k',T);
    else
        eta = kdtree_k_nearest_neighbors(Tree_x, xs(i, :)', T);
    end
    
    for j = 1:T
        eta_j = eta(j);
        if KdtreeInMatlab
            t   = knnsearch(Tree_r, y(eta_j, :) ,'k', 1);
            idx = knnsearch(Tree_x, x(eta_j, :) ,'k', S);
        else
            t   = kdtree_nearest_neighbor(Tree_r, y(eta_j, :));
            idx = kdtree_k_nearest_neighbors(Tree_x, x(eta_j, :)', S);
        end
        logtheta_j = logtheta{t};
        
        K           = feval(covfunc{:}, logtheta_j, x(idx, :));
        [K_tt, K_xt] = feval(covfunc{:}, logtheta_j, x(idx, :), xs(i, :)); 
        sig2 = exp(2*logtheta_j(end));
        
        L = chol(K, 'lower');
        alpha_j = L \ y(idx, :);
        K_j     = L \ K_xt;
        mu_i(j) = K_j' * alpha_j;
        s2_i(j) = sig2 +  K_tt - K_j' * K_j;
    end
    pi_i = (1./s2_i) / sum(1./s2_i);
    mu(i) = sum(pi_i.*mu_i);
    s2(i) = sum((pi_i.^2).*s2_i);
end
elapsed = toc;