function [loglike, dloglike] = loglikelihood(logtheta, covfunc, x, y)
%
% loglikelihood - The function returns minus the log likelihood and its partial derivatives with
% respect to the hyperparameters; this mode is used to fit the hyperparameters.
%
% where:
%   logtheta is a (column) vector of log hyperparameters
%   covfunc  is the covariance function
%   x        is a n by D matrix of training inputs
%   y        is a (column) vector (of size n) of targets
% 
% (C) Copyright 2006 by Carl Edward Rasmussen (2006-03-24)

if ischar(covfunc), covfunc = cellstr(covfunc); end % convert to cell if needed
[n,D] = size(x);
K = feval(covfunc{:}, logtheta, x);    % compute training set covariance matrix

L = chol(K, 'lower');                  % cholesky factorization of the covariance
alpha = L' \ (L \ y);

loglike = 0.5*y'*alpha + sum(log(diag(L))) + 0.5*n*log(2*pi);

if nargout == 2               % ... and if requested, its partial derivatives
    dloglike = zeros(size(logtheta));       % set the size of the derivative vector
    W = L'\(L\eye(n))-alpha*alpha';                % precompute for convenience
    for i = 1:length(dloglike)
        dloglike(i) = sum(sum(W.*feval(covfunc{:}, logtheta, x, i)))/2;
    end
end
