clear
clc
addpath('./pic');
addpath('./mesh');
addpath('./cov');
addpath('./lik');
addpath('./etc');

% load ozone dataset (2D)
x = csvread('ozone_x.csv');
y = csvread('ozone_y.csv');
[dum,I]    = sort(rand(size(x,1),1)); clear dum;
t_idx      = ones(size(x,1),1); t_idx(I(1:round(size(x,1) * 0.1))) = 0; 
t_idx = logical(t_idx);

xs = x(~t_idx, :); ys = y(~t_idx, :);
x  = x(t_idx, :); y = y(t_idx, :);

% set the input parameters
d               = size(x, 2);

% starting values of log hyperparameters: 
logtheta0(1:d,1) = -2*log((max(x)-min(x))'/2); % log 1/(lengthscales)^2
logtheta0(d+1,1) = log(var(y,1)); % log size 
logtheta0(d+2,1) = log(var(y,1)/4); % log noise
param.logtheta0 = logtheta0; 

% fraction of training data used for learning hyperparameters
param.frachyper = 0.6;  
param.M         = 200;
param.K         = 300;

% execute the main logic
[model, train, test, mu, s2, mse, nlpd] = picGP(x, y, param, xs, ys);
fprintf('training time = %-8.4f seconds\n',train);
fprintf('test time = %-8.4f seconds\n',test);
fprintf('mse = %-8.4f\n',mse);
fprintf('nlpd = %-8.4f\n',nlpd);
