clc
clear

% add library path 
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

% load data & subsample to a training dataset
x = csvread('ozone_L2_x.csv');
y = csvread('ozone_L2_y.csv');
xs = csvread('ozone_gr_x.csv');
ys = csvread('ozone_gr_y.csv');

% set the input parameters regarding domain decomposition
dd_param.meshfunc = 'rectMesh';   %mesh generation function
dd_param.mparam   = [30 20];      %mesh generation function parameters (mesh size)
dd_param.p        = 2;            %degree of freedom for boundary element
dd_param.q        = 2;            %the number of locations to check the 
                                  %continuity of prediction over boundary

% set the input parameters regarding prior covariance function
% cv_param.covfunc: prior covariance function = squared covariance function
% + noise covariance function
cv_param.covfunc  = {'covSum', {'covSEard','covNoise'}}; 
d                = size(x, 2);
logtheta0        = 0*ones(d+2,1); % starting values of log hyperparameters:
                                  %   log (\lambda_1,..,\lambda_d, rho)
                                  % for square covariance function    
logtheta0(d+2)   = -1.15; % starting value for log(noise std dev): log 
                          % sigma^2 for noise covariance function             
cv_param.logtheta0 = logtheta0; 
% fraction of training data used for learning hyperparameters
cv_param.frachyper = 0.5;              

% execute the main logic
[model, train, test, mu, s2, mse, nlpd] = ddmGP(x, y, dd_param,cv_param, xs, ys);
fprintf('training time = %-8.4f seconds\n',train);
fprintf('test time = %-8.4f seconds\n',test);
fprintf('mse = %-8.4f\n',mse);
fprintf('nlpd = %-8.4f\n',nlpd);