% add library path 
addpath('./pddm-multinode')
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

global comm; % communication channel
global my_rank

% Initialize MPI (Message Passing Interface) for MATLAB or Octave.
MPI_Init;

% Create communicator.
comm = MPI_COMM_WORLD;

% Get rank.
my_rank = MPI_Comm_rank(comm);

% load data
disp('loading data files...');
x = csvread('ozone_L2_x.csv');
y = csvread('ozone_L2_y.csv');
xs = csvread('ozone_gr_x.csv');
ys = csvread('ozone_gr_y.csv');

% Subsample the training dataset for efficient hyperparameter learning
% Make sure that every node has the same training/test dataset as well as
% the same subsample used for the hyperparameter learning. 
disp('generating a random subset used for learning hyperparameters...');
[indices] = gen_random_subset(size(x,1), [0.2]);
idx       = indices{1};

% set the input parameters regarding domain decomposition
dd_param.meshfunc = 'rectMesh';   %mesh generation function
dd_param.mparam   = [30 20];      %mesh generation function parameters (mesh size)
dd_param.p        = 2;            %degree of freedom for boundary element
dd_param.q        = 2;            %the number of locations to check the 
                                  %continuity of prediction over boundary

% set the input parameters regarding prior covariance function
% prior covariance function
cv_param.covfunc   = {'covSum', {'covSEard','covNoise'}}; 
d                  = size(x, 2);
% starting values of log hyperparameters: log (\lambda_1,..,\lambda_d, rho) for Square Covariance Function
logtheta0          = 0*ones(d+2,1);       
% starting value for log(noise std dev): log sigma^2 for Noise Covariance Function
logtheta0(d+2)     = -1.15;               
cv_param.logtheta0 = logtheta0; 
cv_param.idx       = idx; 

disp('starting the main logic...');
% execute the main logic
if my_rank == 0
    [model, train, test, mu, s2, mse, nlpd] = ddmGP_mn(x, y, dd_param, cv_param, xs, ys);
    fprintf('training time = %-8.4f seconds\n',train);
    fprintf('test time = %-8.4f seconds\n',test);
    fprintf('mse = %-8.4f\n',mse);
    fprintf('nlpd = %-8.4f\n',nlpd);
else
    ddmGP_mn(x, y, dd_param, cv_param, xs, ys);
end

% Finalize Matlab MPI.
MPI_Finalize;
disp('SUCCESS');
if (my_rank ~= MatMPI_Host_rank(comm))
  exit;
end
