clc
clear

% add library path 
addpath('./pddm-multicore')
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

% open pool of MATLAB sessions for parallel computation 
if matlabpool('size') == 0
    matlabpool open 8 
end

% load data & subsample to a training dataset
x = csvread('ozone_L2_x.csv');
y = csvread('ozone_L2_y.csv');
xs = csvread('ozone_gr_x.csv');
ys = csvread('ozone_gr_y.csv');

% set the input parameters regarding domain decomposition
dd_param.meshfunc = 'rectMesh';   %mesh generation function
dd_param.mparam   = [30 20];      %mesh generation function parameters 
                                  %   (the total number of meshes per each
                                  %   spatial dimension)
dd_param.p        = 2;            %degree of freedom for boundary element
dd_param.q        = 2;            %the number of locations to check the 
                                  %continuity of prediction over boundary

% set the input parameters regarding prior covariance function
cv_param.covfunc  = {'covSum', {'covSEard','covNoise'}}; % prior covariance function
d                = size(x, 2);
logtheta0        = 0*ones(d+2,1);       % starting values of log hyperparameters: log (\lambda_1,..,\lambda_d, rho) for Square Covariance Function
logtheta0(d+2)   = -1.15;               % starting value for log(noise std dev): log sigma^2 for Noise Covariance Function
cv_param.logtheta0 = logtheta0; 
cv_param.frachyper = 0.2;               % fraction of training data used for learning hyperparameters

% train the GP model
[model, train] = ddmGP_mc(x, y, dd_param, cv_param);
fprintf('training time = %-8.4f seconds\n',train);

% test the model
[mu, s2, test] = ddm_pred_mc(xs, model);

%compute MSE & NLPD
ns   = size(xs,1);
se   = (ys - mu)' * (ys - mu);
nlpd = sum(0.5*(log(2*pi*s2) + ((ys - mu).^2)./s2));
mse  = se / ns;
nlpd = nlpd / ns;

fprintf('training time = %-8.4f seconds\n',train);
fprintf('test time = %-8.4f seconds\n',test);
fprintf('mse = %-8.4f\n',mse);
fprintf('nlpd = %-8.4f\n',nlpd);