clc
clear

% add library path 
addpath('./ddm')
addpath('./mesh')
addpath('./cov')
addpath('./lik')
addpath('./etc')

% load data & subsample to a training dataset
x = csvread('ozone_x.csv');
y = csvread('ozone_y.csv');
[dum,I]    = sort(rand(size(x,1),1)); clear dum;
t_idx      = ones(size(x,1),1); t_idx(I(1:round(size(x,1) * 0.1))) = 0; 
t_idx = logical(t_idx);

xs = x(~t_idx, :); ys = y(~t_idx, :);
x  = x(t_idx, :); y = y(t_idx, :);

% set the input parameters regarding domain decomposition
dd_param.meshfunc = 'rectGrid';   % mesh generation function
dd_param.mparam   = [14 21];      % mesh generation function parameters 
                                  % (mesh size)
dd_param.p        = 3;            % degree of freedom for boundary element
dd_param.q        = 3;            % the number of locations to check the 
                                  % continuity of prediction over boundary

% set the input parameters regarding prior covariance function
% cv_param.covfunc: prior covariance function = squared covariance function
% + noise covariance function
cv_param.covfunc  = {'covSum', {'covSEard','covNoise'}}; 
d                = size(x, 2);
logtheta0        = 0*ones(d+2,1); % starting values of log hyperparameters:
                                  %   log (\lambda_1,..,\lambda_d, rho)
                                  % for square covariance function    
logtheta0(d+2)   = -1.15; % starting value for log(noise std dev): log 
                          % sigma^2 for noise covariance function
cv_param.logtheta0 = logtheta0; 
% fraction of training data used for learning hyperparameters
cv_param.frachyper = 0.6;              
cv_param.local = 0; % do global hyperparameter learning

% execute the main logic
[model, train, test, mu, s2, mse, nlpd] = ddmGP(x, y, dd_param,cv_param, xs, ys);
fprintf('training time = %-8.4f seconds\n',train);
fprintf('test time = %-8.4f seconds\n',test);
fprintf('mse = %-8.4f\n',mse);
fprintf('nlpd = %-8.4f\n',nlpd);