clear
clc
addpath('./bgp');
addpath('./cov');
addpath('./lik');
addpath('./etc');
addpath('./etc/kdtree');

% load ozone dataset (2D)
x = csvread('ozone_x.csv');
y = csvread('ozone_y.csv');
[dum,I]    = sort(rand(size(x,1),1)); clear dum;
t_idx      = ones(size(x,1),1); t_idx(I(1:round(size(x,1) * 0.1))) = 0; 
t_idx = logical(t_idx);

xs = x(~t_idx, :); ys = y(~t_idx, :);
x  = x(t_idx, :); y = y(t_idx, :);

% set the input parameters
param.covfunc  = {'covSum', {'covSEard','covNoise'}}; % prior covariance function
d                 = size(x, 2);
logtheta0         = 0*ones(d+2,1); % starting values of log hyperparameters: 
%                                    log (\lambda_1,..,\lambda_d, rho) for 
%                                    Square Covariance Function
logtheta0(d+2)    = -1.15;  % starting value for log(noise std dev): 
                            %log sigma^2 for Noise Covariance Function
param.logtheta0 = logtheta0; 
param.frachyper = 0.5;  % fraction of training data used for learning 
                        % hyperparameters
param.M         = 300;
param.K         = 40;

% execute the main logic
[model, train, test, mu, s2, mse, nlpd] = baggingGP(x, y, param, xs, ys);
fprintf('training time = %-8.4f seconds\n',train);
fprintf('test time = %-8.4f seconds\n',test);
fprintf('mse = %-8.4f\n',mse);
fprintf('nlpd = %-8.4f\n',nlpd);
