function [loglike, dloglike] = loglikelihood_ddm(logtheta, covfunc, subdomains)
%
% loglikelihood_ddm - The function returns minus the log likelihood and its 
% partial derivatives with respect to the hyperparameters; this mode is 
% used to fit the hyperparameters.
%
% where:
%   logtheta:  a (column) vector of log hyperparameters
%   covfunc:   prior covariance function
%   subdomains: N-by-1 cell array, containing the information about 
%               the structure of domain decomposition
% 
% Copyright (c) by Chiwoo Park, 2011-06-07
global affine
N = size(subdomains, 1);

loglike = 0; dloglike = zeros(size(logtheta));
for i = 1:N
    sd = subdomains{i};
    [LL, dLL] = loglikelihood(logtheta, covfunc, affine(sd.hx, sd), sd.hy);
    loglike = loglike + LL;
    dloglike = dloglike + dLL;
end