function [me, s2] = ddm_pred2(sd, covfunc)
%
% Predict the regression values at testing inputs. Usage:
%     [me, s2] = ddm_pred(sd, covfunc)
% where 
%     sd:      a structure containing information about a subdomain 
%     covfunc: prior covariance function 
%     me:      prediction mean values
%     s2:      prediction variances
% 
% Copyright (c) by Chiwoo Park, 2011-06-07
global affine

x    = affine(sd.x, sd); % training inputs
xt   = affine(sd.tx, sd); % testing inputs

[Kxx, K_ix] = feval(covfunc{:}, sd.logtheta, x, xt);
[Kxx, K_qx] = feval(covfunc{:}, sd.logtheta, affine(sd.gx, sd), xt);

% numerical hanlding 
d1     = diag(K_qx' * K_qx); nz1 = logical(d1 ~= 0);
xx1    = K_qx';
xx1(nz1, :) = diag(1./sqrt(d1(nz1))) * xx1(nz1, :);
%xx1    = diag(1./sqrt(diag(K_qx' * K_qx))) * K_qx';  
d2     = diag(K_ix' * K_ix); nz2 = logical(d2 ~= 0);
xx2    = K_ix' * sd.K_iq;
xx2(nz2, :) = diag(1./d2(nz2)) * xx2(nz2, :);
%xx2 = diag(1./diag(K_ix' * K_ix)) * K_ix' * sd.K_iq;


xx     = xx1.*xx2;
me     = K_ix' * sd.h_i + xx*sd.S';

if nargout > 1
    sig2 = exp(2*sd.logtheta(end));
    v    = sd.S * xx'; 
    s2   = sig2 + Kxx - diag(K_ix' *  sd.isigK * K_ix - v' * v / sd.yKy);
end
