function [sd] = ddm_local(sd, param)
% 
% Perform all pre-computations necessary for learning local models for
% subdomains; estimating the local hyperparameters of the prior covariance 
% function and computing some inverses of kernel matrices. Usage:
%     [sd] = ddm_local(sd, param)
%
% where 
%      
%     sd:    a structure containing information about a subdomain 
%     param: a structure containing information about the prior covariance
%            function used for Gaussian process regression.
% 
% Copyright (c) by Chiwoo Park, 2011-06-07

global interfaces
global vertices
global iTk
global bpts
global affine

if param.local == 0 % local hyperparameter learning
    [dum, idx] = sort(rand(sd.n,1)); clear dum;
    idx = idx(1:round(sd.n*param.frachyper));
    sd.logtheta = minimize(param.logtheta, 'loglikelihood',param.nIter, ...
                param.covfunc, affine(sd.x(idx, :), sd), sd.y(idx, :));
    sd.sigK     = feval(param.covfunc{:}, sd.logtheta, affine(sd.x, sd)); 
else % use global hyperparameter 
    sd.logtheta = param.logtheta;
    % evaluate the kernel covariance matrix at training inputs
    sd.sigK     = feval(param.covfunc{:}, sd.logtheta, affine(sd.x,sd));
end

n_intf   = sd.int_idx(length(sd.int_idx));
gx_block = cell(1,n_intf); gx = zeros(n_intf*(bpts-1), 2); 
temp     = zeros(n_intf, 2); r = 0;
for j = 1:n_intf
    k = sd.int_idx(j);
    interface = interfaces{k};
    [twoends, ia] = intersect(sd.T, interface.x);
    temp(j, :) = ia;
    gx((j-1)*(bpts-1)+(1:bpts-1), :) = iTk(vertices(sd.T(ia(1)),:), ...
                                            vertices(sd.T(ia(2)),:), bpts);
    mask = zeros(1, bpts+1);
    mask(2:bpts) = r + (1:(bpts-1));
    r = r + bpts - 1;
    gx_block{j} = mask;
end
sd.gx_idx   = unique(temp(:));
gx = [gx; vertices(sd.T(sd.gx_idx),:)];
sd.gx = gx;

for j = 1:size(temp,1)
    qi = find(sd.gx_idx == temp(j,1));
    qj = find(sd.gx_idx == temp(j,2));
    gx_block{j}(1) = r + qi;
    gx_block{j}(length(gx_block{j})) = r + qj;
end
sd.q        = size(gx, 1);
sd.gx_block = gx_block;

[dum, K_iq]   = feval(param.covfunc{:}, sd.logtheta, affine(sd.x, sd),...
                       affine(gx, sd));
[dum, K_qq]   = feval(param.covfunc{:}, sd.logtheta, affine(gx, sd), ...
                       affine(gx, sd));
B1 = K_qq * diag(1./sqrt(diag(K_qq' * K_qq)));
% numerical handling if some elements in diag(K_iq' * K_iq) are zero,
v = diag(K_iq' * K_iq); nz_v = logical(v ~= 0);
B2 = K_iq' * K_iq;  
B2(nz_v, nz_v) = B2(nz_v, nz_v) * diag(1./v(nz_v));

sd.K_iq   = K_iq;
sd.G_i    = B1.*B2;

if rcond(sd.G_i) < 1e-6
    sd.G_i = inv(1e-6 * eye(sd.q) + sd.G_i);
else
    sd.G_i = sd.G_i \ eye(size(sd.G_i));
end
sd.isigK  = inv(sd.sigK);
sd.h_i    = sd.isigK * sd.y;
sd.yKy    = sd.y' * sd.h_i;
end