function [subdomains] = addTestSet(subdomains, memberFunc, xs, ys)
% The addTestSet function is used to classify each data point in the test
% dataset by its corresponding subdomain. 
%
% where 
%      subdomains: the information about the structure of subdomains after 
%                  domain decomposition
%      memberFunc: a membership function to check if data x belongs to 
%                  subdomain sd  (usage: memberFunc(x, sd))
%      xs:         ns by d matrix of test inputs
%      ys:         column vector of length ns of test targets
% 
% Copyright (c) by Chiwoo Park, 2011-06-07

N   = size(subdomains, 1);
for i = 1:N
    sd   = subdomains{i, 1};
    segI = memberFunc(xs, sd);
    sd.tsegI = segI;
    sd.tx    = xs(segI, :);
    if nargin > 3
        sd.ty    = ys(segI, :);
    end
    sd.tn    = size(sd.tx, 1);
    subdomains{i} = sd;
end