function [T] =LargrangeFE(t,d)
% Evaluate the Largrange finite element basis function of degree d at t 
% points evenly distributed. Usage:
%     [T] = LargrangeFE(t,d)
% where 
%       t: n testing points
%       d: degree of polynomials
%       T: finte element basis matrix (n by (d+1))
% 
% Copyright (c) by Chiwoo Park, 2011-06-07

n = size(t, 1);
T = ones(n, d+1);
pts = (0:d)/d;
for p = 1:(d+1)
    L = T(:, p);
    for q = 1:(d+1)
        if q ~= p
            L = L.*(t-pts(q)) / (pts(p) - pts(q));
        end
    end
    T(:, p) = L;
end