function [mu, s2] = bgp_pred(xs, model)

param   = model.param;
experts = model.experts;

mean_sum = 0;
var_sum  = 0;
for i = 1:param.K
    ex = experts{i};
    [Kxx, K_ix] = feval(param.covfunc{:}, ex.logtheta, ex.x, xs);
    LK_ix = ex.L_i * K_ix;
    me = LK_ix' * ex.h_i;
    sig2 = exp(2 * ex.logtheta(end));
    s2   = sig2 + Kxx - sum(LK_ix.^2)';
    mean_sum = mean_sum + me./s2;
    var_sum  = var_sum + 1./s2;
end
s2  = 1./var_sum;
mu = mean_sum .* s2;