#ifndef FF2DESIGN_H
#define FF2DESIGN_H

#include <vector>
#include <iostream>
#include "nauty/nauty.h"


using namespace std;

class FF2Design
{
private:
	vector<bool> contrast_subgroup;
	vector<int> cs_generators;
	vector<int> word_length_pattern;
//	vector< vector<int> > eigenvalues;
	vector< vector<bool> > canonical_graph; // consider converting the graph structure from set ** to vector<bitvector>> - cause when using vector of FF2Designs.. memory reallocation may lead to instability (reference losses to the graphs)
	vector< vector <permutation> > aut_group_gens;


public:
	FF2Design();
	void setContrastSubgroup(const vector<bool> &);
	vector<bool> * getContrastSubgroup() ;
	bool isNullDesign() ;
	void setCSGenerators(const vector<int> &);
	void addCSGenerator(const int &);
	int getLastCSGenerator() ;
	vector<int> * getCSGenerators();
	void setWordLengthPattern(const vector<int> &);
	vector<int> * getWordLengthPattern() ;


	void setCanonicalGraph(const vector< vector<bool> > &);
	vector< vector<bool> > * getCanonicalGraph() ;
	void addAutGroupGenerator(vector<permutation> &);
	vector< vector <permutation> > * getAutGroup() ;

	void freeWLPMemory();


	void freeSomeMemory();
	~FF2Design();

};


#endif //FF2DESIGN_H
