#include "FF2Design.h"


FF2Design::FF2Design()
{
}

bool 
FF2Design::isNullDesign() 
{
	if (cs_generators.size()==0)
		return true;
	return false;
}


void 
FF2Design::setContrastSubgroup(const vector<bool> & cs)
{
	contrast_subgroup.clear();
	contrast_subgroup = cs;
	//bit_vector::iterator itr1 = cs.begin();
	//bit_vector::iterator itr2 = cs.end();
	//for (; itr1!=itr2; itr1++)
	//	contrast_subgroup.push_back(*itr1);

	return;
}


vector<bool> * 
FF2Design::getContrastSubgroup() 
{
	return &contrast_subgroup;
}


void
FF2Design::setCSGenerators(const vector<int> & gens)
{
	cs_generators.clear();
	cs_generators = gens;
	//vector<int>::iterator itr1 = gens.begin();
	//vector<int>::iterator itr2 = gens.end();
	//for (; itr1!=itr2; itr1++)
	//	cs_generators.push_back(*itr1);

	//return 0;
}


void 
FF2Design::addCSGenerator(const int & gen)
{
	cs_generators.push_back(gen);

	return;
}


int 
FF2Design::getLastCSGenerator() 
{
	if (cs_generators.size()==0) return -1;
	return cs_generators[cs_generators.size()-1];
}


vector<int> * 
FF2Design::getCSGenerators()
{
	return &cs_generators;
}


void 
FF2Design::setWordLengthPattern(const vector<int> & wlp)
{
	word_length_pattern.clear();
	word_length_pattern = wlp;
	//vector<int>::iterator itr1 = wlp.begin();
	//vector<int>::iterator itr2 = wlp.end();
	//for(; itr1!=itr2; itr1++)
	//	word_length_pattern.push_back(*itr1);

	return;
}


vector<int> * 
FF2Design::getWordLengthPattern()
{
	return &word_length_pattern;
}





void 
FF2Design::setCanonicalGraph(const vector< vector<bool> > & cg)
{
	vector< vector<bool> >::const_iterator itr1 = cg.begin();
	vector< vector<bool> >::const_iterator itr2 = cg.end();
	for (; itr1!=itr2; itr1++)
	{
		vector<bool> tmp(*itr1);
		canonical_graph.push_back(tmp);
	}

	return;
}


vector< vector<bool> > * 
FF2Design::getCanonicalGraph() 
{
	return &canonical_graph;
}


void 
FF2Design::addAutGroupGenerator(vector<permutation> & pm)
{
	vector<permutation> tmp(pm);
	aut_group_gens.push_back(tmp);

	return;
}


vector< vector <permutation> > * 
FF2Design::getAutGroup() 
{
	return &aut_group_gens;
}




void
FF2Design::freeWLPMemory()
{
	vector<int> t1;
	word_length_pattern.swap(t1);

	return;
}


void
FF2Design::freeSomeMemory()
{
	register int i;

	vector<int> t1;
	word_length_pattern.swap(t1);

	for (i=0; i<(int)canonical_graph.size(); i++)
	{
		vector<bool> t4;
		canonical_graph[i].swap(t4);
	}
	canonical_graph.clear();
	vector< vector<bool> > t5;
	canonical_graph.swap(t5);

	return;
}


FF2Design::~FF2Design()
{
	int i;

	cs_generators.clear();
	word_length_pattern.clear();

	for (i=(int)canonical_graph.size()-1; i>=0; i--)
		canonical_graph[i].clear();
	canonical_graph.clear();
	for (i=(int)aut_group_gens.size()-1; i>=0; i--)
		aut_group_gens[i].clear();
	aut_group_gens.clear();
}
