# Set an appropriate working directory

library(matlab)

source("powerEst_KP.r")

### Data processing
data<-read.csv(file.path("Turbine Upgrade Dataset(VG Pair).csv"),header=T)[-1]

data[,1] = as.POSIXct(data[,1], format = '%m/%d/%Y %H:%M')

MWTF<-data
WT.id<-1

head(MWTF)

TR.from<-MWTF[1,1]
TR.to<-as.POSIXct("2011-06-03 23:50:00", format = '%Y-%m-%d %H:%M:%S')
TS1.from<-as.POSIXct("2011-06-04 00:00:00", format = '%Y-%m-%d %H:%M:%S')
TS1.to<-as.POSIXct("2011-06-18 23:50:00", format = '%Y-%m-%d %H:%M:%S')
TS2.from<-as.POSIXct("2011-06-20 00:00:00", format = '%Y-%m-%d %H:%M:%S')
TS2.to<-as.POSIXct("2011-07-04 20:50:00", format = '%Y-%m-%d %H:%M:%S')

TR.id1<-which(MWTF[,1]==TR.from)
TR.id2<-which(MWTF[,1]==TR.to)
TS1.id1<-which(MWTF[,1]==TS1.from)
TS1.id2<-which(MWTF[,1]==TS1.to)
TS2.id1<-which(MWTF[,1]==TS2.from)
TS2.id2<-which(MWTF[,1]==TS2.to)

data.mast<-MWTF[TR.id1:TS2.id2,c(3,4,6,7,5,10)]
head(data.mast)

mean.mast<-apply(data.mast,2,mean)
sd.mast<-apply(data.mast,2,sd)

############################################################################
### Analysis with the data from the mast ###################################
############################################################################
TR.mast<-data.mast[TR.id1:TR.id2,]		#40415
TS1.mast<-data.mast[TS1.id1:TS1.id2,]	#1773
TS2.mast<-data.mast[TS2.id1:TS2.id2,]	#1695

### Processed data
data_TR.mast<-data.process(TR.mast,TR.mast,c(1:(dim(TR.mast)[2]-1)),
                           mean.mast[3],sd.mast[3])
data_TS1.mast<-data.process(TR.mast,TS1.mast,c(1:(dim(TR.mast)[2]-1)),
                            mean.mast[3],sd.mast[3])
data_TS2.mast<-data.process(TR.mast,TS2.mast,c(1:(dim(TR.mast)[2]-1)),
                            mean.mast[3],sd.mast[3])
h_sim.mast<-bandwidth.sim(data_TR.mast[[9]],data_TR.mast[[3]])

### Self calibration
tic()
cal_TS1.mast<-calibration(data_TS1.mast[[9]],data_TS1.mast[[10]],
                          data_TS1.mast[[3]],h_sim.mast)
cal_TS2.mast<-calibration(data_TS2.mast[[9]],data_TS2.mast[[10]],
                          data_TS2.mast[[3]],h_sim.mast)
toc()

### Binning method
cutIn<-3.5
cutOut<-20

bin_TS1.mast<-bin.est(data_TS1.mast[[5]],data_TS1.mast[[6]],
                      data_TS1.mast[[3]],cutIn,cutOut,0.5)
bin_TS2.mast<-bin.est(data_TS2.mast[[5]],data_TS2.mast[[6]],
                      data_TS2.mast[[3]],cutIn,cutOut,0.5)

### Hybrid kernel estimation
tic()
kerVDAI_TS1.mast<-NW.est(data_TS1.mast[[9]][,1:4],data_TS1.mast[[10]][,1:4],
                         data_TS1.mast[[3]],h_sim.mast[1:4])
kerVDAI_TS2.mast<-NW.est(data_TS2.mast[[9]][,1:4],data_TS2.mast[[10]][,1:4],
                         data_TS2.mast[[3]],h_sim.mast[1:4])
kerVDAI_cal1.mast<-NW.est(cal_TS1.mast[[1]][,1:4],cal_TS1.mast[[2]][,1:4],
                          cal_TS1.mast[[3]],h_sim.mast[1:4])
kerVDAI_cal2.mast<-NW.est(cal_TS2.mast[[1]][,1:4],cal_TS2.mast[[2]][,1:4],
                          cal_TS2.mast[[3]],h_sim.mast[1:4])
toc()

### Result report
# Residual
rBin_TS1.mast<-data_TS1.mast[[4]]-bin_TS1.mast		# Residual for binning
rBin_TS2.mast<-data_TS2.mast[[4]]-bin_TS2.mast

rCal_TS1.mast<-cal_TS1.mast[[4]]-kerVDAI_cal1.mast	# R cal
rCal_TS2.mast<-cal_TS2.mast[[4]]-kerVDAI_cal2.mast
yKP_TS1.mast<-kerVDAI_TS1.mast+rCal_TS1.mast		# yhat KP
yKP_TS2.mast<-kerVDAI_TS2.mast+rCal_TS2.mast
rKP_TS1.mast<-data_TS1.mast[[4]]-yKP_TS1.mast		# Residual for KP
rKP_TS2.mast<-data_TS2.mast[[4]]-yKP_TS2.mast

# Difference
rB1<-which(is.na(rBin_TS1.mast)==1)		# Missing residual
rB2<-which(is.na(rBin_TS2.mast)==1)		# Missing residual

{if(length(rB1)==0)
  diffBin_TS1.mast<-mean(rBin_TS1.mast)/mean(data_TS1.mast[[4]])*100
  else
    diffBin_TS1.mast<-mean(rBin_TS1.mast[-rB1])/mean(data_TS1.mast[[4]][-rB1])*100}

{if(length(rB2)==0)
  diffBin_TS2.mast<-mean(rBin_TS2.mast)/mean(data_TS2.mast[[4]])*100
  else
    diffBin_TS2.mast<-mean(rBin_TS2.mast[-rB2])/mean(data_TS2.mast[[4]][-rB2])*100}

diffBin.mast<-diffBin_TS2.mast-diffBin_TS1.mast

rK1<-which(is.na(rKP_TS1.mast)==1)		# Missing residual
rK2<-which(is.na(rKP_TS2.mast)==1)		# Missing residual

{if(length(rK1)==0)
  diffKP_TS1.mast<-mean(rKP_TS1.mast)/mean(data_TS1.mast[[4]])*100
  else
    diffKP_TS1.mast<-mean(rKP_TS1.mast[-rK1])/mean(data_TS1.mast[[4]][-rK1])*100}

{if(length(rK2)==0)
  diffKP_TS2.mast<-mean(rKP_TS2.mast)/mean(data_TS2.mast[[4]])*100
  else
    diffKP_TS2.mast<-mean(rKP_TS2.mast[-rK2])/mean(data_TS2.mast[[4]][-rK2])*100}

diffKP.mast<-diffKP_TS2.mast-diffKP_TS1.mast

# T-test
tstat_bin.mast<-t.test(rBin_TS2.mast,rBin_TS1.mast,var.equal=T)
tstat_KP.mast<-t.test(rKP_TS2.mast,rKP_TS1.mast,var.equal=T)

tb1M<-c(tstat_bin.mast$statistic,tstat_bin.mast$p.value,
        tstat_KP.mast$statistic,tstat_KP.mast$p.value)
names(tb1M)=c("t.bin","p-val.bin","t.KP","p-val.KP")

round(tb1M, 3)

