# Set an appropriate working directory

library(matlab)

source("powerEst_KP.r")

### Data processing
data<-read.csv(file.path("Turbine Upgrade Dataset(VG Pair).csv"),header=T)[-1]

data[,1] = as.POSIXct(data[,1], format = '%m/%d/%Y %H:%M')

MWTF<-data
WT.id<-1

head(MWTF)

TR.from<-MWTF[1,1]
TR.to<-as.POSIXct("2011-06-18 23:50:00", format = '%Y-%m-%d %H:%M:%S')
TS.from<-as.POSIXct("2011-06-20 00:00:00", format = '%Y-%m-%d %H:%M:%S')
TS.to<-as.POSIXct("2011-10-31 21:40:00", format = '%Y-%m-%d %H:%M:%S')

TR.id1<-which(MWTF[,1]==TR.from)
TR.id2<-which(MWTF[,1]==TR.to)
TS.id1<-which(MWTF[,1]==TS.from)
TS.id2<-which(MWTF[,1]==TS.to)

data.mast<-MWTF[TR.id1:TS.id2,c(7,3,4,8,6,9)]
head(data.mast)

mean.mast<-apply(data.mast,2,mean)
sd.mast<-apply(data.mast,2,sd)

############################################################################
### Analysis with the data from the mast ###################################
############################################################################
TR.mast<-data.mast[TR.id1:TR.id2,]	#40415
TS.mast<-data.mast[TS.id1:TS.id2,]	#1773

### Processed data
obs.mast<-data.process(TR.mast,TS.mast,c(1:(dim(TR.mast)[2]-1)),
                       mean.mast[3],sd.mast[3])
h_sim.mast<-bandwidth.sim(obs.mast[[9]],obs.mast[[3]])

### Binning method
cutIn<-3.5
cutOut<-20

bin_est.mast<-bin.est(obs.mast[[5]],obs.mast[[6]],obs.mast[[3]],cutIn,cutOut,
                      0.5)

### Hybrid kernel estimation
tic()
kerVDAI.mast<-NW.est(obs.mast[[9]][,1:4],obs.mast[[10]][,1:4],obs.mast[[3]],
                     h_sim.mast[1:4])
toc()

### Result report
# Residual
rBin.mast<-obs.mast[[4]]-bin_est.mast		# Residual for binning
rAMK.mast<-obs.mast[[4]]-kerVDAI.mast		# Residual for AMK

RatedPW<-1650

std_r_bin<-cbind(obs.mast[[10]][,1],rBin.mast)
std_r_AMK<-cbind(obs.mast[[10]][,1],rAMK.mast)
std_r_bin[,2]<-std_r_bin[,2]/RatedPW*100
std_r_AMK[,2]<-std_r_AMK[,2]/RatedPW*100

### Power residual plot before and after upgrading
pdf("Figure7_5a.pdf")
par(mar=c(5,5,3,3))
plot(std_r_bin,xlim=c(3.5,20),ylim=c(-100,100),
     xlab="10-min average wind speed (m/s)",
     ylab="Ratio of power residual to rated power (%)",cex.lab=2.0,
     cex.axis=1.8,cex=1.2,pch=1)
abline(h=0,col="green",lwd=3,lty=2)
abline(v=13.5,col="red",lwd=3,lty=4)
dev.off()

pdf("Figure7_5b.pdf")
par(mar=c(5,5,3,3))
plot(std_r_AMK,xlim=c(3.5,20),ylim=c(-100,100),
     xlab="10-min average wind speed (m/s)",
     ylab="Ratio of power residual to rated power (%)",cex.lab=2.0,
     cex.axis=1.8,cex=1.2,pch=1)
abline(h=0,col="green",lwd=3,lty=2)
abline(v=13.5,col="red",lwd=3,lty=4)
dev.off()

save.image("Figure7_5.RData")

