<!-- #region -->
# Tutorials

This folder contains a collection of useful Notebooks with tutorials on how to use the **LDDS** Lagrangian descriptors Python module for analyzing the phase space structure of dynamical systems.

__[Tutorial 1](tutorial-1.ipynb)__ Continuous 1DoF systems (no perturbation)

* Hamilton centre (autonomous)
* Hamilton saddle (autonomous)
* Duffing oscillator (autonomous)
* Double-gyre (nonautonomous)

__[Tutorial 2](tutorial-2.ipynb)__ Lagrangian descriptors for 1 DoF dynamical system with forcing

* Forced Duffing oscillator (nonautonomous)

__[Tutorial 3](tutorial-3.ipynb)__ Variable time integration

* Hamilton saddle-node
* Inverted Duffing oscillator

__[Tutorial 4](tutorial-4.ipynb)__ Lagrangian descriptors for a user-defined 1 DoF dynamical system

* Morse oscillator

__[Tutorial 5](tutorial-5.ipynb)__ High-dimensional continuous systems

* 2DoF Hénon-Heiles
* 2DoF Index-1 normal form saddle
* 3DoF index-1 normal form saddle

__[Tutorial 6](tutorial-6.ipynb)__ Lagrangian descriptors for a user-defined 2 DoF Hamiltonian

* Double-well Hamiltonian system


__[Tutorial 7](tutorial-7.ipynb)__ Dynamics using Potential Energy Surface (PES) data

* Discretised Hénon-Heiles

__[Tutorial 8](tutorial-8.ipynb)__ Lagrangian descriptors for maps of discrete systems

* Standard map
* Hénon map

__[Tutorial 9](tutorial-9.ipynb)__ User-defined discrete maps

* Gauss map
* Gingerbreadman map

__[Tutorial 10](tutorial-10.ipynb)__ Lagrangian descriptors for Stochastic Dynamical Systems

* Noisy saddle
* Noisy Duffing oscillator 
* Noisy double-gyre

__[Tutorial 11](tutorial-11.ipynb)__ Dynamics using a vector field dataset

* Discretised forced Duffing oscillator

__[Tutorial 12](tutorial-12.ipynb)__ Integration Time & Grid Resolution for Lagrangian descriptor Simulations

* Arnold's cat map
* Double-gyre flow

__More to come...__

We encourage contributions from users to develop Jupyter notebooks that extend the capabilities and features of the **LDDS** software package.
<!-- #endregion -->
