/**
 * Mandelbulber v2, a 3D fractal generator       ,=#MKNmMMKmmßMNWy,
 *                                             ,B" ]L,,p%%%,,,§;, "K
 * Copyright (C) 2021 Mandelbulber Team        §R-==%w["'~5]m%=L.=~5N
 *                                        ,=mm=§M ]=4 yJKA"/-Nsaj  "Bw,==,,
 * This file is part of Mandelbulber.    §R.r= jw",M  Km .mM  FW ",§=ß., ,TN
 *                                     ,4R =%["w[N=7]J '"5=],""]]M,w,-; T=]M
 * Mandelbulber is free software:     §R.ß~-Q/M=,=5"v"]=Qf,'§"M= =,M.§ Rz]M"Kw
 * you can redistribute it and/or     §w "xDY.J ' -"m=====WeC=\ ""%""y=%"]"" §
 * modify it under the terms of the    "§M=M =D=4"N #"%==A%p M§ M6  R' #"=~.4M
 * GNU General Public License as        §W =, ][T"]C  §  § '§ e===~ U  !§[Z ]N
 * published by the                    4M",,Jm=,"=e~  §  §  j]]""N  BmM"py=ßM
 * Free Software Foundation,          ]§ T,M=& 'YmMMpM9MMM%=w=,,=MT]M m§;'§,
 * either version 3 of the License,    TWw [.j"5=~N[=§%=%W,T ]R,"=="Y[LFT ]N
 * or (at your option)                   TW=,-#"%=;[  =Q:["V""  ],,M.m == ]N
 * any later version.                      J§"mr"] ,=,," =="""J]= M"M"]==ß"
 *                                          §= "=C=4 §"eM "=B:m|4"]#F,§~
 * Mandelbulber is distributed in            "9w=,,]w em%wJ '"~" ,=,,ß"
 * the hope that it will be useful,                 . "K=  ,=RMMMßM"""
 * but WITHOUT ANY WARRANTY;                            .'''
 * without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Mandelbulber. If not, see <http://www.gnu.org/licenses/>.
 *
 * ###########################################################################
 *
 * Authors: Krzysztof Marczak (buddhi1980@gmail.com)
 *
 * TODO: description
 */

#ifndef MANDELBULBER2_SRC_DENOISER_H_
#define MANDELBULBER2_SRC_DENOISER_H_

#include <memory>
#include <vector>

#include "color_structures.hpp"

class cImage;

class cDenoiser
{
public:
	enum enumStrength
	{
		light = 0,
		medium = 1,
		strong = 2
	};

public:
	cDenoiser(int _imageWidth, int _imageHeight, enumStrength _strength);
	~cDenoiser();

public:
	void AllocMem();
	void UpdatePixel(int x, int y, const sRGBFloat color, float noise);
	void Denoise(int boxX, int boxY, int boxWidth, int boxHeight, bool preserveGeometry,
		std::shared_ptr<cImage> image, int loopCounter);

private:
	std::vector<sRGBFloat> blurBuffer;
	std::vector<float> blurRadiusBuffer;

	int width = 0;
	int height = 0;

	enumStrength strength;

	float maxBlurRadius;
	float minBlurRadius;
	int maxMedianSize;
	float noiseMultiplier;
	float zDepthFilterfactor;
	float normalFilterFactor;
};

#endif /* MANDELBULBER2_SRC_DENOISER_H_ */
