/**
 * Mandelbulber v2, a 3D fractal generator       ,=#MKNmMMKmmßMNWy,
 *                                             ,B" ]L,,p%%%,,,§;, "K
 * Copyright (C) 2017-21 Mandelbulber Team     §R-==%w["'~5]m%=L.=~5N
 *                                        ,=mm=§M ]=4 yJKA"/-Nsaj  "Bw,==,,
 * This file is part of Mandelbulber.    §R.r= jw",M  Km .mM  FW ",§=ß., ,TN
 *                                     ,4R =%["w[N=7]J '"5=],""]]M,w,-; T=]M
 * Mandelbulber is free software:     §R.ß~-Q/M=,=5"v"]=Qf,'§"M= =,M.§ Rz]M"Kw
 * you can redistribute it and/or     §w "xDY.J ' -"m=====WeC=\ ""%""y=%"]"" §
 * modify it under the terms of the    "§M=M =D=4"N #"%==A%p M§ M6  R' #"=~.4M
 * GNU General Public License as        §W =, ][T"]C  §  § '§ e===~ U  !§[Z ]N
 * published by the                    4M",,Jm=,"=e~  §  §  j]]""N  BmM"py=ßM
 * Free Software Foundation,          ]§ T,M=& 'YmMMpM9MMM%=w=,,=MT]M m§;'§,
 * either version 3 of the License,    TWw [.j"5=~N[=§%=%W,T ]R,"=="Y[LFT ]N
 * or (at your option)                   TW=,-#"%=;[  =Q:["V""  ],,M.m == ]N
 * any later version.                      J§"mr"] ,=,," =="""J]= M"M"]==ß"
 *                                          §= "=C=4 §"eM "=B:m|4"]#F,§~
 * Mandelbulber is distributed in            "9w=,,]w em%wJ '"~" ,=,,ß"
 * the hope that it will be useful,                 . "K=  ,=RMMMßM"""
 * but WITHOUT ANY WARRANTY;                            .'''
 * without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Mandelbulber. If not, see <http://www.gnu.org/licenses/>.
 *
 * ###########################################################################
 *
 * Authors: Krzysztof Marczak (buddhi1980@gmail.com)
 *
 * sParamRenderCl struct - container for scene parameters
 *       ____                   ________
 *      / __ \____  ___  ____  / ____/ /
 *     / / / / __ \/ _ \/ __ \/ /   / /
 *    / /_/ / /_/ /  __/ / / / /___/ /___
 *    \____/ .___/\___/_/ /_/\____/_____/
 *        /_/
 *
 * This file has been autogenerated by tools/populateOpenCL.php
 * from the file src/fractparams.hpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

#ifndef MANDELBULBER2_OPENCL_FRACTPARAMS_CL_HPP_
#define MANDELBULBER2_OPENCL_FRACTPARAMS_CL_HPP_

#ifndef OPENCL_KERNEL_CODE
#include "common_params_cl.hpp"
#include "fractal_cl.h"
#include "image_adjustments_cl.h"
#include "opencl_algebra.h"

#include "src/common_params.hpp"
#include "src/fractal.h"
#include "src/fractal_enums.h"
#include "src/fractparams.hpp"
#include "src/image_adjustments.h"
#endif /* OPENCL_KERNEL_CODE */

typedef enum
{
	mapEquirectangular = 0,
	mapDoubleHemisphere = 1,
	mapFlat = 2
} enumTextureMapTypeCl;

typedef enum
{
	booleanOperatorAND = 0,
	booleanOperatorOR = 1,
	booleanOperatorSUB = 2
} enumBooleanOperatorCl;

typedef struct
{
	// constructor with init

	cl_int antialiasingSize;
	cl_int antialiasingOclDepth;
	cl_int ambientOcclusionQuality; // ambient occlusion quality
	cl_int cloudsIterations;
	cl_int cloudsRandomSeed;
	cl_int frameNo;
	cl_int imageHeight; // image height
	cl_int imageWidth;	// image width
	cl_int formulaMaterialId[NUMBER_OF_FRACTALS];
	cl_int minN; // minimum number of iterations
	cl_int N;
	cl_int reflectionsMax;
	cl_int repeatFrom;
	cl_int DOFNumberOfPasses;
	cl_int DOFSamples;
	cl_int DOFMinSamples;
	cl_int monteCarloDenoiserStrength;

	cl_int perspectiveType;
	cl_int ambientOcclusionMode;
	cl_int texturedBackgroundMapType;
	cl_int booleanOperator[NUMBER_OF_FRACTALS - 1];
	cl_int delta_DE_method;
	cl_int delta_DE_function;

	cl_int advancedQuality;
	cl_int allPrimitivesInvisibleAlpha;
	cl_int antialiasingEnabled;
	cl_int antialiasingAdaptive;
	cl_int ambientOcclusionEnabled; // enable global illumination
	cl_int background3ColorsEnable;
	cl_int booleanOperatorsEnabled;
	cl_int cloudsCastShadows;
	cl_int cloudsDistanceMode;
	cl_int cloudsEnable;
	cl_int cloudsPlaneShape;
	cl_int constantDEThreshold;
	cl_int DOFEnabled;
	cl_int DOFHDRMode;
	cl_int DOFMonteCarlo;
	cl_int DOFMonteCarloGlobalIllumination;
	cl_int DOFMonteCarloChromaticAberration;
	cl_int envMappingEnable;
	cl_int fakeLightsEnabled;
	cl_int fogEnabled;
	cl_int glowEnabled;
	cl_int hdrBlurEnabled;
	cl_int hybridFractalEnable;
	cl_int interiorMode;
	cl_int iterThreshMode;
	cl_int iterFogEnabled;
	cl_int iterFogShadows;
	cl_int legacyCoordinateSystem;
	cl_int limitsEnabled; // enable limits (intersections)
	cl_int monteCarloSoftShadows;
	cl_int monteCarloGIVolumetric;
	cl_int monteCarloDenoiserEnable;
	cl_int monteCarloDenoiserPreserveGeometry;
	cl_int postChromaticAberrationEnabled;
	cl_int postChromaticAberrationReverse;
	cl_int raytracedReflections;
	cl_int slowShading; // enable fake gradient calculation for shading
	cl_int SSAO_random_mode;
	cl_int stereoSwapEyes;
	cl_int texturedBackground; // enable textured background
	cl_int useDefaultBailout;
	cl_int volFogEnabled;

	cl_float3 ambientOcclusionColor;
	cl_float3 background_color1; // background colour
	cl_float3 background_color2;
	cl_float3 background_color3;
	cl_float3 cloudsColor;
	cl_float3 fakeLightsColor;
	cl_float3 fillLightColor;
	cl_float3 fogColor;
	cl_float3 glowColor1;
	cl_float3 glowColor2;
	cl_float3 iterFogColour1;
	cl_float3 iterFogColour2;
	cl_float3 iterFogColour3;
	cl_float3 volFogColour1;
	cl_float3 volFogColour2;
	cl_float3 volFogColour3;

	cl_float absMaxMarchingStep;
	cl_float absMinMarchingStep;
	cl_float ambientOcclusion;
	cl_float ambientOcclusionFastTune;
	cl_float background_brightness;
	cl_float backgroundHScale;
	cl_float backgroundVScale;
	cl_float backgroundTextureOffsetX;
	cl_float backgroundTextureOffsetY;
	cl_float cameraDistanceToTarget; // zoom
	cl_float cloudsAmbientLight;
	cl_float cloudsDEApproaching;
	cl_float cloudsDEMultiplier;
	cl_float cloudsDensity;
	cl_float cloudsDetailAccuracy;
	cl_float cloudsDistance;
	cl_float cloudsDistanceLayer;
	cl_float cloudsLightsBoost;
	cl_float cloudsPeriod;
	cl_float cloudsHeight;
	cl_float cloudsOpacity;
	cl_float constantFactor;
	cl_float DEFactor; // factor for distance estimation steps
	cl_float deltaDERelativeDelta;
	cl_float detailLevel; // DE threshold factor
	cl_float detailSizeMax;
	cl_float detailSizeMin;
	cl_float DEThresh;
	cl_float DOFFocus;
	cl_float DOFRadius;
	cl_float DOFMaxRadius;
	cl_float DOFBlurOpacity;
	cl_float DOFMaxNoise;
	cl_float DOFMonteCarloCADispersionGain;
	cl_float DOFMonteCarloCACameraDispersion;
	cl_float fakeLightsIntensity;
	cl_float fakeLightsVisibility;
	cl_float fakeLightsVisibilitySize;
	cl_float fogVisibility;
	cl_float formulaScale[NUMBER_OF_FRACTALS];
	cl_float fov; // perspective factor
	cl_float glowIntensity;
	cl_float hdrBlurIntensity;
	cl_float hdrBlurRadius;
	cl_float iterFogColor1Maxiter;
	cl_float iterFogColor2Maxiter;
	cl_float iterFogOpacity;
	cl_float iterFogOpacityTrim;
	cl_float iterFogOpacityTrimHigh;
	cl_float iterFogBrightnessBoost;
	cl_float monteCarloGIRadianceLimit;
	cl_float postChromaticAberrationIntensity;
	cl_float postChromaticAberrationRadius;
	cl_float relMaxMarchingStep;
	cl_float relMinMarchingStep;
	cl_float resolution; // resolution of image in fractal coordinates
	cl_float smoothness;
	cl_float stereoEyeDistance;
	cl_float stereoInfiniteCorrection;
	cl_float sweetSpotHAngle;
	cl_float sweetSpotVAngle;
	cl_float viewDistanceMax;
	cl_float viewDistanceMin;
	cl_float volFogColour1Distance;
	cl_float volFogColour2Distance;
	cl_float volFogDensity;
	cl_float volFogDistanceFactor;
	cl_float volFogDistanceFromSurface;
	cl_float volumetricLightDEFactor;

	sImageAdjustmentsCl imageAdjustments;

	cl_float3 backgroundRotation;
	cl_float3 cloudsCenter;
	cl_float3 cloudsRotation;
	cl_float3 formulaPosition[NUMBER_OF_FRACTALS];
	cl_float3 formulaRotation[NUMBER_OF_FRACTALS];
	cl_float3 formulaRepeat[NUMBER_OF_FRACTALS];
	cl_float3 limitMin;
	cl_float3 limitMax;
	cl_float3 repeat;
	cl_float3 target;
	cl_float3 camera; // view point
	cl_float3 viewAngle;
	cl_float3 topVector;

	matrix33 mRotFormulaRotation[NUMBER_OF_FRACTALS];
	matrix33 mRotBackgroundRotation;
	matrix33 mRotCloudsRotation;

	sCommonParamsCl common;
} sParamRenderCl;

#ifndef OPENCL_KERNEL_CODE
inline sParamRenderCl clCopySParamRenderCl(const sParamRender &source)
{
	sParamRenderCl target;
	target.antialiasingSize = source.antialiasingSize;
	target.antialiasingOclDepth = source.antialiasingOclDepth;
	target.ambientOcclusionQuality = source.ambientOcclusionQuality;
	target.cloudsIterations = source.cloudsIterations;
	target.cloudsRandomSeed = source.cloudsRandomSeed;
	target.frameNo = source.frameNo;
	target.imageHeight = source.imageHeight;
	target.imageWidth = source.imageWidth;
	for (int i = 0; i < NUMBER_OF_FRACTALS; i++)
	{
		target.formulaMaterialId[i] = source.formulaMaterialId[i];
	}
	target.minN = source.minN;
	target.N = source.N;
	target.reflectionsMax = source.reflectionsMax;
	target.repeatFrom = source.repeatFrom;
	target.DOFNumberOfPasses = source.DOFNumberOfPasses;
	target.DOFSamples = source.DOFSamples;
	target.DOFMinSamples = source.DOFMinSamples;
	target.monteCarloDenoiserStrength = source.monteCarloDenoiserStrength;
	target.perspectiveType = source.perspectiveType;
	target.ambientOcclusionMode = source.ambientOcclusionMode;
	target.texturedBackgroundMapType = source.texturedBackgroundMapType;
	for (int i = 0; i < NUMBER_OF_FRACTALS - 1; i++)
	{
		target.booleanOperator[i] = source.booleanOperator[i];
	}
	target.delta_DE_method = source.delta_DE_method;
	target.delta_DE_function = source.delta_DE_function;
	target.advancedQuality = source.advancedQuality;
	target.allPrimitivesInvisibleAlpha = source.allPrimitivesInvisibleAlpha;
	target.antialiasingEnabled = source.antialiasingEnabled;
	target.antialiasingAdaptive = source.antialiasingAdaptive;
	target.ambientOcclusionEnabled = source.ambientOcclusionEnabled;
	target.background3ColorsEnable = source.background3ColorsEnable;
	target.booleanOperatorsEnabled = source.booleanOperatorsEnabled;
	target.cloudsCastShadows = source.cloudsCastShadows;
	target.cloudsDistanceMode = source.cloudsDistanceMode;
	target.cloudsEnable = source.cloudsEnable;
	target.cloudsPlaneShape = source.cloudsPlaneShape;
	target.constantDEThreshold = source.constantDEThreshold;
	target.DOFEnabled = source.DOFEnabled;
	target.DOFHDRMode = source.DOFHDRMode;
	target.DOFMonteCarlo = source.DOFMonteCarlo;
	target.DOFMonteCarloGlobalIllumination = source.DOFMonteCarloGlobalIllumination;
	target.DOFMonteCarloChromaticAberration = source.DOFMonteCarloChromaticAberration;
	target.envMappingEnable = source.envMappingEnable;
	target.fakeLightsEnabled = source.fakeLightsEnabled;
	target.fogEnabled = source.fogEnabled;
	target.glowEnabled = source.glowEnabled;
	target.hdrBlurEnabled = source.hdrBlurEnabled;
	target.hybridFractalEnable = source.hybridFractalEnable;
	target.interiorMode = source.interiorMode;
	target.iterThreshMode = source.iterThreshMode;
	target.iterFogEnabled = source.iterFogEnabled;
	target.iterFogShadows = source.iterFogShadows;
	target.legacyCoordinateSystem = source.legacyCoordinateSystem;
	target.limitsEnabled = source.limitsEnabled;
	target.monteCarloSoftShadows = source.monteCarloSoftShadows;
	target.monteCarloGIVolumetric = source.monteCarloGIVolumetric;
	target.monteCarloDenoiserEnable = source.monteCarloDenoiserEnable;
	target.monteCarloDenoiserPreserveGeometry = source.monteCarloDenoiserPreserveGeometry;
	target.postChromaticAberrationEnabled = source.postChromaticAberrationEnabled;
	target.postChromaticAberrationReverse = source.postChromaticAberrationReverse;
	target.raytracedReflections = source.raytracedReflections;
	target.slowShading = source.slowShading;
	target.SSAO_random_mode = source.SSAO_random_mode;
	target.stereoSwapEyes = source.stereoSwapEyes;
	target.texturedBackground = source.texturedBackground;
	target.useDefaultBailout = source.useDefaultBailout;
	target.volFogEnabled = source.volFogEnabled;
	target.ambientOcclusionColor = toClFloat3(source.ambientOcclusionColor);
	target.background_color1 = toClFloat3(source.background_color1);
	target.background_color2 = toClFloat3(source.background_color2);
	target.background_color3 = toClFloat3(source.background_color3);
	target.cloudsColor = toClFloat3(source.cloudsColor);
	target.fakeLightsColor = toClFloat3(source.fakeLightsColor);
	target.fillLightColor = toClFloat3(source.fillLightColor);
	target.fogColor = toClFloat3(source.fogColor);
	target.glowColor1 = toClFloat3(source.glowColor1);
	target.glowColor2 = toClFloat3(source.glowColor2);
	target.iterFogColour1 = toClFloat3(source.iterFogColour1);
	target.iterFogColour2 = toClFloat3(source.iterFogColour2);
	target.iterFogColour3 = toClFloat3(source.iterFogColour3);
	target.volFogColour1 = toClFloat3(source.volFogColour1);
	target.volFogColour2 = toClFloat3(source.volFogColour2);
	target.volFogColour3 = toClFloat3(source.volFogColour3);
	target.absMaxMarchingStep = source.absMaxMarchingStep;
	target.absMinMarchingStep = source.absMinMarchingStep;
	target.ambientOcclusion = source.ambientOcclusion;
	target.ambientOcclusionFastTune = source.ambientOcclusionFastTune;
	target.background_brightness = source.background_brightness;
	target.backgroundHScale = source.backgroundHScale;
	target.backgroundVScale = source.backgroundVScale;
	target.backgroundTextureOffsetX = source.backgroundTextureOffsetX;
	target.backgroundTextureOffsetY = source.backgroundTextureOffsetY;
	target.cameraDistanceToTarget = source.cameraDistanceToTarget;
	target.cloudsAmbientLight = source.cloudsAmbientLight;
	target.cloudsDEApproaching = source.cloudsDEApproaching;
	target.cloudsDEMultiplier = source.cloudsDEMultiplier;
	target.cloudsDensity = source.cloudsDensity;
	target.cloudsDetailAccuracy = source.cloudsDetailAccuracy;
	target.cloudsDistance = source.cloudsDistance;
	target.cloudsDistanceLayer = source.cloudsDistanceLayer;
	target.cloudsLightsBoost = source.cloudsLightsBoost;
	target.cloudsPeriod = source.cloudsPeriod;
	target.cloudsHeight = source.cloudsHeight;
	target.cloudsOpacity = source.cloudsOpacity;
	target.constantFactor = source.constantFactor;
	target.DEFactor = source.DEFactor;
	target.deltaDERelativeDelta = source.deltaDERelativeDelta;
	target.detailLevel = source.detailLevel;
	target.detailSizeMax = source.detailSizeMax;
	target.detailSizeMin = source.detailSizeMin;
	target.DEThresh = source.DEThresh;
	target.DOFFocus = source.DOFFocus;
	target.DOFRadius = source.DOFRadius;
	target.DOFMaxRadius = source.DOFMaxRadius;
	target.DOFBlurOpacity = source.DOFBlurOpacity;
	target.DOFMaxNoise = source.DOFMaxNoise;
	target.DOFMonteCarloCADispersionGain = source.DOFMonteCarloCADispersionGain;
	target.DOFMonteCarloCACameraDispersion = source.DOFMonteCarloCACameraDispersion;
	target.fakeLightsIntensity = source.fakeLightsIntensity;
	target.fakeLightsVisibility = source.fakeLightsVisibility;
	target.fakeLightsVisibilitySize = source.fakeLightsVisibilitySize;
	target.fogVisibility = source.fogVisibility;
	for (int i = 0; i < NUMBER_OF_FRACTALS; i++)
	{
		target.formulaScale[i] = source.formulaScale[i];
	}
	target.fov = source.fov;
	target.glowIntensity = source.glowIntensity;
	target.hdrBlurIntensity = source.hdrBlurIntensity;
	target.hdrBlurRadius = source.hdrBlurRadius;
	target.iterFogColor1Maxiter = source.iterFogColor1Maxiter;
	target.iterFogColor2Maxiter = source.iterFogColor2Maxiter;
	target.iterFogOpacity = source.iterFogOpacity;
	target.iterFogOpacityTrim = source.iterFogOpacityTrim;
	target.iterFogOpacityTrimHigh = source.iterFogOpacityTrimHigh;
	target.iterFogBrightnessBoost = source.iterFogBrightnessBoost;
	target.monteCarloGIRadianceLimit = source.monteCarloGIRadianceLimit;
	target.postChromaticAberrationIntensity = source.postChromaticAberrationIntensity;
	target.postChromaticAberrationRadius = source.postChromaticAberrationRadius;
	target.relMaxMarchingStep = source.relMaxMarchingStep;
	target.relMinMarchingStep = source.relMinMarchingStep;
	target.resolution = source.resolution;
	target.smoothness = source.smoothness;
	target.stereoEyeDistance = source.stereoEyeDistance;
	target.stereoInfiniteCorrection = source.stereoInfiniteCorrection;
	target.sweetSpotHAngle = source.sweetSpotHAngle;
	target.sweetSpotVAngle = source.sweetSpotVAngle;
	target.viewDistanceMax = source.viewDistanceMax;
	target.viewDistanceMin = source.viewDistanceMin;
	target.volFogColour1Distance = source.volFogColour1Distance;
	target.volFogColour2Distance = source.volFogColour2Distance;
	target.volFogDensity = source.volFogDensity;
	target.volFogDistanceFactor = source.volFogDistanceFactor;
	target.volFogDistanceFromSurface = source.volFogDistanceFromSurface;
	target.volumetricLightDEFactor = source.volumetricLightDEFactor;
	target.imageAdjustments = clCopySImageAdjustmentsCl(source.imageAdjustments);
	target.backgroundRotation = toClFloat3(source.backgroundRotation);
	target.cloudsCenter = toClFloat3(source.cloudsCenter);
	target.cloudsRotation = toClFloat3(source.cloudsRotation);
	for (int i = 0; i < NUMBER_OF_FRACTALS; i++)
	{
		target.formulaPosition[i] = toClFloat3(source.formulaPosition[i]);
	}
	for (int i = 0; i < NUMBER_OF_FRACTALS; i++)
	{
		target.formulaRotation[i] = toClFloat3(source.formulaRotation[i]);
	}
	for (int i = 0; i < NUMBER_OF_FRACTALS; i++)
	{
		target.formulaRepeat[i] = toClFloat3(source.formulaRepeat[i]);
	}
	target.limitMin = toClFloat3(source.limitMin);
	target.limitMax = toClFloat3(source.limitMax);
	target.repeat = toClFloat3(source.repeat);
	target.target = toClFloat3(source.target);
	target.camera = toClFloat3(source.camera);
	target.viewAngle = toClFloat3(source.viewAngle);
	target.topVector = toClFloat3(source.topVector);
	for (int i = 0; i < NUMBER_OF_FRACTALS; i++)
	{
		target.mRotFormulaRotation[i] = toClMatrix33(source.mRotFormulaRotation[i]);
	}
	target.mRotBackgroundRotation = toClMatrix33(source.mRotBackgroundRotation);
	target.mRotCloudsRotation = toClMatrix33(source.mRotCloudsRotation);
	target.common = clCopySCommonParamsCl(source.common);
	return target;
}
#endif /* OPENCL_KERNEL_CODE */

#endif /* MANDELBULBER2_OPENCL_FRACTPARAMS_CL_HPP_ */
