/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical pwr fold
 * This formula contains aux.color and analytic aux.DE

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_pwr_fold.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalPwrFoldIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	// if (z.x > -1e-21f && z.x < 1e-21f) z.x = (z.x > 0) ? 1e-21f : -1e-21f;
	// if (z.y > -1e-21f && z.y < 1e-21f) z.y = (z.y > 0) ? 1e-21f : -1e-21f;
	// if (z.z > -1e-21f && z.z < 1e-21f) z.z = (z.z > 0) ? 1e-21f : -1e-21f;
	REAL rr = native_powr(native_powr(z.x, fractal->transformCommon.pwr4)
													+ native_powr(z.y, fractal->transformCommon.pwr4)
													+ native_powr(z.z, fractal->transformCommon.pwr4),
		fractal->transformCommon.pwr05);

	// if (rr < 1e-21f && rr > -1e-21f)
	//	rr = (rr > 0) ? 1e-21f : -1e-21f;
	if (rr < fractal->mandelbox.mR2)
	{
		z *= fractal->mandelbox.mboxFactor1;
		aux->DE *= fractal->mandelbox.mboxFactor1;
		if (fractal->foldColor.auxColorEnabledFalse)
		{
			aux->color += fractal->mandelbox.color.factorSp1;
		}
	}
	else if (rr < fractal->mandelbox.fR2)
	{
		REAL tglad_factor2 = fractal->mandelbox.fR2 / rr;
		z *= tglad_factor2;
		aux->DE *= tglad_factor2;
		if (fractal->foldColor.auxColorEnabledFalse)
		{
			aux->color += fractal->mandelbox.color.factorSp2;
		}
	}
	return z;
}