/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * smoothing based on Menger Smooth
 * http://www.fractalforums.com/fragmentarium/help-t22583/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_smooth_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSmoothV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	REAL OffsetS = fractal->transformCommon.offset0005;

	REAL4 ZZ = z * z;
	REAL4 sc = fabs(z) * fractal->transformCommon.offset000;
	REAL4 tc = fabs(z) * fractal->transformCommon.offsetF000;

	// the closer to origin the greater the effect of smooth
	z = (REAL4){native_sqrt(ZZ.x + OffsetS + sc.x), native_sqrt(ZZ.y + OffsetS) + sc.y,
		native_sqrt(ZZ.z + OffsetS + sc.z), z.w};

	REAL t;
	if (fractal->transformCommon.functionEnabledx)
	{
		t = z.x - z.y;
		t = 0.5f * (t - native_sqrt(t * t + OffsetS + tc.x));
		z.x = z.x - t;
		z.y = z.y + t;
	}
	if (fractal->transformCommon.functionEnabledy)
	{
		t = z.y - z.z;
		t = 0.5f * (t - native_sqrt(t * t + OffsetS + tc.y));
		z.y = z.y - t;
		z.z = z.z + t;
	}
	if (fractal->transformCommon.functionEnabledz)
	{
		t = z.z - z.x;
		t = 0.5f * (t - native_sqrt(t * t + OffsetS + tc.z));
		z.z = z.z - t;
		z.x = z.x + t;
	}

	z += fractal->transformCommon.offsetA000;
	return z;
}