/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * testing log

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_rotation_chebyshev.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfRotationChebyshevIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{

	// chebyshev
	if (fractal->transformCommon.functionEnabledAx
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC1)
	{
		// chebyshev
		REAL tmp = 0.0f;
		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			REAL temp = z.x;
			z.x = z.y;
			z.y = temp;
		}
		REAL F = z.x / z.y;
		if (z.y == 0.0f) tmp = (z.x > 0.0f ? 0.0 : 4.0f);
		if (fabs(F) < 1.0f)
		{
			if (z.y > 0.0f)
				tmp = 2.0f - F;
			else
				tmp = 6.0f - F;
		}
		else
		{
			F = z.y / z.x;
			if (z.x > 0.0f)
				tmp = fmod(F, 8.0f);
			else
				tmp = 4.0f + F;
		}

		tmp = tmp + fractal->transformCommon.offset111.x;
		REAL Length2 = max(fabs(z.x), fabs(z.y));

		REAL C = tmp - 8.0f * floor(tmp / 8.0f);
		C = fabs(C - 4.0f) - 2.0f;
		z.x = clamp(C, -1.0f, 1.0f) * Length2;

		REAL S = tmp - 2.0f;
		S = S - 8.0f * floor(S / 8.0f);
		S = fabs(S - 4.0f) - 2.0f;
		z.y = clamp(S, -1.0f, 1.0f) * Length2;
	}

	if (fractal->transformCommon.functionEnabledAyFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		REAL tmp = 0.0f;
		if (fractal->transformCommon.functionEnabledByFalse)
		{
			REAL temp = z.y;
			z.y = z.z;
			z.z = temp;
		}
		REAL F = z.y / z.z;
		if (z.z == 0.0f) tmp = (z.y > 0.0f ? 0.0 : 4.0f);
		if (fabs(F) < 1.0f)
		{
			if (z.z > 0.0f)
				tmp = 2.0f - F;
			else
				tmp = 6.0f - F;
		}
		else
		{
			F = z.z / z.y;
			if (z.y > 0.0f)
				tmp = fmod(F, 8.0f);
			else
				tmp = 4.0f + F;
		}

		tmp = tmp + fractal->transformCommon.offset111.y;
		REAL Length2 = max(fabs(z.y), fabs(z.z));

		REAL C = tmp - 8.0f * floor(tmp / 8.0f);
		C = fabs(C - 4.0f) - 2.0f;
		z.y = clamp(C, -1.0f, 1.0f) * Length2;

		REAL S = tmp - 2.0f;
		S = S - 8.0f * floor(S / 8.0f);
		S = fabs(S - 4.0f) - 2.0f;
		z.z = clamp(S, -1.0f, 1.0f) * Length2;
	}

	if (fractal->transformCommon.functionEnabledAzFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP1)
	{
		REAL tmp = 0.0f;
		if (fractal->transformCommon.functionEnabledBzFalse)
		{
			REAL temp = z.z;
			z.z = z.x;
			z.x = temp;
		}
		REAL F = z.z / z.x;
		if (z.x == 0.0f) tmp = (z.z > 0.0f ? 0.0 : 4.0f);
		if (fabs(F) < 1.0f)
		{
			if (z.x > 0.0f)
				tmp = 2.0f - F;
			else
				tmp = 6.0f - F;
		}
		else
		{
			F = z.x / z.z;
			if (z.z > 0.0f)
				tmp = fmod(F, 8.0f);
			else
				tmp = 4.0f + F;
		}

		tmp = tmp + fractal->transformCommon.offset111.z;
		REAL Length2 = max(fabs(z.x), fabs(z.z));

		REAL C = tmp - 8.0f * floor(tmp / 8.0f);
		C = fabs(C - 4.0f) - 2.0f;
		z.z = clamp(C, -1.0f, 1.0f) * Length2;

		REAL S = tmp - 2.0f;
		S = S - 8.0f * floor(S / 8.0f);
		S = fabs(S - 4.0f) - 2.0f;
		z.x = clamp(S, -1.0f, 1.0f) * Length2;
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}