/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Hybrid Color Trial2
 *
 *
 * bailout may need to be adjusted with some formulas

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_hybrid_color2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfHybridColor2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterationsT
			&& aux->i < fractal->transformCommon.stopIterationsT)
	{
		REAL componentMaster = 0.0f;
		REAL orbitPoints = 0.0f;
		REAL distL = 0.0f;
		REAL newR = 0.0f;
		REAL lastVec = 0.0f;

		// summation of r
		if (fractal->transformCommon.functionEnabledMFalse)
		{
			newR = aux->r * fractal->transformCommon.scaleD1;
		}

		// max distance travelled
		if (fractal->transformCommon.functionEnabledSFalse)
		{
			REAL4 oldPt = aux->old_z;
			REAL4 newPt = z;
			REAL4 diffZ = oldPt - newPt;
			distL = length(diffZ) * fractal->transformCommon.scaleC1;
		}

		// last two z lengths
		if (fractal->transformCommon.functionEnabledPFalse)
		{
			if (aux->i < fractal->transformCommon.stopIterationsM) // remove
			{
				REAL4 oldPt = aux->old_z;
				REAL lastZ = length(oldPt); // aux->old_r;
				REAL newZ = aux->r;
				if (fractal->transformCommon.functionEnabledAzFalse) lastVec = newZ / lastZ;
				if (fractal->transformCommon.functionEnabledByFalse) lastVec = lastZ / newZ;
				if (fractal->transformCommon.functionEnabledBzFalse) lastVec = fabs(lastZ - newZ);
				lastVec *= fractal->transformCommon.scaleB1;
			}
		}

		// orbitTrap points
		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			REAL4 PtOne = z - fractal->transformCommon.offset000;
			REAL distOne = length(PtOne); // * weight
			orbitPoints = distOne;
			if (fractal->transformCommon.functionEnabledAzFalse)
			{
				REAL4 PtTwo = z - fractal->transformCommon.offsetA000;
				REAL distTwo = length(PtTwo);
				orbitPoints = min(orbitPoints, distTwo);
			}
			if (fractal->transformCommon.functionEnabledAxFalse)
			{
				REAL4 PtThree = z - fractal->transformCommon.offsetF000;
				REAL distThree = length(PtThree);
				orbitPoints = min(orbitPoints, distThree);
			}
			if (fractal->transformCommon.functionEnabledAyFalse)
			{
				REAL4 PtFour = z - fractal->transformCommon.additionConstantA000;
				REAL distFour = length(PtFour);
				orbitPoints = min(orbitPoints, distFour);
			}
			orbitPoints *= fractal->transformCommon.scaleA1;
		}

		// build  componentMaster
		componentMaster = (distL + orbitPoints + lastVec + newR);
		componentMaster *= fractal->transformCommon.scale;

		if (!fractal->transformCommon.functionEnabledFalse)
		{
			aux->colorHybrid += componentMaster;
		}
		else
		{
			aux->temp1000 = min(aux->temp1000, componentMaster);
			aux->colorHybrid = aux->temp1000;
		}
	}
	aux->old_z = z;
	return z;
}