/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDifsSphereIteration  fragmentarium code, mdifs by knighty (jan 2012)

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_sphere.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSSphereIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 zc = z;
	REAL vecLen;
	if (!fractal->transformCommon.functionEnabled4dFalse)
	{
		REAL3 vec = (REAL3){zc.x, zc.y, zc.z};
		vecLen = length(vec);
	}
	else
		vecLen = length(zc);

	REAL spD = vecLen - fractal->transformCommon.offsetR1;
	aux->dist = min(aux->dist, spD / (aux->DE + 1.0f));
	aux->DE0 = spD; // temp testing
	return z;
}