/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * transfDIFSHextgrid2Iteration  fragmentarium code, mdifs by knighty (jan 2012)
 * and  darkbeams optimized verion @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/
 * "Beautiful iso-surface made of a hexagonal grid of tubes.
 * Taken from K3DSurf forum, posted by user abdelhamid belaid."

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_hextgrid2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSHextgrid2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 zc = z;

	REAL size = fractal->transformCommon.scale1;
	REAL hexD = 0.0f;

	if (fractal->transformCommon.rotationEnabled)
	{
		zc = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, zc);
	}

	zc.z /= fractal->transformCommon.scaleF1;

	REAL cosPi6 = native_cos(M_PI_F / 6.0f);
	REAL yFloor = fabs(zc.y - size * floor(zc.y / size + 0.5f));
	REAL xFloor = fabs(zc.x - size * 1.5f / cosPi6 * floor(zc.x / size / 1.5f * cosPi6 + 0.5f));
	REAL gridMax = max(yFloor, xFloor * cosPi6 + yFloor * native_sin(M_PI_F / 6.0f));
	REAL gridMin = min(gridMax - size * 0.5f, yFloor);
	if (!fractal->transformCommon.functionEnabledJFalse)
		hexD = native_sqrt(gridMin * gridMin + zc.z * zc.z);
	else
		hexD = max(fabs(gridMin), fabs(zc.z));

	aux->dist = min(aux->dist, (hexD - fractal->transformCommon.offset0005) / (aux->DE + 1.0f));
	return z;
}