/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_hexprism.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSHexprismIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL lenX = fractal->transformCommon.offset1;
	REAL lenY = fractal->transformCommon.offsetA1;
	REAL4 zc = fabs(z);

	// swap axis
	if (fractal->transformCommon.functionEnabledSFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.y;
		zc.y = temp;
	}

	// swap axis
	if (fractal->transformCommon.functionEnabledSwFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.z;
		zc.z = temp;
	}

	if (fractal->transformCommon.rotation2EnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR)
	{
		zc = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, zc);
	}

	REAL4 k = (REAL4){-SQRT_3_4_F, 0.5f, SQRT_1_3_F, 0.0f};

	REAL tp = 2.0f * min(k.x * zc.x + k.y * zc.y, 0.0f);
	zc.x -= tp * k.x;
	zc.y -= tp * k.y;

	REAL dx = zc.x - clamp(zc.x, -k.z * lenX, k.z * lenX);
	REAL dy = zc.y - lenX;

	tp = native_sqrt(dx * dx + dy * dy);
	dx = tp * sign(zc.y - lenX);
	dy = zc.z - lenY;

	if (fractal->transformCommon.functionEnabledDFalse)
		dx = fabs(dx) - fractal->transformCommon.offset0;

	REAL maxdx = max(dx, 0.0f);
	REAL maxdy = max(dy, 0.0f);

	tp = native_sqrt(maxdx * maxdx + maxdy * maxdy);
	aux->DE0 = min(max(dx, dy), 0.0f) + tp;
	aux->dist = min(aux->dist, aux->DE0 / (aux->DE + 1.0f));
	return z;
}