/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Box Tiling 4d

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_box_tiling_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfBoxTilingV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 size = fractal->transformCommon.offset222;
	REAL4 t = fractal->transformCommon.offset111;

	if (!fractal->transformCommon.functionEnabledFalse)
	{
		if (fractal->transformCommon.functionEnabledx && size.x != 0.0f)
		{
			z.x -= round(z.x / size.x) * size.x;
			z.x = clamp(fabs(z.x), -t.x, t.x);
		}
		if (fractal->transformCommon.functionEnabledyFalse && size.y != 0.0f)
		{
			z.y -= round(z.y / size.y) * size.y;
			z.y = clamp(fabs(z.y), -t.y, t.y);
		}
		if (fractal->transformCommon.functionEnabledzFalse && size.z != 0.0f)
		{
			z.z -= round(z.z / size.z) * size.z;
			z.z = clamp(fabs(z.z), -t.z, t.z);
		}
	}
	else
	{
		REAL4 repeatPos = fractal->transformCommon.offsetA111;
		REAL4 repeatNeg = fractal->transformCommon.offsetB111;

		if (fractal->transformCommon.functionEnabledx && z.x < (repeatPos.x + 0.5f) * size.x
				&& z.x > (repeatNeg.x + 0.5f) * -size.x && size.x != 0.0f)
		{
			z.x -= round(z.x / size.x) * size.x;
			z.x = clamp(fabs(z.x), -t.x, t.x);
		}
		if (fractal->transformCommon.functionEnabledyFalse && z.y < (repeatPos.y + 0.5f) * size.y
				&& z.y > (repeatNeg.y + 0.5f) * -size.y && size.y != 0.0f)
		{
			z.y -= round(z.y / size.y) * size.y;
			z.y = clamp(fabs(z.y), -t.y, t.y);
		}
		if (fractal->transformCommon.functionEnabledzFalse && z.z < (repeatPos.z + 0.5f) * size.z
				&& z.z > (repeatNeg.z + 0.5f) * -size.z && size.z != 0.0f)
		{
			z.z -= round(z.z / size.z) * size.z;
			z.z = clamp(fabs(z.z), -t.z, t.z);
		}
	}

	if (fractal->analyticDE.enabled)
	{
		if (!fractal->analyticDE.enabledFalse)
			aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
		else
		{
			aux->DE = aux->DE * length(z) * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
		}
	}
	return z;
}