/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Based on a DarkBeam fold formula adapted by Knighty
 * MandalayBox  Fragmentarium /Examples/ Knighty Collection

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_testing_transform.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TestingTransformIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 signs;
	signs.x = sign(aux->const_c.x);
	signs.y = sign(aux->const_c.y);
	signs.z = sign(aux->const_c.z);
	signs.w = 0.0f;

	REAL4 offset = fractal->transformCommon.offset000;
	if (!fractal->transformCommon.functionEnabledEFalse) offset *= signs;

	REAL4 temp;
	if (!fractal->transformCommon.functionEnabledAFalse)
		temp = aux->const_c - offset;
	else
		temp = z - offset;

	REAL r = dot(temp, temp);

	if (fractal->transformCommon.functionEnabledBFalse) r = native_sqrt(r);

	// REAL4 offset1 = fractal->transformCommon.offset111;
	// if (fractal->transformCommon.functionEnabledCFalse)	offset1 *=	sign(c);
	// t = offset1 + t;

	REAL4 offset1 = fractal->transformCommon.offsetA000;
	if (fractal->transformCommon.functionEnabledCFalse) offset1 *= signs;

	if (r > fractal->transformCommon.radius1)
	{
		temp = (temp * (1.0f - fractal->transformCommon.radius1 / r));
		// if (fractal->transformCommon.functionEnabledCFalse)	temp *= sign(z);
		z += temp + offset1;
		//	z = fabs(z);
	}
	else
	{
		if (fractal->transformCommon.functionEnabledDFalse)
			z += fractal->transformCommon.scale1 * temp / (fractal->transformCommon.radius1 / r - 1.0f);
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}