/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Menger4D MOD1   from Syntopia & DarkBeam's Menger4 code from M3D
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_menger4d_mod2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 Menger4dMod2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		if (fractal->transformCommon.functionEnabledAFalse)
		{
			z = (REAL4){z.x, z.y, z.z, length(z)};
			aux->DE += 0.5f;
		}
		if (fractal->transformCommon.functionEnabledBFalse)
		{
			z = (REAL4){z.x + z.y + z.z, -z.x - z.y + z.z, -z.x + z.y - z.z, z.x - z.y - z.z};
			aux->DE *= length(z) / aux->r;
		}
		z = fabs(z - fractal->transformCommon.offsetA0000);
	}

	z = fabs(z);
	if (aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		z += fractal->transformCommon.additionConstant0000; // offset
	}

	if (z.x - z.y < 0.0f)
	{
		REAL temp = z.y;
		z.y = z.x;
		z.x = temp;
	}
	if (z.x - z.z < 0.0f)
	{
		REAL temp = z.z;
		z.z = z.x;
		z.x = temp;
	}
	if (z.y - z.z < 0.0f)
	{
		REAL temp = z.z;
		z.z = z.y;
		z.y = temp;
	}
	if (z.x - z.w < 0.0f)
	{
		REAL temp = z.w;
		z.w = z.x;
		z.x = temp;
	}
	if (z.y - z.w < 0.0f)
	{
		REAL temp = z.w;
		z.w = z.y;
		z.y = temp;
	}
	if (z.z - z.w < 0.0f)
	{
		REAL temp = z.w;
		z.w = z.z;
		z.z = temp;
	}

	// 6 plane rotation
	if (fractal->transformCommon.functionEnabledRFalse
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR)
	{
		REAL4 tp;
		if (fractal->transformCommon.rotation44a.x != 0)
		{
			tp = z;
			REAL alpha = fractal->transformCommon.rotation44a.x * M_PI_180_F;
			z.x = tp.x * native_cos(alpha) + tp.y * native_sin(alpha);
			z.y = tp.x * -native_sin(alpha) + tp.y * native_cos(alpha);
		}
		if (fractal->transformCommon.rotation44a.y != 0)
		{
			tp = z;
			REAL beta = fractal->transformCommon.rotation44a.y * M_PI_180_F;
			z.y = tp.y * native_cos(beta) + tp.z * native_sin(beta);
			z.z = tp.y * -native_sin(beta) + tp.z * native_cos(beta);
		}
		if (fractal->transformCommon.rotation44a.z != 0)
		{
			tp = z;
			REAL gamma = fractal->transformCommon.rotation44a.z * M_PI_180_F;
			z.x = tp.x * native_cos(gamma) + tp.z * native_sin(gamma);
			z.z = tp.x * -native_sin(gamma) + tp.z * native_cos(gamma);
		}
		if (fractal->transformCommon.rotation44b.x != 0)
		{
			tp = z;
			REAL delta = fractal->transformCommon.rotation44b.x * M_PI_180_F;
			z.x = tp.x * native_cos(delta) + tp.w * native_sin(delta);
			z.w = tp.x * -native_sin(delta) + tp.w * native_cos(delta);
		}
		if (fractal->transformCommon.rotation44b.y != 0)
		{
			tp = z;
			REAL epsilon = fractal->transformCommon.rotation44b.y * M_PI_180_F;
			z.y = tp.y * native_cos(epsilon) + tp.w * native_sin(epsilon);
			z.w = tp.y * -native_sin(epsilon) + tp.w * native_cos(epsilon);
		}
		if (fractal->transformCommon.rotation44b.z != 0)
		{
			tp = z;
			REAL zeta = fractal->transformCommon.rotation44b.z * M_PI_180_F;
			z.z = tp.z * native_cos(zeta) + tp.w * native_sin(zeta);
			z.w = tp.z * -native_sin(zeta) + tp.w * native_cos(zeta);
		}
	}

	REAL4 scaleM = fractal->transformCommon.scale3 * fractal->transformCommon.scale1111;
	REAL4 offsetM = fractal->transformCommon.additionConstant111d5;
	z.x = scaleM.x * z.x - offsetM.x;
	z.y = scaleM.y * z.y - offsetM.y;
	z.w = scaleM.w * z.w - offsetM.w;
	z.z *= fractal->transformCommon.scale1;
	REAL t = 0.5f * offsetM.z / scaleM.z;
	z.z -= t;
	z.z = -fabs(z.z);
	z.z += t;
	z.z *= fractal->transformCommon.scaleA3;
	aux->DE *= fractal->transformCommon.scale3;

	if (fractal->transformCommon.functionEnabledSFalse
			&& aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		REAL rr = dot(z, z);
		// if (r2 < 1e-21f && r2 > -1e-21f) r2 = (r2 > 0) ? 1e-21f : -1e-21f;

		if (rr < fractal->transformCommon.minR2p25)
		{
			z *= fractal->transformCommon.maxMinR2factor;
			aux->DE *= fractal->transformCommon.maxMinR2factor;
		}
		else if (rr < fractal->transformCommon.maxR2d1)
		{
			REAL tglad_factor2 = fractal->transformCommon.maxR2d1 / rr;
			z *= tglad_factor2;
			aux->DE *= tglad_factor2;
		}
	}

	aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}