/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Mandelnest by Jeannoc, adapted by pupukuusikko
 * https://fractalforums.org/share-a-fractal/22/mandelbrot-3d-mandelnest/4028/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelnest.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandelnestIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL Power = fractal->bulb.power;
	REAL shift = fractal->transformCommon.offset0 * M_PI_F;

	REAL r = aux->r;
	REAL rN = 1.0f / r;
	aux->DE *= rN;

	if (fractal->transformCommon.functionEnabledFalse)
	{
		if (fractal->transformCommon.functionEnabledAxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledAyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledAzFalse) z.z = fabs(z.z);
	}

	z.x = (native_cos(shift + Power * acos(z.x * rN)));
	z.y = (native_cos(shift + Power * acos(z.y * rN)));
	z.z = (native_cos(shift + Power * acos(z.z * rN)));

	if (!fractal->transformCommon.functionEnabledAFalse)
	{
		rN = 1.0f / length(z);
		z *= rN;
		aux->DE *= rN;
	}

	z *= native_powr(r, Power - fractal->transformCommon.offset1);

	if (aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
		z += fractal->transformCommon.offsetF000;

	r = length(z);

	aux->DE = aux->DE * Power * r + 1.0f;
	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
		if (fractal->transformCommon.functionEnabledBFalse)
			aux->DE = max(aux->DE, fractal->analyticDE.offset2);

		if (fractal->transformCommon.functionEnabledDFalse)
		{
			aux->dist = 0.5f * log(r) * r / aux->DE;
			aux->dist = min(aux->dist, fractal->analyticDE.offset1);
		}
	}
	return z;
}