/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Based on a DarkBeam fold formula
 * http://www.fractalforums.com/amazing-box-amazing-surf-and-variations/'new'-fractal-type-mandalay/msg81349/#msg81349

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandalay_kifs.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandalayKIFSIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL colorAdd = 0.0f;
	REAL rrCol = 0.0f;

	// tglad fold
	if (fractal->transformCommon.functionEnabledAFalse
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA)
	{
		z.x = fabs(z.x + fractal->transformCommon.additionConstantA000.x)
					- fabs(z.x - fractal->transformCommon.additionConstantA000.x) - z.x;
		z.y = fabs(z.y + fractal->transformCommon.additionConstantA000.y)
					- fabs(z.y - fractal->transformCommon.additionConstantA000.y) - z.y;
		if (fractal->transformCommon.functionEnabled)
		{
			z.z = fabs(z.z + fractal->transformCommon.additionConstantA000.z)
						- fabs(z.z - fractal->transformCommon.additionConstantA000.z) - z.z;
		}
	}

	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP)
	{
		if (fractal->transformCommon.functionEnabledAx) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledAy) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledAz) z.z = fabs(z.z);
	}
	else // transformCommon.functionEnabledM
	{
		z = fabs(z);
	}

	REAL fo = fractal->transformCommon.offsetA1;
	REAL g = fractal->transformCommon.offset1;
	REAL zT = fractal->transformCommon.offset0;
	REAL4 p = z;

	// Kifs Octahedral fold:
	if (z.y > z.x)
	{
		REAL temp = z.x;
		z.x = z.y;
		z.y = temp;
	}

	if (fractal->transformCommon.functionEnabledM && z.z > z.y)
	{
		REAL temp = z.y;
		z.y = z.z;
		z.z = temp;
	}

	if (z.y > z.x)
	{
		REAL temp = z.x;
		z.x = z.y;
		z.y = temp;
	}

	// ABoxKali-like abs folding:
	REAL fx = -2.0f * fo + z.x;
	// Edges:
	p.x = (fo - fabs(-fo + z.x));
	p.y = (fo - fabs(-fo + z.y));

	if (!fractal->transformCommon.functionEnabledTFalse)
		p.z = zT + z.z;
	else
		p.z = zT - fabs(-fo + z.z);

	REAL gy = g + z.y;
	if (fx > 0.0f && fx > z.y)
	{
		if (fx > gy)
		{
			// top:
			p.x += g;
			p.y = (fo - fabs(g - fo + z.y));
		}
		else
		{
			// edges:
			p.x = -z.y;
			p.y = (fo - fabs(-3.0f * fo + z.x));
		}
	}
	z = p;

	// spherical fold
	REAL useScale = 1.0f;
	if (aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		REAL rr = dot(z, z);
		rrCol = rr;
		if (rr < fractal->transformCommon.minR0)
		{
			REAL tglad_factor1 = fractal->transformCommon.maxR2d1 / fractal->transformCommon.minR0;
			z *= tglad_factor1;
			aux->DE *= tglad_factor1;
		}
		else if (rr < fractal->transformCommon.maxR2d1)
		{
			REAL tglad_factor2 = fractal->transformCommon.maxR2d1 / rr;
			z *= tglad_factor2;
			aux->DE *= tglad_factor2;
		}
	}

	// scale
	useScale = aux->actualScaleA + fractal->transformCommon.scale2;
	z *= useScale;
	aux->DE = aux->DE * fabs(useScale) + 1.0f;

	if (fractal->transformCommon.functionEnabledKFalse
			&& aux->i >= fractal->transformCommon.startIterationsK
			&& aux->i < fractal->transformCommon.stopIterationsK)
	{
		// update actualScaleA for next iteration
		REAL vary = fractal->transformCommon.scaleVary0
								* (fabs(aux->actualScaleA) - fractal->transformCommon.scaleC1);
		aux->actualScaleA -= vary;
	}

	// rotation
	if (fractal->transformCommon.rotationEnabled
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

	if (fractal->foldColor.auxColorEnabledFalse)
	{
		if (rrCol < fractal->transformCommon.maxR2d1)
		{
			colorAdd += fractal->mandelbox.color.factorSp2 * (fractal->transformCommon.maxR2d1 - rrCol);
			if (rrCol < fractal->transformCommon.minR2p25)
				colorAdd += fractal->mandelbox.color.factorSp1 * (fractal->transformCommon.minR2p25 - rrCol)
										+ fractal->mandelbox.color.factorSp2
												* (fractal->transformCommon.maxR2d1 - fractal->transformCommon.minR2p25);
		}
		aux->color += colorAdd;
	}

	if (fractal->transformCommon.functionEnabledXFalse)
	{
		p = fabs(z);
		aux->dist = max(p.x, max(p.y, p.z));
		aux->dist = aux->dist / aux->DE;
	}
	return z;
}