/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesiT1PineTree 3D
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_benesi_t1_pine_tree.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 BenesiT1PineTreeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.benesiT1Enabled && aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{

		// Benesi mag transform T1
		if (fractal->transformCommon.benesiT1Enabled
				&& aux->i >= fractal->transformCommon.startIterations
				&& aux->i < fractal->transformCommon.stopIterations)
		{
			REAL tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
			z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
				z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};

			REAL tempL = length(z);
			z = fabs(z) * fractal->transformCommon.scale3D222;
			// if (tempL < 1e-21f) tempL = 1e-21f;
			REAL avgScale = length(z) / tempL;
			aux->DE = aux->DE * avgScale + 1.0f;

			if (fractal->transformCommon.rotationEnabled)
			{ // rotation inside T1
				z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
			}

			tempXZ = (z.y + z.x) * SQRT_1_2_F;

			z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
				z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
			z = z - fractal->transformCommon.offset200;
		}
	}
	//  Benesi pine tree pwr2
	if (fractal->transformCommon.addCpixelEnabled
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		REAL4 zz = z * z;
		aux->r = native_sqrt(zz.x + zz.y + zz.z); // needed when alternating pwr2s
		aux->DE = aux->r * aux->DE * 2.0f + 1.0f;

		REAL t = 1.0f;
		REAL temp = zz.y + zz.z;
		if (temp > 0.0f) t = 2.0f * z.x / native_sqrt(temp);
		temp = z.z;
		z.x = (zz.x - zz.y - zz.z);
		z.y = (2.0f * t * z.y * temp);
		z.z = (t * (zz.y - zz.z));

		// swap c.yz then add cPixel
		REAL4 tempC = aux->const_c;
		if (fractal->transformCommon.alternateEnabledFalse) // alternate
		{
			tempC = aux->c * fractal->transformCommon.constantMultiplier100;
			tempC = (REAL4){tempC.x, tempC.z, tempC.y, tempC.w};
			aux->c = tempC;
		}
		else
		{
			tempC *= fractal->transformCommon.constantMultiplier100;
			tempC = (REAL4){tempC.x, tempC.z, tempC.y, tempC.w};
		}
		z += tempC;
	}

	if (fractal->transformCommon.functionEnabledBxFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD)
	{
		z = (REAL4){z.x * native_cos(z.y * fractal->transformCommon.scale1),
					z.x * native_sin(z.y * fractal->transformCommon.scale1),
					z.z * fractal->transformCommon.scaleC1, z.w}
				* fractal->transformCommon.scaleA1;
		aux->DE *= fabs(fractal->transformCommon.scaleA1);
	}

	if (fractal->transformCommon.juliaMode)
	{
		z.x += fractal->transformCommon.offset000.x;
		z.y += fractal->transformCommon.offset000.y;
		z.z += fractal->transformCommon.offset000.z;
	}
	if (fractal->transformCommon.rotation2EnabledFalse)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix2, z);
	}
	return z;
}