/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesiMagTransforms
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_benesi_mag_transforms.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 BenesiMagTransformsIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 c = aux->const_c;
	// benesi T1
	if (fractal->transformCommon.benesiT1Enabled && aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		REAL tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
		z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
			z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};

		REAL tempL = length(z);
		z = fabs(z) * fractal->transformCommon.scale3D222;
		// if (tempL < 1e-21f) tempL = 1e-21f;
		REAL avgScale = length(z) / tempL;
		aux->DE = aux->DE * avgScale;

		tempXZ = (z.y + z.x) * SQRT_1_2_F;
		z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
			z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
		z = z - fractal->transformCommon.offset200;
	}
	// rotation
	if (fractal->transformCommon.rotationEnabled)
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);

	//  Benesi pine tree pwr2
	if (fractal->transformCommon.addCpixelEnabled
			&& aux->i >= fractal->transformCommon.startIterationsT
			&& aux->i < fractal->transformCommon.stopIterationsT)
	{
		REAL4 zz = z * z;
		aux->r = native_sqrt(zz.x + zz.y + zz.z); // needed when alternating pwr2s
		aux->DE = aux->r * aux->DE * 2.0f + 1.0f;

		REAL t = 1.0f;
		REAL temp = zz.y + zz.z;
		if (temp > 0.0f) t = 2.0f * z.x / native_sqrt(temp);
		temp = z.z;
		z.x = (zz.x - zz.y - zz.z);
		z.y = (2.0f * t * z.y * temp);
		z.z = (t * (zz.y - zz.z));

		// swap c.yz then add cPixel
		REAL4 tempC = c;
		if (fractal->transformCommon.alternateEnabledFalse) // alternate
		{
			tempC = aux->c * fractal->transformCommon.constantMultiplier100;
			tempC = (REAL4){tempC.x, tempC.z, tempC.y, tempC.w};
			aux->c = tempC;
		}
		else
		{
			tempC *= fractal->transformCommon.constantMultiplier100;
			tempC = (REAL4){tempC.x, tempC.z, tempC.y, tempC.w};
		}
		z += tempC;
	}

	if (fractal->transformCommon.juliaMode)
	{
		z.x += fractal->transformCommon.juliaC.x * fractal->transformCommon.constantMultiplier100.x;
		z.z += fractal->transformCommon.juliaC.y * fractal->transformCommon.constantMultiplier100.y;
		z.y += fractal->transformCommon.juliaC.z * fractal->transformCommon.constantMultiplier100.z;
	}
	// additional transform slot controls
	bool functionEnabledN[5] = {fractal->transformCommon.functionEnabledAxFalse,
		fractal->transformCommon.functionEnabledAyFalse,
		fractal->transformCommon.functionEnabledAzFalse,
		fractal->transformCommon.functionEnabledBxFalse,
		fractal->transformCommon.functionEnabledByFalse};
	int startIterationN[5] = {fractal->transformCommon.startIterationsA,
		fractal->transformCommon.startIterationsB, fractal->transformCommon.startIterationsC,
		fractal->transformCommon.startIterationsD, fractal->transformCommon.startIterationsE};
	int stopIterationN[5] = {fractal->transformCommon.stopIterationsA,
		fractal->transformCommon.stopIterationsB, fractal->transformCommon.stopIterationsC,
		fractal->transformCommon.stopIterationsD, fractal->transformCommon.stopIterationsE};

	enumMulti_orderOfTransfCl transfN[5] = {fractal->magTransf.orderOfTransf1,
		fractal->magTransf.orderOfTransf2, fractal->magTransf.orderOfTransf3,
		fractal->magTransf.orderOfTransf4, fractal->magTransf.orderOfTransf5};

	for (int f = 0; f < 5; f++)
	{
		if (functionEnabledN[f] && aux->i >= startIterationN[f] && aux->i < stopIterationN[f])
		{
			REAL tempXZ;
			REAL tempL;
			REAL4 temp;
			REAL avgScale;
			REAL4 tempV2;

			switch (transfN[f])
			{
				case multi_orderOfTransfCl_typeT1:
				default:
					tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
					z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
						z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};
					z = fabs(z) * fractal->transformCommon.scale3Da222;
					tempL = length(temp);
					// if (tempL < 1e-21f) tempL = 1e-21f;
					avgScale = length(z) / tempL;
					aux->DE = aux->DE * avgScale;
					tempXZ = (z.y + z.x) * SQRT_1_2_F;
					z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
						z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
					z = z - fractal->transformCommon.offsetA200;
					break;

				case multi_orderOfTransfCl_typeT1Mod:
					tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
					z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
						z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};
					z = fabs(z) * fractal->transformCommon.scale3D333;
					tempL = length(temp);
					// if (tempL < 1e-21f) tempL = 1e-21f;
					avgScale = length(z) / tempL;
					aux->DE = aux->DE * avgScale;
					z = (fabs(z + fractal->transformCommon.offset111)
							 - fabs(z - fractal->transformCommon.offset111) - z);
					tempXZ = (z.y + z.x) * SQRT_1_2_F;
					z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
						z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
					break;

				case multi_orderOfTransfCl_typeT2:
					tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
					z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
						z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};
					tempV2 = z;
					tempV2.x = native_sqrt(z.y * z.y + z.z * z.z);
					tempV2.y = native_sqrt(z.x * z.x + z.z * z.z); // switching, squared, sqrt
					tempV2.z = native_sqrt(z.x * z.x + z.y * z.y);
					z = fabs(tempV2 - fractal->transformCommon.offsetA111);
					temp = z;
					tempL = length(temp);
					z = fabs(z) * fractal->transformCommon.scale3D444;
					// if (tempL < 1e-21f) tempL = 1e-21f;
					avgScale = length(z) / tempL;
					aux->DE = aux->DE * avgScale;
					tempXZ = (z.y + z.x) * SQRT_1_2_F;
					z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
						z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
					break;

				case multi_orderOfTransfCl_typeT3:
					tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
					z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
						z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};

					tempV2 = z;
					tempV2.x = (z.y + z.z);
					tempV2.y = (z.x + z.z); // switching
					tempV2.z = (z.x + z.y);
					z = (fabs(tempV2 - fractal->transformCommon.offset222))
							* fractal->transformCommon.scale3Db222;
					aux->DE *= length(z) / length(tempV2);

					tempXZ = (z.y + z.x) * SQRT_1_2_F;
					z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
						z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
					break;

				case multi_orderOfTransfCl_typeT4:
					tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
					z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
						z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};

					tempV2 = z;
					tempV2.x = (z.y * z.y + z.z * z.z);
					tempV2.y = (z.x * z.x + z.z * z.z); // switching, squared,
					tempV2.z = (z.x * z.x + z.y * z.y);
					z = (fabs(tempV2 - fractal->transformCommon.offsetB111))
							* fractal->transformCommon.scale3Dc222;
					aux->DE *= length(z) / length(tempV2);

					tempXZ = (z.y + z.x) * SQRT_1_2_F;
					z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
						z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
					break;

				case multi_orderOfTransfCl_typeT5b:
					tempXZ = z.x * SQRT_2_3_F - z.z * SQRT_1_3_F;
					z = (REAL4){(tempXZ - z.y) * SQRT_1_2_F, (tempXZ + z.y) * SQRT_1_2_F,
						z.x * SQRT_1_3_F + z.z * SQRT_2_3_F, z.w};
					// if (z.x > -1e-21f && z.x < 1e-21f)
					//	z.x = (z.x > 0) ? 1e-21f : -1e-21f;
					// if (z.y > -1e-21f && z.y < 1e-21f)
					//	z.y = (z.y > 0) ? 1e-21f : -1e-21f;
					// if (z.z > -1e-21f && z.z < 1e-21f)
					//	z.z = (z.z > 0) ? 1e-21f : -1e-21f;
					tempV2 = z;
					tempV2.x = fabs(native_powr(native_powr(z.y, fractal->transformCommon.int8X)
																				+ native_powr(z.z, fractal->transformCommon.int8X),
						fractal->transformCommon.power025.x));
					tempV2.y = fabs(native_powr(native_powr(z.x, fractal->transformCommon.int8Y)
																				+ native_powr(z.z, fractal->transformCommon.int8Y),
						fractal->transformCommon.power025.y));
					tempV2.z = fabs(native_powr(native_powr(z.x, fractal->transformCommon.int8Z)
																				+ native_powr(z.y, fractal->transformCommon.int8Z),
						fractal->transformCommon.power025.z));
					z = (fabs(tempV2 - fractal->transformCommon.offsetC111))
							* fractal->transformCommon.scale3Dd222;
					aux->DE *= length(z) / length(tempV2);

					tempXZ = (z.y + z.x) * SQRT_1_2_F;
					z = (REAL4){z.z * SQRT_1_3_F + tempXZ * SQRT_2_3_F, (z.y - z.x) * SQRT_1_2_F,
						z.z * SQRT_2_3_F - tempXZ * SQRT_1_3_F, z.w};
					break;
			}
		}
	}
	// analyticDE controls
	if (fractal->analyticDE.enabled)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;
	return z;
}