/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * ABoxModKali V3, a formula from Mandelbulb3D
 * @reference http://www.fractalforums.com/new-theories-and-research/aboxmodkali-the-2d-version/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_abox_mod_kali_v3.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 AboxModKaliV3Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterations15)
	{
		z = fractal->transformCommon.offset111 - fabs(z);
		REAL rr = dot(z, z);
		REAL MinR = fractal->transformCommon.minR0;
		REAL dividend = rr < MinR ? MinR : min(rr, 1.0f);
		REAL m = -fractal->transformCommon.scale015 / dividend;
		z = z * m;
		aux->DE = aux->DE * fabs(m) + 1.0f;
	}

	if (aux->i >= fractal->transformCommon.startIterationsB
			&& aux->i < fractal->transformCommon.stopIterationsB)
	{
		z += fractal->transformCommon.offsetA111;
	}

	// TODO add the options
	return z;
}