/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * ABoxModKali, a formula from Mandelbulb3D
 * @reference http://www.fractalforums.com/new-theories-and-research/aboxmodkali-the-2d-version/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_abox_mod_kali.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 AboxModKaliIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	// 3D Rotation
	if (fractal->mandelbox.mainRotationEnabled)
	{
		REAL4 tempVC = (REAL4){fractal->mandelbox.rotationMain.x, fractal->mandelbox.rotationMain.y,
			fractal->mandelbox.rotationMain.z, 0.0f}; // constant to be varied
		if (fractal->transformCommon.functionEnabledPFalse)
		{
			if (aux->i >= fractal->transformCommon.startIterations
					&& aux->i < fractal->transformCommon.stopIterations
					&& (fractal->transformCommon.stopIterations - fractal->transformCommon.startIterations
							!= 0))
			{
				REAL iterationRange =
					fractal->transformCommon.stopIterations - fractal->transformCommon.startIterations;
				REAL currentIteration = (aux->i - fractal->transformCommon.startIterations);
				tempVC += fractal->transformCommon.offset000 * currentIteration / iterationRange;
			}

			if (aux->i >= fractal->transformCommon.stopIterations)
			{
				tempVC += tempVC + fractal->transformCommon.offset000;
			}
		}

		tempVC *= M_PI_180_F;

		if (tempVC.x != 0.0f) z = RotateAroundVectorByAngle4(z, (REAL3){1.0f, 0.0f, 0.0f}, tempVC.x);
		if (tempVC.y != 0.0f) z = RotateAroundVectorByAngle4(z, (REAL3){0.0f, 1.0f, 0.0f}, tempVC.y);
		if (tempVC.z != 0.0f) z = RotateAroundVectorByAngle4(z, (REAL3){0.0f, 0.0f, 1.0f}, tempVC.z);
	}

	z = fractal->transformCommon.additionConstant0555 - fabs(z);
	REAL rr = dot(z, z);
	REAL MinR = fractal->transformCommon.minR06;
	REAL dividend = rr < MinR ? MinR : min(rr, 1.0f);
	REAL m = fractal->transformCommon.scale015 / dividend;
	z = z * m;
	aux->DE = aux->DE * fabs(m) + 1.0f;
	return z;
}