!-------------------------------------------------------------------------------
!> module file_history
!!
!! @par Description
!!          I/O handling for history output
!!
!! @author Team SCALE
!!
!<
!-------------------------------------------------------------------------------
! Warning: This file was generated from file/scale_file_history.F90.erb.
!          Do not edit this file.
!-------------------------------------------------------------------------------
#include "scalelib.h"
module scale_file_history
  !-----------------------------------------------------------------------------
  !
  !++ Used modules
  !
  use scale_precision
  use scale_io
  use scale_prof
  use scale_prc, only: &
     PRC_abort
  !-----------------------------------------------------------------------------
  implicit none
  private
  !-----------------------------------------------------------------------------
  !
  !++ Public procedures
  !
  public :: FILE_HISTORY_Setup
  public :: FILE_HISTORY_Query
  public :: FILE_HISTORY_reg
  public :: FILE_HISTORY_Put
  public :: FILE_HISTORY_Write
  public :: FILE_HISTORY_in
  public :: FILE_HISTORY_Set_Dim
  public :: FILE_HISTORY_Set_Axis
  public :: FILE_HISTORY_Set_AssociatedCoordinate
  public :: FILE_HISTORY_Set_Attribute
  public :: FILE_HISTORY_Set_NowDate
  public :: FILE_HISTORY_Set_Disable
  public :: FILE_HISTORY_Finalize

  interface FILE_HISTORY_Query
     module procedure FILE_HISTORY_Query_NAME
     module procedure FILE_HISTORY_Query_ID
  end interface FILE_HISTORY_Query

  interface FILE_HISTORY_Put
     module procedure FILE_HISTORY_Put_0D
     module procedure FILE_HISTORY_Put_1D
     module procedure FILE_HISTORY_Put_2D
     module procedure FILE_HISTORY_Put_3D
     module procedure FILE_HISTORY_Put_4D
  end interface FILE_HISTORY_Put

  interface FILE_HISTORY_in
     module procedure FILE_HISTORY_in_0D
     module procedure FILE_HISTORY_in_1D
     module procedure FILE_HISTORY_in_2D
     module procedure FILE_HISTORY_in_3D
     module procedure FILE_HISTORY_in_4D
  end interface FILE_HISTORY_in

  abstract interface
     subroutine truncate_1D( src, dim_type, zcoord, fill_halo, dsc )
       import RP, DP
       real(RP),         intent(in) :: src(:)
       character(len=*), intent(in) :: dim_type
       character(len=*), intent(in) :: zcoord
       logical,          intent(in) :: fill_halo
       real(DP),         intent(out) :: dsc(:)
     end subroutine truncate_1D
  end interface
  procedure(truncate_1D), pointer :: FILE_HISTORY_truncate_1D => NULL()
  public :: FILE_HISTORY_truncate_1D
  abstract interface
     subroutine truncate_2D( src, dim_type, zcoord, fill_halo, dsc )
       import RP, DP
       real(RP),         intent(in) :: src(:,:)
       character(len=*), intent(in) :: dim_type
       character(len=*), intent(in) :: zcoord
       logical,          intent(in) :: fill_halo
       real(DP),         intent(out) :: dsc(:)
     end subroutine truncate_2D
  end interface
  procedure(truncate_2D), pointer :: FILE_HISTORY_truncate_2D => NULL()
  public :: FILE_HISTORY_truncate_2D
  abstract interface
     subroutine truncate_3D( src, dim_type, zcoord, fill_halo, dsc )
       import RP, DP
       real(RP),         intent(in) :: src(:,:,:)
       character(len=*), intent(in) :: dim_type
       character(len=*), intent(in) :: zcoord
       logical,          intent(in) :: fill_halo
       real(DP),         intent(out) :: dsc(:)
     end subroutine truncate_3D
  end interface
  procedure(truncate_3D), pointer :: FILE_HISTORY_truncate_3D => NULL()
  public :: FILE_HISTORY_truncate_3D
  abstract interface
     subroutine truncate_4D( src, dim_type, zcoord, fill_halo, dsc )
       import RP, DP
       real(RP),         intent(in) :: src(:,:,:,:)
       character(len=*), intent(in) :: dim_type
       character(len=*), intent(in) :: zcoord
       logical,          intent(in) :: fill_halo
       real(DP),         intent(out) :: dsc(:)
     end subroutine truncate_4D
  end interface
  procedure(truncate_4D), pointer :: FILE_HISTORY_truncate_4D => NULL()
  public :: FILE_HISTORY_truncate_4D


  interface FILE_HISTORY_Set_AssociatedCoordinate
     module procedure FILE_HISTORY_Set_AssociatedCoordinate_1D
     module procedure FILE_HISTORY_Set_AssociatedCoordinate_2D
     module procedure FILE_HISTORY_Set_AssociatedCoordinate_3D
  end interface FILE_HISTORY_Set_AssociatedCoordinate

  interface FILE_HISTORY_Set_Attribute
     module procedure FILE_HISTORY_Set_Attribute_Text
     module procedure FILE_HISTORY_Set_Attribute_Logical
     module procedure FILE_HISTORY_Set_Attribute_Int
     module procedure FILE_HISTORY_Set_Attribute_Float
     module procedure FILE_HISTORY_Set_Attribute_Double
  end interface FILE_HISTORY_Set_Attribute


  !-----------------------------------------------------------------------------
  !
  !++ included parameters
  !
  !-----------------------------------------------------------------------------
  !
  !++ Public parameters & variables
  !
  logical, public :: FILE_HISTORY_AGGREGATE !> Switch to use aggregate file I/O
  !-----------------------------------------------------------------------------
  !
  !++ Private procedures
  !
  private :: FILE_HISTORY_Create
  private :: FILE_HISTORY_Close
  private :: FILE_HISTORY_Add_Variable
  private :: FILE_HISTORY_Write_Axes
  private :: FILE_HISTORY_Write_OneVar
  private :: FILE_HISTORY_Output_List
  private :: FILE_HISTORY_Check

  !-----------------------------------------------------------------------------
  !
  !++ Private parameters & variables
  !

  type request
     character(len=H_SHORT) :: name              !> Name of variable (in the code)
     character(len=H_SHORT) :: outname           !> Name of variable (for output)
     character(len=H_LONG)  :: basename          !> Base name of the file
     logical                :: postfix_timelabel !> Add time label to basename?
     character(len=H_SHORT) :: zcoord            !> Z-coordinate
     integer                :: dstep             !> Time unit
     logical                :: taverage          !> Apply time average?
     integer                :: dtype             !> Data type
     character(len=H_SHORT) :: cell_measures     !> Cell measures
     logical                :: registered        !> This item is registered?
  end type request

  type var_out
     character(len=H_SHORT) :: name              !> Name of variable (in the code)
     character(len=H_SHORT) :: outname           !> Name of variable (for output)
     character(len=H_LONG)  :: basename          !> Base name of the file
     logical                :: postfix_timelabel !> Add time label to basename?
     character(len=H_SHORT) :: zcoord            !> Z-coordinate
     integer                :: zid               !> Z-coordinate index
     integer                :: dstep             !> Time unit
     logical                :: taverage          !> Apply time average?
     integer                :: dtype             !> Data type

     integer                :: fid               !> FILE id of the file
     integer                :: vid               !> Variable id
     character(len=H_LONG)  :: desc              !> Variable description
     character(len=H_SHORT) :: units             !> Variable units
     character(len=H_SHORT) :: standard_name     !> Variable standard_name
     integer                :: dimid             !> dimension ID
     character(len=H_SHORT) :: cell_measures     !> Cell measures
     integer                :: waitstep          !> Step length to suppress output [step]
     integer                :: laststep_write    !> Last step when the variable is written
     integer                :: laststep_put      !> Last step when the variable is put
     logical                :: flag_clear        !> Data buffer should be cleared at the timing of putting?
     integer                :: size              !> Size of array
     real(DP)               :: timesum           !> Buffer for time
     real(DP), pointer      :: varsum(:)         !> Buffer for value
     logical                :: fill_halo         !> switch to fill halo with RMISS value
  end type var_out

  integer, parameter :: FILE_HISTORY_variant_max = 10
  type var_in
     character(len=H_SHORT) :: name
     integer                :: nvariants
     integer                :: variants(FILE_HISTORY_variant_max)
  end type var_in

  type dim
     character(len=H_SHORT)          :: name
     integer                         :: ndims
     integer                         :: nzcoords
     character(len=H_SHORT), pointer :: dims(:,:)
     integer               , pointer :: start(:,:)
     integer               , pointer :: count(:,:)
     integer               , pointer :: size(:)
     character(len=H_SHORT), pointer :: zcoords(:)
     character(len=H_SHORT)          :: mapping
     character(len=H_SHORT)          :: area
     character(len=H_SHORT)          :: area_x
     character(len=H_SHORT)          :: area_y
     character(len=H_SHORT)          :: volume
     character(len=H_SHORT)          :: location
     character(len=H_SHORT)          :: grid
  end type dim

  type axis
     character(len=H_SHORT) :: name
     character(len=H_LONG)  :: desc
     character(len=H_SHORT) :: units
     character(len=H_SHORT) :: dim
     integer                :: dim_size
     real(DP), pointer      :: var(:)
     real(DP), pointer      :: bounds(:,:)
     logical                :: down
     integer                :: gdim_size  ! global dimension size
     integer                :: start      ! global array start index
  end type axis

  type assoc
     character(len=H_SHORT) :: name
     character(len=H_LONG)  :: desc
     character(len=H_SHORT) :: units
     integer                :: ndims
     character(len=H_SHORT) :: dims(4)
     integer                :: dtype
     real(DP), pointer      :: var(:)
     integer                :: start(4)   ! global array start indices
     integer                :: count(4)   ! global array request lengths
  end type assoc

  integer, parameter :: I_TEXT = 1, I_INT = 2, I_FLOAT = 3, I_DOUBLE = 4
  type attr
     character(len=H_SHORT) :: varname
     character(len=H_MID)   :: key
     integer                :: type
     character(len=H_LONG)  :: text
     integer,  pointer      :: int(:)
     real(SP), pointer      :: float(:)
     real(DP), pointer      :: double(:)
     logical                :: add_variable
  end type attr

  ! From upstream side of the library
  integer                :: FILE_HISTORY_myrank      !> Number of my rank


  real(DP)               :: FILE_HISTORY_STARTDAYSEC !> Start date [second]
  real(DP)               :: FILE_HISTORY_DTSEC       !> Delta t    [second]
  character(len=H_MID)   :: FILE_HISTORY_TIME_SINCE  !> Offset time

  ! From NAMELIST or upstream side of the library
  character(len=H_MID)   :: FILE_HISTORY_TITLE       !> Header information of the output file: title
  character(len=H_MID)   :: FILE_HISTORY_SOURCE      !> Header information of the output file: model name
  character(len=H_MID)   :: FILE_HISTORY_INSTITUTION !> Header information of the output file: institution

  character(len=H_MID)   :: FILE_HISTORY_TIME_UNITS             !> Unit for time axis
  character(len=H_SHORT) :: FILE_HISTORY_CALENDAR               !> Calendar name
  logical                :: FILE_HISTORY_OUTPUT_STEP0 = .false. !> Output value at step=0?
  integer                :: FILE_HISTORY_OUTPUT_WAIT_STEP       !> Step length to suppress output
  integer                :: FILE_HISTORY_OUTPUT_SWITCH_STEP     !> Step interval to switch output file
  integer                :: FILE_HISTORY_OUTPUT_SWITCH_LASTSTEP !> Last step when the file is switched
  logical                :: FILE_HISTORY_ERROR_PUTMISS = .true. !> Abort if the value is never stored after last output?

  ! working
  integer,       parameter   :: FILE_HISTORY_req_max = 1000 !> number limit for history item request
  integer                    :: FILE_HISTORY_nreqs = 0      !> number of requested item
  type(request), allocatable :: FILE_HISTORY_req(:)

  integer                    :: FILE_HISTORY_nitems = 0     !> number of registered item
  type(var_out), allocatable :: FILE_HISTORY_vars(:)

  integer                    :: FILE_HISTORY_nvar_inputs
  type(var_in),  allocatable :: FILE_HISTORY_var_inputs(:)

  integer,       parameter   :: FILE_HISTORY_dim_max = 30
  integer                    :: FILE_HISTORY_ndims = 0
  type(dim)                  :: FILE_HISTORY_dims(FILE_HISTORY_dim_max)

  integer,       parameter   :: FILE_HISTORY_axis_max = 100
  integer                    :: FILE_HISTORY_naxes    =   0
  type(axis)                 :: FILE_HISTORY_axes(FILE_HISTORY_axis_max)

  integer,       parameter   :: FILE_HISTORY_assoc_max = 40
  integer                    :: FILE_HISTORY_nassocs   =  0
  type(assoc)                :: FILE_HISTORY_assocs(FILE_HISTORY_assoc_max)

  integer,       parameter   :: FILE_HISTORY_attr_max = 200
  integer                    :: FILE_HISTORY_nattrs   = 0
  type(attr)                 :: FILE_HISTORY_attrs(FILE_HISTORY_attr_max)

  integer                    :: FILE_HISTORY_NOWDATE(6)         !> date at the time
  real(DP)                   :: FILE_HISTORY_NOWMS              !> milli sec
  integer                    :: FILE_HISTORY_NOWSTEP            !> step at the time

  integer(8)                 :: FILE_HISTORY_io_buffer_size = 0 !> internal buffer for PnetCDF

  character(len=H_MID)       :: FILE_HISTORY_options = ''       !> option to give file.  'filetype1:key1=val1&filetype2:key2=val2&...'


  logical                    :: FILE_HISTORY_disabled = .true.

  integer                    :: laststep_write = -1
  logical                    :: firsttime      = .true.
  logical                    :: debug          = .false.

  !-----------------------------------------------------------------------------
contains
  !-----------------------------------------------------------------------------
  !> Setup
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Setup( &
       title, source, institution,       &
       time_start, time_interval,        &
       time_units, time_since, calendar, &
       default_basename,                 &
       default_postfix_timelabel,        &
       default_zcoord,                   &
       default_tinterval,                &
       default_tunit,                    &
       default_taverage,                 &
       default_datatype,                 &
       myrank                            )
    use scale_file_h, only: &
       FILE_REAL4, &
       FILE_REAL8
    use scale_file, only: &
       FILE_AGGREGATE
    use scale_calendar, only: &
       CALENDAR_unit2sec
    implicit none

    character(len=*), intent(in)  :: title
    character(len=*), intent(in)  :: source
    character(len=*), intent(in)  :: institution
    real(DP),         intent(in)  :: time_start
    real(DP),         intent(in)  :: time_interval

    character(len=*), intent(in), optional :: time_units
    character(len=*), intent(in), optional :: time_since
    character(len=*), intent(in), optional :: calendar
    character(len=*), intent(in), optional :: default_basename
    logical,          intent(in), optional :: default_postfix_timelabel
    character(len=*), intent(in), optional :: default_zcoord
    real(DP),         intent(in), optional :: default_tinterval
    character(len=*), intent(in), optional :: default_tunit
    logical,          intent(in), optional :: default_taverage
    character(len=*), intent(in), optional :: default_datatype
    integer,          intent(in), optional :: myrank

    character(len=H_LONG)  :: FILE_HISTORY_DEFAULT_BASENAME          !> Base name of the file
    logical                :: FILE_HISTORY_DEFAULT_POSTFIX_TIMELABEL !> Add timelabel to the basename?
    character(len=H_SHORT) :: FILE_HISTORY_DEFAULT_ZCOORD            !> Default z-coordinate
    real(DP)               :: FILE_HISTORY_DEFAULT_TINTERVAL         !> Time interval
    character(len=H_SHORT) :: FILE_HISTORY_DEFAULT_TUNIT             !> Time unit
    logical                :: FILE_HISTORY_DEFAULT_TAVERAGE          !> Apply time average?
    character(len=H_SHORT) :: FILE_HISTORY_DEFAULT_DATATYPE          !> Data type
                                                                     !> REAL4 : single precision
                                                                     !> REAL8 : double precision
    real(DP)               :: FILE_HISTORY_OUTPUT_WAIT               !> Time length to suppress output
    character(len=H_SHORT) :: FILE_HISTORY_OUTPUT_WAIT_TUNIT         !> Time unit
    real(DP)               :: FILE_HISTORY_OUTPUT_SWITCH_TINTERVAL   !> Time interval to switch output file
    character(len=H_SHORT) :: FILE_HISTORY_OUTPUT_SWITCH_TUNIT       !> Time unit

    namelist / PARAM_FILE_HISTORY / &
       FILE_HISTORY_TITLE,                     &
       FILE_HISTORY_SOURCE,                    &
       FILE_HISTORY_INSTITUTION,               &
       FILE_HISTORY_TIME_UNITS,                &
       FILE_HISTORY_DEFAULT_BASENAME,          &
       FILE_HISTORY_DEFAULT_POSTFIX_TIMELABEL, &
       FILE_HISTORY_DEFAULT_ZCOORD,            &
       FILE_HISTORY_DEFAULT_TINTERVAL,         &
       FILE_HISTORY_DEFAULT_TUNIT,             &
       FILE_HISTORY_DEFAULT_TAVERAGE,          &
       FILE_HISTORY_DEFAULT_DATATYPE,          &
       FILE_HISTORY_OUTPUT_STEP0,              &
       FILE_HISTORY_OUTPUT_WAIT,               &
       FILE_HISTORY_OUTPUT_WAIT_TUNIT,         &
       FILE_HISTORY_OUTPUT_SWITCH_TINTERVAL,   &
       FILE_HISTORY_OUTPUT_SWITCH_TUNIT,       &
       FILE_HISTORY_ERROR_PUTMISS,             &
       FILE_HISTORY_AGGREGATE,                 &
       FILE_HISTORY_OPTIONS,                   &
       debug

    character(len=H_SHORT) :: NAME              !> name of variable (in the code)
    character(len=H_SHORT) :: OUTNAME           !> name of variable (for output)
    character(len=H_LONG)  :: BASENAME          !> base name of the file
    logical                :: POSTFIX_TIMELABEL !> Add timelabel to the basename?
    character(len=H_SHORT) :: ZCOORD            !> z-coordinate
    real(DP)               :: TINTERVAL         !> time interval
    character(len=H_SHORT) :: TUNIT             !> time unit
    logical                :: TAVERAGE          !> apply time average?
    character(len=H_SHORT) :: DATATYPE          !> data type

    namelist / HISTORY_ITEM / &
       NAME,              &
       OUTNAME,           &
       BASENAME,          &
       POSTFIX_TIMELABEL, &
       ZCOORD,            &
       TINTERVAL,         &
       TUNIT,             &
       TAVERAGE,          &
       DATATYPE


    integer  :: reqid
    real(DP) :: dtsec
    integer  :: dstep

    integer  :: ierr
    integer  :: n, id

    intrinsic size
    !---------------------------------------------------------------------------

    LOG_NEWLINE
    LOG_INFO("FILE_HISTORY_Setup",*) 'Setup'

    ! setup
    FILE_HISTORY_myrank      = myrank

    FILE_HISTORY_STARTDAYSEC = time_start
    FILE_HISTORY_DTSEC       = time_interval
    if ( present(time_since) ) then
       FILE_HISTORY_TIME_SINCE = time_since
    else
       FILE_HISTORY_TIME_SINCE = ''
    endif

    if ( present(calendar) ) then
       FILE_HISTORY_CALENDAR = calendar
    else
       FILE_HISTORY_CALENDAR = ""
    end if

    FILE_HISTORY_TIME_UNITS                = 'seconds' !> Unit for time axis
    FILE_HISTORY_DEFAULT_BASENAME          = ''        !> Base name of the file
    FILE_HISTORY_DEFAULT_POSTFIX_TIMELABEL = .false.   !> Add timelabel to the basename?
    FILE_HISTORY_DEFAULT_ZCOORD            = ''        !> Default z-coordinate
    FILE_HISTORY_DEFAULT_TINTERVAL         = -1.0_DP   !> Time interval
    FILE_HISTORY_DEFAULT_TUNIT             = 'SEC'     !> Time unit
    FILE_HISTORY_DEFAULT_TAVERAGE          = .false.   !> Apply time average?
    FILE_HISTORY_DEFAULT_DATATYPE          = 'REAL4'   !> Data type
    FILE_HISTORY_OUTPUT_WAIT               =  0.0_DP   !> Time length to suppress output
    FILE_HISTORY_OUTPUT_WAIT_TUNIT         = 'SEC'     !> Time unit
    FILE_HISTORY_OUTPUT_SWITCH_TINTERVAL   = -1.0_DP   !> Time interval to switch output file
    FILE_HISTORY_OUTPUT_SWITCH_TUNIT       = 'SEC'     !> Time unit

    FILE_HISTORY_AGGREGATE                 = FILE_AGGREGATE

    !--- read namelist
    FILE_HISTORY_TITLE       = title
    FILE_HISTORY_SOURCE      = source
    FILE_HISTORY_INSTITUTION = institution
    if( present(time_units)                ) FILE_HISTORY_TIME_UNITS                = time_units
    if( present(default_basename)          ) FILE_HISTORY_DEFAULT_BASENAME          = default_basename
    if( present(default_postfix_timelabel) ) FILE_HISTORY_DEFAULT_POSTFIX_TIMELABEL = default_postfix_timelabel
    if( present(default_zcoord)            ) FILE_HISTORY_DEFAULT_ZCOORD            = default_zcoord
    if( present(default_tinterval)         ) FILE_HISTORY_DEFAULT_TINTERVAL         = default_tinterval
    if( present(default_tunit)             ) FILE_HISTORY_DEFAULT_TUNIT             = default_tunit
    if( present(default_taverage)          ) FILE_HISTORY_DEFAULT_TAVERAGE          = default_taverage
    if( present(default_datatype)          ) FILE_HISTORY_DEFAULT_DATATYPE          = default_datatype

    !--- read namelist
    rewind(IO_FID_CONF)
    read(IO_FID_CONF,nml=PARAM_FILE_HISTORY,iostat=ierr)
    if( ierr < 0 ) then !--- missing
       LOG_INFO("FILE_HISTORY_Setup",*) 'Not found namelist. Default used.'
    elseif( ierr > 0 ) then !--- fatal error
       LOG_ERROR("FILE_HISTORY_Setup",*) 'Not appropriate names in namelist PARAM_FILE_HISTORY. Check!'
       call PRC_abort
    endif
    LOG_NML(PARAM_FILE_HISTORY)

    call IO_filename_replace( FILE_HISTORY_DEFAULT_BASENAME, 'FILE_HISTORY_DEFAULT_BASENAME' )


    if ( FILE_HISTORY_OUTPUT_WAIT >= 0.0_DP ) then
       call CALENDAR_unit2sec( dtsec, FILE_HISTORY_OUTPUT_WAIT, FILE_HISTORY_OUTPUT_WAIT_TUNIT )
       FILE_HISTORY_OUTPUT_WAIT_STEP = int( dtsec / FILE_HISTORY_DTSEC )
    else
       LOG_ERROR("FILE_HISTORY_Setup",*) 'FILE_HISTORY_OUTPUT_WAIT must be positive. STOP'
       call PRC_abort
    endif

    if ( FILE_HISTORY_OUTPUT_SWITCH_TINTERVAL >= 0.0_DP ) then
       call CALENDAR_unit2sec( dtsec, FILE_HISTORY_OUTPUT_SWITCH_TINTERVAL, FILE_HISTORY_OUTPUT_SWITCH_TUNIT )
       FILE_HISTORY_OUTPUT_SWITCH_STEP = int( dtsec / FILE_HISTORY_DTSEC )
    else
       FILE_HISTORY_OUTPUT_SWITCH_STEP = -1
    endif
    FILE_HISTORY_OUTPUT_SWITCH_LASTSTEP = 0


    ! count history request
    FILE_HISTORY_nreqs = 0
    if ( IO_FID_CONF > 0 ) rewind(IO_FID_CONF)
    do n = 1, FILE_HISTORY_req_max
       NAME      = ''
       OUTNAME   = 'undefined'
       BASENAME  = FILE_HISTORY_DEFAULT_BASENAME

       read(IO_FID_CONF,nml=HISTORY_ITEM,iostat=ierr)
       if( ierr /= 0 ) exit
       if( BASENAME == '' .OR. NAME == '' .OR. OUTNAME == '' ) cycle ! invalid HISTORY_ITEM

       FILE_HISTORY_nreqs = FILE_HISTORY_nreqs + 1
    enddo

    if    ( FILE_HISTORY_nreqs > FILE_HISTORY_req_max ) then
       LOG_ERROR("FILE_HISTORY_Setup",*) 'request of history file is exceed! n >', FILE_HISTORY_req_max
       call PRC_abort
    elseif( FILE_HISTORY_nreqs == 0 ) then
       LOG_INFO("FILE_HISTORY_Setup",*) 'No history file specified.'
       return
    endif

    allocate( FILE_HISTORY_req(FILE_HISTORY_nreqs) )

    ! read history request
    reqid   = 0
    if ( IO_FID_CONF > 0 ) rewind(IO_FID_CONF)
    do n = 1, FILE_HISTORY_req_max
       ! set default
       NAME              = ''
       OUTNAME           = 'undefined'
       BASENAME          = FILE_HISTORY_DEFAULT_BASENAME
       POSTFIX_TIMELABEL = FILE_HISTORY_DEFAULT_POSTFIX_TIMELABEL
       ZCOORD            = FILE_HISTORY_DEFAULT_ZCOORD
       TINTERVAL         = FILE_HISTORY_DEFAULT_TINTERVAL
       TUNIT             = FILE_HISTORY_DEFAULT_TUNIT
       TAVERAGE          = FILE_HISTORY_DEFAULT_TAVERAGE
       DATATYPE          = FILE_HISTORY_DEFAULT_DATATYPE

       read(IO_FID_CONF,nml=HISTORY_ITEM,iostat=ierr)
       if    ( ierr < 0 ) then
          exit ! no more items
       elseif( ierr > 0 ) then
          LOG_ERROR("FILE_HISTORY_Setup",*) 'Not appropriate names in namelist HISTORY_ITEM. Check!'
          call PRC_abort
       endif
       if( BASENAME == '' .OR. NAME == '' .OR. OUTNAME == '' ) cycle ! invalid HISTORY_ITEM

       LOG_NML(HISTORY_ITEM)

       ! check duplicated request
       if ( OUTNAME == 'undefined' ) OUTNAME = NAME ! set default name
       do id = 1, reqid
          if ( FILE_HISTORY_req(id)%outname == OUTNAME ) then
             LOG_ERROR("FILE_HISTORY_Setup",*) 'Same name of history output is already registered. Check!', trim(OUTNAME)
             call PRC_abort
          endif
       enddo

       reqid = reqid + 1

       FILE_HISTORY_req(reqid)%name              = NAME
       FILE_HISTORY_req(reqid)%outname           = OUTNAME
       FILE_HISTORY_req(reqid)%basename          = BASENAME
       FILE_HISTORY_req(reqid)%postfix_timelabel = POSTFIX_TIMELABEL
       if( FILE_HISTORY_OUTPUT_SWITCH_STEP >= 0 ) FILE_HISTORY_req(reqid)%postfix_timelabel = .true. ! force true
       FILE_HISTORY_req(reqid)%zcoord            = ZCOORD
       FILE_HISTORY_req(reqid)%taverage          = TAVERAGE

       call CALENDAR_unit2sec( dtsec, TINTERVAL, TUNIT )
       dstep = int( dtsec / FILE_HISTORY_DTSEC )

       if ( dtsec <= 0.D0 ) then
          LOG_ERROR("FILE_HISTORY_Setup",*) 'Not appropriate time interval. Check!', trim(NAME), TINTERVAL, trim(TUNIT)
          call PRC_abort
       endif

       if ( abs(dtsec-real(dstep,kind=DP)*FILE_HISTORY_DTSEC) > dtsec*1.E-3_DP ) then
          LOG_ERROR("FILE_HISTORY_Setup",*) 'time interval must be a multiple of delta t. (interval,dt)=', dtsec, FILE_HISTORY_DTSEC
          call PRC_abort
       endif

       FILE_HISTORY_req(reqid)%dstep  = dstep

       if    ( DATATYPE == 'REAL4' ) then
          FILE_HISTORY_req(reqid)%dtype  = FILE_REAL4
       elseif( DATATYPE == 'REAL8' ) then
          FILE_HISTORY_req(reqid)%dtype  = FILE_REAL8
       else
          LOG_ERROR("FILE_HISTORY_Setup",*) 'Not appropriate DATATYPE. Check!', DATATYPE
          call PRC_abort
       endif

       FILE_HISTORY_req(reqid)%registered = .false.
    enddo

    LOG_NEWLINE
    LOG_INFO("FILE_HISTORY_Setup",*) 'Number of requested history item             : ', FILE_HISTORY_nreqs
    LOG_INFO("FILE_HISTORY_Setup",*) 'Output default data type                     : ', trim(FILE_HISTORY_DEFAULT_DATATYPE)
    LOG_INFO("FILE_HISTORY_Setup",*) 'Output value at the initial step?            : ', FILE_HISTORY_OUTPUT_STEP0
    if ( FILE_HISTORY_OUTPUT_WAIT_STEP > 0 ) then
       LOG_INFO("FILE_HISTORY_Setup",*) 'Time when the output is suppressed [step]    : ', FILE_HISTORY_OUTPUT_WAIT_STEP
    end if
    if ( FILE_HISTORY_OUTPUT_SWITCH_STEP >= 0 ) then
       LOG_INFO("FILE_HISTORY_Setup",*) 'Interval for switching the file [step]       : ', FILE_HISTORY_OUTPUT_SWITCH_STEP
    end if
    LOG_INFO("FILE_HISTORY_Setup",*) 'Check if requested item is not registered?   : ', FILE_HISTORY_ERROR_PUTMISS

    FILE_HISTORY_nitems = 0
    allocate( FILE_HISTORY_vars        (FILE_HISTORY_nreqs) )

    FILE_HISTORY_nvar_inputs = 0
    allocate( FILE_HISTORY_var_inputs(FILE_HISTORY_nreqs) )

    FILE_HISTORY_truncate_1D => FILE_HISTORY_truncate_1D_default
    FILE_HISTORY_truncate_2D => FILE_HISTORY_truncate_2D_default
    FILE_HISTORY_truncate_3D => FILE_HISTORY_truncate_3D_default
    FILE_HISTORY_truncate_4D => FILE_HISTORY_truncate_4D_default

    FILE_HISTORY_disabled = .false.

    return
  end subroutine FILE_HISTORY_Setup

  !-----------------------------------------------------------------------------
  !> Register/Append variable to history file
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_reg( &
       name, desc, unit, &
       itemid,           &
       standard_name,    &
       ndims, dim_type,  &
       cell_measures,    &
       fill_halo         )
    implicit none

    character(len=*), intent(in)  :: name   !< name         of the item
    character(len=*), intent(in)  :: desc   !< description  of the item
    character(len=*), intent(in)  :: unit   !< unit         of the item

    integer,          intent(out) :: itemid !< index number of the item

    character(len=*), intent(in), optional :: standard_name
    integer,          intent(in), optional :: ndims    !< if ndims is set and dim_type is not set, the dim_type that set firstry by FILE_HISTORY_set_dim of ndims is used
    character(len=*), intent(in), optional :: dim_type
    character(len=*), intent(in), optional :: cell_measures
    logical,          intent(in), optional :: fill_halo

    character(len=H_SHORT) :: standard_name_
    character(len=H_SHORT) :: cell_measures_
    integer :: dimid, iid
    integer :: n
    !---------------------------------------------------------------------------

    itemid = -1
    if ( FILE_HISTORY_nreqs == 0 ) return

    itemid = FILE_HISTORY_find_id( name )
    if ( itemid > 0 ) return ! already registered

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    if ( len_trim(name) >= H_SHORT ) then
       LOG_ERROR("FILE_HISTORY_reg",'(1x,A,I2,A,A)') 'Length of history name should be <= ', H_SHORT-1 ,' chars. name=', trim(name)
       call PRC_abort
    endif

    ! standard_name
    if ( present(standard_name) ) then
       standard_name_ = standard_name
    else
       standard_name_ = ""
    end if

    ! get dimension id
    if ( FILE_HISTORY_ndims < 1 ) then
       LOG_ERROR("FILE_HISTORY_reg",*) 'at least one dim_type must be registerd with FILE_HISTORY_set_dim. name=', trim(name)
       call PRC_abort
    end if
    if ( present(dim_type) ) then
       dimid = -1
       do n = 1, FILE_HISTORY_ndims
          if ( FILE_HISTORY_dims(n)%name == dim_type ) then
             dimid = n
             exit
          end if
       end do
       if ( dimid == -1 ) then
          LOG_ERROR("FILE_HISTORY_reg",*) 'dim_type must be registerd with FILE_HISTORY_set_dim: ', trim(dim_type) ,' name=', trim(name)
          call PRC_abort
       end if
    else if ( present(ndims) ) then
       do n = 1, FILE_HISTORY_ndims
          if ( FILE_HISTORY_dims(n)%ndims == ndims ) then
             dimid = n
             exit
          end if
       end do
       if ( dimid == -1 ) then
          LOG_ERROR("FILE_HISTORY_reg",'(a,i1,a)') 'dim_type of ', ndims, 'D must be registerd with FILE_HISTORY_set_dim. name=', trim(name)
          call PRC_abort
       end if
    else
       ! ndims = 3 is assumed as default
       do n = 1, FILE_HISTORY_ndims
          if ( FILE_HISTORY_dims(n)%ndims == 3 ) then
             dimid = n
             exit
          end if
       end do
       if ( dimid == -1 ) then
          LOG_ERROR("FILE_HISTORY_reg",'(a,i1,a)') 'dim_type or ndims must be specified. name=', trim(name)
          call PRC_abort
       end if
    end if

    if ( present(cell_measures) ) then
       select case ( cell_measures )
       case ( "area" )
          if ( FILE_HISTORY_dims(dimid)%area == "" ) then
             LOG_ERROR("FILE_HISTORY_reg",*) 'area is not supported for cell_measures. name=', trim(name)
             call PRC_abort
          end if
       case ( "area_z" )
          if ( FILE_HISTORY_dims(dimid)%area == "" ) then
             LOG_ERROR("FILE_HISTORY_reg",*) 'area_z is not supported for cell_measures. name=', trim(name)
             call PRC_abort
          end if
       case ( "area_x" )
          if ( FILE_HISTORY_dims(dimid)%area_x == "" ) then
             LOG_ERROR("FILE_HISTORY_reg",*) 'area_x is not supported for cell_measures. name=', trim(name)
             call PRC_abort
          end if
       case ( "area_y" )
          if ( FILE_HISTORY_dims(dimid)%area_y == "" ) then
             LOG_ERROR("FILE_HISTORY_reg",*) 'area_y is not supported for cell_measures. name=', trim(name)
             call PRC_abort
          end if
       case ( "volume" )
          if ( FILE_HISTORY_dims(dimid)%volume == "" ) then
             LOG_ERROR("FILE_HISTORY_reg",*) 'volume is not supported for cell_measures. name=', trim(name)
             call PRC_abort
          end if
       case default
          LOG_ERROR("FILE_HISTORY_reg",*) 'cell_measures must be "area" or "volume". name=', trim(name)
          call PRC_abort
       end select
       cell_measures_ = cell_measures
    else if ( FILE_HISTORY_dims(dimid)%ndims == 2 ) then
       cell_measures_ = "area"
    else if ( FILE_HISTORY_dims(dimid)%ndims == 3 ) then
       cell_measures_ = "volume"
    else
       cell_measures_ = ""
    end if

    if ( FILE_HISTORY_dims(dimid)%nzcoords > 1 ) then

       itemid = -1
       do n = 1, FILE_HISTORY_dims(dimid)%nzcoords
          if ( FILE_HISTORY_dims(dimid)%zcoords(n) == "model" ) then
             call FILE_HISTORY_Add_Variable( name, desc, unit, standard_name_,    & ! (in)
                                             dimid,                               & ! (in)
                                             FILE_HISTORY_dims(dimid)%zcoords(n), & ! (in)
                                             iid,                                 & ! (out)
                                             cell_measures = cell_measures_,      & ! (in)
                                             fill_halo     = fill_halo            ) ! (in)
          else
             call FILE_HISTORY_Add_Variable( name, desc, unit, standard_name_,    & ! (in)
                                             dimid,                               & ! (in)
                                             FILE_HISTORY_dims(dimid)%zcoords(n), & ! (in)
                                             iid,                                 & ! (out)
                                             fill_halo     = fill_halo            ) ! (in)
          end if
          if ( iid > 0 ) itemid = iid
       end do

    else

       call FILE_HISTORY_Add_Variable( name, desc, unit, standard_name_, & ! (in)
                                       dimid,                            & ! (in)
                                       "model",                          & ! (in)
                                       itemid,                           & ! (out)
                                       cell_measures = cell_measures_,   & ! (in)
                                       fill_halo     = fill_halo         ) ! (in)

    end if

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_reg
  !-----------------------------------------------------------------------------
  ! interface FILE_HISTORY_Put
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Put_0D( &
       itemid,   &
       var       )
    use scale_file_h, only: &
       RMISS => FILE_RMISS
    use scale_const, only: &
       UNDEF => CONST_UNDEF, &
       EPS   => CONST_EPS
    implicit none

    integer,  intent(in) :: itemid
    real(RP), intent(in) :: var

    integer :: dimid
    real(DP), allocatable :: buffer(:)
    real(DP) :: dt
    integer  :: idx
    logical  :: do_put

    integer :: i, id

    intrinsic shape
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return
    if ( itemid < 0 ) return

    call FILE_HISTORY_query( itemid, do_put )
    if ( .not. do_put ) return

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
       id = FILE_HISTORY_var_inputs(itemid)%variants(i)

       dt = ( FILE_HISTORY_NOWSTEP - FILE_HISTORY_vars(id)%laststep_put ) * FILE_HISTORY_DTSEC

       if ( dt < eps .AND. ( .NOT. FILE_HISTORY_vars(id)%taverage ) ) then
          LOG_ERROR("FILE_HISTORY_Put_0D",*) 'variable was put two times before output!: ', &
                     trim(FILE_HISTORY_vars(id)%name), FILE_HISTORY_NOWSTEP, FILE_HISTORY_vars(id)%laststep_put
          call PRC_abort
       endif

       if ( FILE_HISTORY_vars(id)%flag_clear ) then ! time to purge
          FILE_HISTORY_vars(id)%timesum    = 0.0_DP
          if ( FILE_HISTORY_vars(id)%taverage ) FILE_HISTORY_vars(id)%varsum(:)  = 0.0_DP
       endif

       dimid = FILE_HISTORY_vars(id)%dimid
       if ( FILE_HISTORY_vars(id)%taverage ) then
         if ( FILE_HISTORY_vars(id)%varsum(1) /= RMISS ) then
            if ( var /= UNDEF ) then
               FILE_HISTORY_vars(id)%varsum(1) = FILE_HISTORY_vars(id)%varsum(1) + var * dt
            else
               FILE_HISTORY_vars(id)%varsum(1) = RMISS
            end if
         end if
         FILE_HISTORY_vars(id)%timesum = FILE_HISTORY_vars(id)%timesum + dt
      else
         FILE_HISTORY_vars(id)%varsum(1) = var
         FILE_HISTORY_vars(id)%timesum = 0.0_DP
      endif

      FILE_HISTORY_vars(id)%laststep_put = FILE_HISTORY_NOWSTEP
      FILE_HISTORY_vars(id)%flag_clear   = .false.

   end do ! variants

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_Put_0D

  !-----------------------------------------------------------------------------
  !> Wrapper routine of FILE_HISTORY_reg + FILE_HISTORY_put
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_in_0D( &
       var,              &
       name, desc, unit, &
       standard_name,    &
       dim_type )
    implicit none

    real(RP),         intent(in) :: var !< value
    character(len=*), intent(in) :: name       !< name        of the item
    character(len=*), intent(in) :: desc       !< description of the item
    character(len=*), intent(in) :: unit       !< unit        of the item

    character(len=*), intent(in), optional :: standard_name
    character(len=*), intent(in), optional :: dim_type

    logical, parameter     :: fill_halo = .false.

    integer, parameter :: ndim = 0
    integer :: itemid
    logical :: do_put
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return

    ! Check whether the item has been already registered
    call FILE_HISTORY_reg( name, desc, unit,            & ! [IN]
                           itemid,                      & ! [OUT]
                           standard_name=standard_name, & ! [IN]
                           ndims=ndim,                  & ! [IN]
                           dim_type=dim_type,           & ! [IN]
                           fill_halo=fill_halo          ) ! [IN]

    if ( itemid < 0 ) return

    ! Check whether it is time to input the item
    call FILE_HISTORY_query( itemid, do_put ) ! [IN], [OUT]

    if ( do_put ) call FILE_HISTORY_put( itemid, var )

    return
  end subroutine FILE_HISTORY_in_0D

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Put_1D( &
       itemid,   &
       var       )
    use scale_file_h, only: &
       RMISS => FILE_RMISS
    use scale_const, only: &
       UNDEF => CONST_UNDEF, &
       EPS   => CONST_EPS
    implicit none

    integer,  intent(in) :: itemid
    real(RP), intent(in) :: var(:)

    integer :: dimid
    real(DP), allocatable :: buffer(:)
    real(DP) :: dt
    integer  :: idx
    logical  :: do_put

    integer :: i, id

    intrinsic shape
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return
    if ( itemid < 0 ) return

    call FILE_HISTORY_query( itemid, do_put )
    if ( .not. do_put ) return

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
       id = FILE_HISTORY_var_inputs(itemid)%variants(i)

       dt = ( FILE_HISTORY_NOWSTEP - FILE_HISTORY_vars(id)%laststep_put ) * FILE_HISTORY_DTSEC

       if ( dt < eps .AND. ( .NOT. FILE_HISTORY_vars(id)%taverage ) ) then
          LOG_ERROR("FILE_HISTORY_Put_1D",*) 'variable was put two times before output!: ', &
                     trim(FILE_HISTORY_vars(id)%name), FILE_HISTORY_NOWSTEP, FILE_HISTORY_vars(id)%laststep_put
          call PRC_abort
       endif

       if ( FILE_HISTORY_vars(id)%flag_clear ) then ! time to purge
          FILE_HISTORY_vars(id)%timesum    = 0.0_DP
          if ( FILE_HISTORY_vars(id)%taverage ) FILE_HISTORY_vars(id)%varsum(:)  = 0.0_DP
       endif

       dimid = FILE_HISTORY_vars(id)%dimid
       if ( FILE_HISTORY_vars(id)%taverage ) then
         allocate( buffer( FILE_HISTORY_vars(id)%size ) )
         call FILE_HISTORY_truncate_1D( var(:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        buffer(:)                        ) ! (out)
         do idx = 1, FILE_HISTORY_vars(id)%size
            if ( FILE_HISTORY_vars(id)%varsum(idx) /= RMISS ) then
               if ( buffer(idx) /= UNDEF ) then
                  FILE_HISTORY_vars(id)%varsum(idx) = FILE_HISTORY_vars(id)%varsum(idx) + buffer(idx) * dt
               else
                  FILE_HISTORY_vars(id)%varsum(idx) = RMISS
               end if
            end if
         enddo
         deallocate( buffer )
         FILE_HISTORY_vars(id)%timesum = FILE_HISTORY_vars(id)%timesum + dt
      else
         call FILE_HISTORY_truncate_1D( var(:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        FILE_HISTORY_vars(id)%varsum(:)  ) ! (out)
         FILE_HISTORY_vars(id)%timesum = 0.0_DP
      endif

      FILE_HISTORY_vars(id)%laststep_put = FILE_HISTORY_NOWSTEP
      FILE_HISTORY_vars(id)%flag_clear   = .false.

   end do ! variants

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_Put_1D

  !-----------------------------------------------------------------------------
  !> Wrapper routine of FILE_HISTORY_reg + FILE_HISTORY_put
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_in_1D( &
       var,              &
       name, desc, unit, &
       standard_name,    &
       dim_type )
    implicit none

    real(RP),         intent(in) :: var(:) !< value
    character(len=*), intent(in) :: name       !< name        of the item
    character(len=*), intent(in) :: desc       !< description of the item
    character(len=*), intent(in) :: unit       !< unit        of the item

    character(len=*), intent(in), optional :: standard_name
    character(len=*), intent(in), optional :: dim_type

    logical, parameter     :: fill_halo = .false.

    integer, parameter :: ndim = 1
    integer :: itemid
    logical :: do_put
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return

    ! Check whether the item has been already registered
    call FILE_HISTORY_reg( name, desc, unit,            & ! [IN]
                           itemid,                      & ! [OUT]
                           standard_name=standard_name, & ! [IN]
                           ndims=ndim,                  & ! [IN]
                           dim_type=dim_type,           & ! [IN]
                           fill_halo=fill_halo          ) ! [IN]

    if ( itemid < 0 ) return

    ! Check whether it is time to input the item
    call FILE_HISTORY_query( itemid, do_put ) ! [IN], [OUT]

    if ( do_put ) call FILE_HISTORY_put( itemid, var(:) )

    return
  end subroutine FILE_HISTORY_in_1D

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Put_2D( &
       itemid,   &
       var       )
    use scale_file_h, only: &
       RMISS => FILE_RMISS
    use scale_const, only: &
       UNDEF => CONST_UNDEF, &
       EPS   => CONST_EPS
    implicit none

    integer,  intent(in) :: itemid
    real(RP), intent(in) :: var(:,:)

    integer :: dimid
    real(DP), allocatable :: buffer(:)
    real(DP) :: dt
    integer  :: idx
    logical  :: do_put

    integer :: i, id

    intrinsic shape
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return
    if ( itemid < 0 ) return

    call FILE_HISTORY_query( itemid, do_put )
    if ( .not. do_put ) return

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
       id = FILE_HISTORY_var_inputs(itemid)%variants(i)

       dt = ( FILE_HISTORY_NOWSTEP - FILE_HISTORY_vars(id)%laststep_put ) * FILE_HISTORY_DTSEC

       if ( dt < eps .AND. ( .NOT. FILE_HISTORY_vars(id)%taverage ) ) then
          LOG_ERROR("FILE_HISTORY_Put_2D",*) 'variable was put two times before output!: ', &
                     trim(FILE_HISTORY_vars(id)%name), FILE_HISTORY_NOWSTEP, FILE_HISTORY_vars(id)%laststep_put
          call PRC_abort
       endif

       if ( FILE_HISTORY_vars(id)%flag_clear ) then ! time to purge
          FILE_HISTORY_vars(id)%timesum    = 0.0_DP
          if ( FILE_HISTORY_vars(id)%taverage ) FILE_HISTORY_vars(id)%varsum(:)  = 0.0_DP
       endif

       dimid = FILE_HISTORY_vars(id)%dimid
       if ( FILE_HISTORY_vars(id)%taverage ) then
         allocate( buffer( FILE_HISTORY_vars(id)%size ) )
         call FILE_HISTORY_truncate_2D( var(:,:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        buffer(:)                        ) ! (out)
         do idx = 1, FILE_HISTORY_vars(id)%size
            if ( FILE_HISTORY_vars(id)%varsum(idx) /= RMISS ) then
               if ( buffer(idx) /= UNDEF ) then
                  FILE_HISTORY_vars(id)%varsum(idx) = FILE_HISTORY_vars(id)%varsum(idx) + buffer(idx) * dt
               else
                  FILE_HISTORY_vars(id)%varsum(idx) = RMISS
               end if
            end if
         enddo
         deallocate( buffer )
         FILE_HISTORY_vars(id)%timesum = FILE_HISTORY_vars(id)%timesum + dt
      else
         call FILE_HISTORY_truncate_2D( var(:,:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        FILE_HISTORY_vars(id)%varsum(:)  ) ! (out)
         FILE_HISTORY_vars(id)%timesum = 0.0_DP
      endif

      FILE_HISTORY_vars(id)%laststep_put = FILE_HISTORY_NOWSTEP
      FILE_HISTORY_vars(id)%flag_clear   = .false.

   end do ! variants

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_Put_2D

  !-----------------------------------------------------------------------------
  !> Wrapper routine of FILE_HISTORY_reg + FILE_HISTORY_put
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_in_2D( &
       var,              &
       name, desc, unit, &
       standard_name,    &
       dim_type, &
       fill_halo )
    implicit none

    real(RP),         intent(in) :: var(:,:) !< value
    character(len=*), intent(in) :: name       !< name        of the item
    character(len=*), intent(in) :: desc       !< description of the item
    character(len=*), intent(in) :: unit       !< unit        of the item

    character(len=*), intent(in), optional :: standard_name
    character(len=*), intent(in), optional :: dim_type
    logical,          intent(in), optional :: fill_halo

    integer, parameter :: ndim = 2
    integer :: itemid
    logical :: do_put
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return

    ! Check whether the item has been already registered
    call FILE_HISTORY_reg( name, desc, unit,            & ! [IN]
                           itemid,                      & ! [OUT]
                           standard_name=standard_name, & ! [IN]
                           ndims=ndim,                  & ! [IN]
                           dim_type=dim_type,           & ! [IN]
                           fill_halo=fill_halo          ) ! [IN]

    if ( itemid < 0 ) return

    ! Check whether it is time to input the item
    call FILE_HISTORY_query( itemid, do_put ) ! [IN], [OUT]

    if ( do_put ) call FILE_HISTORY_put( itemid, var(:,:) )

    return
  end subroutine FILE_HISTORY_in_2D

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Put_3D( &
       itemid,   &
       var       )
    use scale_file_h, only: &
       RMISS => FILE_RMISS
    use scale_const, only: &
       UNDEF => CONST_UNDEF, &
       EPS   => CONST_EPS
    implicit none

    integer,  intent(in) :: itemid
    real(RP), intent(in) :: var(:,:,:)

    integer :: dimid
    real(DP), allocatable :: buffer(:)
    real(DP) :: dt
    integer  :: idx
    logical  :: do_put

    integer :: i, id

    intrinsic shape
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return
    if ( itemid < 0 ) return

    call FILE_HISTORY_query( itemid, do_put )
    if ( .not. do_put ) return

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
       id = FILE_HISTORY_var_inputs(itemid)%variants(i)

       dt = ( FILE_HISTORY_NOWSTEP - FILE_HISTORY_vars(id)%laststep_put ) * FILE_HISTORY_DTSEC

       if ( dt < eps .AND. ( .NOT. FILE_HISTORY_vars(id)%taverage ) ) then
          LOG_ERROR("FILE_HISTORY_Put_3D",*) 'variable was put two times before output!: ', &
                     trim(FILE_HISTORY_vars(id)%name), FILE_HISTORY_NOWSTEP, FILE_HISTORY_vars(id)%laststep_put
          call PRC_abort
       endif

       if ( FILE_HISTORY_vars(id)%flag_clear ) then ! time to purge
          FILE_HISTORY_vars(id)%timesum    = 0.0_DP
          if ( FILE_HISTORY_vars(id)%taverage ) FILE_HISTORY_vars(id)%varsum(:)  = 0.0_DP
       endif

       dimid = FILE_HISTORY_vars(id)%dimid
       if ( FILE_HISTORY_vars(id)%taverage ) then
         allocate( buffer( FILE_HISTORY_vars(id)%size ) )
         call FILE_HISTORY_truncate_3D( var(:,:,:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        buffer(:)                        ) ! (out)
         do idx = 1, FILE_HISTORY_vars(id)%size
            if ( FILE_HISTORY_vars(id)%varsum(idx) /= RMISS ) then
               if ( buffer(idx) /= UNDEF ) then
                  FILE_HISTORY_vars(id)%varsum(idx) = FILE_HISTORY_vars(id)%varsum(idx) + buffer(idx) * dt
               else
                  FILE_HISTORY_vars(id)%varsum(idx) = RMISS
               end if
            end if
         enddo
         deallocate( buffer )
         FILE_HISTORY_vars(id)%timesum = FILE_HISTORY_vars(id)%timesum + dt
      else
         call FILE_HISTORY_truncate_3D( var(:,:,:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        FILE_HISTORY_vars(id)%varsum(:)  ) ! (out)
         FILE_HISTORY_vars(id)%timesum = 0.0_DP
      endif

      FILE_HISTORY_vars(id)%laststep_put = FILE_HISTORY_NOWSTEP
      FILE_HISTORY_vars(id)%flag_clear   = .false.

   end do ! variants

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_Put_3D

  !-----------------------------------------------------------------------------
  !> Wrapper routine of FILE_HISTORY_reg + FILE_HISTORY_put
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_in_3D( &
       var,              &
       name, desc, unit, &
       standard_name,    &
       dim_type, &
       fill_halo )
    implicit none

    real(RP),         intent(in) :: var(:,:,:) !< value
    character(len=*), intent(in) :: name       !< name        of the item
    character(len=*), intent(in) :: desc       !< description of the item
    character(len=*), intent(in) :: unit       !< unit        of the item

    character(len=*), intent(in), optional :: standard_name
    character(len=*), intent(in), optional :: dim_type
    logical,          intent(in), optional :: fill_halo

    integer, parameter :: ndim = 3
    integer :: itemid
    logical :: do_put
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return

    ! Check whether the item has been already registered
    call FILE_HISTORY_reg( name, desc, unit,            & ! [IN]
                           itemid,                      & ! [OUT]
                           standard_name=standard_name, & ! [IN]
                           ndims=ndim,                  & ! [IN]
                           dim_type=dim_type,           & ! [IN]
                           fill_halo=fill_halo          ) ! [IN]

    if ( itemid < 0 ) return

    ! Check whether it is time to input the item
    call FILE_HISTORY_query( itemid, do_put ) ! [IN], [OUT]

    if ( do_put ) call FILE_HISTORY_put( itemid, var(:,:,:) )

    return
  end subroutine FILE_HISTORY_in_3D

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Put_4D( &
       itemid,   &
       var       )
    use scale_file_h, only: &
       RMISS => FILE_RMISS
    use scale_const, only: &
       UNDEF => CONST_UNDEF, &
       EPS   => CONST_EPS
    implicit none

    integer,  intent(in) :: itemid
    real(RP), intent(in) :: var(:,:,:,:)

    integer :: dimid
    real(DP), allocatable :: buffer(:)
    real(DP) :: dt
    integer  :: idx
    logical  :: do_put

    integer :: i, id

    intrinsic shape
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return
    if ( itemid < 0 ) return

    call FILE_HISTORY_query( itemid, do_put )
    if ( .not. do_put ) return

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
       id = FILE_HISTORY_var_inputs(itemid)%variants(i)

       dt = ( FILE_HISTORY_NOWSTEP - FILE_HISTORY_vars(id)%laststep_put ) * FILE_HISTORY_DTSEC

       if ( dt < eps .AND. ( .NOT. FILE_HISTORY_vars(id)%taverage ) ) then
          LOG_ERROR("FILE_HISTORY_Put_4D",*) 'variable was put two times before output!: ', &
                     trim(FILE_HISTORY_vars(id)%name), FILE_HISTORY_NOWSTEP, FILE_HISTORY_vars(id)%laststep_put
          call PRC_abort
       endif

       if ( FILE_HISTORY_vars(id)%flag_clear ) then ! time to purge
          FILE_HISTORY_vars(id)%timesum    = 0.0_DP
          if ( FILE_HISTORY_vars(id)%taverage ) FILE_HISTORY_vars(id)%varsum(:)  = 0.0_DP
       endif

       dimid = FILE_HISTORY_vars(id)%dimid
       if ( FILE_HISTORY_vars(id)%taverage ) then
         allocate( buffer( FILE_HISTORY_vars(id)%size ) )
         call FILE_HISTORY_truncate_4D( var(:,:,:,:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        buffer(:)                        ) ! (out)
         do idx = 1, FILE_HISTORY_vars(id)%size
            if ( FILE_HISTORY_vars(id)%varsum(idx) /= RMISS ) then
               if ( buffer(idx) /= UNDEF ) then
                  FILE_HISTORY_vars(id)%varsum(idx) = FILE_HISTORY_vars(id)%varsum(idx) + buffer(idx) * dt
               else
                  FILE_HISTORY_vars(id)%varsum(idx) = RMISS
               end if
            end if
         enddo
         deallocate( buffer )
         FILE_HISTORY_vars(id)%timesum = FILE_HISTORY_vars(id)%timesum + dt
      else
         call FILE_HISTORY_truncate_4D( var(:,:,:,:),               & ! (in)
                                        FILE_HISTORY_dims(dimid)%name,   & ! (in)
                                        FILE_HISTORY_vars(id)%zcoord,    & ! (in)
                                        FILE_HISTORY_vars(id)%fill_halo, & ! (in)
                                        FILE_HISTORY_vars(id)%varsum(:)  ) ! (out)
         FILE_HISTORY_vars(id)%timesum = 0.0_DP
      endif

      FILE_HISTORY_vars(id)%laststep_put = FILE_HISTORY_NOWSTEP
      FILE_HISTORY_vars(id)%flag_clear   = .false.

   end do ! variants

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_Put_4D

  !-----------------------------------------------------------------------------
  !> Wrapper routine of FILE_HISTORY_reg + FILE_HISTORY_put
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_in_4D( &
       var,              &
       name, desc, unit, &
       standard_name,    &
       dim_type, &
       fill_halo )
    implicit none

    real(RP),         intent(in) :: var(:,:,:,:) !< value
    character(len=*), intent(in) :: name       !< name        of the item
    character(len=*), intent(in) :: desc       !< description of the item
    character(len=*), intent(in) :: unit       !< unit        of the item

    character(len=*), intent(in), optional :: standard_name
    character(len=*), intent(in), optional :: dim_type
    logical,          intent(in), optional :: fill_halo

    integer, parameter :: ndim = 4
    integer :: itemid
    logical :: do_put
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return

    ! Check whether the item has been already registered
    call FILE_HISTORY_reg( name, desc, unit,            & ! [IN]
                           itemid,                      & ! [OUT]
                           standard_name=standard_name, & ! [IN]
                           ndims=ndim,                  & ! [IN]
                           dim_type=dim_type,           & ! [IN]
                           fill_halo=fill_halo          ) ! [IN]

    if ( itemid < 0 ) return

    ! Check whether it is time to input the item
    call FILE_HISTORY_query( itemid, do_put ) ! [IN], [OUT]

    if ( do_put ) call FILE_HISTORY_put( itemid, var(:,:,:,:) )

    return
  end subroutine FILE_HISTORY_in_4D


  !-----------------------------------------------------------------------------
  !> set dimension information
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Dim( &
       name,                 &
       ndims, nzcoords,      &
       dims, zcoords,        &
       start, count,         &
       mapping,              &
       area, area_x, area_y, &
       volume,               &
       location, grid        )
    implicit none

    character(len=*), intent(in) :: name
    integer,          intent(in) :: ndims
    integer,          intent(in) :: nzcoords
    character(len=*), intent(in) :: dims(ndims,nzcoords)
    character(len=*), intent(in) :: zcoords(nzcoords)
    integer,          intent(in) :: start(ndims,nzcoords)
    integer,          intent(in) :: count(ndims,nzcoords)

    character(len=*), intent(in), optional :: mapping
    character(len=*), intent(in), optional :: area
    character(len=*), intent(in), optional :: area_x
    character(len=*), intent(in), optional :: area_y
    character(len=*), intent(in), optional :: volume
    character(len=*), intent(in), optional :: location
    character(len=*), intent(in), optional :: grid

    integer :: id
    integer :: size, n, m

    if ( FILE_HISTORY_ndims >= FILE_HISTORY_dim_max ) then
       LOG_ERROR("FILE_HISTORY_Set_Dim",*) 'number of dimension exceed max limit: ', FILE_HISTORY_dim_max
       call PRC_abort
    end if
    FILE_HISTORY_ndims = FILE_HISTORY_ndims + 1
    id = FILE_HISTORY_ndims

    allocate( FILE_HISTORY_dims(id)%dims(ndims,nzcoords) )
    allocate( FILE_HISTORY_dims(id)%start(ndims,nzcoords) )
    allocate( FILE_HISTORY_dims(id)%count(ndims,nzcoords) )
    allocate( FILE_HISTORY_dims(id)%zcoords(nzcoords) )
    allocate( FILE_HISTORY_dims(id)%size(nzcoords) )

    FILE_HISTORY_dims(id)%name       = name
    FILE_HISTORY_dims(id)%ndims      = ndims
    FILE_HISTORY_dims(id)%dims(:,:)  = dims(:,:)
    FILE_HISTORY_dims(id)%nzcoords   = nzcoords
    FILE_HISTORY_dims(id)%zcoords(:) = zcoords(:)
    FILE_HISTORY_dims(id)%start(:,:) = start(:,:)
    FILE_HISTORY_dims(id)%count(:,:) = count(:,:)

    do m = 1, nzcoords
       size = 1
       do n = 1, ndims
          size = size * count(n,m)
       end do
       FILE_HISTORY_dims(id)%size(m) = size
    end do

    if ( present(mapping) ) then
       FILE_HISTORY_dims(id)%mapping = mapping
    else
       FILE_HISTORY_dims(id)%mapping = ""
    end if

    if ( present(area) ) then
       FILE_HISTORY_dims(id)%area = area
    else
       FILE_HISTORY_dims(id)%area = ""
    end if
    if ( present(area_x) ) then
       FILE_HISTORY_dims(id)%area_x = area_x
    else
       FILE_HISTORY_dims(id)%area_x = ""
    end if
    if ( present(area_y) ) then
       FILE_HISTORY_dims(id)%area_y = area_y
    else
       FILE_HISTORY_dims(id)%area_y = ""
    end if
    if ( present(volume) ) then
       FILE_HISTORY_dims(id)%volume = volume
    else
       FILE_HISTORY_dims(id)%volume = ""
    end if

    if ( present(location) ) then
       FILE_HISTORY_dims(id)%location = location
       if ( present(grid) ) then
          FILE_HISTORY_dims(id)%grid = "grid_"//trim(grid)
       else
          FILE_HISTORY_dims(id)%grid = "grid"
       end if
    else
       FILE_HISTORY_dims(id)%location = ""
       FILE_HISTORY_dims(id)%grid     = ""
    end if

    return
  end subroutine FILE_HISTORY_Set_Dim

  !-----------------------------------------------------------------------------
  !> set axis information
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Axis( &
       name, desc, units,    &
       dim,      &
       var,      &
       bounds,   &
       down,     &
       gsize,    &
       start     )
    implicit none

    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim
    real(RP),         intent(in) :: var(:)

    real(RP),         intent(in), optional :: bounds(:,:)
    logical,          intent(in), optional :: down
    integer,          intent(in), optional :: gsize ! global dim size
    integer,          intent(in), optional :: start ! global subarray start indices

    integer :: dim_size
    integer :: id

    intrinsic size
    !---------------------------------------------------------------------------

    dim_size = size(var)

    if ( FILE_HISTORY_naxes >= FILE_HISTORY_axis_max ) then
       LOG_ERROR("FILE_HISTORY_Set_Axis",*) 'Number of axis exceeds the limit.'
       call PRC_abort
    endif

    FILE_HISTORY_naxes = FILE_HISTORY_naxes + 1
    id                 = FILE_HISTORY_naxes

    allocate( FILE_HISTORY_axes(id)%var(dim_size) )

    FILE_HISTORY_axes(id)%name     = name
    FILE_HISTORY_axes(id)%desc     = desc
    FILE_HISTORY_axes(id)%units    = units
    FILE_HISTORY_axes(id)%dim      = dim
    FILE_HISTORY_axes(id)%dim_size = dim_size
    FILE_HISTORY_axes(id)%var(:)   = var(:)

    if ( present(down) ) then
       FILE_HISTORY_axes(id)%down = down
    else
       FILE_HISTORY_axes(id)%down = .false.
    endif
    if ( present(gsize) ) then ! global dimension size
         FILE_HISTORY_axes(id)%gdim_size = gsize
    else
         FILE_HISTORY_axes(id)%gdim_size = -1
    end if
    if ( present(start) ) then  ! global subarray starting indices
       FILE_HISTORY_axes(id)%start = start
    else
       FILE_HISTORY_axes(id)%start = 1
    end if

    if ( present(bounds) ) then
       allocate( FILE_HISTORY_axes(id)%bounds(2,dim_size) )
       FILE_HISTORY_axes(id)%bounds(:,:) = bounds(:,:)
    end if

    return
  end subroutine FILE_HISTORY_Set_Axis

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Write
    use scale_file, only: &
       FILE_EndDef, &
       FILE_Flush
    implicit none

    integer :: fid, prev_fid
    integer :: id
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_disabled ) return

    call PROF_rapstart('FILE_HISTORY_OUT', 2)

    ! Write registered history variables to history file
    do id = 1, FILE_HISTORY_nitems
       call FILE_HISTORY_Write_OneVar( id, FILE_HISTORY_NOWSTEP ) ! [IN]
    enddo

    ! when using PnetCDF, the above FILE_HISTORY_Write() only posts write requests
    ! Now we need to commit the requests to the file
    prev_fid = -1
    do id = 1, FILE_HISTORY_nitems
       fid = FILE_HISTORY_vars(id)%fid
       if ( fid > 0 .AND. fid /= prev_fid ) then
          call FILE_Flush( fid )
          prev_fid = fid
       endif
    enddo

    ! check time to switching output file
    if (       FILE_HISTORY_OUTPUT_SWITCH_STEP >= 0                                      &
         .AND. FILE_HISTORY_NOWSTEP-FILE_HISTORY_OUTPUT_SWITCH_LASTSTEP > FILE_HISTORY_OUTPUT_SWITCH_STEP ) then

       call FILE_HISTORY_Close

       LOG_INFO("FILE_HISTORY_Write",*) 'FILE_HISTORY file is switched.'

       do id = 1, FILE_HISTORY_nitems
          FILE_HISTORY_vars(id)%fid = -1 ! reset
          FILE_HISTORY_vars(id)%vid = -1 ! reset
       enddo

       FILE_HISTORY_OUTPUT_SWITCH_LASTSTEP = FILE_HISTORY_NOWSTEP - 1
    endif

    call PROF_rapend('FILE_HISTORY_OUT', 2)

    return
  end subroutine FILE_HISTORY_Write

  !-----------------------------------------------------------------------------
  !> set now step
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_NowDate( NOWDATE, NOWMS, NOWSTEP )
    integer,  intent(in) :: NOWDATE(:)
    real(DP), intent(in) :: NOWMS
    integer,  intent(in) :: NOWSTEP

    FILE_HISTORY_NOWDATE(:) = NOWDATE(:)
    FILE_HISTORY_NOWMS      = NOWMS
    FILE_HISTORY_NOWSTEP    = NOWSTEP

    return
  end subroutine FILE_HISTORY_Set_NowDate

  !-----------------------------------------------------------------------------
  !> set switch to turn on/off history
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Disable( switch )
    implicit none

    logical, intent(in) :: switch
    !---------------------------------------------------------------------------

    FILE_HISTORY_disabled = switch

    return
  end subroutine FILE_HISTORY_Set_Disable

  !-----------------------------------------------------------------------------
  !> finalization
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Finalize

    call FILE_HISTORY_Close

    return
  end subroutine FILE_HISTORY_Finalize


  !! private procedures

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Check( &
       name, zcoord, &
       itemid        )
    implicit none

    character(len=*), intent(in)  :: name
    character(len=*), intent(in)  :: zcoord
    integer,          intent(out) :: itemid

    integer :: id, i
    !---------------------------------------------------------------------------

    !--- search existing item
    do itemid = 1, FILE_HISTORY_nvar_inputs
       if ( name == FILE_HISTORY_var_inputs(itemid)%name ) then ! match name
          do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
             id = FILE_HISTORY_var_inputs(itemid)%variants(i)
             !--- check zcoord
             if ( FILE_HISTORY_vars(id)%zcoord == zcoord ) return
          end do
       end if
    end do
    itemid = -1

    return
  end subroutine FILE_HISTORY_Check

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Add_Variable( &
       name, desc, units,  &
       standard_name,      &
       dimid,              &
       zcoord,             &
       itemid,             &
       cell_measures,      &
       fill_halo           )
    use scale_file_h, only: &
       FILE_dtypelist
    implicit none
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: standard_name
    integer,          intent(in) :: dimid
    character(len=*), intent(in) :: zcoord
    integer,          intent(out) :: itemid
    character(len=*), intent(in), optional :: cell_measures
    logical,          intent(in), optional :: fill_halo

    integer :: reqid, zid, id
    logical :: existed
    integer :: n, m

    intrinsic size
    !---------------------------------------------------------------------------

    call FILE_HISTORY_Check( name, zcoord, & ! (in)
                             itemid        )

    if ( itemid > 0 ) return

    do reqid = 1, FILE_HISTORY_nreqs

       if ( FILE_HISTORY_req(reqid)%registered ) cycle
       if ( name /= FILE_HISTORY_req(reqid)%name ) cycle

       if ( FILE_HISTORY_dims(dimid)%nzcoords == 1 .or. &
            zcoord == FILE_HISTORY_req(reqid)%zcoord ) then

          FILE_HISTORY_req(reqid)%registered = .true.

          FILE_HISTORY_nitems = FILE_HISTORY_nitems + 1
          id                  = FILE_HISTORY_nitems

          FILE_HISTORY_vars(id)%name              = FILE_HISTORY_req(reqid)%name
          FILE_HISTORY_vars(id)%outname           = FILE_HISTORY_req(reqid)%outname
          FILE_HISTORY_vars(id)%basename          = FILE_HISTORY_req(reqid)%basename
          FILE_HISTORY_vars(id)%postfix_timelabel = FILE_HISTORY_req(reqid)%postfix_timelabel
          FILE_HISTORY_vars(id)%zcoord            = zcoord
          FILE_HISTORY_vars(id)%dstep             = FILE_HISTORY_req(reqid)%dstep
          FILE_HISTORY_vars(id)%taverage          = FILE_HISTORY_req(reqid)%taverage
          FILE_HISTORY_vars(id)%dtype             = FILE_HISTORY_req(reqid)%dtype

          FILE_HISTORY_vars(id)%zid               = -1
          do zid = 1, FILE_HISTORY_dims(dimid)%nzcoords
             if ( FILE_HISTORY_dims(dimid)%zcoords(zid) == FILE_HISTORY_vars(id)%zcoord ) then
                FILE_HISTORY_vars(id)%zid = zid
                exit
             end if
          end do
          if ( zid < 0 ) then
             LOG_ERROR("FILE_HISTORY_Add_Variable",*) 'z-coordinate ', trim(FILE_HISTORY_vars(id)%zcoord), ' is not found for dimension ', trim(FILE_HISTORY_dims(dimid)%name)
             call PRC_abort
          end if

          FILE_HISTORY_vars(id)%fid   = -1
          FILE_HISTORY_vars(id)%vid   = -1
          FILE_HISTORY_vars(id)%desc  = desc
          FILE_HISTORY_vars(id)%units = units
          FILE_HISTORY_vars(id)%standard_name = standard_name
          FILE_HISTORY_vars(id)%dimid = dimid
          if ( present(cell_measures) ) then
             FILE_HISTORY_vars(id)%cell_measures = cell_measures
          else
             FILE_HISTORY_vars(id)%cell_measures = ""
          end if
          if ( present(fill_halo) ) then
             FILE_HISTORY_vars(id)%fill_halo = fill_halo
          else
             FILE_HISTORY_vars(id)%fill_halo = .false.
          end if

          FILE_HISTORY_vars(id)%waitstep = FILE_HISTORY_OUTPUT_WAIT_STEP
          if ( FILE_HISTORY_OUTPUT_STEP0 .AND. FILE_HISTORY_NOWSTEP == 1 ) then
             FILE_HISTORY_vars(id)%laststep_write = 1 - FILE_HISTORY_vars(id)%dstep
          else
             FILE_HISTORY_vars(id)%laststep_write = 1
          endif
          FILE_HISTORY_vars(id)%laststep_put = FILE_HISTORY_vars(id)%laststep_write
          FILE_HISTORY_vars(id)%flag_clear   = .true.
          FILE_HISTORY_vars(id)%size = FILE_HISTORY_dims(dimid)%size(zid)
          allocate( FILE_HISTORY_vars(id)%varsum( FILE_HISTORY_vars(id)%size ) )

          FILE_HISTORY_vars(id)%timesum = 0.0_DP

          if ( debug ) then
             LOG_INFO("FILE_HISTORY_Add_Variable",*) '[HISTORY] Item registration No.= ', id
             LOG_INFO_CONT(*) 'Item name                      : ', trim(FILE_HISTORY_vars(id)%name)
             LOG_INFO_CONT(*) 'Output name                    : ', trim(FILE_HISTORY_vars(id)%outname)
             LOG_INFO_CONT(*) 'Description                    : ', trim(FILE_HISTORY_vars(id)%desc)
             LOG_INFO_CONT(*) 'Unit                           : ', trim(FILE_HISTORY_vars(id)%units)
             LOG_INFO_CONT(*) 'Basename of output file        : ', trim(FILE_HISTORY_vars(id)%basename)
             LOG_INFO_CONT(*) 'Add timelabel to the filename? : ', FILE_HISTORY_vars(id)%postfix_timelabel
             LOG_INFO_CONT(*) 'Zcoord                         : ', trim(FILE_HISTORY_vars(id)%zcoord)
             LOG_INFO_CONT(*) 'Interval [step]                : ', FILE_HISTORY_vars(id)%dstep
             LOG_INFO_CONT(*) 'Time Average?                  : ', FILE_HISTORY_vars(id)%taverage
             LOG_INFO_CONT(*) 'Datatype                       : ', trim(FILE_dtypelist(FILE_HISTORY_vars(id)%dtype))
             LOG_INFO_CONT(*) 'axis name                      : ', ( trim(FILE_HISTORY_dims(dimid)%dims(n,zid))//" ", n=1, FILE_HISTORY_dims(dimid)%ndims )
          endif

          existed = .false.
          do m = 1, FILE_HISTORY_nvar_inputs
             if ( FILE_HISTORY_var_inputs(m)%name == name ) then
                FILE_HISTORY_var_inputs(m)%nvariants = FILE_HISTORY_var_inputs(m)%nvariants + 1
                if ( FILE_HISTORY_var_inputs(m)%nvariants > FILE_HISTORY_variant_max ) then
                   LOG_ERROR("FILE_HISTORY_Add_Variable",*) 'Number of variant for ', trim(name), ' excees limit!'
                   call PRC_abort
                end if
                FILE_HISTORY_var_inputs(m)%variants(FILE_HISTORY_var_inputs(m)%nvariants) = id
                itemid = m
                existed = .true.
                exit
             end if
          end do
          if ( .not. existed ) then
             FILE_HISTORY_nvar_inputs = FILE_HISTORY_nvar_inputs + 1
             itemid = FILE_HISTORY_nvar_inputs
             FILE_HISTORY_var_inputs(itemid)%name = name
             FILE_HISTORY_var_inputs(itemid)%nvariants = 1
             FILE_HISTORY_var_inputs(itemid)%variants(1) = id
          end if

       endif ! match item?

    enddo

    return
  end subroutine FILE_HISTORY_Add_Variable

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Create( &
       id,     &
       options )
    use scale_file_h, only: &
       FILE_REAL8, &
       FILE_REAL4
    use scale_file, only: &
       FILE_Create,                   &
       FILE_Set_Option,               &
       FILE_Def_Axis,                 &
       FILE_Def_AssociatedCoordinate, &
       FILE_Add_AssociatedVariable,   &
       FILE_Attach_Buffer,            &
       FILE_Add_Variable,             &
       FILE_Set_Attribute
    use scale_time, only: &
       TIME_time2label
    implicit none

    integer,           intent(in)  :: id

    character(len=*),  intent(in) :: options ! 'filetype1:key1=val1&filetype2:key2=val2&...'

    integer                :: fid
    character(len=H_MID)   :: tunits
    character(len=H_LONG)  :: basename_mod
    logical                :: fileexisted
    integer(8)             :: array_size
    integer                :: dim_size
    integer                :: dtype
    integer                :: dimid, zid
    integer                :: ndims
    character(len=H_SHORT) :: dims(3)
    real(DP)               :: dtsec

    character(len=H_MID)   :: timelabel

    integer :: ic, ie, is, lo
    integer :: m
    !---------------------------------------------------------------------------

    fid = FILE_HISTORY_vars(id)%fid

    if ( fid >= 0 ) return ! file already exists

    if ( FILE_HISTORY_TIME_SINCE == '' ) then
       tunits = trim(FILE_HISTORY_TIME_UNITS)
    else
       tunits = trim(FILE_HISTORY_TIME_UNITS)//' since '//trim(FILE_HISTORY_TIME_SINCE)
    endif

    if ( FILE_HISTORY_vars(id)%postfix_timelabel ) then
       call TIME_time2label( FILE_HISTORY_NOWDATE, FILE_HISTORY_NOWMS, & ! [IN]
                             timelabel ) ! [OUT]
       basename_mod = trim(FILE_HISTORY_vars(id)%basename)//'_'//trim(timelabel)
    else
       basename_mod = trim(FILE_HISTORY_vars(id)%basename)
    endif

    call FILE_Create( basename_mod,                       & ! [IN]
                      FILE_HISTORY_TITLE,                 & ! [IN]
                      FILE_HISTORY_SOURCE,                & ! [IN]
                      FILE_HISTORY_INSTITUTION,           & ! [IN]
                      fid, fileexisted,                   & ! [OUT]
                      rankid = FILE_HISTORY_myrank,       & ! [IN]
                      aggregate = FILE_HISTORY_AGGREGATE, & ! [IN]
                      time_units = tunits,                & ! [IN]
                      calendar = FILE_HISTORY_CALENDAR    ) ! [IN]

    FILE_HISTORY_vars(id)%fid = fid

    ! write options
    ic = -1 ! index of ':'
    ie = -1 ! index of '='
    is =  1 ! start index
    lo = len_trim(options)
    if ( lo > 0 ) then
       do m = 1, lo+1
          if ( m == lo+1 .OR. options(m:m) == '&' ) then
             if ( ic == -1 .OR. ie == -1 ) then
                LOG_ERROR("FILE_HISTORY_Create",*)'option is invalid: ', trim(options)
                call PRC_abort
             endif
             call FILE_Set_Option( fid, options(is:ic-1), options(ic+1:ie-1), options(ie+1:m -1)  ) ! [IN]
             ic = -1
             ie = -1
             is = m+1
          elseif( options(m:m) == ':' ) then
             ic = m
          elseif( options(m:m) == '=' ) then
             ie = m
          endif
       enddo
    endif

    if ( RP == DP ) then
       dtype = FILE_REAL8
    else
       dtype = FILE_REAL4
    end if

    ! define registered history axis variables in the newly created file
    ! actual writing axis variables are deferred to FILE_HISTORY_WriteAxes
    do m = 1, FILE_HISTORY_naxes
       if ( FILE_HISTORY_AGGREGATE ) then ! for shared-file I/O, define axis in its global size
          dim_size = FILE_HISTORY_axes(m)%gdim_size ! axis global size
          if ( dim_size < 1 ) then
             LOG_ERROR("FILE_HISTORY_Create",*) 'gsize is not set by FILE_HISTORY_Set_Axis'
             LOG_ERROR_CONT(*) 'It is necessary for aggregate file'
             call PRC_abort
          end if
       else
          dim_size = FILE_HISTORY_axes(m)%dim_size
       endif
       call FILE_Def_Axis( fid,                                           & ! [IN]
                           FILE_HISTORY_axes(m)%name,                     & ! [IN]
                           FILE_HISTORY_axes(m)%desc,                     & ! [IN]
                           FILE_HISTORY_axes(m)%units,                    & ! [IN]
                           FILE_HISTORY_axes(m)%dim,                      & ! [IN]
                           dtype, dim_size,                               & ! [IN]
                           bounds=associated(FILE_HISTORY_axes(m)%bounds) ) ! [IN]
       if ( FILE_HISTORY_axes(m)%down ) then
          call FILE_Set_Attribute( fid, FILE_HISTORY_axes(m)%name, 'positive', 'down' ) ! [IN]
       endif
    enddo

    ! define registered history associated coordinate variables in the newly created file
    ! actual writing coordinate variables are deferred to FILE_HISTORY_WriteAxes
    do m = 1, FILE_HISTORY_nassocs
       ndims = FILE_HISTORY_assocs(m)%ndims
       call FILE_Def_AssociatedCoordinate( fid,                                  & ! [IN]
                                           FILE_HISTORY_assocs(m)%name,          & ! [IN]
                                           FILE_HISTORY_assocs(m)%desc,          & ! [IN]
                                           FILE_HISTORY_assocs(m)%units,         & ! [IN]
                                           FILE_HISTORY_assocs(m)%dims(1:ndims), & ! [IN]
                                           FILE_HISTORY_assocs(m)%dtype          ) ! [IN]
    enddo

    ! attributes
    do m = 1, FILE_HISTORY_nattrs

       if ( FILE_HISTORY_attrs(m)%add_variable ) then
          ! associated variable
          call FILE_Add_AssociatedVariable( fid, FILE_HISTORY_attrs(m)%varname )
       end if

       select case ( FILE_HISTORY_attrs(m)%type )
       case ( I_TEXT )
          call FILE_Set_Attribute( fid,                           & ! [IN]
                                   FILE_HISTORY_attrs(m)%varname, & ! [IN]
                                   FILE_HISTORY_attrs(m)%key,     & ! [IN]
                                   FILE_HISTORY_attrs(m)%text     ) ! [IN]
       case ( I_INT )
          call FILE_Set_Attribute( fid,                           & ! [IN]
                                   FILE_HISTORY_attrs(m)%varname, & ! [IN]
                                   FILE_HISTORY_attrs(m)%key,     & ! [IN]
                                   FILE_HISTORY_attrs(m)%int(:)   ) ! [IN]
       case ( I_FLOAT )
          call FILE_Set_Attribute( fid,                           & ! [IN]
                                   FILE_HISTORY_attrs(m)%varname, & ! [IN]
                                   FILE_HISTORY_attrs(m)%key,     & ! [IN]
                                   FILE_HISTORY_attrs(m)%float(:) ) ! [IN]
       case ( I_DOUBLE )
          call FILE_Set_Attribute( fid,                            & ! [IN]
                                   FILE_HISTORY_attrs(m)%varname,  & ! [IN]
                                   FILE_HISTORY_attrs(m)%key,      & ! [IN]
                                   FILE_HISTORY_attrs(m)%double(:) ) ! [IN]
       end select

    end do

    ! allows PnetCDF to allocate an internal buffer of size io_buffer_size
    ! to aggregate write requests for history variables
    if ( FILE_HISTORY_io_buffer_size == 0 ) then
       array_size = 0
       do m = 1, FILE_HISTORY_nitems
          array_size = array_size + FILE_HISTORY_vars(m)%size
       end do
       FILE_HISTORY_io_buffer_size = array_size * DP
    end if
    call FILE_Attach_Buffer( FILE_HISTORY_vars(id)%fid, FILE_HISTORY_io_buffer_size ) ! [IN]


    do m = 1, FILE_HISTORY_nitems
       if ( FILE_HISTORY_vars(id)%basename == FILE_HISTORY_vars(m)%basename ) then
          ! Add new variable
          FILE_HISTORY_vars(m)%fid = fid
          dtsec = real(FILE_HISTORY_vars(m)%dstep,kind=DP) * FILE_HISTORY_DTSEC
          dimid = FILE_HISTORY_vars(m)%dimid
          zid   = FILE_HISTORY_vars(m)%zid
          ndims = FILE_HISTORY_dims(dimid)%ndims
          dims(1:ndims) = FILE_HISTORY_dims(dimid)%dims(1:ndims,zid)
          call FILE_Add_Variable( FILE_HISTORY_vars(m)%fid,              & ! [IN]
                                  FILE_HISTORY_vars(m)%outname,          & ! [IN]
                                  FILE_HISTORY_vars(m)%desc,             & ! [IN]
                                  FILE_HISTORY_vars(m)%units,            & ! [IN]
                                  FILE_HISTORY_vars(m)%standard_name,    & ! [IN]
                                  dims(1:ndims),                         & ! [IN]
                                  FILE_HISTORY_vars(m)%dtype,            & ! [IN]
                                  dtsec,                                 & ! [IN]
                                  FILE_HISTORY_vars(m)%vid,              & ! [OUT]
                                  time_avg=FILE_HISTORY_vars(m)%taverage ) ! [IN]
          if (       FILE_HISTORY_dims(dimid)%mapping /= "" ) then
             call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname, & ! [IN]
                                      'grid_mapping', FILE_HISTORY_dims(dimid)%mapping         ) ! [IN]
          endif

          select case( FILE_HISTORY_vars(m)%cell_measures )
          case ( "area", "area_z" )
             if ( FILE_HISTORY_dims(dimid)%area /= "" ) then
                call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname,        & ! [IN]
                                         'cell_measures', "area: "//trim(FILE_HISTORY_dims(dimid)%area) ) ! [IN]
             end if
          case ( "area_x" )
             if ( FILE_HISTORY_dims(dimid)%area_x /= "" ) then
                call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname,          & ! [IN]
                                         'cell_measures', "area: "//trim(FILE_HISTORY_dims(dimid)%area_x) ) ! [IN]
             end if
          case ( "area_y" )
             if ( FILE_HISTORY_dims(dimid)%area_x /= "" ) then
                call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname,          & ! [IN]
                                         'cell_measures', "area: "//trim(FILE_HISTORY_dims(dimid)%area_y) ) ! [IN]
             end if
          case ( "volume" )
             if ( FILE_HISTORY_dims(dimid)%area_x /= "" ) then
                call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname,          & ! [IN]
                                         'cell_measures', "volume: "//trim(FILE_HISTORY_dims(dimid)%volume) ) ! [IN]
             end if
          end select

          if ( FILE_HISTORY_dims(dimid)%location /= "" ) then
             if ( FILE_HISTORY_vars(m)%zcoord == "model" ) then
                call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname, & ! [IN]
                                         'grid', FILE_HISTORY_dims(dimid)%grid                   ) ! [IN]
             else
                call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname,                              & ! [IN]
                                         'grid', trim(FILE_HISTORY_dims(dimid)%grid)//'_'//trim(FILE_HISTORY_vars(id)%zcoord) ) ! [IN]
             end if
             call FILE_Set_Attribute( FILE_HISTORY_vars(m)%fid, FILE_HISTORY_vars(m)%outname, & ! [IN]
                                      'location', FILE_HISTORY_dims(dimid)%location           ) ! [IN]
          end if
       end if
    end do

    call FILE_HISTORY_Write_Axes(id) ! [IN]

    return
  end subroutine FILE_HISTORY_Create

  subroutine FILE_HISTORY_Close
    use scale_file, only: &
       FILE_Detach_Buffer, &
       FILE_Close
    implicit none

    integer :: fid, prev_fid
    integer :: id
    !---------------------------------------------------------------------------

    prev_fid = -1
    do id = 1, FILE_HISTORY_nitems
       fid = FILE_HISTORY_vars(id)%fid
       FILE_HISTORY_vars(id)%fid = -1
       if ( fid > 0 .AND. fid /= prev_fid ) then
          call FILE_Detach_Buffer( fid ) ! Release the internal buffer previously allowed to be used by PnetCDF
          call FILE_Close( fid )
          prev_fid = fid
       endif
    enddo

    return
  end subroutine FILE_HISTORY_Close

  !-----------------------------------------------------------------------------
  ! interface FILE_HISTORY_SetAssociatedCoordinate
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_AssociatedCoordinate_1D( &
       name,     &
       desc,     &
       units,    &
       dims,     &
       var,      &
       datatype, &
       start     )
    use scale_file_h, only: &
       FILE_REAL4, &
       FILE_REAL8
    implicit none

    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dims(:)
    real(RP),         intent(in) :: var(:)
    character(len=*), intent(in), optional :: datatype
    integer,          intent(in), optional :: start(:)

    integer :: dtype
    integer :: dim_size
    integer :: id

    intrinsic size, shape, reshape
    !---------------------------------------------------------------------------

    if ( present(datatype) ) then
       if    ( datatype == 'REAL4' ) then
          dtype = FILE_REAL4
       elseif( datatype == 'REAL8' ) then
          dtype = FILE_REAL8
       else
          LOG_ERROR("FILE_HISTORY_Set_AssociatedCoordinate_1D",*) 'Not appropriate datatype. Check!', datatype
          call PRC_abort
       endif
    else if ( RP == SP ) then
       dtype = FILE_REAL4
    else
       dtype = FILE_REAL8
    endif

    dim_size = size(var)

    if ( FILE_HISTORY_nassocs < FILE_HISTORY_assoc_max ) then
       FILE_HISTORY_nassocs = FILE_HISTORY_nassocs + 1
       id                   = FILE_HISTORY_nassocs

       allocate( FILE_HISTORY_assocs(id)%var(dim_size) )

       FILE_HISTORY_assocs(id)%name      = name
       FILE_HISTORY_assocs(id)%desc      = desc
       FILE_HISTORY_assocs(id)%units     = units
       FILE_HISTORY_assocs(id)%ndims     = 1
       FILE_HISTORY_assocs(id)%dims(:)   = ''
       FILE_HISTORY_assocs(id)%dims(1:1) = dims(1:1)
       FILE_HISTORY_assocs(id)%dtype     = dtype
       FILE_HISTORY_assocs(id)%var(:)    = real(reshape( var, (/ dim_size /) ),kind=DP)

       ! start and count are used for parallel I/O to a single shared file
       ! since var is reshaped into 1D array, we need to preserve its original shape in count
       FILE_HISTORY_assocs(id)%count(1:1) = shape(var)
       if ( present(start) ) then
          FILE_HISTORY_assocs(id)%start(1:1) = start(1:1)
       else
          FILE_HISTORY_assocs(id)%start = (/ 1, 1, 1, 1 /)
       end if
    else
       LOG_ERROR("FILE_HISTORY_Set_AssociatedCoordinate_1D",*) 'Number of associate coordinates exceeds the limit.'
       call PRC_abort
    endif

    return
  end subroutine FILE_HISTORY_Set_AssociatedCoordinate_1D

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_AssociatedCoordinate_2D( &
       name,     &
       desc,     &
       units,    &
       dims,     &
       var,      &
       datatype, &
       start     )
    use scale_file_h, only: &
       FILE_REAL4, &
       FILE_REAL8
    implicit none

    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dims(:)
    real(RP),         intent(in) :: var(:,:)
    character(len=*), intent(in), optional :: datatype
    integer,          intent(in), optional :: start(:)

    integer :: dtype
    integer :: dim_size
    integer :: id

    intrinsic size, shape, reshape
    !---------------------------------------------------------------------------

    if ( present(datatype) ) then
       if    ( datatype == 'REAL4' ) then
          dtype = FILE_REAL4
       elseif( datatype == 'REAL8' ) then
          dtype = FILE_REAL8
       else
          LOG_ERROR("FILE_HISTORY_Set_AssociatedCoordinate_2D",*) 'Not appropriate datatype. Check!', datatype
          call PRC_abort
       endif
    else if ( RP == SP ) then
       dtype = FILE_REAL4
    else
       dtype = FILE_REAL8
    endif

    dim_size = size(var)

    if ( FILE_HISTORY_nassocs < FILE_HISTORY_assoc_max ) then
       FILE_HISTORY_nassocs = FILE_HISTORY_nassocs + 1
       id                   = FILE_HISTORY_nassocs

       allocate( FILE_HISTORY_assocs(id)%var(dim_size) )

       FILE_HISTORY_assocs(id)%name      = name
       FILE_HISTORY_assocs(id)%desc      = desc
       FILE_HISTORY_assocs(id)%units     = units
       FILE_HISTORY_assocs(id)%ndims     = 2
       FILE_HISTORY_assocs(id)%dims(:)   = ''
       FILE_HISTORY_assocs(id)%dims(1:2) = dims(1:2)
       FILE_HISTORY_assocs(id)%dtype     = dtype
       FILE_HISTORY_assocs(id)%var(:)    = real(reshape( var, (/ dim_size /) ),kind=DP)

       ! start and count are used for parallel I/O to a single shared file
       ! since var is reshaped into 1D array, we need to preserve its original shape in count
       FILE_HISTORY_assocs(id)%count(1:2) = shape(var)
       if ( present(start) ) then
          FILE_HISTORY_assocs(id)%start(1:2) = start(1:2)
       else
          FILE_HISTORY_assocs(id)%start = (/ 1, 1, 1, 1 /)
       end if
    else
       LOG_ERROR("FILE_HISTORY_Set_AssociatedCoordinate_2D",*) 'Number of associate coordinates exceeds the limit.'
       call PRC_abort
    endif

    return
  end subroutine FILE_HISTORY_Set_AssociatedCoordinate_2D

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_AssociatedCoordinate_3D( &
       name,     &
       desc,     &
       units,    &
       dims,     &
       var,      &
       datatype, &
       start     )
    use scale_file_h, only: &
       FILE_REAL4, &
       FILE_REAL8
    implicit none

    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dims(:)
    real(RP),         intent(in) :: var(:,:,:)
    character(len=*), intent(in), optional :: datatype
    integer,          intent(in), optional :: start(:)

    integer :: dtype
    integer :: dim_size
    integer :: id

    intrinsic size, shape, reshape
    !---------------------------------------------------------------------------

    if ( present(datatype) ) then
       if    ( datatype == 'REAL4' ) then
          dtype = FILE_REAL4
       elseif( datatype == 'REAL8' ) then
          dtype = FILE_REAL8
       else
          LOG_ERROR("FILE_HISTORY_Set_AssociatedCoordinate_3D",*) 'Not appropriate datatype. Check!', datatype
          call PRC_abort
       endif
    else if ( RP == SP ) then
       dtype = FILE_REAL4
    else
       dtype = FILE_REAL8
    endif

    dim_size = size(var)

    if ( FILE_HISTORY_nassocs < FILE_HISTORY_assoc_max ) then
       FILE_HISTORY_nassocs = FILE_HISTORY_nassocs + 1
       id                   = FILE_HISTORY_nassocs

       allocate( FILE_HISTORY_assocs(id)%var(dim_size) )

       FILE_HISTORY_assocs(id)%name      = name
       FILE_HISTORY_assocs(id)%desc      = desc
       FILE_HISTORY_assocs(id)%units     = units
       FILE_HISTORY_assocs(id)%ndims     = 3
       FILE_HISTORY_assocs(id)%dims(:)   = ''
       FILE_HISTORY_assocs(id)%dims(1:3) = dims(1:3)
       FILE_HISTORY_assocs(id)%dtype     = dtype
       FILE_HISTORY_assocs(id)%var(:)    = real(reshape( var, (/ dim_size /) ),kind=DP)

       ! start and count are used for parallel I/O to a single shared file
       ! since var is reshaped into 1D array, we need to preserve its original shape in count
       FILE_HISTORY_assocs(id)%count(1:3) = shape(var)
       if ( present(start) ) then
          FILE_HISTORY_assocs(id)%start(1:3) = start(1:3)
       else
          FILE_HISTORY_assocs(id)%start = (/ 1, 1, 1, 1 /)
       end if
    else
       LOG_ERROR("FILE_HISTORY_Set_AssociatedCoordinate_3D",*) 'Number of associate coordinates exceeds the limit.'
       call PRC_abort
    endif

    return
  end subroutine FILE_HISTORY_Set_AssociatedCoordinate_3D

  !-----------------------------------------------------------------------------
  ! interface FILE_HISTORY_Set_Attribute
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Attribute_Text( &
       varname,     &
       key, val,    &
       add_variable )
    use scale_prc, only: &
       PRC_abort
    use scale_file, only: &
       FILE_Set_Attribute
    implicit none
    character(len=*), intent(in) :: varname
    character(len=*), intent(in) :: key
    character(len=*), intent(in) :: val
    logical,          intent(in), optional :: add_variable

    integer :: id
    !---------------------------------------------------------------------------

    FILE_HISTORY_nattrs = FILE_HISTORY_nattrs + 1
    if ( FILE_HISTORY_nattrs > FILE_HISTORY_attr_max ) then
       LOG_ERROR("FILE_HISTORY_Set_Attribute_Text",*) 'number of attributes exceeds the limit'
       call PRC_abort
    end if

    id = FILE_HISTORY_nattrs

    FILE_HISTORY_attrs(id)%varname = varname
    FILE_HISTORY_attrs(id)%key     = key
    FILE_HISTORY_attrs(id)%text    = val
    FILE_HISTORY_attrs(id)%type    = I_TEXT

    if ( present(add_variable) ) then
       FILE_HISTORY_attrs(id)%add_variable = add_variable
    else
       FILE_HISTORY_attrs(id)%add_variable = .false.
    end if

    return
  end subroutine FILE_HISTORY_Set_Attribute_Text

  subroutine FILE_HISTORY_Set_Attribute_Logical( &
       varname,     &
       key, val,    &
       add_variable )
    use scale_file, only: &
       FILE_Set_Attribute
    implicit none
    character(len=*), intent(in) :: varname
    character(len=*), intent(in) :: key
    logical,          intent(in) :: val
    logical,          intent(in), optional :: add_variable

    character(len=5) :: buf
    !---------------------------------------------------------------------------

    if ( val ) then
       buf = "true"
    else
       buf = "false"
    end if

    call FILE_HISTORY_Set_Attribute_Text( varname, key, buf, add_variable=add_variable )

    return
  end subroutine FILE_HISTORY_Set_Attribute_Logical

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Attribute_Int( &
       varname,     &
       key, val,    &
       add_variable )
    use scale_prc, only: &
       PRC_abort
    use scale_file, only: &
       FILE_Set_Attribute
    implicit none
    character(len=*), intent(in) :: varname
    character(len=*), intent(in) :: key
    integer,          intent(in) :: val(:)
    logical,          intent(in), optional :: add_variable

    integer :: id

    intrinsic size
    !---------------------------------------------------------------------------

    FILE_HISTORY_nattrs = FILE_HISTORY_nattrs + 1
    if ( FILE_HISTORY_nattrs > FILE_HISTORY_attr_max ) then
       LOG_ERROR("FILE_HISTORY_Set_Attribute_Int",*) 'number of attributes exceeds the limit'
       call PRC_abort
    end if

    id = FILE_HISTORY_nattrs

    allocate( FILE_HISTORY_attrs(id)%int( size(val) ) )

    FILE_HISTORY_attrs(id)%varname = varname
    FILE_HISTORY_attrs(id)%key     = key
    FILE_HISTORY_attrs(id)%int(:)    = val(:)
    FILE_HISTORY_attrs(id)%type    = I_INT

    if ( present(add_variable) ) then
       FILE_HISTORY_attrs(id)%add_variable = add_variable
    else
       FILE_HISTORY_attrs(id)%add_variable = .false.
    end if

    return
  end subroutine FILE_HISTORY_Set_Attribute_Int

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Attribute_Float( &
       varname,     &
       key, val,    &
       add_variable )
    use scale_prc, only: &
       PRC_abort
    use scale_file, only: &
       FILE_Set_Attribute
    implicit none
    character(len=*), intent(in) :: varname
    character(len=*), intent(in) :: key
    real(SP),         intent(in) :: val(:)
    logical,          intent(in), optional :: add_variable

    integer :: id

    intrinsic size
    !---------------------------------------------------------------------------

    FILE_HISTORY_nattrs = FILE_HISTORY_nattrs + 1
    if ( FILE_HISTORY_nattrs > FILE_HISTORY_attr_max ) then
       LOG_ERROR("FILE_HISTORY_Set_Attribute_Float",*) 'number of attributes exceeds the limit'
       call PRC_abort
    end if

    id = FILE_HISTORY_nattrs

    allocate( FILE_HISTORY_attrs(id)%float( size(val) ) )

    FILE_HISTORY_attrs(id)%varname = varname
    FILE_HISTORY_attrs(id)%key     = key
    FILE_HISTORY_attrs(id)%float(:)    = val(:)
    FILE_HISTORY_attrs(id)%type    = I_FLOAT

    if ( present(add_variable) ) then
       FILE_HISTORY_attrs(id)%add_variable = add_variable
    else
       FILE_HISTORY_attrs(id)%add_variable = .false.
    end if

    return
  end subroutine FILE_HISTORY_Set_Attribute_Float

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Set_Attribute_Double( &
       varname,     &
       key, val,    &
       add_variable )
    use scale_prc, only: &
       PRC_abort
    use scale_file, only: &
       FILE_Set_Attribute
    implicit none
    character(len=*), intent(in) :: varname
    character(len=*), intent(in) :: key
    real(DP),         intent(in) :: val(:)
    logical,          intent(in), optional :: add_variable

    integer :: id

    intrinsic size
    !---------------------------------------------------------------------------

    FILE_HISTORY_nattrs = FILE_HISTORY_nattrs + 1
    if ( FILE_HISTORY_nattrs > FILE_HISTORY_attr_max ) then
       LOG_ERROR("FILE_HISTORY_Set_Attribute_Double",*) 'number of attributes exceeds the limit'
       call PRC_abort
    end if

    id = FILE_HISTORY_nattrs

    allocate( FILE_HISTORY_attrs(id)%double( size(val) ) )

    FILE_HISTORY_attrs(id)%varname = varname
    FILE_HISTORY_attrs(id)%key     = key
    FILE_HISTORY_attrs(id)%double(:)    = val(:)
    FILE_HISTORY_attrs(id)%type    = I_DOUBLE

    if ( present(add_variable) ) then
       FILE_HISTORY_attrs(id)%add_variable = add_variable
    else
       FILE_HISTORY_attrs(id)%add_variable = .false.
    end if

    return
  end subroutine FILE_HISTORY_Set_Attribute_Double


  !-----------------------------------------------------------------------------
  ! interface FILE_HOSTORY_Query
  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Query_ID( &
       itemid,    &
       answer )
    integer, intent(in)  :: itemid
    logical, intent(out) :: answer

    integer :: id, i

    answer = .false.
    if ( FILE_HISTORY_disabled ) return
    if ( itemid < 0 ) return

    do i = 1, FILE_HISTORY_var_inputs(itemid)%nvariants
       id = FILE_HISTORY_var_inputs(itemid)%variants(i)
       if ( FILE_HISTORY_vars(id)%taverage ) then
          answer = .true.
          return
       else if ( FILE_HISTORY_NOWSTEP >= FILE_HISTORY_vars(id)%laststep_write + FILE_HISTORY_vars(id)%dstep ) then
          answer = .true.
          return
       endif
    end do

    return
  end subroutine FILE_HISTORY_Query_ID

  subroutine FILE_HISTORY_Query_Name( &
       name,  &
       answer )
    implicit none

    character(len=*), intent(in) :: name

    logical, intent(out) :: answer

    integer :: itemid
    !---------------------------------------------------------------------------

    answer  = .false.
    if ( FILE_HISTORY_disabled ) return

    do itemid = 1, FILE_HISTORY_nvar_inputs
       if ( FILE_HISTORY_var_inputs(itemid)%name == name ) then
          call FILE_HISTORY_Query_ID( itemid, answer ) ! [IN], [OUT]
          return
       end if
    end do

    return
  end subroutine FILE_HISTORY_Query_Name

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Write_Axes(id)
    use scale_file, only: &
       FILE_EndDef,     &
       FILE_Flush,      &
       FILE_Write_Axis, &
       FILE_Write_AssociatedCoordinate
    use scale_prc, only: &
       PRC_abort
    implicit none
    integer, intent(in) :: id

    integer :: start(1)
    integer :: m, fid
    !---------------------------------------------------------------------------

    if ( id < 0 ) return

    fid = FILE_HISTORY_vars(id)%fid
    call FILE_EndDef( fid )

    ! write registered history variables to file
    do m = 1, FILE_HISTORY_naxes
       if ( FILE_HISTORY_axes(m)%start > 0 ) then
          start(1) = FILE_HISTORY_axes(m)%start

          call FILE_Write_Axis( fid,                       & ! [IN]
                                FILE_HISTORY_axes(m)%name, & ! [IN]
                                FILE_HISTORY_axes(m)%var,  & ! [IN]
                                start                      ) ! [IN]

          if ( associated(FILE_HISTORY_axes(m)%bounds) ) then
             call FILE_Write_AssociatedCoordinate( fid,                                      & ! [IN]
                                                   trim(FILE_HISTORY_axes(m)%name)//'_bnds', & ! [IN]
                                                   FILE_HISTORY_axes(m)%bounds(:,:),         & ! [IN]
                                                   (/ 1, start(1) /)                         ) ! [IN]
          end if

       end if
    end do

    do m = 1, FILE_HISTORY_nassocs
       call FILE_Write_AssociatedCoordinate( fid,                          & ! [IN]
                                             FILE_HISTORY_assocs(m)%name,  & ! [IN]
                                             FILE_HISTORY_assocs(m)%var,   & ! [IN]
                                             FILE_HISTORY_assocs(m)%start, & ! [IN]
                                             FILE_HISTORY_assocs(m)%count, & ! [IN]
                                             FILE_HISTORY_assocs(m)%ndims  ) ! [IN]
    enddo

    ! for PnetCDF I/O, flush all pending nonblocking write requests
    call FILE_Flush( fid )

    return
  end subroutine FILE_HISTORY_Write_Axes

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Write_OneVar( &
       id,  &
       step_now )
    use scale_file_h, only: &
       RMISS => FILE_RMISS
    use scale_calendar, only: &
       CALENDAR_sec2unit
    use scale_file, only: &
       FILE_Write
    implicit none

    integer, intent(in) :: id
    integer, intent(in) :: step_now

    integer  :: dimid, zid
    real(DP) :: time_str, time_end
    real(DP) :: sec_str,  sec_end
    integer  :: i
    !---------------------------------------------------------------------------

    if( FILE_HISTORY_nreqs == 0 ) return

    if ( step_now < FILE_HISTORY_vars(id)%laststep_write + FILE_HISTORY_vars(id)%dstep ) then
       return
    endif

    if ( FILE_HISTORY_vars(id)%flag_clear ) then
       if ( FILE_HISTORY_ERROR_PUTMISS ) then
          LOG_ERROR("FILE_HISTORY_Write_OneVar",*) 'The time interval of history output ', trim(FILE_HISTORY_vars(id)%name), &
                     ' and the time interval of its related scheme are inconsistent.'
          LOG_ERROR_CONT(*) 'Please check the namelist PARAM_TIME, PARAM_FILE_HISTORY, and HISTORY_ITEM.'
          LOG_ERROR_CONT(*) 'Please set FILE_HISTORY_ERROR_PUTMISS in the namelist PARAM_FILE_HISTORY to .false.', &
                     ' when you want to disable this check.'
          LOG_ERROR_CONT(*) 'The time interval of history output ', trim(FILE_HISTORY_vars(id)%name), &
                     ' and the time interval of its related scheme are inconsistent.',        &
                     ' Please see detail in log file.'
          call PRC_abort
       else
          LOG_WARN("FILE_HISTORY_Write_OneVar",*) 'Output value is not updated in this step.', &
                                         ' NAME = ',     trim(FILE_HISTORY_vars(id)%name), &
                                         ', OUTNAME = ', trim(FILE_HISTORY_vars(id)%outname)
       endif
    endif

    if ( .NOT. FILE_HISTORY_vars(id)%flag_clear .AND. FILE_HISTORY_vars(id)%taverage ) then
       do i = 1, FILE_HISTORY_vars(id)%size
          if ( FILE_HISTORY_vars(id)%varsum(i) /= RMISS ) then
             FILE_HISTORY_vars(id)%varsum(i) = FILE_HISTORY_vars(id)%varsum(i) / FILE_HISTORY_vars(id)%timesum
          end if
       end do
    endif

    if ( firsttime ) then
       firsttime = .false.
       call FILE_HISTORY_Output_List
    endif

    if ( step_now > FILE_HISTORY_vars(id)%waitstep ) then
       if ( laststep_write < step_now ) then ! log only once in this step
          LOG_PROGRESS(*) 'output history'
       endif

       ! Note this subroutine must be called after all FILE_HISTORY_reg calls are completed
       ! Write registered history axes to history file
       call FILE_HISTORY_Create( id, options = FILE_HISTORY_options ) ! [IN]

       sec_str = FILE_HISTORY_STARTDAYSEC + real(FILE_HISTORY_vars(id)%laststep_write-1,kind=DP) * FILE_HISTORY_DTSEC
       sec_end = FILE_HISTORY_STARTDAYSEC + real(step_now                       -1,kind=DP) * FILE_HISTORY_DTSEC

       ! convert time units [sec]->[sec,min,hour,day,month,year]
       call CALENDAR_sec2unit( time_str, sec_str, FILE_HISTORY_TIME_UNITS )
       call CALENDAR_sec2unit( time_end, sec_end, FILE_HISTORY_TIME_UNITS )

       dimid = FILE_HISTORY_vars(id)%dimid
       zid = FILE_HISTORY_vars(id)%zid
       if ( FILE_HISTORY_dims(dimid)%count(1,zid) > 0 ) then

          ! for one-file-per-process I/O method, count(1) == 1 always
          ! for one file shared by all processes, count(1) >= 0,
          ! being 0 indicates a 1D history variable, which will only be written by the
          ! south-most processes in parallel, or a z axis to be written by rank 0 only

          call FILE_Write( FILE_HISTORY_vars(id)%vid,                   & ! [IN]
                           FILE_HISTORY_vars(id)%varsum(:),             & ! [IN]
                           time_str,                                    & ! [IN]
                           time_end,                                    & ! [IN]
                           ndims=FILE_HISTORY_dims(dimid)%ndims,        & ! ndims before reshape
                           count=FILE_HISTORY_dims(dimid)%count(:,zid), & ! global subarray lengths
                           start=FILE_HISTORY_dims(dimid)%start(:,zid)  ) ! global subarray start indices
       end if
    else
       if ( laststep_write < step_now ) then
          LOG_PROGRESS(*) 'history output is suppressed'
       endif
    endif

    FILE_HISTORY_vars(id)%laststep_write = step_now
    FILE_HISTORY_vars(id)%flag_clear     = .true.

    laststep_write = step_now ! remember for multiple call in the same step

    return
  end subroutine FILE_HISTORY_Write_OneVar

  !-----------------------------------------------------------------------------
  subroutine FILE_HISTORY_Output_List
    implicit none

    real(DP) :: dtsec
    integer  :: id
    !---------------------------------------------------------------------------

    if ( FILE_HISTORY_nitems /= FILE_HISTORY_nreqs ) then

       LOG_INFO("FILE_HISTORY_Output_List",*) '[HISTORY] All of requested variable by the namelist HISTORY_ITEM did not find.'
       do id = 1, FILE_HISTORY_nreqs
          LOG_INFO("FILE_HISTORY_Output_List",'(A,A24,A,L1)') 'NAME : ', FILE_HISTORY_req(id)%name, &
                                                      ', registered? : ', FILE_HISTORY_req(id)%registered
       enddo
       LOG_INFO("FILE_HISTORY_Output_List",*)  'Please set FILE_HISTORY_ERROR_PUTMISS in the namelist PARAM_FILE_HISTORY to .false.', &
                                      ' when you want to disable this check.'

       if ( FILE_HISTORY_ERROR_PUTMISS ) then
          LOG_ERROR("FILE_HISTORY_Output_List",*) 'Requested variables by the namelist HISTORY_ITEM did not find. Please see detail in log file.'
          call PRC_abort
       endif
    endif

    LOG_INFO("FILE_HISTORY_Output_List",*)           '[HISTORY] Output item list '
    LOG_INFO_CONT('(1x,A,I4)') 'Number of history item :', FILE_HISTORY_nreqs
    LOG_INFO_CONT(*)           'ITEM                    :OUTNAME                 ', &
                  ':    size:interval[sec]:    step:timeavg?:zcoord'
    LOG_INFO_CONT(*)           '=================================================', &
                                             '================================================='


    do id = 1, FILE_HISTORY_nitems
       dtsec = real(FILE_HISTORY_vars(id)%dstep,kind=DP) * FILE_HISTORY_DTSEC

       LOG_INFO_CONT('(1x,A24,1x,A24,1x,I8,1x,F13.3,1x,I8,1x,L8,1x,A8)') &
                  FILE_HISTORY_vars(id)%name,     &
                  FILE_HISTORY_vars(id)%outname,  &
                  FILE_HISTORY_vars(id)%size,     &
                  dtsec,                          &
                  FILE_HISTORY_vars(id)%dstep,    &
                  FILE_HISTORY_vars(id)%taverage, &
                  FILE_HISTORY_vars(id)%zcoord
    enddo

    LOG_INFO_CONT(*)           '=================================================', &
                                             '================================================='

    return
  end subroutine FILE_HISTORY_Output_List

  function FILE_HISTORY_find_id( name )
    character(len=*), intent(in) :: name
    integer :: FILE_HISTORY_find_id

    integer :: itemid

    do itemid = 1, FILE_HISTORY_nvar_inputs
       if ( FILE_HISTORY_var_inputs(itemid)%name == name ) then
          FILE_HISTORY_find_id = itemid
          return
       end if
    end do

    FILE_HISTORY_find_id = -1

    return
  end function FILE_HISTORY_find_id

  function FILE_HISTORY_get_size( &
       dims, ndims )
    character(len=*), intent(in) :: dims(:)
    integer, intent(in) :: ndims
    integer :: FILE_HISTORY_get_size

    integer :: len
    integer :: n, i

    FILE_HISTORY_get_size = 1
    do n = 1, ndims
       len = -1
       do i = 1, FILE_HISTORY_naxes
          if ( FILE_HISTORY_axes(i)%name == dims(n) ) then
             len = FILE_HISTORY_axes(i)%dim_size
             exit
          end if
       end do
       if ( len < 0 ) then
          LOG_ERROR("FILE_HISTORY_get_size",*) 'dimension name is not found: ', dims(n)
          call PRC_abort
       end if
       FILE_HISTORY_get_size = FILE_HISTORY_get_size * len
    end do

    return
  end function FILE_HISTORY_get_size

  subroutine FILE_HISTORY_truncate_1D_default( &
       src, &
       dim_type, zcoord, fill_halo, &
       dsc )
    real(RP),         intent(in) :: src(:)
    character(len=*), intent(in) :: dim_type
    character(len=*), intent(in) :: zcoord
    logical,          intent(in) :: fill_halo
    real(DP),         intent(out) :: dsc(:)

    dsc(:) = src(:)

    return
  end subroutine FILE_HISTORY_truncate_1D_default
  subroutine FILE_HISTORY_truncate_2D_default( &
       src, &
       dim_type, zcoord, fill_halo, &
       dsc )
    real(RP),         intent(in) :: src(:,:)
    character(len=*), intent(in) :: dim_type
    character(len=*), intent(in) :: zcoord
    logical,          intent(in) :: fill_halo
    real(DP),         intent(out) :: dsc(:)

    integer :: i, j
    integer :: idx

    intrinsic size

    idx = 1
    do j = 1, size(src,2)
    do i = 1, size(src,1)
       dsc(idx) = src(i, j)
       idx = idx + 1
    end do
    end do

    return
  end subroutine FILE_HISTORY_truncate_2D_default
  subroutine FILE_HISTORY_truncate_3D_default( &
       src, &
       dim_type, zcoord, fill_halo, &
       dsc )
    real(RP),         intent(in) :: src(:,:,:)
    character(len=*), intent(in) :: dim_type
    character(len=*), intent(in) :: zcoord
    logical,          intent(in) :: fill_halo
    real(DP),         intent(out) :: dsc(:)

    integer :: k, i, j
    integer :: idx

    intrinsic size

    idx = 1
    do j = 1, size(src,3)
    do i = 1, size(src,2)
    do k = 1, size(src,1)
       dsc(idx) = src(k, i, j)
       idx = idx + 1
    end do
    end do
    end do

    return
  end subroutine FILE_HISTORY_truncate_3D_default
  subroutine FILE_HISTORY_truncate_4D_default( &
       src, &
       dim_type, zcoord, fill_halo, &
       dsc )
    real(RP),         intent(in) :: src(:,:,:,:)
    character(len=*), intent(in) :: dim_type
    character(len=*), intent(in) :: zcoord
    logical,          intent(in) :: fill_halo
    real(DP),         intent(out) :: dsc(:)

    integer :: l, k, i, j
    integer :: idx

    intrinsic size

    idx = 1
    do j = 1, size(src,4)
    do i = 1, size(src,3)
    do k = 1, size(src,2)
    do l = 1, size(src,1)
       dsc(idx) = src(l, k, i, j)
       idx = idx + 1
    end do
    end do
    end do
    end do

    return
  end subroutine FILE_HISTORY_truncate_4D_default

end module scale_file_history



!--
! vi:set readonly sw=4 ts=8
!
!Local Variables:
!mode: f90
!buffer-read-only:t
!End:
!
!++
