!-------------------------------------------------------------------------------
!> module file
!!
!! @par Description
!!          file I/O hundring
!!
!! @author Team SCALE
!!
!<
!-------------------------------------------------------------------------------
! Warning: This file was generated from file/scale_file.F90.erb.
!          Do not edit this file.
!-------------------------------------------------------------------------------
#include "scalelib.h"
module scale_file
  !-----------------------------------------------------------------------------
  !
  !++ Used modules
  !
  use scale_precision
  use scale_io
  use scale_prof
  use scale_file_h
  use scale_prc, only: &
     PRC_abort
  !-----------------------------------------------------------------------------
  implicit none
  private
  !-----------------------------------------------------------------------------
  !
  !++ Public procedures
  !
  public :: FILE_setup
  public :: FILE_open
  public :: FILE_opened
  public :: FILE_create
  public :: FILE_get_dimLength
  public :: FILE_set_option
  public :: FILE_def_axis
  public :: FILE_put_axis
  public :: FILE_write_axis
  public :: FILE_def_associatedCoordinate
  public :: FILE_put_associatedCoordinate
  public :: FILE_write_associatedCoordinate
  public :: FILE_add_variable
  public :: FILE_def_variable
  public :: FILE_get_shape
  public :: FILE_get_stepSize
  public :: FILE_get_commonInfo
  public :: FILE_get_dataInfo
  public :: FILE_get_all_dataInfo
  public :: FILE_read
  public :: FILE_write
  public :: FILE_get_attribute
  public :: FILE_set_attribute
  public :: FILE_add_associatedVariable
  public :: FILE_enddef
  public :: FILE_flush
  public :: FILE_close
  public :: FILE_close_all
  public :: FILE_make_fname
  public :: FILE_attach_buffer
  public :: FILE_detach_buffer
  public :: FILE_get_CFtunits
  public :: FILE_get_aggregate

  interface FILE_get_commonInfo
     module procedure FILE_get_commonInfo_fid
     module procedure FILE_get_commonInfo_fname
  end interface FILE_get_commonInfo

  interface FILE_get_shape
     module procedure FILE_get_shape_fid
     module procedure FILE_get_shape_fname
  end interface FILE_get_shape

  interface FILE_get_datainfo
     module procedure FILE_get_datainfo_fid
     module procedure FILE_get_datainfo_fname
  end interface FILE_get_datainfo

  interface FILE_get_all_datainfo
     module procedure FILE_get_all_datainfo_fid
     module procedure FILE_get_all_datainfo_fname
  end interface FILE_get_all_datainfo

  interface FILE_put_axis
     module procedure FILE_put_axis_realSP
     module procedure FILE_put_axis_realDP
  end interface FILE_put_axis
  interface FILE_write_axis
     module procedure FILE_write_axis_realSP
     module procedure FILE_write_axis_realDP
  end interface FILE_write_axis
  interface FILE_put_associatedCoordinate
    module procedure FILE_put_associatedCoordinate_realSP_1D
    module procedure FILE_put_associatedCoordinate_realDP_1D
    module procedure FILE_put_associatedCoordinate_realSP_2D
    module procedure FILE_put_associatedCoordinate_realDP_2D
    module procedure FILE_put_associatedCoordinate_realSP_3D
    module procedure FILE_put_associatedCoordinate_realDP_3D
    module procedure FILE_put_associatedCoordinate_realSP_4D
    module procedure FILE_put_associatedCoordinate_realDP_4D
  end interface FILE_put_associatedCoordinate
  interface FILE_write_associatedCoordinate
    module procedure FILE_write_associatedCoordinate_RealSP_1D
    module procedure FILE_write_associatedCoordinate_RealDP_1D
    module procedure FILE_write_associatedCoordinate_RealSP_2D
    module procedure FILE_write_associatedCoordinate_RealDP_2D
    module procedure FILE_write_associatedCoordinate_RealSP_3D
    module procedure FILE_write_associatedCoordinate_RealDP_3D
    module procedure FILE_write_associatedCoordinate_RealSP_4D
    module procedure FILE_write_associatedCoordinate_RealDP_4D
  end interface FILE_write_associatedCoordinate
  interface FILE_add_variable
     module procedure FILE_add_variable_no_time
     module procedure FILE_add_variable_with_time
  end interface FILE_add_variable
  interface FILE_read
    module procedure FILE_read_realSP_1D
    module procedure FILE_read_realDP_1D
    module procedure FILE_read_realSP_2D
    module procedure FILE_read_realDP_2D
    module procedure FILE_read_realSP_3D
    module procedure FILE_read_realDP_3D
    module procedure FILE_read_realSP_4D
    module procedure FILE_read_realDP_4D
    module procedure FILE_read_var_realSP_1D
    module procedure FILE_read_var_realDP_1D
    module procedure FILE_read_var_realSP_2D
    module procedure FILE_read_var_realDP_2D
    module procedure FILE_read_var_realSP_3D
    module procedure FILE_read_var_realDP_3D
    module procedure FILE_read_var_realSP_4D
    module procedure FILE_read_var_realDP_4D
  end interface FILE_read
  interface FILE_write
    module procedure FILE_write_realSP_1D
    module procedure FILE_write_realDP_1D
    module procedure FILE_write_realSP_2D
    module procedure FILE_write_realDP_2D
    module procedure FILE_write_realSP_3D
    module procedure FILE_write_realDP_3D
    module procedure FILE_write_realSP_4D
    module procedure FILE_write_realDP_4D
  end interface FILE_write
  interface FILE_get_attribute
     module procedure FILE_get_attribute_text_fname
     module procedure FILE_get_attribute_logical_fname
     module procedure FILE_get_attribute_int_fname
     module procedure FILE_get_attribute_float_fname
     module procedure FILE_get_attribute_double_fname
     module procedure FILE_get_attribute_text_fid
     module procedure FILE_get_attribute_logical_fid
     module procedure FILE_get_attribute_int_fid
     module procedure FILE_get_attribute_float_fid
     module procedure FILE_get_attribute_double_fid
  end interface FILE_get_attribute
  interface FILE_set_attribute
     module procedure FILE_set_attribute_text
     module procedure FILE_set_attribute_logical
     module procedure FILE_set_attribute_int
     module procedure FILE_set_attribute_float
     module procedure FILE_set_attribute_double
  end interface FILE_set_attribute

  !-----------------------------------------------------------------------------
  !
  !++ Public parameters & variables
  !
  logical, public :: FILE_AGGREGATE = .false. !> do parallel I/O through PnetCDF (default setting)

  !-----------------------------------------------------------------------------
  !
  !++ Private procedures
  !
  private :: FILE_get_fid

  !-----------------------------------------------------------------------------
  !
  !++ Private parameters & variables
  !
  type file
     character(len=FILE_HLONG) :: name
     integer                   :: fid
     logical                   :: aggregate
  end type file
  type(file) :: FILE_files(FILE_FILE_MAX)
  integer    :: FILE_nfiles = 0

  type var
  character(len=FILE_HLONG) :: name
  integer                   :: fid
  integer                   :: vid
  end type var
  type(var) :: FILE_vars(FILE_VAR_MAX)
  integer   :: FILE_nvars = 0

  integer                   :: mpi_myrank

  !-----------------------------------------------------------------------------
contains
  !-----------------------------------------------------------------------------
  !> setup
  !-----------------------------------------------------------------------------
  subroutine FILE_setup( &
       myrank )
    use scale_prc, only: &
       PRC_set_file_closer
    implicit none

    integer, intent(in) :: myrank

    namelist / PARAM_FILE / &
         FILE_AGGREGATE

    integer :: ierr

       !--- read namelist
    rewind(IO_FID_CONF)
    read(IO_FID_CONF,nml=PARAM_FILE,iostat=ierr)
    if( ierr < 0 ) then !--- missing
       LOG_INFO("FILE_setup",*) 'Not found namelist. Default used.'
    elseif( ierr > 0 ) then !--- fatal error
       LOG_ERROR("FILE_setup",*) 'Not appropriate names in namelist PARAM_FILE. Check!'
       call PRC_abort
    endif
    LOG_NML(PARAM_FILE)

    mpi_myrank = myrank

    call PRC_set_file_closer( FILE_CLOSE_ALL )

    return
  end subroutine FILE_setup

  !-----------------------------------------------------------------------------
  !> create file
  !!  fid is >= 1
  !<
  subroutine FILE_create( &
       basename,                   &
       title, source, institution, &
       fid, existed,               &
       rankid, single, aggregate,  &
       time_units, calendar,       &
       append                      )
    implicit none

    character(len=*), intent(in)  :: basename
    character(len=*), intent(in)  :: title
    character(len=*), intent(in)  :: source
    character(len=*), intent(in)  :: institution

    integer,          intent(out) :: fid
    logical,          intent(out) :: existed

    integer,          intent(in), optional :: rankid
    logical,          intent(in), optional :: single
    logical,          intent(in), optional :: aggregate
    character(len=*), intent(in), optional :: time_units
    character(len=*), intent(in), optional :: calendar
    logical,          intent(in), optional :: append

    character(len=FILE_HMID)   :: time_units_
    character(len=FILE_HSHORT) :: calendar_
    integer :: rankid_
    logical :: single_
    integer :: mode

    integer :: error
    !---------------------------------------------------------------------------


    if ( present(rankid) ) then
       rankid_ = rankid
    else
       rankid_ = mpi_myrank
    end if

    single_ = .false.
    if ( present(single) ) then
       single_ = single
    endif

    if ( present(time_units) ) then
       time_units_ = time_units
    else
       time_units_ = 'seconds'
    endif

    if ( present(calendar) ) then
       calendar_ = calendar
    else
       calendar_ = ""
    end if

    mode = FILE_FWRITE
    if ( present(append) ) then
       if( append ) mode = FILE_FAPPEND
    endif

    if ( single_ .and. rankid_ /= 0 ) return

    call FILE_get_fid( basename, mode,     & ! [IN]
                       rankid_, single_,   & ! [IN]
                       fid, existed,       & ! [OUT]
                       aggregate=aggregate ) ! [IN]

    if( existed ) return

    !--- append package header to the file
    call FILE_set_attribute( fid, "global", "title"      , title       ) ! [IN]
    call FILE_set_attribute( fid, "global", "source"     , source      ) ! [IN]
    call FILE_set_attribute( fid, "global", "institution", institution ) ! [IN]

    if ( ( .not. present(aggregate) ) .or. .not. aggregate ) then
       ! for shared-file parallel I/O, skip attributes related to MPI processes
       call FILE_set_attribute( fid, "global", "rankid"  , (/rankid/)  ) ! [IN]
    endif

    call file_set_tunits_c( FILE_files(fid)%fid,    & ! [IN]
                            time_units_, calendar_, & ! [IN]
                            error                   ) ! [OUT]

    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_create",*) 'failed to set time units'
       call PRC_abort
    endif

    return
  end subroutine FILE_create

  !-----------------------------------------------------------------------------
  subroutine FILE_get_var_num( &
       fid, nvars_limit, &
       nvars             )
    implicit none

    integer, intent(in)  :: fid
    integer, intent(in)  :: nvars_limit
    integer, intent(out) :: nvars

    integer :: error
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_var_num",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_get_nvars_c( FILE_files(fid)%fid, & ! (in)
                           nvars, error         ) ! (out)

    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_get_var_num",*) 'failed to get varnum. fid = ', fid
       call PRC_abort
    end if

    if ( nvars > nvars_limit ) then
       LOG_ERROR("FILE_get_var_num",*) 'number of variables exceeds the requested size.', nvars, nvars_limit
       call PRC_abort
    endif

    return
  end subroutine FILE_get_var_num

  !-----------------------------------------------------------------------------
  subroutine FILE_get_var_name( &
       fid, cvid, &
       varname    )
    implicit none

    integer,          intent(in)  :: fid
    integer,          intent(in)  :: cvid
    character(len=*), intent(out) :: varname

    integer :: error
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_var_name",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_get_varname_c( FILE_files(fid)%fid, cvid, & ! (in)
                             varname, error             ) ! (out)

    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_get_var_name",*) 'failed to get varname. cvid = ', cvid
       call PRC_abort
    end if

    return
  end subroutine FILE_get_var_name

  !-----------------------------------------------------------------------------
  subroutine FILE_add_associatedVariable( fid, vname, existed )
    integer,           intent(in)  :: fid
    character(len=*),  intent(in)  :: vname
    logical, optional, intent(out) :: existed

    integer :: error

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_add_associatedVariable",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_add_associatedvariable_c( FILE_files(fid)%fid, vname , & ! (in)
                                        error                        ) ! (out)

    if ( present(existed) ) then
       if ( error == FILE_ALREADY_EXISTED_CODE ) then
          existed = .true.
          return
       end if
       existed = .false.
    end if

    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_add_associatedvariable",*) 'failed to add associated variable: '//trim(vname)
       call PRC_abort
    end if

    return
  end subroutine FILE_add_associatedvariable

  !-----------------------------------------------------------------------------
  subroutine FILE_set_option( &
       fid,               &
       filetype, key, val )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: filetype
    character(len=*), intent(in) :: key
    character(len=*), intent(in) :: val

    integer :: error

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_set_option",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_set_option_c( FILE_files(fid)%fid, filetype, key, val, & ! (in)
                            error                                    ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_set_option",*) 'failed to set option'
       call PRC_abort
    end if

    return
  end subroutine FILE_set_option

  !-----------------------------------------------------------------------------
  subroutine FILE_open( &
      basename,  &
      fid,       &
      mode,      &
      single,    &
      aggregate, &
      rankid,    &
      postfix    )
    implicit none

    character(len=*), intent( in) :: basename
    integer,          intent(out) :: fid
    integer,          intent( in), optional :: mode
    logical,          intent( in), optional :: single
    logical,          intent( in), optional :: aggregate
    integer,          intent( in), optional :: rankid
    character(len=*), intent( in), optional :: postfix

    integer :: mode_
    integer :: rankid_
    logical :: existed
    logical :: single_

    single_ = .false.

    if ( present(mode) ) then
       mode_ = mode
    else
       mode_ = FILE_FREAD
    end if

    if ( present(single) ) single_ = single
    if ( present(rankid) ) then
       rankid_ = rankid
    else
       rankid_ = mpi_myrank
    end if

    call FILE_get_fid( basename, mode_, rankid_, single_,   & ! (in)
                       fid, existed,                        & ! (out)
                       aggregate=aggregate, postfix=postfix ) ! (in)

    return
  end subroutine FILE_open

  !-----------------------------------------------------------------------------
  !> check if the file is opened?
  function FILE_opened( fid )
    implicit none

    integer, intent( in) :: fid
    logical :: FILE_opened

    if ( fid < 1 ) then
       FILE_opened = .false.
    else
       FILE_opened = FILE_files(fid)%fid >= 0
    end if

    return
  end function FILE_opened

  !-----------------------------------------------------------------------------
  !> get length of dimension
  !-----------------------------------------------------------------------------
  subroutine FILE_get_dimLength( &
       fid, dimname, &
       len,          &
       error         )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: dimname

    integer, intent(out) :: len

    logical, intent(out), optional :: error

    integer :: ierror


    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_dimLength",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_get_dim_length_c( FILE_files(fid)%fid, dimname, & ! (in)
                                len, ierror                   ) ! (out)
    if ( ierror /= FILE_SUCCESS_CODE .and. ierror /= FILE_ALREADY_EXISTED_CODE ) then
       if ( present(error) ) then
          error = .true.
       else
          LOG_ERROR("FILE_get_dimLength",*) 'failed to get dimension length'
          call PRC_abort
       end if
    else
       if ( present(error) ) error = .false.
    end if

    return
  end subroutine FILE_get_dimLength

  !-----------------------------------------------------------------------------
  ! interface FILE_PutAxis
  !-----------------------------------------------------------------------------
  subroutine FILE_put_axis_realSP( &
       fid,               &
       name, desc, units, &
       dim_name, dtype,   &
       val                )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_name
    integer,          intent(in) :: dtype
    real(SP),    intent(in) :: val(:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_axis_real",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_axis_c( FILE_files(fid)%fid,                        & ! (in)
         name, desc, units, dim_name, dtype, val, size(val), SP, & ! (in)
         error                                                        ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_axis_realSP",*) 'failed to put axis'
       call PRC_abort
    end if

    return
  end subroutine FILE_put_axis_realSP
  subroutine FILE_put_axis_realDP( &
       fid,               &
       name, desc, units, &
       dim_name, dtype,   &
       val                )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_name
    integer,          intent(in) :: dtype
    real(DP),    intent(in) :: val(:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_axis_real",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_axis_c( FILE_files(fid)%fid,                        & ! (in)
         name, desc, units, dim_name, dtype, val, size(val), DP, & ! (in)
         error                                                        ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_axis_realDP",*) 'failed to put axis'
       call PRC_abort
    end if

    return
  end subroutine FILE_put_axis_realDP

  subroutine FILE_def_axis( &
       fid,                       &
       name, desc, units,         &
       dim_name, dtype, dim_size, &
       bounds                     )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_name
    integer,          intent(in) :: dtype
    integer,          intent(in) :: dim_size

    logical,          intent(in), optional :: bounds

    integer :: error
    integer :: bounds_

    bounds_ = 0 ! .false.
    if ( present(bounds) ) then
       if ( bounds ) bounds_ = 1 ! .true.
    end if

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_def_axis",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_def_axis_c( FILE_files(fid)%fid, &
         name, desc, units, dim_name, dtype, dim_size, bounds_, & ! (in)
         error                                                  ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_def_axis",*) 'failed to define axis'
       call PRC_abort
    end if

    return
  end subroutine FILE_def_axis

  !-----------------------------------------------------------------------------
  ! interface FILE_WriteAxis
  !-----------------------------------------------------------------------------
  subroutine FILE_write_axis_realSP( &
       fid,  &
       name, &
       val,  &
       start )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(SP),    intent(in)           :: val(:)
    integer,          intent(in), optional :: start(:)

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_axis_realSP",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(start) ) then
       call file_write_axis_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP, start, shape(val),  & ! (in)
            error                                   ) ! (out)
    else
       call file_write_axis_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP, (/1/), shape(val),  & ! (in)
            error                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_write_axis_realSP",*) 'failed to write axis: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_axis_realSP
  subroutine FILE_write_axis_realDP( &
       fid,  &
       name, &
       val,  &
       start )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(DP),    intent(in)           :: val(:)
    integer,          intent(in), optional :: start(:)

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_axis_realDP",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(start) ) then
       call file_write_axis_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP, start, shape(val),  & ! (in)
            error                                   ) ! (out)
    else
       call file_write_axis_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP, (/1/), shape(val),  & ! (in)
            error                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_write_axis_realDP",*) 'failed to write axis: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_axis_realDP

  !-----------------------------------------------------------------------------
  ! interface FILE_put_associatedCoordinate
  !-----------------------------------------------------------------------------
  subroutine FILE_put_associatedCoordinate_realSP_1D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(SP),    intent(in) :: val(:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_1D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, SP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_1D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realSP_1D
  subroutine FILE_put_associatedCoordinate_realDP_1D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(DP),    intent(in) :: val(:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_1D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, DP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_1D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realDP_1D
  subroutine FILE_put_associatedCoordinate_realSP_2D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(SP),    intent(in) :: val(:,:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_2D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, SP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_2D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realSP_2D
  subroutine FILE_put_associatedCoordinate_realDP_2D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(DP),    intent(in) :: val(:,:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_2D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, DP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_2D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realDP_2D
  subroutine FILE_put_associatedCoordinate_realSP_3D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(SP),    intent(in) :: val(:,:,:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_3D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, SP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_3D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realSP_3D
  subroutine FILE_put_associatedCoordinate_realDP_3D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(DP),    intent(in) :: val(:,:,:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_3D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, DP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_3D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realDP_3D
  subroutine FILE_put_associatedCoordinate_realSP_4D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(SP),    intent(in) :: val(:,:,:,:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_4D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, SP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realSP_4D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realSP_4D
  subroutine FILE_put_associatedCoordinate_realDP_4D( &
       fid,                &
       name, desc,  units, &
       dim_names, dtype,   &
       val                 )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype
    real(DP),    intent(in) :: val(:,:,:,:)

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_4D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_put_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         val, DP,                                         & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_put_associatedCoordinate_realDP_4D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_put_associatedCoordinate_realDP_4D

  subroutine FILE_def_associatedCoordinate( &
       fid,               &
       name, desc, units, &
       dim_names, dtype   )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: desc
    character(len=*), intent(in) :: units
    character(len=*), intent(in) :: dim_names(:)
    integer,          intent(in) :: dtype

    integer :: error
    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_def_associatedCoordinate",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_def_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
         name, desc, units, dim_names, size(dim_names), dtype, & ! (in)
         error                                                 ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_def_associatedCoordinate",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_def_associatedCoordinate

  !-----------------------------------------------------------------------------
  ! interface FILE_write_associatedCoordinate
  !-----------------------------------------------------------------------------
  subroutine FILE_write_associatedCoordinate_realSP_1D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(SP),    intent(in)           :: val(:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_1D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            1, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            1, (/1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_1D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realSP_1D
  subroutine FILE_write_associatedCoordinate_realDP_1D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(DP),    intent(in)           :: val(:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_1D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            1, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            1, (/1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_1D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realDP_1D
  subroutine FILE_write_associatedCoordinate_realSP_2D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(SP),    intent(in)           :: val(:,:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_2D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            2, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            2, (/1,1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_2D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realSP_2D
  subroutine FILE_write_associatedCoordinate_realDP_2D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(DP),    intent(in)           :: val(:,:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_2D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            2, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            2, (/1,1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_2D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realDP_2D
  subroutine FILE_write_associatedCoordinate_realSP_3D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(SP),    intent(in)           :: val(:,:,:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_3D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            3, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            3, (/1,1,1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_3D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realSP_3D
  subroutine FILE_write_associatedCoordinate_realDP_3D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(DP),    intent(in)           :: val(:,:,:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_3D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            3, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            3, (/1,1,1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_3D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realDP_3D
  subroutine FILE_write_associatedCoordinate_realSP_4D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(SP),    intent(in)           :: val(:,:,:,:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_4D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            4, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, SP,                                     & ! (in)
            4, (/1,1,1,1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realSP_4D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realSP_4D
  subroutine FILE_write_associatedCoordinate_realDP_4D( &
       fid,          &
       name,         &
       val,          &
       start, count, &
       ndims         )
    integer,          intent(in)           :: fid
    character(len=*), intent(in)           :: name
    real(DP),    intent(in)           :: val(:,:,:,:)
    integer,          intent(in), optional :: start(:)
    integer,          intent(in), optional :: count(:)  ! in case val has been reshaped
    integer,          intent(in), optional :: ndims     ! in case val has been reshaped

    integer :: error
    intrinsic shape

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_4D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! Note this is called for history coordinates which have been reshaped
       ! from 2D/3D into 1D array. In this case, start and count must be also present
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            ndims, start, count,                                    & ! (in)
            error                                                   ) ! (out)
    else if ( present(start) ) then
       ! Note this is called for restart coordinates
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            4, start, shape(val),                              & ! (in)
            error                                                   ) ! (out)
    else
       ! Note this is for the one-file-per-process I/O method
       call file_write_associatedcoordinate_c( FILE_files(fid)%fid, & ! (in)
            name, val, DP,                                     & ! (in)
            4, (/1,1,1,1/), shape(val),         & ! (in)
            error                                                   ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_write_associatedCoordinate_realDP_4D",*) 'failed to put associated coordinate: '//trim(name)
       call PRC_abort
    end if

    return
  end subroutine FILE_write_associatedCoordinate_realDP_4D

  !-----------------------------------------------------------------------------
  ! interface FILE_add_variable
  !-----------------------------------------------------------------------------
  subroutine FILE_add_variable_no_time( &
       fid,                  &
       varname, desc, units, &
       standard_name,        &
       dims, dtype,          &
       vid,                  &
       time_avg              )
    integer,          intent( in) :: fid
    character(len=*), intent( in) :: varname
    character(len=*), intent( in) :: desc
    character(len=*), intent( in) :: units
    character(len=*), intent( in) :: standard_name
    character(len=*), intent( in) :: dims(:)
    integer,          intent( in) :: dtype
    integer,          intent(out) :: vid
    logical,          intent( in), optional :: time_avg

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_add_variable_no_time",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call FILE_add_variable_with_time( fid,    & ! (in)
         varname, desc, units, standard_name, & ! (in)
         dims, dtype, -1.0_DP,                & ! (in)
         vid,                                 & ! (out)
         time_avg = time_avg                  ) ! (in)

    return
  end subroutine FILE_add_variable_no_time

  !-----------------------------------------------------------------------------
  subroutine FILE_add_variable_with_time( &
       fid,                  &
       varname, desc, units, &
       standard_name,        &
       dims, dtype,          &
       time_int,             &
       vid,                  &
       time_avg              )
    implicit none
    integer,          intent(in)  :: fid
    character(len=*), intent(in)  :: varname
    character(len=*), intent(in)  :: desc
    character(len=*), intent(in)  :: units
    character(len=*), intent(in)  :: standard_name
    character(len=*), intent(in)  :: dims(:)
    integer,          intent(in)  :: dtype
    real(DP),         intent(in)  :: time_int

    integer,          intent(out) :: vid

    logical,          intent(in), optional :: time_avg

    integer  :: cvid
    integer  :: ndims
    integer  :: itavg
    integer  :: error
    integer  :: n

    intrinsic size
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_add_variable_with_time",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    vid = -1
    do n = 1, FILE_nvars
       if ( FILE_vars(n)%fid == fid .and. FILE_vars(n)%name == varname ) then
          vid = FILE_vars(n)%vid
          exit
       endif
    enddo

    if ( vid < 0 ) then ! variable registration

       ndims = size(dims)
       itavg = 0

       if ( present(time_avg) ) then
          if( time_avg ) itavg = 1
       endif

       call file_add_variable_c( FILE_files(fid)%fid,                 & ! [IN]
                                 varname, desc, units, standard_name, & ! [IN]
                                 dims, ndims, dtype, time_int, itavg, & ! [IN]
                                 cvid, error                          ) ! [OUT]

       if ( error /= FILE_SUCCESS_CODE ) then
          LOG_ERROR("FILE_add_variable_with_time",*) 'failed to add variable: '//trim(varname)
          call PRC_abort
       endif

       FILE_nvars = FILE_nvars + 1
       vid = FILE_nvars
       FILE_vars(vid)%name = varname
       FILE_vars(vid)%vid  = cvid
       FILE_vars(vid)%fid  = fid

       LOG_INFO("FILE_add_variable_with_time",'(1x,A,I3.3,A,I4.4,2A)') &
       'Variable registration : NO.', fid, ', vid = ', vid, ', name = ', trim(varname)
    endif

    return
  end subroutine FILE_add_variable_with_time

  subroutine FILE_def_variable( &
       fid,                  &
       varname, desc, units, &
       standard_name,        &
       ndims, dims,          &
       dtype,                &
       vid,                  &
       time_int, time_avg,   &
       existed               )
    integer,          intent( in) :: fid
    character(len=*), intent( in) :: varname
    character(len=*), intent( in) :: desc
    character(len=*), intent( in) :: units
    character(len=*), intent( in) :: standard_name
    integer,          intent( in) :: ndims
    character(len=*), intent( in) :: dims(:)
    integer,          intent( in) :: dtype
    integer,          intent(out) :: vid
    real(DP),         intent( in), optional :: time_int
    logical,          intent( in), optional :: time_avg
    logical,          intent(out), optional :: existed

    real(DP) :: tint_
    integer  :: itavg
    integer  :: cvid
    integer  :: error
    integer  :: n

    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_def_variable",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    vid = -1
    do n = 1, FILE_nvars
       if ( FILE_vars(n)%fid == fid .and. FILE_vars(n)%name == varname ) then
          vid = n
       end if
    enddo

    if ( vid < 0 ) then ! variable registration

       if ( present(time_int) ) then
          tint_ = time_int
       else
          tint_ = -1.0_DP
       endif

       if ( present(time_avg) ) then
          if ( time_avg ) then
             itavg = 1
          else
             itavg = 0
          end if
       else
          itavg = 0
       end if

       call file_add_variable_c( FILE_files(fid)%fid,                 & ! (in)
                                 varname, desc, units, standard_name, & ! (in)
                                 dims, ndims, dtype,                  & ! (in)
                                 tint_, itavg,                        & ! (in)
                                 cvid, error                          ) ! (out)
       if ( error /= FILE_SUCCESS_CODE ) then
          LOG_ERROR("FILE_def_variable",*) 'failed to add variable: '//trim(varname)
          call PRC_abort
       end if

       FILE_nvars = FILE_nvars + 1
       vid = FILE_nvars
       FILE_vars(vid)%name = varname
       FILE_vars(vid)%vid  = cvid
       FILE_vars(vid)%fid  = fid

       LOG_INFO("FILE_def_variable",'(1x,A,I3.3,A,I4.4,2A)') &
       'Variable registration : NO.', fid, ', vid = ', vid, ', name = ', trim(varname)

       if ( present(existed) ) existed = .false.
    else
       if ( present(existed) ) existed = .true.
    endif

    return
  end subroutine FILE_def_variable

  !-----------------------------------------------------------------------------
  ! FILE_Get_Attribute
  !-----------------------------------------------------------------------------
  subroutine FILE_get_attribute_text_fid( &
       fid,        &
       vname, key, &
       val,        &
       existed     )
    integer,          intent(in ) :: fid
    character(len=*), intent(in ) :: vname
    character(len=*), intent(in ) :: key
    character(len=*), intent(out) :: val

    logical, intent(out), optional :: existed

    integer :: suppress
    integer :: error

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_attribute_text_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(existed) ) then
       suppress = 1
    else
       suppress = 0
    end if
    call file_get_attribute_text_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, suppress,              & ! (in)
         val, error                  ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( present(existed) ) then
          existed = .false.
       else
          LOG_ERROR("FILE_get_attribute_text_fid",*) 'failed to get text attribute for '//trim(vname)//': '//trim(key)
          call PRC_abort
       end if
    else
       if ( present(existed) ) existed = .true.
    end if

    return
  end subroutine FILE_get_attribute_text_fid
  subroutine FILE_get_attribute_text_fname( &
      basename, vname, key,      &
      val,                       &
      single, aggregate, rankid, &
      existed                    )
    implicit none

    character(len=*), intent(in) :: basename
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key

    character(len=*), intent(out) :: val

    logical, intent(in), optional :: single
    logical, intent(in), optional :: aggregate
    integer, intent(in), optional :: rankid

    logical, intent(out), optional :: existed
    integer :: fid

    call FILE_open( basename, & ! (in)
         fid,                 & ! (out)
         single=single,       & ! (in)
         aggregate=aggregate, & ! (in)
         rankid=rankid        ) ! (in)

    call FILE_get_attribute_text_fid( &
         fid, vname, key, & ! (in)
         val,             & ! (out)
         existed          ) ! (out)

    return
  end subroutine FILE_get_attribute_text_fname

  !-----------------------------------------------------------------------------
  subroutine FILE_get_attribute_logical_fid( &
       fid,        &
       vname, key, &
       val,        &
       existed     )
    integer,          intent(in ) :: fid
    character(len=*), intent(in ) :: vname
    character(len=*), intent(in ) :: key
    logical,          intent(out) :: val

    logical, intent(out), optional :: existed

    character(len=5) :: buf

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_attribute_logical_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call FILE_get_attribute_text_fid( fid, vname, key, & ! (in)
                                      buf, existed     ) ! (out)

    if ( present(existed) ) then
       if ( .not. existed ) return
    end if

    if ( buf == "true" ) then
       val = .true.
    else if ( buf == "false" ) then
       val = .false.
    else
       LOG_ERROR("FILE_get_attribute_logical_fid",*) 'value is not eigher true or false'
       call PRC_abort
    end if

    return
  end subroutine FILE_get_attribute_logical_fid
  subroutine FILE_get_attribute_logical_fname( &
      basename, vname, key,      &
      val,                       &
      single, aggregate, rankid, &
      existed                    )
    implicit none

    character(len=*), intent(in) :: basename
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key

    logical, intent(out) :: val

    logical, intent(in), optional :: single
    logical, intent(in), optional :: aggregate
    integer, intent(in), optional :: rankid

    logical, intent(out), optional :: existed
    integer :: fid

    call FILE_open( basename, & ! (in)
         fid,                 & ! (out)
         single=single,       & ! (in)
         aggregate=aggregate, & ! (in)
         rankid=rankid        ) ! (in)

    call FILE_get_attribute_logical_fid( &
         fid, vname, key, & ! (in)
         val,             & ! (out)
         existed          ) ! (out)

    return
  end subroutine FILE_get_attribute_logical_fname

  !-----------------------------------------------------------------------------
  subroutine FILE_get_attribute_int_fid( &
       fid, vname, key, &
       val,             &
       existed          )
    integer,          intent(in ) :: fid
    character(len=*), intent(in ) :: vname
    character(len=*), intent(in ) :: key
    integer,          intent(out) :: val(:)

    logical, intent(out), optional :: existed

    integer :: suppress
    integer :: error

    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_attribute_int_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(existed) ) then
       suppress = 1
    else
       suppress = 0
    end if
    call file_get_attribute_int_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, size(val), suppress,   & ! (in)
         val, error                  ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( present(existed) ) then
          existed = .false.
       else
          LOG_ERROR("FILE_get_attribute_int_fid",*) 'failed to get integer attribute for '//trim(vname)//': '//trim(key)
          call PRC_abort
       end if
    else
       if ( present(existed) ) existed = .true.
    end if

    return
  end subroutine FILE_get_attribute_int_fid
  subroutine FILE_get_attribute_int_fname( &
      basename, vname, key,      &
      val,                       &
      single, aggregate, rankid, &
      existed                    )
    implicit none

    character(len=*), intent(in) :: basename
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key

    integer, intent(out) :: val(:)

    logical, intent(in), optional :: single
    logical, intent(in), optional :: aggregate
    integer, intent(in), optional :: rankid

    logical, intent(out), optional :: existed

    integer :: fid

    call FILE_open( basename, & ! (in)
         fid,                 & ! (out)
         single=single,       & ! (in)
         aggregate=aggregate, &
         rankid=rankid        ) ! (in)

    call FILE_get_attribute_int_fid( &
         fid, vname, key, & ! (in)
         val,             & ! (out)
         existed          ) ! (out)

    return
  end subroutine FILE_get_attribute_int_fname
  !-----------------------------------------------------------------------------

  subroutine FILE_get_attribute_float_fid( &
       fid, vname, key, &
       val,             &
       existed          )
    integer,          intent(in ) :: fid
    character(len=*), intent(in ) :: vname
    character(len=*), intent(in ) :: key
    real(SP),    intent(out) :: val(:)

    logical, intent(out), optional :: existed

    integer :: suppress
    integer :: error

    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_attribute_float_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(existed) ) then
       suppress = 1
    else
       suppress = 0
    end if
    call file_get_attribute_float_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, size(val), suppress,   & ! (in)
         val, error                  ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( present(existed) ) then
          existed = .false.
       else
          LOG_ERROR("FILE_get_attribute_float_fid",*) 'failed to get float attribute for '//trim(vname)//': '//trim(key)
          call PRC_abort
       end if
    else
       if ( present(existed) ) existed = .true.
    end if

    return
  end subroutine FILE_get_attribute_float_fid
  subroutine FILE_get_attribute_float_fname( &
      basename, vname, key,      &
      val,                       &
      single, aggregate, rankid, &
      existed                    )
    implicit none

    character(len=*), intent(in) :: basename
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key

    real(SP), intent(out) :: val(:)

    logical, intent(in), optional :: single
    logical, intent(in), optional :: aggregate
    integer, intent(in), optional :: rankid

    logical, intent(out), optional :: existed

    integer :: fid

    call FILE_open( basename, & ! (in)
         fid,                 & ! (out)
         single=single,       & ! (in)
         aggregate=aggregate, & ! (in)
         rankid=rankid        ) ! (in)

    call FILE_get_attribute_float_fid( &
         fid, vname, key, & ! (in)
         val,             & ! (out)
         existed          ) ! (out)

    return
  end subroutine FILE_get_attribute_float_fname
  subroutine FILE_get_attribute_double_fid( &
       fid, vname, key, &
       val,             &
       existed          )
    integer,          intent(in ) :: fid
    character(len=*), intent(in ) :: vname
    character(len=*), intent(in ) :: key
    real(DP),    intent(out) :: val(:)

    logical, intent(out), optional :: existed

    integer :: suppress
    integer :: error

    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_attribute_double_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(existed) ) then
       suppress = 1
    else
       suppress = 0
    end if
    call file_get_attribute_double_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, size(val), suppress,   & ! (in)
         val, error                  ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( present(existed) ) then
          existed = .false.
       else
          LOG_ERROR("FILE_get_attribute_double_fid",*) 'failed to get double attribute for '//trim(vname)//': '//trim(key)
          call PRC_abort
       end if
    else
       if ( present(existed) ) existed = .true.
    end if

    return
  end subroutine FILE_get_attribute_double_fid
  subroutine FILE_get_attribute_double_fname( &
      basename, vname, key,      &
      val,                       &
      single, aggregate, rankid, &
      existed                    )
    implicit none

    character(len=*), intent(in) :: basename
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key

    real(DP), intent(out) :: val(:)

    logical, intent(in), optional :: single
    logical, intent(in), optional :: aggregate
    integer, intent(in), optional :: rankid

    logical, intent(out), optional :: existed

    integer :: fid

    call FILE_open( basename, & ! (in)
         fid,                 & ! (out)
         single=single,       & ! (in)
         aggregate=aggregate, & ! (in)
         rankid=rankid        ) ! (in)

    call FILE_get_attribute_double_fid( &
         fid, vname, key, & ! (in)
         val,             & ! (out)
         existed          ) ! (out)

    return
  end subroutine FILE_get_attribute_double_fname

  !-----------------------------------------------------------------------------
  ! FILE_set_attribute
  !-----------------------------------------------------------------------------
  subroutine FILE_set_attribute_text( &
     fid, vname, &
     key, val    )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key
    character(len=*), intent(in) :: val

    integer :: error

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_set_attribute_text",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_set_attribute_text_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, val,                   & ! (in)
         error                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_set_attribute_text",*) 'failed to set text attribute for '//trim(vname)//': '//trim(key)
       call PRC_abort
    end if

    return
  end subroutine FILE_set_attribute_text

  subroutine FILE_set_attribute_logical( &
     fid, vname, &
     key, val    )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key
    logical,          intent(in) :: val

    character(len=5) :: buf

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_set_attribute_logical",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( val ) then
       buf = "true"
    else
       buf = "false"
    end if

    call FILE_set_attribute_text( fid, vname, key, buf )

    return
  end subroutine FILE_set_attribute_logical

  !-----------------------------------------------------------------------------
  subroutine FILE_set_attribute_int( &
     fid, vname, &
     key, val    )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key
    integer,          intent(in) :: val(:)

    integer :: error

    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_set_attribute_int",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_set_attribute_int_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, val(:), size(val(:)),  & ! (in)
         error                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_set_attribute_int",*) 'failed to set integer attribute for '//trim(vname)//': '//trim(key)
       call PRC_abort
    end if

    return
  end subroutine FILE_set_attribute_int

  !-----------------------------------------------------------------------------
  subroutine FILE_set_attribute_float( &
     fid, vname, &
     key, val    )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key
    real(SP),    intent(in) :: val(:)

    integer :: error

    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_set_attributefloat",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_set_attribute_float_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, val(:), size(val(:)),  & ! (in)
         error                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_set_attribute_float",*) 'failed to set float attribute for '//trim(vname)//': '//trim(key)
       call PRC_abort
    end if

    return
  end subroutine FILE_set_attribute_float
  !-----------------------------------------------------------------------------
  subroutine FILE_set_attribute_double( &
     fid, vname, &
     key, val    )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: vname
    character(len=*), intent(in) :: key
    real(DP),    intent(in) :: val(:)

    integer :: error

    intrinsic size

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_set_attributedouble",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_set_attribute_double_c( &
         FILE_files(fid)%fid, vname, & ! (in)
         key, val(:), size(val(:)),  & ! (in)
         error                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE .and. error /= FILE_ALREADY_EXISTED_CODE ) then
       LOG_ERROR("FILE_set_attribute_double",*) 'failed to set double attribute for '//trim(vname)//': '//trim(key)
       call PRC_abort
    end if

    return
  end subroutine FILE_set_attribute_double
  !-----------------------------------------------------------------------------
  ! FILE_get_shape
  !-----------------------------------------------------------------------------
  subroutine FILE_get_shape_fname( &
      basename, varname, &
      dims,              &
      rankid, single,    &
      error              )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    integer,          intent(out)           :: dims(:)
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    logical,          intent(out), optional :: error

    integer :: fid
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                    & ! (in)
                    fid,                         & ! (out)
                    rankid=rankid, single=single ) ! (in)

    call FILE_get_shape_fid( fid, varname, & ! (in)
                             dims(:),      & ! (out)
                             error = error ) ! (out)

    return
  end subroutine FILE_get_shape_fname

  subroutine FILE_get_shape_fid( &
       fid, varname, &
       dims,         &
       error         )
    implicit none
    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname

    integer,          intent(out)           :: dims(:)

    logical,          intent(out), optional :: error

    type(datainfo) :: dinfo
    integer :: ierror
    integer :: n

    logical :: suppress

    intrinsic size
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_shape_id",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(error) ) then
       suppress = .true.
    else
       suppress = .false.
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,   & ! (out)
         FILE_files(fid)%fid, varname, & ! (in)
         1, suppress,                  & ! (in)
         ierror                        ) ! (out)

    !--- verify
    if ( ierror /= FILE_SUCCESS_CODE ) then
       if ( present(error) ) then
          error = .true.
          return
       else
          LOG_ERROR("FILE_get_shape_fid",*) 'failed to get data information : ', trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= size(dims) ) then
       LOG_ERROR("FILE_get_shape_fid",*) 'rank is different, ', trim(varname), size(dims), dinfo%rank
       call PRC_abort
    end if
    do n = 1, size(dims)
       dims(n) = dinfo%dim_size(n)
    end do

    if ( present(error) ) error = .false.

    return
  end subroutine FILE_get_shape_fid

  !-----------------------------------------------------------------------------
  !> get number of steps
  !-----------------------------------------------------------------------------
  subroutine FILE_get_stepSize( &
       fid, varname, &
       len,          &
       error         )
    integer,          intent(in) :: fid
    character(len=*), intent(in) :: varname

    integer, intent(out) :: len

    logical, intent(out), optional :: error

    integer :: ierror

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_stepSize",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call file_get_step_size_c( FILE_files(fid)%fid, varname, & ! (in)
                               len, ierror                   ) ! (out)
    if ( ierror /= FILE_SUCCESS_CODE .and. ierror /= FILE_ALREADY_EXISTED_CODE ) then
       if ( present(error) ) then
          error = .true.
       else
          LOG_ERROR("FILE_get_stepSize",*) 'failed to get number of steps'
          call PRC_abort
       end if
    else
       if ( present(error) ) error = .false.
    end if

    return
  end subroutine FILE_get_stepSize

  !-----------------------------------------------------------------------------
  ! FILE_get_commonInfo
  !-----------------------------------------------------------------------------
  subroutine FILE_get_commonInfo_fname( &
       basename,    &
       rankid,      &
       nvars_limit, &
       title,       &
       source,      &
       institution, &
       nvars,       &
       varname      )
    implicit none

    character(len=*),           intent(in)  :: basename
    integer,                    intent(in)  :: rankid
    integer,                    intent(in)  :: nvars_limit
    character(len=FILE_HMID),   intent(out) :: title                ! title of the file
    character(len=FILE_HMID),   intent(out) :: source               ! for file header
    character(len=FILE_HMID),   intent(out) :: institution          ! for file header
    integer,                    intent(out) :: nvars                ! number of variables
    character(len=FILE_HSHORT), intent(out) :: varname(nvars_limit) ! name of variables

    integer :: fid
    !---------------------------------------------------------------------------

    call FILE_open( basename,             & ! [IN]
                    fid,                  & ! [OUT]
                    rankid=rankid         ) ! [IN]

    call FILE_get_commonInfo_fid( fid,         & ! [IN]
                                  nvars_limit, & ! [IN]
                                  title,       & ! [OUT]
                                  source,      & ! [OUT]
                                  institution, & ! [OUT]
                                  nvars,       & ! [OUT]
                                  varname(:)   ) ! [OUT]

    return
  end subroutine FILE_get_commonInfo_fname

  subroutine FILE_get_commonInfo_fid( &
       fid,         &
       nvars_limit, &
       title,       &
       source,      &
       institution, &
       nvars,       &
       varname      )
    implicit none

    integer,                    intent(in)  :: fid
    integer,                    intent(in)  :: nvars_limit
    character(len=FILE_HMID),   intent(out) :: title                ! title of the file
    character(len=FILE_HMID),   intent(out) :: source               ! for file header
    character(len=FILE_HMID),   intent(out) :: institution          ! for file header
    integer,                    intent(out) :: nvars                ! number of variables
    character(len=FILE_HSHORT), intent(out) :: varname(nvars_limit) ! name of variables

    integer :: v
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_commonInfo_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    call FILE_get_attribute( fid, 'global', 'title',       title       )
    call FILE_get_attribute( fid, 'global', 'source',      source      )
    call FILE_get_attribute( fid, 'global', 'institution', institution )

    call FILE_get_var_num( fid, nvars_limit, nvars )

    do v = 1, nvars
       call FILE_get_var_name( fid, v, varname(v) )
    enddo

    return
  end subroutine FILE_get_commonInfo_fid

  !-----------------------------------------------------------------------------
  ! FILE_get_dataInfo
  !-----------------------------------------------------------------------------
  subroutine FILE_get_dataInfo_fname( &
       basename, varname,                  &
       rankid, istep, single,              &
       existed,                            &
       description, units, standard_name,  &
       datatype,                           &
       dim_rank, dim_name, dim_size,       &
       natts, att_name, att_type, att_len, &
       time_start, time_end,               &
       time_units, calendar                )
    implicit none

    character(len=*),           intent(in)  :: basename
    character(len=*),           intent(in)  :: varname

    integer,                    intent(in),  optional :: rankid
    integer,                    intent(in),  optional :: istep
    logical,                    intent(in),  optional :: single
    logical,                    intent(out), optional :: existed
    character(len=FILE_HMID),   intent(out), optional :: description
    character(len=FILE_HSHORT), intent(out), optional :: units
    character(len=FILE_HMID),   intent(out), optional :: standard_name
    integer,                    intent(out), optional :: datatype
    integer,                    intent(out), optional :: dim_rank
    character(len=FILE_HSHORT), intent(out), optional :: dim_name(:)
    integer,                    intent(out), optional :: dim_size(:)
    integer,                    intent(out), optional :: natts
    character(len=FILE_HSHORT), intent(out), optional :: att_name(:)
    integer,                    intent(out), optional :: att_type(:)
    integer,                    intent(out), optional :: att_len (:)
    real(DP),                   intent(out), optional :: time_start
    real(DP),                   intent(out), optional :: time_end
    character(len=FILE_HMID),   intent(out), optional :: time_units
    character(len=FILE_HSHORT), intent(out), optional :: calendar

    logical :: single_
    integer :: fid
    !---------------------------------------------------------------------------

    if ( present(single) ) then
       single_ = single
    else
       single_ = .false.
    endif

    !--- search/register file
    call FILE_open( basename,                     & ! [IN]
                    fid,                          & ! [OUT]
                    rankid=rankid, single=single_ ) ! [IN]

    call FILE_get_dataInfo_fid( fid, varname,                              & ! [IN]
                                istep,                                     & ! [IN] , optional
                                existed,                                   & ! [OUT], optional
                                description, units, standard_name,         & ! [OUT], optional
                                datatype,                                  & ! [OUT], optional
                                dim_rank, dim_name, dim_size,              & ! [OUT], optional
                                natts, att_name, att_type, att_len,        & ! [OUT], optional
                                time_start, time_end, time_units, calendar ) ! [OUT], optional

    return
  end subroutine FILE_get_dataInfo_fname

  subroutine FILE_get_dataInfo_fid( &
       fid, varname,                       &
       istep,                              &
       existed,                            &
       description, units, standard_name,  &
       datatype,                           &
       dim_rank, dim_name, dim_size,       &
       natts, att_name, att_type, att_len, &
       time_start, time_end,               &
       time_units, calendar                )
    implicit none

    integer,          intent(in)  :: fid
    character(len=*), intent(in)  :: varname

    integer,                    intent(in),  optional :: istep
    logical,                    intent(out), optional :: existed
    character(len=FILE_HMID),   intent(out), optional :: description
    character(len=FILE_HSHORT), intent(out), optional :: units
    character(len=FILE_HMID),   intent(out), optional :: standard_name
    integer,                    intent(out), optional :: datatype
    integer,                    intent(out), optional :: dim_rank
    character(len=FILE_HSHORT), intent(out), optional :: dim_name(:)
    integer,                    intent(out), optional :: dim_size(:)
    integer,                    intent(out), optional :: natts
    character(len=FILE_HSHORT), intent(out), optional :: att_name(:)
    integer,                    intent(out), optional :: att_type(:)
    integer,                    intent(out), optional :: att_len (:)
    real(DP),                   intent(out), optional :: time_start
    real(DP),                   intent(out), optional :: time_end
    character(len=FILE_HMID),   intent(out), optional :: time_units
    character(len=FILE_HSHORT), intent(out), optional :: calendar

    type(datainfo) :: dinfo

    integer  :: istep_
    real(DP) :: time(1)
    integer  :: i
    integer  :: error

    logical :: suppress
    logical :: existed2

    intrinsic size
    !---------------------------------------------------------------------------

    if ( present(istep) ) then
       istep_ = istep
    else
       istep_ = 1
    end if

    if ( present(existed) ) then
       suppress = .true.
    else
       suppress = .false.
    end if

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_dataInfo_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,               & ! [OUT]
                              FILE_files(fid)%fid, & ! [IN]
                              varname,             & ! [IN]
                              istep_,              & ! [IN]
                              suppress,            & ! [IN]
                              error                ) ! [OUT]

    !--- verify and exit
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( present( existed ) ) then
          existed = .false.
          return
       else
          LOG_ERROR("FILE_get_dataInfo_fid",*) 'data info not found'
          call PRC_abort
       end if
    endif

    if ( present(existed) ) existed = .true.

    if ( present(description)   ) description   = dinfo%description
    if ( present(units)         ) units         = dinfo%units
    if ( present(standard_name) ) standard_name = dinfo%standard_name
    if ( present(datatype)      ) datatype      = dinfo%datatype
    if ( present(dim_rank)      ) dim_rank      = dinfo%rank

    if ( present(dim_name) ) then
       do i = 1, min( dinfo%rank, size(dim_name) ) ! limit dimension rank
          dim_name(i) = dinfo%dim_name(i)
       enddo
    endif

    if ( present(dim_size) ) then
       do i = 1, min( dinfo%rank, size(dim_size) ) ! limit dimension rank
          dim_size(i) = dinfo%dim_size(i)
       enddo
    endif

    if ( present(natts) ) natts = dinfo%natts
    if ( present(att_name) ) then
       do i = 1, min( dinfo%natts, size(att_name) )
          att_name(i) = dinfo%att_name(i)
       end do
    end if
    if ( present(att_type) ) then
       do i = 1, min( dinfo%natts, size(att_type) )
          att_type(i) = dinfo%att_type(i)
       end do
    end if
    if ( present(att_len) ) then
       do i = 1, min( dinfo%natts, size(att_len) )
          att_len(i) = dinfo%att_len(i)
       end do
    end if

    if ( present(time_units)  ) then
       if ( dinfo%time_units == "" ) then
          call FILE_get_attribute( fid, "global", "time_units", time_units )
       else
          time_units = dinfo%time_units
       endif
    endif

    if ( present(calendar) ) then
       if ( dinfo%time_units == "" ) then
          call FILE_get_attribute( fid, "global", "calendar", calendar, existed2 )
          if ( .not. existed2 ) calendar = ""
       else
          calendar = dinfo%calendar
       end if
    end if

    if ( present(time_start)  ) then
       if ( dinfo%time_units == "" ) then
          call FILE_get_Attribute( fid, "global", "time_start", time )
          time_start = time(1)
       else
          time_start = dinfo%time_start
       endif
    endif

    if ( present(time_end)  ) then
       if ( dinfo%time_units == "" ) then
          call FILE_get_Attribute( fid, "global", "time_start", time )
          time_end = time(1)
       else
          time_end = dinfo%time_end
       end if
    endif

    return
  end subroutine FILE_get_dataInfo_fid

  !-----------------------------------------------------------------------------
  ! FILE_get_data_all_dataInfo
  !-----------------------------------------------------------------------------
  subroutine FILE_get_all_dataInfo_fname(  &
       basename, varname,                  &
       step_nmax,                          &
       description, units, standard_name,  &
       datatype,                           &
       dim_rank, dim_name, dim_size,       &
       natts, att_name, att_type, att_len, &
       time_start, time_end,               &
       time_units, calendar,               &
       rankid, single                      )
    implicit none
    character(len=*),           intent(in)  :: basename
    character(len=*),           intent(in)  :: varname
    integer,                    intent(out) :: step_nmax
    character(len=FILE_HMID),   intent(out) :: description
    character(len=FILE_HSHORT), intent(out) :: units
    character(len=FILE_HMID),   intent(out) :: standard_name
    integer,                    intent(out) :: datatype
    integer,                    intent(out) :: dim_rank
    character(len=FILE_HSHORT), intent(out) :: dim_name  (:)
    integer,                    intent(out) :: dim_size  (:)
    integer,                    intent(out) :: natts
    character(len=FILE_HSHORT), intent(out) :: att_name  (:)
    integer,                    intent(out) :: att_type  (:)
    integer,                    intent(out) :: att_len   (:)
    real(DP),                   intent(out) :: time_start(:)
    real(DP),                   intent(out) :: time_end  (:)
    character(len=FILE_HMID),   intent(out) :: time_units
    character(len=FILE_HSHORT), intent(out) :: calendar

    integer,                    intent(in), optional :: rankid
    logical,                    intent(in), optional :: single

    integer :: fid
    logical :: single_
    !---------------------------------------------------------------------------

    if ( present(single) ) then
       single_ = single
    else
       single_ = .false.
    endif

    !--- search/register file
    call FILE_open( basename,                     & ! [IN]
                    fid,                          & ! [OUT]
                    rankid=rankid, single=single_ ) ! [IN]

    call FILE_get_all_datainfo_fid( fid, varname,                                & ! [IN]
                                    step_nmax,                                   & ! [OUT]
                                    description, units, standard_name,           & ! [OUT]
                                    datatype,                                    & ! [OUT]
                                    dim_rank, dim_name(:), dim_size(:),          & ! [OUT]
                                    natts, att_name(:), att_type(:), att_len(:), & ! [OUT]
                                    time_start(:), time_end(:),                  & ! [OUT]
                                    time_units, calendar                         ) ! [OUT]

    return
  end subroutine FILE_get_all_dataInfo_fname

  subroutine FILE_get_all_dataInfo_fid( &
       fid, varname,                       &
       step_nmax,                          &
       description, units, standard_name,  &
       datatype,                           &
       dim_rank, dim_name, dim_size,       &
       natts, att_name, att_type, att_len, &
       time_start, time_end,               &
       time_units, calendar                )
    implicit none

    integer,                    intent(in)  :: fid
    character(len=*),           intent(in)  :: varname
    integer,                    intent(out) :: step_nmax
    character(len=FILE_HMID),   intent(out) :: description
    character(len=FILE_HSHORT), intent(out) :: units
    character(len=FILE_HMID),   intent(out) :: standard_name
    integer,                    intent(out) :: datatype
    integer,                    intent(out) :: dim_rank
    character(len=FILE_HSHORT), intent(out) :: dim_name  (:)
    integer,                    intent(out) :: dim_size  (:)
    integer,                    intent(out) :: natts
    character(len=FILE_HSHORT), intent(out) :: att_name  (:)
    integer,                    intent(out) :: att_type  (:)
    integer,                    intent(out) :: att_len   (:)
    real(DP),                   intent(out) :: time_start(:)
    real(DP),                   intent(out) :: time_end  (:)
    character(len=FILE_HMID),   intent(out) :: time_units
    character(len=FILE_HSHORT), intent(out) :: calendar

    type(datainfo) :: dinfo

    real(DP) :: time(1)
    integer  :: i
    integer  :: error
    logical  :: existed

    integer  :: istep

    intrinsic size
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_get_all_dataInfo_fid",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    ! initialize
    description   = ""
    units         = ""
    standard_name = ""
    datatype      = -1
    dim_rank      = -1
    dim_name  (:) = ""
    dim_size  (:) = -1
    time_start(:) = FILE_RMISS
    time_end  (:) = FILE_RMISS

    do istep = 1, min( size(time_start), size(time_end) )
       !--- get data information
       call file_get_datainfo_c( dinfo,               & ! [OUT]
                                 FILE_files(fid)%fid, & ! [IN]
                                 varname,             & ! [IN]
                                 istep,               & ! [IN]
                                 .true.,              & ! [IN]
                                 error                ) ! [OUT]

       !--- verify and exit
       if ( error /= FILE_SUCCESS_CODE ) then
          step_nmax = istep - 1
          exit
       endif

       if ( istep == 1 ) then
          description   = dinfo%description
          units         = dinfo%units
          standard_name = dinfo%standard_name
          datatype      = dinfo%datatype
          dim_rank      = dinfo%rank
          natts         = dinfo%natts

          do i = 1, min( dinfo%rank, size(dim_name) ) ! limit dimension rank
             dim_name(i) = dinfo%dim_name(i)
             dim_size(i) = dinfo%dim_size(i)
          enddo

          do i = 1, min( dinfo%natts, size(att_name) )
             att_name(i) = dinfo%att_name(i)
             att_type(i) = dinfo%att_type(i)
             att_len (i) = dinfo%att_len (i)
          end do

          if ( dinfo%time_units == "" ) then
             call FILE_get_attribute( fid, "global", "time_units", time_units )
             call FILE_get_attribute( fid, "global", "calendar", calendar, existed )
             if ( .not. existed ) calendar = ""
             call FILE_get_attribute( fid, "global", "time_start", time )
             time_start(1) = time(1)
             time_end  (1) = time(1)
             step_nmax = 1
             exit
          else
             time_units    = dinfo%time_units
             calendar      = dinfo%calendar
             time_start(1) = dinfo%time_start
             time_end  (1) = dinfo%time_end
          endif
       else
          time_start(istep) = dinfo%time_start
          time_end  (istep) = dinfo%time_end
       endif
    enddo

    return
  end subroutine FILE_get_all_dataInfo_fid

  !-----------------------------------------------------------------------------
  ! interface FILE_read
  !-----------------------------------------------------------------------------
  subroutine FILE_read_realSP_1D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realSP_1D( &
         fid, varname,                                            & ! (in)
         var(:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realSP_1D
  subroutine FILE_read_realDP_1D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realDP_1D( &
         fid, varname,                                            & ! (in)
         var(:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realDP_1D
  subroutine FILE_read_realSP_2D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:,:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realSP_2D( &
         fid, varname,                                            & ! (in)
         var(:,:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realSP_2D
  subroutine FILE_read_realDP_2D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:,:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realDP_2D( &
         fid, varname,                                            & ! (in)
         var(:,:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realDP_2D
  subroutine FILE_read_realSP_3D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:,:,:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realSP_3D( &
         fid, varname,                                            & ! (in)
         var(:,:,:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realSP_3D
  subroutine FILE_read_realDP_3D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:,:,:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realDP_3D( &
         fid, varname,                                            & ! (in)
         var(:,:,:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realDP_3D
  subroutine FILE_read_realSP_4D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:,:,:,:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realSP_4D( &
         fid, varname,                                            & ! (in)
         var(:,:,:,:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realSP_4D
  subroutine FILE_read_realDP_4D( &
      basename, varname,             &
      var,                           &
      step, rankid, single, postfix, &
      allow_missing, missing_value   )
    implicit none

    character(len=*), intent( in)           :: basename
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:,:,:,:)
    integer,          intent( in), optional :: step
    integer,          intent( in), optional :: rankid
    logical,          intent( in), optional :: single
    character(len=*), intent( in), optional :: postfix
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero

    integer :: fid

    intrinsic shape
    !---------------------------------------------------------------------------

    !--- search/register file
    call FILE_open( basename,                     & ! (in)
                    fid,                          & ! (out)
                    rankid=rankid, single=single, & ! (in)
                    postfix=postfix               ) ! (in)

    call FILE_read_var_realDP_4D( &
         fid, varname,                                            & ! (in)
         var(:,:,:,:),                                           & ! (out)
         step=step,                                               & ! (in)
         allow_missing=allow_missing, missing_value=missing_value ) ! (in)

    return
  end subroutine FILE_read_realDP_4D

  subroutine FILE_read_var_realSP_1D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(SP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(1)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_SP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realSP_1D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realSP_1D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realSP_1D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 1 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realSP_1D",*) 'rank of '//trim(varname)//' is not 1', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:),                   & ! (out)
            dinfo, SP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:),          & ! (out)
            dinfo, SP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 1
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realSP_1D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:), & ! (out)
            dinfo, SP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realSP_1D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realSP_1D
  subroutine FILE_read_var_realDP_1D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(DP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(1)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_DP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realDP_1D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realDP_1D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realDP_1D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 1 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realDP_1D",*) 'rank of '//trim(varname)//' is not 1', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:),                   & ! (out)
            dinfo, DP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:),          & ! (out)
            dinfo, DP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 1
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realDP_1D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:), & ! (out)
            dinfo, DP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realDP_1D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realDP_1D
  subroutine FILE_read_var_realSP_2D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:,:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(SP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(2)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_SP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realSP_2D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realSP_2D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:,:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realSP_2D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 2 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realSP_2D",*) 'rank of '//trim(varname)//' is not 2', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:,:),                   & ! (out)
            dinfo, SP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:,:),          & ! (out)
            dinfo, SP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 2
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realSP_2D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:,:), & ! (out)
            dinfo, SP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realSP_2D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realSP_2D
  subroutine FILE_read_var_realDP_2D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:,:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(DP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(2)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_DP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realDP_2D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realDP_2D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:,:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realDP_2D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 2 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realDP_2D",*) 'rank of '//trim(varname)//' is not 2', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:,:),                   & ! (out)
            dinfo, DP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:,:),          & ! (out)
            dinfo, DP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 2
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realDP_2D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:,:), & ! (out)
            dinfo, DP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realDP_2D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realDP_2D
  subroutine FILE_read_var_realSP_3D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:,:,:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(SP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(3)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_SP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realSP_3D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realSP_3D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:,:,:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realSP_3D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 3 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realSP_3D",*) 'rank of '//trim(varname)//' is not 3', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:,:,:),                   & ! (out)
            dinfo, SP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:,:,:),          & ! (out)
            dinfo, SP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 3
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realSP_3D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:,:,:), & ! (out)
            dinfo, SP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realSP_3D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realSP_3D
  subroutine FILE_read_var_realDP_3D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:,:,:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(DP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(3)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_DP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realDP_3D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realDP_3D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:,:,:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realDP_3D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 3 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realDP_3D",*) 'rank of '//trim(varname)//' is not 3', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:,:,:),                   & ! (out)
            dinfo, DP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:,:,:),          & ! (out)
            dinfo, DP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 3
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realDP_3D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:,:,:), & ! (out)
            dinfo, DP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realDP_3D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realDP_3D
  subroutine FILE_read_var_realSP_4D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(SP),    intent(out)           :: var(:,:,:,:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(SP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(SP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(4)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_SP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realSP_4D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realSP_4D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:,:,:,:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realSP_4D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 4 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realSP_4D",*) 'rank of '//trim(varname)//' is not 4', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:,:,:,:),                   & ! (out)
            dinfo, SP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:,:,:,:),          & ! (out)
            dinfo, SP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 4
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realSP_4D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:,:,:,:), & ! (out)
            dinfo, SP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realSP_4D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realSP_4D
  subroutine FILE_read_var_realDP_4D( &
      fid, varname,  &
      var,           &
      step,          &
      allow_missing, &
      missing_value, &
      ntypes, dtype, &
      start, count   )
    implicit none

    integer,          intent( in)           :: fid
    character(len=*), intent( in)           :: varname
    real(DP),    intent(out)           :: var(:,:,:,:)
    integer,          intent( in), optional :: step
    logical,          intent( in), optional :: allow_missing !> if data is missing, set value to missing_value
    real(DP),    intent( in), optional :: missing_value !> default is zero
    integer,          intent( in), optional :: ntypes      !> number of dtypes
    integer,          intent( in), optional :: dtype       !> MPI derived datatype for read buffer
    integer,          intent( in), optional :: start(:)    !> request starts to global variable
    integer,          intent( in), optional :: count(:)    !> request sizes to global variable

    integer :: step_
    logical :: allow_missing_
    real(DP) :: missing_value_

    type(datainfo) :: dinfo
    integer :: dim_size(4)
    integer :: error
    integer :: n

    intrinsic size, shape
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(step) ) then
       step_ = step
    else
       step_ = 1
    end if

    if ( present(allow_missing) ) then
       allow_missing_ = allow_missing
    else
       allow_missing_ = .false.
    end if

    if ( present(missing_value) ) then
       missing_value_ = missing_value
    else
       missing_value_ = 0.0_DP
    end if

    !--- get data information
    call file_get_datainfo_c( dinfo,                          & ! (out)
         FILE_files(fid)%fid, varname, step_, allow_missing_, & ! (in)
         error                                                ) ! (out)

    !--- verify
    if ( error /= FILE_SUCCESS_CODE ) then
       if ( allow_missing_ ) then
          LOG_INFO("FILE_read_var_realDP_4D",*) '[INPUT]/[FILE] data not found! : ', &
               'varname= ',trim(varname),', step=',step_
          LOG_INFO("FILE_read_var_realDP_4D",*) '[INPUT]/[FILE] Value is set to ', missing_value_
          var(:,:,:,:) = missing_value_
          return
       else
          LOG_ERROR("FILE_read_var_realDP_4D",*) 'failed to get data information :'//trim(varname)
          call PRC_abort
       end if
    end if

    if ( dinfo%rank /= 4 ) then
       if ( (.not. present(start)) .and. (.not. present(count)) ) then
          LOG_ERROR("FILE_read_var_realDP_4D",*) 'rank of '//trim(varname)//' is not 4', dinfo%rank
          call PRC_abort
       end if
    end if

    if ( present(ntypes) ) then
       call file_read_data_c( var(:,:,:,:),                   & ! (out)
            dinfo, DP, ntypes, dtype, start(:), count(:), & ! (in)
            error                                              ) ! (out)
    else if ( present(start) .and. present(count) ) then
       call file_read_data_c( var(:,:,:,:),          & ! (out)
            dinfo, DP, 0, 0, start(:), count(:), & ! (in)
            error                                     ) ! (out)
    else
       dim_size(:) = shape(var)
       do n = 1, 4
          if ( dinfo%dim_size(n) /= dim_size(n) ) then
             LOG_ERROR("FILE_read_var_realDP_4D",*) 'shape is different: ', varname, n, dinfo%dim_size(n), dim_size(n)
             call PRC_abort
          end if
       end do
       call file_read_data_c( var(:,:,:,:), & ! (out)
            dinfo, DP, 0, 0, -1, -1,    & ! (in)
            error                            ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_read_var_realDP_4D",*) 'failed to get data value: ', trim(varname)
       call PRC_abort
    end if

    return
  end subroutine FILE_read_var_realDP_4D

  !-----------------------------------------------------------------------------
  ! interface FILE_write
  !-----------------------------------------------------------------------------
  subroutine FILE_write_realSP_1D( &
      vid, var,       &
      t_start, t_end, &
      ndims,          &
      count,          &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(SP), intent(in) :: var(:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: ndims    ! when var has been reshaped to 1D
    integer,  intent(in), optional :: count(:)
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(1)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realSP_1D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! history variable has been reshaped to 1D
       ! In this case, start and count must be present

       if ( .not. present(start) ) then
          LOG_ERROR("FILE_write_realSP_1D",*) 'start argument is neccessary when ndims is specified'
          call PRC_abort
       end if
       if ( .not. present(count) ) then
          LOG_ERROR("FILE_write_realSP_1D",*) 'count argument is neccessary when ndims is specified'
          call PRC_abort
       end if

       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:), ts, te, SP,                             & ! (in)
            ndims, start, count,                                        & ! (in)
            error                                                       ) ! (out)
    else
       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:), ts, te, SP,                             & ! (in)
            1, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realSP_1D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realSP_1D
  subroutine FILE_write_realDP_1D( &
      vid, var,       &
      t_start, t_end, &
      ndims,          &
      count,          &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(DP), intent(in) :: var(:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: ndims    ! when var has been reshaped to 1D
    integer,  intent(in), optional :: count(:)
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(1)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realDP_1D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

    if ( present(ndims) ) then
       ! history variable has been reshaped to 1D
       ! In this case, start and count must be present

       if ( .not. present(start) ) then
          LOG_ERROR("FILE_write_realDP_1D",*) 'start argument is neccessary when ndims is specified'
          call PRC_abort
       end if
       if ( .not. present(count) ) then
          LOG_ERROR("FILE_write_realDP_1D",*) 'count argument is neccessary when ndims is specified'
          call PRC_abort
       end if

       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:), ts, te, DP,                             & ! (in)
            ndims, start, count,                                        & ! (in)
            error                                                       ) ! (out)
    else
       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:), ts, te, DP,                             & ! (in)
            1, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    end if
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realDP_1D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realDP_1D
  subroutine FILE_write_realSP_2D( &
      vid, var,       &
      t_start, t_end, &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(SP), intent(in) :: var(:,:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(2)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realSP_2D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:,:), ts, te, SP,                             & ! (in)
            2, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realSP_2D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realSP_2D
  subroutine FILE_write_realDP_2D( &
      vid, var,       &
      t_start, t_end, &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(DP), intent(in) :: var(:,:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(2)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realDP_2D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:,:), ts, te, DP,                             & ! (in)
            2, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realDP_2D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realDP_2D
  subroutine FILE_write_realSP_3D( &
      vid, var,       &
      t_start, t_end, &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(SP), intent(in) :: var(:,:,:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(3)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realSP_3D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:,:,:), ts, te, SP,                             & ! (in)
            3, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realSP_3D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realSP_3D
  subroutine FILE_write_realDP_3D( &
      vid, var,       &
      t_start, t_end, &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(DP), intent(in) :: var(:,:,:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(3)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realDP_3D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:,:,:), ts, te, DP,                             & ! (in)
            3, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realDP_3D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realDP_3D
  subroutine FILE_write_realSP_4D( &
      vid, var,       &
      t_start, t_end, &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(SP), intent(in) :: var(:,:,:,:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(4)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realSP_4D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:,:,:,:), ts, te, SP,                             & ! (in)
            4, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realSP_4D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realSP_4D
  subroutine FILE_write_realDP_4D( &
      vid, var,       &
      t_start, t_end, &
      start           )
    implicit none

    integer,  intent(in)           :: vid
    real(DP), intent(in) :: var(:,:,:,:)
    real(DP), intent(in)           :: t_start
    real(DP), intent(in)           :: t_end
    integer,  intent(in), optional :: start(:)
    real(DP) :: ts, te

    integer :: start_(4)

    integer :: fid
    integer :: error, n

    intrinsic shape
    !---------------------------------------------------------------------------

    ts = t_start
    te = t_end

    fid = FILE_vars(vid)%fid

    if ( .not. FILE_opened(fid) ) then
       LOG_ERROR("FILE_write_realDP_4D",*) 'File is not opened. fid = ', fid
       call PRC_abort
    end if

       ! this is for restart variable which keeps its original shape
       if ( present(start) ) then
          start_(:) = start(:)
       else
          start_(:) = 1
       end if
       call file_write_data_c( FILE_files(fid)%fid, FILE_vars(vid)%vid, & ! (in)
            var(:,:,:,:), ts, te, DP,                             & ! (in)
            4, start_, shape(var),                                 & ! (in)
            error                                                       ) ! (out)
    if ( error /= FILE_SUCCESS_CODE ) then
       do n = 1, FILE_nvars
          if ( FILE_vars(n)%vid == vid ) then
             LOG_ERROR("FILE_write_realDP_4D",*) 'failed to write data: ', trim(FILE_vars(n)%name)
             exit
          end if
       enddo
       call PRC_abort
    end if

    return
  end subroutine FILE_write_realDP_4D

  !-----------------------------------------------------------------------------
  ! exit netCDF define mode and enter data mode
  subroutine FILE_enddef( fid )
    implicit none

    integer, intent(in) :: fid

    integer :: error
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) return

    call file_enddef_c( FILE_files(fid)%fid, error )

    if ( error == FILE_SUCCESS_CODE ) then

       LOG_NEWLINE
       LOG_INFO("FILE_enddef",'(1x,A,I3.3,2A)') &
            'End define mode : No.', fid, ', name = ', trim(FILE_files(fid)%name)

    else
       LOG_ERROR("FILE_enddef",*) 'failed to exit define mode'
       call PRC_abort
    end if

    return
  end subroutine FILE_enddef

  !-----------------------------------------------------------------------------
  ! This subroutine is used when PnetCDF I/O method is enabled
  subroutine FILE_attach_buffer( &
       fid,       &
       buf_amount )
    implicit none

    integer,    intent(in) :: fid
    integer(8), intent(in) :: buf_amount

    integer :: error
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) return

    call file_attach_buffer_c( FILE_files(fid)%fid, buf_amount, error )

    if ( error == FILE_SUCCESS_CODE ) then

       LOG_NEWLINE
       LOG_INFO("FILE_attach_buffer",'(1x,A,I3.3,3A,I10)') &
            'Attach buffer : No.', fid, ', name = ', trim(FILE_files(fid)%name), &
            ', size = ', buf_amount
    else
       LOG_ERROR("FILE_attach_buffer",*) 'failed to attach buffer in PnetCDF'
       call PRC_abort
    end if

    return
  end subroutine FILE_attach_buffer

  !-----------------------------------------------------------------------------
  ! This subroutine is used when PnetCDF I/O method is enabled
  subroutine FILE_detach_buffer( fid )
    implicit none

    integer, intent(in) :: fid

    integer :: error
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) return

    if ( FILE_files(fid)%fid < 0 ) return  ! already closed

    call file_detach_buffer_c( FILE_files(fid)%fid, error )

    if ( error == FILE_SUCCESS_CODE ) then

       LOG_NEWLINE
       LOG_INFO("FILE_detach_buffer",'(1x,A,I3.3,2A)') &
            'Detach buffer : No.', fid, ', name = ', trim(FILE_files(fid)%name)

    else
       LOG_ERROR("FILE_detach_buffer",*) 'failed to detach buffer in PnetCDF'
       call PRC_abort
    end if

    return
  end subroutine FILE_detach_buffer

  !-----------------------------------------------------------------------------
  ! This subroutine is used when PnetCDF I/O method is enabled
  subroutine FILE_flush( fid )
    implicit none

    integer, intent(in) :: fid

    integer :: error
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) return

    if ( FILE_files(fid)%fid < 0 ) return  ! already closed

    call file_flush_c( FILE_files(fid)%fid, error )

    if ( error == FILE_SUCCESS_CODE ) then

!!$       LOG_NEWLINE
!!$       LOG_INFO("FILE_flush",'(1xA,I3.3,2A)') &
!!$            'Flush : No.', fid, ', name = ', trim(FILE_files(fid)%name)

    else
       LOG_ERROR("FILE_flush",*) 'failed to flush PnetCDF pending requests'
       call PRC_abort
    end if

    return
  end subroutine FILE_flush

  !-----------------------------------------------------------------------------
  subroutine FILE_close( fid, skip_abort )
    implicit none
    integer, intent(in) :: fid
    logical, intent(in), optional :: skip_abort

    logical :: skip_abort_
    integer :: error
    integer :: n
    !---------------------------------------------------------------------------

    if ( .not. FILE_opened(fid) ) return

    if ( FILE_files(fid)%fid < 0 ) return  ! already closed

    if ( present(skip_abort) ) then
       skip_abort_ = skip_abort
    else
       skip_abort_ = .false.
    end if

    call file_close_c( FILE_files(fid)%fid, error )

    if ( error == FILE_SUCCESS_CODE ) then

       LOG_NEWLINE
       LOG_INFO("FILE_close",'(1x,A,I3.3,2A)') &
            'Close : No.', fid, ', name = ', trim(FILE_files(fid)%name)

    elseif( error /= FILE_ALREADY_CLOSED_CODE ) then
       LOG_ERROR("FILE_close",*) 'failed to close file'
       if ( .not. skip_abort_ ) call PRC_abort
    end if

    FILE_files(fid)%fid = -1
    FILE_files(fid)%name = ''
    FILE_files(fid)%aggregate = .false.

    do n = 1, FILE_nvars
       if ( FILE_vars(n)%fid == fid ) then
          FILE_vars(n)%vid = -1
          FILE_vars(n)%name = ''
       end if
    end do

    return
  end subroutine FILE_close
  !-----------------------------------------------------------------------------
  subroutine FILE_close_all( &
       skip_abort )
    implicit none
    logical, intent(in), optional :: skip_abort

    integer :: fid
    !---------------------------------------------------------------------------

    do fid = 1, FILE_nfiles
       call FILE_close( fid, skip_abort )
    enddo

    return
  end subroutine FILE_close_all

  subroutine FILE_make_fname( &
       basename, &
       prefix,   &
       rankid,   &
       len,      &
       fname     )
    character(len=*), intent( in) :: basename
    character(len=*), intent( in) :: prefix
    integer,          intent( in) :: rankid
    integer,          intent( in) :: len
    character(len=*), intent(out) :: fname

    !                           12345678901234567
    character(len=17) :: fmt = "(A, '.', A, I*.*)"
    !---------------------------------------------------------------------------

    if ( len < 1 .or. len > 9 ) then
       LOG_ERROR("FILE_make_fname",*) 'len is invalid'
       call PRC_abort
    end if

    write(fmt(14:14),'(I1)') len
    write(fmt(16:16),'(I1)') len
    write(fname, fmt) trim(basename), trim(prefix), rankid

    return
  end subroutine FILE_make_fname

  !-----------------------------------------------------------------------------
  !> get unit of time
  !-----------------------------------------------------------------------------
  subroutine FILE_get_CFtunits(date, tunits)
    implicit none

    integer,          intent(in)  :: date(6)
    character(len=*), intent(out) :: tunits
    !---------------------------------------------------------------------------

    write(tunits,'(a,i4.4,"-",i2.2,"-",i2.2," ",i2.2,":",i2.2,":",i2.2)') 'seconds since ', date

    return
  end subroutine FILE_get_CFtunits

  function FILE_get_aggregate( fid )
    integer, intent(in) :: fid
    logical :: FILE_get_aggregate

    if ( .not. FILE_opened(fid) ) then
       FILE_get_aggregate = .false.
    else
       FILE_get_aggregate = FILE_files(fid)%aggregate
    end if

    return
  end function FILE_get_aggregate

  !-----------------------------------------------------------------------------
  ! private
  !-----------------------------------------------------------------------------

  !-----------------------------------------------------------------------------
  subroutine FILE_get_fid( &
      basename,  &
      mode,      &
      rankid,    &
      single,    &
      fid,       &
      existed,   &
      aggregate, &
      postfix    )
    use scale_prc, only: &
       PRC_LOCAL_COMM_WORLD, &
       PRC_COMM_NULL
    implicit none

    character(len=*), intent( in) :: basename
    integer,          intent( in) :: mode
    integer,          intent( in) :: rankid
    logical,          intent( in) :: single

    integer,          intent(out) :: fid
    logical,          intent(out) :: existed

    logical,          intent( in), optional :: aggregate
    character(len=*), intent( in), optional :: postfix

    character(len=FILE_HSHORT) :: rwname(0:2)
    data rwname / 'READ','WRITE','APPEND' /

    character(len=FILE_HLONG) :: fname
    integer                   :: n

    logical :: aggregate_
    integer :: cfid
    integer :: error
    integer :: mpi_comm
    !---------------------------------------------------------------------------

    !--- check aggregate (parallel I/O on a single shared netCDF file)

    ! check to do PnetCDF I/O
    if ( present(aggregate) ) then
       aggregate_ = aggregate
    else
       aggregate_ = FILE_AGGREGATE
    end if

    if ( aggregate_ ) then
       mpi_comm = PRC_LOCAL_COMM_WORLD
    else
       mpi_comm = PRC_COMM_NULL
    end if

    if ( present(postfix) ) then
       fname = trim(basename)//trim(postfix)
    elseif ( aggregate_ ) then
       fname = basename
    elseif ( single ) then
       fname = trim(basename)//'.peall'
    else
       call FILE_make_fname( basename, 'pe', rankid, 6, fname )
    endif

    !--- search existing file
    fid = -1
    do n = 1, FILE_nfiles
       if ( fname == FILE_files(n)%name ) then
          fid = n
          exit
       end if
    enddo

    if ( FILE_opened(fid) ) then
       existed = .true.
       return
    end if

    call file_open_c( cfid,                  & ! (out)
                      fname, mode, mpi_comm, & ! (in)
                      error                  ) ! (out)

    if ( error /= FILE_SUCCESS_CODE ) then
       LOG_ERROR("FILE_get_fid",*) 'failed to open file :'//trim(fname)//'.nc'
       call PRC_abort
    end if

    FILE_nfiles = FILE_nfiles + 1
    fid         = FILE_nfiles

    FILE_files(fid)%name      = fname
    FILE_files(fid)%fid       = cfid
    FILE_files(fid)%aggregate = aggregate_

    LOG_NEWLINE
    LOG_INFO("FILE_get_fid",'(1x,A,A6,A,I3.3,2A)') &
    'Registration (', trim(rwname(mode)), ') : No.', fid, ', name = ', trim(fname)

    existed = .false.

    return
  end subroutine FILE_get_fid


end module scale_file
!-------------------------------------------------------------------------------


!--
! vi:set readonly sw=4 ts=8
!
!Local Variables:
!mode: f90
!buffer-read-only: t
!End:
!
!++
