
!-------------------------------------------------------------------------------
!> module scale_atmos_dyn_fvm_flux_ud5
!!
!! @par Description
!!          FVM flux scheme with the ud5 order
!!
!! @author Team SCALE
!!
!<
!-------------------------------------------------------------------------------
! Warning: This file was generated from atmos-rm/dynamics/scale_atmos_dyn_fvm_flux_udcd.F90.erb.
!          Do not edit this file.
!-------------------------------------------------------------------------------
#include "scalelib.h"
module scale_atmos_dyn_fvm_flux_ud5
  !-----------------------------------------------------------------------------
  !
  !++ used modules
  !
  use scale_precision
  use scale_io
  use scale_prof
  use scale_atmos_grid_cartesC_index
  use scale_index
  use scale_tracer
  use scale_prc
#ifdef DEBUG
  use scale_debug, only: &
     CHECK
  use scale_const, only: &
     UNDEF  => CONST_UNDEF, &
     IUNDEF => CONST_UNDEF2
#endif
  !-----------------------------------------------------------------------------
  implicit none
  private
  !-----------------------------------------------------------------------------
  !
  !++ Public procedure
  !
  public :: ATMOS_DYN_FVM_flux_valueW_Z_ud5

  public :: ATMOS_DYN_FVM_fluxZ_XYZ_ud5
  public :: ATMOS_DYN_FVM_fluxX_XYZ_ud5
  public :: ATMOS_DYN_FVM_fluxY_XYZ_ud5

  public :: ATMOS_DYN_FVM_fluxZ_XYW_ud5
  public :: ATMOS_DYN_FVM_fluxJ13_XYW_ud5
  public :: ATMOS_DYN_FVM_fluxJ23_XYW_ud5
  public :: ATMOS_DYN_FVM_fluxX_XYW_ud5
  public :: ATMOS_DYN_FVM_fluxY_XYW_ud5

  public :: ATMOS_DYN_FVM_fluxZ_UYZ_ud5
  public :: ATMOS_DYN_FVM_fluxJ13_UYZ_ud5
  public :: ATMOS_DYN_FVM_fluxJ23_UYZ_ud5
  public :: ATMOS_DYN_FVM_fluxX_UYZ_ud5
  public :: ATMOS_DYN_FVM_fluxY_UYZ_ud5

  public :: ATMOS_DYN_FVM_fluxZ_XVZ_ud5
  public :: ATMOS_DYN_FVM_fluxJ13_XVZ_ud5
  public :: ATMOS_DYN_FVM_fluxJ23_XVZ_ud5
  public :: ATMOS_DYN_FVM_fluxX_XVZ_ud5
  public :: ATMOS_DYN_FVM_fluxY_XVZ_ud5

  !-----------------------------------------------------------------------------
  !
  !++ Public parameters & variables
  !
  !-----------------------------------------------------------------------------
  !
  !++ Private procedure
  !
#if 1
#define F2H(k,p,q) (CDZ(k+p-1)*GSQRT(k+p-1,i,j)/(CDZ(k)*GSQRT(k,i,j)+CDZ(k+1)*GSQRT(k+1,i,j)))
#else
#define F2H(k,p,q) 0.5_RP
#endif
  !-----------------------------------------------------------------------------
  !
  !++ Private parameters & variables
  !

  real(RP), parameter :: F2  =  0.5_RP          ! F2 is always used to calculate flux near boundary.


  real(RP), parameter :: F31  = -1.0_RP/12.0_RP
  real(RP), parameter :: F32  =  7.0_RP/12.0_RP
  real(RP), parameter :: F33  =  3.0_RP/12.0_RP


  real(RP), parameter :: F51  =  1.0_RP/60.0_RP
  real(RP), parameter :: F52  = -8.0_RP/60.0_RP
  real(RP), parameter :: F53  = 37.0_RP/60.0_RP
  real(RP), parameter :: F54  = -5.0_RP/60.0_RP
  real(RP), parameter :: F55  = 10.0_RP/60.0_RP



contains
  !-----------------------------------------------------------------------------
  !> value at XYW
!OCL SERIAL
  subroutine ATMOS_DYN_FVM_flux_valueW_Z_ud5( &
       valW,             &
       mflx, val, GSQRT, &
       CDZ               )
    implicit none

    real(RP), intent(out) :: valW (KA)
    real(RP), intent(in)  :: mflx (KA)
    real(RP), intent(in)  :: val  (KA)
    real(RP), intent(in)  :: GSQRT(KA)
    real(RP), intent(in)  :: CDZ  (KA)

    integer  :: k
    !---------------------------------------------------------------------------

    do k = KS+2, KE-3
#ifdef DEBUG
       call CHECK( __LINE__, mflx(k) )

       call CHECK( __LINE__, val(k) )
       call CHECK( __LINE__, val(k+1) )

       call CHECK( __LINE__, val(k-1) )
       call CHECK( __LINE__, val(k+2) )

       call CHECK( __LINE__, val(k-2) )
       call CHECK( __LINE__, val(k+3) )

#endif
       valW(k)       = ( F51 * ( val(k+3)+val(k-2) ) &
                       + F52 * ( val(k+2)+val(k-1) ) &
                       + F53 * ( val(k+1)+val(k) ) ) &
                     - ( F51 * ( val(k+3)-val(k-2) ) &
                       + F54 * ( val(k+2)-val(k-1) ) &
                       + F55 * ( val(k+1)-val(k) ) ) * sign(1.0_RP,mflx(k))
    enddo
#ifdef DEBUG
    k = IUNDEF
#endif

#ifdef DEBUG

       call CHECK( __LINE__, mflx(KS) )
       call CHECK( __LINE__, val(KS  ) )
       call CHECK( __LINE__, val(KS+1) )
       call CHECK( __LINE__, mflx(KE-1) )
       call CHECK( __LINE__, val(KE  ) )
       call CHECK( __LINE__, val(KE-1) )

       call CHECK( __LINE__, mflx(KS+1) )
       call CHECK( __LINE__, val(KS+2  ) )
       call CHECK( __LINE__, val(KS+3) )
       call CHECK( __LINE__, mflx(KE-2) )
       call CHECK( __LINE__, val(KE-2  ) )
       call CHECK( __LINE__, val(KE-3) )

#endif

       valW(KS) = F2 * ( val(KS+1)+val(KS) ) &
                     * ( 0.5_RP + sign(0.5_RP,mflx(KS)) ) &
                + ( 2.0_RP * val(KS) + 5.0_RP * val(KS+1) - val(KS+2) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,mflx(KS)) )
       valW(KE-1) = ( 2.0_RP * val(KE) + 5.0_RP * val(KE-1) - val(KE-2) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,mflx(KE-1)) ) &
                + F2 * ( val(KE)+val(KE-1) ) &
                     * ( 0.5_RP - sign(0.5_RP,mflx(KE-1)) )

       valW(KS+1) = ( 2.0_RP * val(KS+2) + 5.0_RP * val(KS+1) - val(KS) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,mflx(KS+1)) ) &
                + ( -  3.0_RP * val(KS)  &
                         + 27.0_RP * val(KS+1)  &
                         + 47.0_RP * val(KS+2)  &
                         - 13.0_RP * val(KS+3) &
                         + 2.0_RP * val(KS+4) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,mflx(KS+1)) )
       valW(KE-2) = ( -  3.0_RP * val(KE)  &
                         + 27.0_RP * val(KE-1)  &
                         + 47.0_RP * val(KE-2)  &
                         - 13.0_RP * val(KE-3) &
                         + 2.0_RP * val(KE-4) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,mflx(KE-2)) ) &
                + ( 2.0_RP * val(KE-2) + 5.0_RP * val(KE-1) - val(KE) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,mflx(KE-2)) )


    return
  end subroutine ATMOS_DYN_FVM_flux_ValueW_Z_ud5

  !-----------------------------------------------------------------------------
  !> calculation z-flux at XYZ
  subroutine ATMOS_DYN_FVM_fluxZ_XYZ_ud5( &
       flux,              &
       mflx, val, GSQRT,  &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    use scale_const, only: &
      EPS => CONST_EPS
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mflx    (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mflx,val,flux,GSQRT,num_diff)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
#ifdef DEBUG
       call CHECK( __LINE__, mflx(k,i,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k+1,i,j) )

       call CHECK( __LINE__, val(k-1,i,j) )
       call CHECK( __LINE__, val(k+2,i,j) )

       call CHECK( __LINE__, val(k-2,i,j) )
       call CHECK( __LINE__, val(k+3,i,j) )

#endif
       vel = mflx(k,i,j)
       flux(k,i,j) = vel &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mflx,val,flux,GSQRT,num_diff,EPS)
    do j = JJS, JJE
    do i = IIS, IIE
#ifdef DEBUG

       call CHECK( __LINE__, mflx(KS,i,j) )
       call CHECK( __LINE__, val(KS  ,i,j) )
       call CHECK( __LINE__, val(KS+1,i,j) )
       call CHECK( __LINE__, mflx(KE-1,i,j) )
       call CHECK( __LINE__, val(KE  ,i,j) )
       call CHECK( __LINE__, val(KE-1,i,j) )

       call CHECK( __LINE__, mflx(KS+1,i,j) )
       call CHECK( __LINE__, val(KS+2  ,i,j) )
       call CHECK( __LINE__, val(KS+3,i,j) )
       call CHECK( __LINE__, mflx(KE-2,i,j) )
       call CHECK( __LINE__, val(KE-2  ,i,j) )
       call CHECK( __LINE__, val(KE-3,i,j) )

#endif
       flux(KS-1,i,j) = 0.0_RP

       vel = mflx(KS,i,j)
       flux(KS,i,j) = vel &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS,i,j) * num_diff(KS,i,j)
       vel = mflx(KE-1,i,j)
       flux(KE-1,i,j) = vel &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-1,i,j) * num_diff(KE-1,i,j)

       vel = mflx(KS+1,i,j)
       flux(KS+1,i,j) = vel &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS+1,i,j) * num_diff(KS+1,i,j)
       vel = mflx(KE-2,i,j)
       flux(KE-2,i,j) = vel &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-2,i,j) * num_diff(KE-2,i,j)

       flux(KE  ,i,j) = 0.0_RP
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxZ_XYZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation X-flux at XYZ
  subroutine ATMOS_DYN_FVM_fluxX_XYZ_ud5( &
       flux,              &
       mflx, val, GSQRT,  &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mflx    (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ(KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mflx,val,flux,GSQRT,num_diff)
    do j = JJS, JJE
    do i = IIS-1, IIE
    do k = KS, KE
#ifdef DEBUG
       call CHECK( __LINE__, mflx(k,i,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k,i+1,j) )

       call CHECK( __LINE__, val(k,i-1,j) )
       call CHECK( __LINE__, val(k,i+2,j) )

       call CHECK( __LINE__, val(k,i-2,j) )
       call CHECK( __LINE__, val(k,i+3,j) )

#endif
       vel = mflx(k,i,j)
       flux(k,i,j) = vel &
                   * ( ( F51 * ( val(k,i+3,j)+val(k,i-2,j) ) &
                       + F52 * ( val(k,i+2,j)+val(k,i-1,j) ) &
                       + F53 * ( val(k,i+1,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k,i+3,j)-val(k,i-2,j) ) &
                       + F54 * ( val(k,i+2,j)-val(k,i-1,j) ) &
                       + F55 * ( val(k,i+1,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxX_XYZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation Y-flux at XYZ
  subroutine ATMOS_DYN_FVM_fluxY_XYZ_ud5( &
       flux,              &
       mflx, val, GSQRT,  &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mflx    (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ(KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mflx,val,flux,GSQRT,num_diff)
    do j = JJS-1, JJE
    do i = IIS, IIE
    do k = KS, KE
#ifdef DEBUG
       call CHECK( __LINE__, mflx(k,i,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k,i,j+1) )

       call CHECK( __LINE__, val(k,i,j-1) )
       call CHECK( __LINE__, val(k,i,j+2) )

       call CHECK( __LINE__, val(k,i,j-2) )
       call CHECK( __LINE__, val(k,i,j+3) )

#endif
       vel = mflx(k,i,j)
       flux(k,i,j) = vel &
                   * ( ( F51 * ( val(k,i,j+3)+val(k,i,j-2) ) &
                       + F52 * ( val(k,i,j+2)+val(k,i,j-1) ) &
                       + F53 * ( val(k,i,j+1)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k,i,j+3)-val(k,i,j-2) ) &
                       + F54 * ( val(k,i,j+2)-val(k,i,j-1) ) &
                       + F55 * ( val(k,i,j+1)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxY_XYZ_ud5


  !-----------------------------------------------------------------------------
  !> calculation z-flux at XYW
  subroutine ATMOS_DYN_FVM_fluxZ_XYW_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J33G,       &
       num_diff,          &
       CDZ, FDZ,          &
       dtrk,              &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J33G
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    real(RP), intent(in)  :: FDZ     (KA-1)
    real(RP), intent(in)  :: dtrk
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    ! note than z-index is added by -1

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,flux,J33G,GSQRT,num_diff,DENS)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+3, KE-2
#ifdef DEBUG
       call CHECK( __LINE__, mom(k-1,i,j) )
       call CHECK( __LINE__, mom(k  ,i,j) )

       call CHECK( __LINE__, val(k-1,i,j) )
       call CHECK( __LINE__, val(k,i,j) )

       call CHECK( __LINE__, val(k-2,i,j) )
       call CHECK( __LINE__, val(k+1,i,j) )

       call CHECK( __LINE__, val(k-3,i,j) )
       call CHECK( __LINE__, val(k+2,i,j) )

#endif
       vel = ( 0.5_RP * ( mom(k-1,i,j) &
                        + mom(k,i,j) ) ) &
           / DENS(k,i,j)
       flux(k-1,i,j) = J33G * vel &
                   * ( ( F51 * ( val(k+2,i,j)+val(k-3,i,j) ) &
                       + F52 * ( val(k+1,i,j)+val(k-2,i,j) ) &
                       + F53 * ( val(k,i,j)+val(k-1,i,j) ) ) &
                     - ( F51 * ( val(k+2,i,j)-val(k-3,i,j) ) &
                       + F54 * ( val(k+1,i,j)-val(k-2,i,j) ) &
                       + F55 * ( val(k,i,j)-val(k-1,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J33G,GSQRT,num_diff,FDZ,dtrk)
    do j = JJS, JJE
    do i = IIS, IIE
#ifdef DEBUG

       call CHECK( __LINE__, val(KS  ,i,j) )
       call CHECK( __LINE__, val(KS+1,i,j) )


       call CHECK( __LINE__, val(KE-2,i,j) )
       call CHECK( __LINE__, val(KE-1,i,j) )

#endif
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS.
       ! The flux at KS can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP ! k = KS

       vel = ( 0.5_RP * ( mom(KS,i,j) &
                        + mom(KS+1,i,j) ) ) &
           / DENS(KS+1,i,j)
       flux(KS,i,j) = J33G * vel &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS+1,i,j) * num_diff(KS+1,i,j) ! k = KS+1

       vel = ( 0.5_RP * ( mom(KS+1,i,j) &
                        + mom(KS+2,i,j) ) ) &
           / DENS(KS+2,i,j)
       flux(KS+1,i,j) = J33G * vel &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS+2,i,j) * num_diff(KS+2,i,j) ! k = KS+2



       vel = ( 0.5_RP * ( mom(KE-2,i,j) &
                        + mom(KE-1,i,j) ) ) &
           / DENS(KE-1,i,j)
       flux(KE-2,i,j) = J33G * vel &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-1,i,j) * num_diff(KE-1,i,j) ! k = KE-1

       flux(KE-1,i,j) = 0.0_RP ! k = KE
       flux(KE  ,i,j) = 0.0_RP ! k = KE+1
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxZ_XYW_ud5


  !-----------------------------------------------------------------------------
  !> calculation J13-flux at XYW
  subroutine ATMOS_DYN_FVM_fluxJ13_XYW_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J13G, MAPF, &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J13G    (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J13G,MAPF)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-2
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i-1,j) ) ) &
           / DENS(k,i,j)
       vel = vel * J13G(k,i,j)
       flux(k-1,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( F51 * ( val(k+2,i,j)+val(k-3,i,j) ) &
                       + F52 * ( val(k+1,i,j)+val(k-2,i,j) ) &
                       + F53 * ( val(k,i,j)+val(k-1,i,j) ) ) &
                     - ( F51 * ( val(k+2,i,j)-val(k-3,i,j) ) &
                       + F54 * ( val(k+1,i,j)-val(k-2,i,j) ) &
                       + F55 * ( val(k,i,j)-val(k-1,i,j) ) ) * sign(1.0_RP,vel) )
    enddo
    enddo
    enddo

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J13G,MAPF)
    do j = JJS, JJE
    do i = IIS, IIE
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS.
       ! The flux at KS can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP ! k = KS

       ! physically incorrect but for numerical stability
       vel = ( ( 0.5_RP * ( mom(KS+1,i,j)+mom(KS+1,i-1,j) ) ) / DENS(KS+1,i,j) &
             + ( 0.5_RP * ( mom(KS,i,j)+mom(KS,i-1,j) ) ) / DENS(KS  ,i,j) ) * 0.5_RP
!       vel = ( 0.5_RP * ( mom(KS+1,i,j)+mom(KS+1,i-1,j) ) ) &
!           / DENS(KS+1,i,j)
       vel = vel * J13G(KS+1,i,j)
       flux(KS,i,j) =  vel / MAPF(i,j,+2) &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) ! k = KS+1


       vel = ( 0.5_RP * ( mom(KE-1,i,j)+mom(KE-1,i-1,j) ) ) &
           / DENS(KE-1,i,j)
       vel = vel * J13G(KE-1,i,j)
       flux(KE-2,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( 2.0_RP * val(KE-1,i,j) + 5.0_RP * val(KE-2,i,j) - val(KE-3,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE-1,i,j)+val(KE-2,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) ! k = KE-3

       flux(KE-1,i,j) = 0.0_RP
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxJ13_XYW_ud5

  !-----------------------------------------------------------------------------
  !> calculation J23-flux at XYW
  subroutine ATMOS_DYN_FVM_fluxJ23_XYW_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J23G, MAPF, &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J23G    (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J23G,MAPF)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-2
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i,j-1) ) ) &
           / DENS(k,i,j)
       vel = vel * J23G(k,i,j)
       flux(k-1,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( F51 * ( val(k+2,i,j)+val(k-3,i,j) ) &
                       + F52 * ( val(k+1,i,j)+val(k-2,i,j) ) &
                       + F53 * ( val(k,i,j)+val(k-1,i,j) ) ) &
                     - ( F51 * ( val(k+2,i,j)-val(k-3,i,j) ) &
                       + F54 * ( val(k+1,i,j)-val(k-2,i,j) ) &
                       + F55 * ( val(k,i,j)-val(k-1,i,j) ) ) * sign(1.0_RP,vel) )
    enddo
    enddo
    enddo

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J23G,MAPF)
    do j = JJS, JJE
    do i = IIS, IIE
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS.
       ! The flux at KS can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP ! k = KS

       ! physically incorrect but for numerical stability
       vel = ( ( 0.5_RP * ( mom(KS+1,i,j)+mom(KS+1,i,j-1) ) ) / DENS(KS+1,i,j) &
             + ( 0.5_RP * ( mom(KS,i,j)+mom(KS,i,j-1) ) ) / DENS(KS  ,i,j) ) * 0.5_RP
!       vel = ( 0.5_RP * ( mom(KS+1,i,j)+mom(KS+1,i,j-1) ) ) &
!           / DENS(KS+1,i,j)
       vel = vel * J23G(KS+1,i,j)
       flux(KS,i,j) =  vel / MAPF(i,j,+1) &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) ! k = KS+1


       vel = ( 0.5_RP * ( mom(KE-1,i,j)+mom(KE-1,i,j-1) ) ) &
           / DENS(KE-1,i,j)
       vel = vel * J23G(KE-1,i,j)
       flux(KE-2,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( 2.0_RP * val(KE-1,i,j) + 5.0_RP * val(KE-2,i,j) - val(KE-3,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE-1,i,j)+val(KE-2,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) ! k = KE-3

       flux(KE-1,i,j) = 0.0_RP
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxJ23_XYW_ud5


  !-----------------------------------------------------------------------------
  !> calculation X-flux at XYW
  subroutine ATMOS_DYN_FVM_fluxX_XYW_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, MAPF,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,GSQRT,MAPF,num_diff) &
    !$omp shared(CDZ)
    do j = JJS, JJE
    do i = IIS-1, IIE
    do k = KS, KE-1
#ifdef DEBUG
       call CHECK( __LINE__, mom(k  ,i,j) )
       call CHECK( __LINE__, mom(k+1,i,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k,i+1,j) )

       call CHECK( __LINE__, val(k,i-1,j) )
       call CHECK( __LINE__, val(k,i+2,j) )

       call CHECK( __LINE__, val(k,i-2,j) )
       call CHECK( __LINE__, val(k,i+3,j) )

#endif
       vel = ( F2H(k,1,I_UYZ) &
             * mom(k+1,i,j) &
             + F2H(k,2,I_UYZ) &
             * mom(k,i,j) ) &
           / ( F2H(k,1,I_UYZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i+1,j) ) &
             + F2H(k,2,I_UYZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i+1,j) ) )
       flux(k,i,j) = GSQRT(k,i,j) / MAPF(i,j,+2) * vel &
                   * ( ( F51 * ( val(k,i+3,j)+val(k,i-2,j) ) &
                       + F52 * ( val(k,i+2,j)+val(k,i-1,j) ) &
                       + F53 * ( val(k,i+1,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k,i+3,j)-val(k,i-2,j) ) &
                       + F54 * ( val(k,i+2,j)-val(k,i-1,j) ) &
                       + F55 * ( val(k,i+1,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KE,flux)
    do j = JJS, JJE
    do i = IIS-1, IIE
       flux(KE,i,j) = 0.0_RP
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxX_XYW_ud5

  !-----------------------------------------------------------------------------
  !> calculation Y-flux at XYW
  subroutine ATMOS_DYN_FVM_fluxY_XYW_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, MAPF,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,GSQRT,MAPF,num_diff) &
    !$omp shared(CDZ)
    do j = JJS-1, JJE
    do i = IIS, IIE
    do k = KS, KE-1
#ifdef DEBUG
       call CHECK( __LINE__, mom(k  ,i,j) )
       call CHECK( __LINE__, mom(k+1,i,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k,i,j+1) )

       call CHECK( __LINE__, val(k,i,j-1) )
       call CHECK( __LINE__, val(k,i,j+2) )

       call CHECK( __LINE__, val(k,i,j-2) )
       call CHECK( __LINE__, val(k,i,j+3) )

#endif
       vel = ( F2H(k,1,I_XVZ) &
             * mom(k+1,i,j) &
             + F2H(k,2,I_XVZ) &
             * mom(k,i,j) ) &
           / ( F2H(k,1,I_XVZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i,j+1) ) &
             + F2H(k,2,I_XVZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i,j+1) ) )
       flux(k,i,j) = GSQRT(k,i,j) / MAPF(i,j,+1) * vel &
                   * ( ( F51 * ( val(k,i,j+3)+val(k,i,j-2) ) &
                       + F52 * ( val(k,i,j+2)+val(k,i,j-1) ) &
                       + F53 * ( val(k,i,j+1)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k,i,j+3)-val(k,i,j-2) ) &
                       + F54 * ( val(k,i,j+2)-val(k,i,j-1) ) &
                       + F55 * ( val(k,i,j+1)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KE,flux)
    do j = JJS-1, JJE
    do i = IIS, IIE
       flux(KE,i,j) = 0.0_RP
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxY_XYW_ud5


  !-----------------------------------------------------------------------------
  !> calculation z-flux at UY
  subroutine ATMOS_DYN_FVM_fluxZ_UYZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J33G,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J33G
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J33G,GSQRT,num_diff) &
    !$omp shared(CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
#ifdef DEBUG
       call CHECK( __LINE__, mom(k,i,j) )
       call CHECK( __LINE__, mom(k,i+1,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k+1,i,j) )

       call CHECK( __LINE__, val(k-1,i,j) )
       call CHECK( __LINE__, val(k+2,i,j) )

       call CHECK( __LINE__, val(k-2,i,j) )
       call CHECK( __LINE__, val(k+3,i,j) )

#endif
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i+1,j) ) ) &
           / ( F2H(k,1,I_UYZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i+1,j) ) &
             + F2H(k,2,I_UYZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i+1,j) ) )
       flux(k,i,j) = J33G * vel &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,flux,J33G,GSQRT,num_diff,DENS,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
#ifdef DEBUG

       call CHECK( __LINE__, mom(KS,i  ,j) )
       call CHECK( __LINE__, mom(KS,i+1,j) )
       call CHECK( __LINE__, val(KS+1,i,j) )
       call CHECK( __LINE__, val(KS,i,j) )

       call CHECK( __LINE__, mom(KS+1,i  ,j) )
       call CHECK( __LINE__, mom(KS+1,i+1,j) )
       call CHECK( __LINE__, val(KS+3,i,j) )
       call CHECK( __LINE__, val(KS+2,i,j) )

#endif
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS-1.
       ! The flux at KS-1 can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP

       vel = ( 0.5_RP * ( mom(KS,i,j)+mom(KS,i+1,j) ) ) &
           / ( F2H(KS,1,I_UYZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i+1,j) ) &
             + F2H(KS,2,I_UYZ) &
             * 0.5_RP * ( DENS(KS,i,j)+DENS(KS,i+1,j) ) )
       flux(KS,i,j) = J33G * vel &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS,i,j) * num_diff(KS,i,j)
       vel = ( 0.5_RP * ( mom(KE-1,i,j)+mom(KE-1,i+1,j) ) ) &
           / ( F2H(KE-1,1,I_UYZ) &
             * 0.5_RP * ( DENS(KE,i,j)+DENS(KE,i+1,j) ) &
             + F2H(KE-1,2,I_UYZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i+1,j) ) )
       flux(KE-1,i,j) = J33G * vel &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-1,i,j) * num_diff(KE-1,i,j)

       vel = ( 0.5_RP * ( mom(KS+1,i,j)+mom(KS+1,i+1,j) ) ) &
           / ( F2H(KS+1,1,I_UYZ) &
             * 0.5_RP * ( DENS(KS+2,i,j)+DENS(KS+2,i+1,j) ) &
             + F2H(KS+1,2,I_UYZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i+1,j) ) )
       flux(KS+1,i,j) = J33G * vel &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS+1,i,j) * num_diff(KS+1,i,j)
       vel = ( 0.5_RP * ( mom(KE-2,i,j)+mom(KE-2,i+1,j) ) ) &
           / ( F2H(KE-2,1,I_UYZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i+1,j) ) &
             + F2H(KE-2,2,I_UYZ) &
             * 0.5_RP * ( DENS(KE-2,i,j)+DENS(KE-2,i+1,j) ) )
       flux(KE-2,i,j) = J33G * vel &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-2,i,j) * num_diff(KE-2,i,j)

       flux(KE,i,j) = 0.0_RP
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxZ_UYZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation J13-flux at UYZ
  subroutine ATMOS_DYN_FVM_fluxJ13_UYZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J13G, MAPF, &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J13G    (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J13G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
       vel = ( F2H(k,1,I_UYZ) &
             * mom(k+1,i,j) &
             + F2H(k,2,I_UYZ) &
             * mom(k,i,j) ) &
           / ( F2H(k,1,I_UYZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i+1,j) ) &
             + F2H(k,2,I_UYZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i+1,j) ) )
       vel = vel * J13G(k,i,j)
       flux(k,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) )
    enddo
    enddo
    enddo

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J13G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS-1.
       ! The flux at KS-1 can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP

       vel = ( F2H(KS,1,I_UYZ) &
             * mom(KS+1,i,j) &
             + F2H(KS,2,I_UYZ) &
             * mom(KS,i,j) ) &
           / ( F2H(KS,1,I_UYZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i+1,j) ) &
             + F2H(KS,2,I_UYZ) &
             * 0.5_RP * ( DENS(KS,i,j)+DENS(KS,i+1,j) ) )
       vel = vel * J13G(KS,i,j)
       flux(KS,i,j) = vel / MAPF(i,j,+2) &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-1,1,I_UYZ) &
             * mom(KE,i,j) &
             + F2H(KE-1,2,I_UYZ) &
             * mom(KE-1,i,j) ) &
           / ( F2H(KE-1,1,I_UYZ) &
             * 0.5_RP * ( DENS(KE,i,j)+DENS(KE,i+1,j) ) &
             + F2H(KE-1,2,I_UYZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i+1,j) ) )
       vel = vel * J13G(KE-1,i,j)
       flux(KE-1,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KS+1,1,I_UYZ) &
             * mom(KS+2,i,j) &
             + F2H(KS+1,2,I_UYZ) &
             * mom(KS+1,i,j) ) &
           / ( F2H(KS+1,1,I_UYZ) &
             * 0.5_RP * ( DENS(KS+2,i,j)+DENS(KS+2,i+1,j) ) &
             + F2H(KS+1,2,I_UYZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i+1,j) ) )
       vel = vel * J13G(KS+1,i,j)
       flux(KS+1,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-2,1,I_UYZ) &
             * mom(KE-1,i,j) &
             + F2H(KE-2,2,I_UYZ) &
             * mom(KE-2,i,j) ) &
           / ( F2H(KE-2,1,I_UYZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i+1,j) ) &
             + F2H(KE-2,2,I_UYZ) &
             * 0.5_RP * ( DENS(KE-2,i,j)+DENS(KE-2,i+1,j) ) )
       vel = vel * J13G(KE-2,i,j)
       flux(KE-2,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       flux(KE  ,i,j) = 0.0_RP
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxJ13_UYZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation J23-flux at UYZ
  subroutine ATMOS_DYN_FVM_fluxJ23_UYZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J23G, MAPF, &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J23G    (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J23G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
       vel = ( F2H(k,1,I_UYZ) &
             * 0.25_RP * ( mom(k+1,i,j)+mom(k+1,i+1,j)+mom(k+1,i,j-1)+mom(k+1,i+1,j-1) ) &
             + F2H(k,2,I_UYZ) &
             * 0.25_RP * ( mom(k,i,j)+mom(k,i+1,j)+mom(k,i,j-1)+mom(k,i+1,j-1) ) ) &
           / ( F2H(k,1,I_UYZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i+1,j) ) &
             + F2H(k,2,I_UYZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i+1,j) ) )
       vel = vel * J23G(k,i,j)
       flux(k,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) )
    enddo
    enddo
    enddo

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J23G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS-1.
       ! The flux at KS-1 can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP

       vel = ( F2H(KS,1,I_UYZ) &
             * 0.25_RP * ( mom(KS+1,i,j)+mom(KS+1,i+1,j)+mom(KS+1,i,j-1)+mom(KS+1,i+1,j-1) ) &
             + F2H(KS,2,I_UYZ) &
             * 0.25_RP * ( mom(KS,i,j)+mom(KS,i+1,j)+mom(KS,i,j-1)+mom(KS,i+1,j-1) ) ) &
           / ( F2H(KS,1,I_UYZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i+1,j) ) &
             + F2H(KS,2,I_UYZ) &
             * 0.5_RP * ( DENS(KS,i,j)+DENS(KS,i+1,j) ) )
       vel = vel * J23G(KS,i,j)
       flux(KS,i,j) = vel / MAPF(i,j,+1) &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-1,1,I_UYZ) &
             * 0.25_RP * ( mom(KE,i,j)+mom(KE,i+1,j)+mom(KE,i,j-1)+mom(KE,i+1,j-1) ) &
             + F2H(KE-1,2,I_UYZ) &
             * 0.25_RP * ( mom(KE-1,i,j)+mom(KE-1,i+1,j)+mom(KE-1,i,j-1)+mom(KE-1,i+1,j-1) ) ) &
           / ( F2H(KE-1,1,I_UYZ) &
             * 0.5_RP * ( DENS(KE,i,j)+DENS(KE,i+1,j) ) &
             + F2H(KE-1,2,I_UYZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i+1,j) ) )
       vel = vel * J23G(KE-1,i,j)
       flux(KE-1,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KS+1,1,I_UYZ) &
             * 0.25_RP * ( mom(KS+2,i,j)+mom(KS+2,i+1,j)+mom(KS+2,i,j-1)+mom(KS+2,i+1,j-1) ) &
             + F2H(KS+1,2,I_UYZ) &
             * 0.25_RP * ( mom(KS+1,i,j)+mom(KS+1,i+1,j)+mom(KS+1,i,j-1)+mom(KS+1,i+1,j-1) ) ) &
           / ( F2H(KS+1,1,I_UYZ) &
             * 0.5_RP * ( DENS(KS+2,i,j)+DENS(KS+2,i+1,j) ) &
             + F2H(KS+1,2,I_UYZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i+1,j) ) )
       vel = vel * J23G(KS+1,i,j)
       flux(KS+1,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-2,1,I_UYZ) &
             * 0.25_RP * ( mom(KE-1,i,j)+mom(KE-1,i+1,j)+mom(KE-1,i,j-1)+mom(KE-1,i+1,j-1) ) &
             + F2H(KE-2,2,I_UYZ) &
             * 0.25_RP * ( mom(KE-2,i,j)+mom(KE-2,i+1,j)+mom(KE-2,i,j-1)+mom(KE-2,i+1,j-1) ) ) &
           / ( F2H(KE-2,1,I_UYZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i+1,j) ) &
             + F2H(KE-2,2,I_UYZ) &
             * 0.5_RP * ( DENS(KE-2,i,j)+DENS(KE-2,i+1,j) ) )
       vel = vel * J23G(KE-2,i,j)
       flux(KE-2,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       flux(KE  ,i,j) = 0.0_RP
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxJ23_UYZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation X-flux at UY
  subroutine ATMOS_DYN_FVM_fluxX_UYZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, MAPF,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    ! note that x-index is added by -1

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,GSQRT,MAPF,num_diff)
    do j = JJS, JJE
    do i = IIS, IIE+1
    do k = KS, KE
#ifdef DEBUG
       call CHECK( __LINE__, mom(k,i  ,j) )
       call CHECK( __LINE__, mom(k,i-1,j) )

       call CHECK( __LINE__, val(k,i-1,j) )
       call CHECK( __LINE__, val(k,i,j) )

       call CHECK( __LINE__, val(k,i-2,j) )
       call CHECK( __LINE__, val(k,i+1,j) )

       call CHECK( __LINE__, val(k,i-3,j) )
       call CHECK( __LINE__, val(k,i+2,j) )

#endif
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i-1,j) ) ) &
           / ( DENS(k,i,j) )
       flux(k,i-1,j) = GSQRT(k,i,j) / MAPF(i,j,+2) * vel &
                   * ( ( F51 * ( val(k,i+2,j)+val(k,i-3,j) ) &
                       + F52 * ( val(k,i+1,j)+val(k,i-2,j) ) &
                       + F53 * ( val(k,i,j)+val(k,i-1,j) ) ) &
                     - ( F51 * ( val(k,i+2,j)-val(k,i-3,j) ) &
                       + F54 * ( val(k,i+1,j)-val(k,i-2,j) ) &
                       + F55 * ( val(k,i,j)-val(k,i-1,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxX_UYZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation Y-flux at UY
  subroutine ATMOS_DYN_FVM_fluxY_UYZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, MAPF,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,GSQRT,MAPF,num_diff)
    do j = JJS-1, JJE
    do i = IIS, IIE
    do k = KS, KE
#ifdef DEBUG
       call CHECK( __LINE__, mom(k,i  ,j) )
       call CHECK( __LINE__, mom(k,i-1,j) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k,i,j+1) )

       call CHECK( __LINE__, val(k,i,j-1) )
       call CHECK( __LINE__, val(k,i,j+2) )

       call CHECK( __LINE__, val(k,i,j-2) )
       call CHECK( __LINE__, val(k,i,j+3) )

#endif
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i+1,j) ) ) &
           / ( 0.25_RP * ( DENS(k,i,j)+DENS(k,i+1,j)+DENS(k,i,j+1)+DENS(k,i+1,j+1) ) )
       flux(k,i,j) = GSQRT(k,i,j) / MAPF(i,j,+1) * vel &
                   * ( ( F51 * ( val(k,i,j+3)+val(k,i,j-2) ) &
                       + F52 * ( val(k,i,j+2)+val(k,i,j-1) ) &
                       + F53 * ( val(k,i,j+1)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k,i,j+3)-val(k,i,j-2) ) &
                       + F54 * ( val(k,i,j+2)-val(k,i,j-1) ) &
                       + F55 * ( val(k,i,j+1)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxY_UYZ_ud5



  !-----------------------------------------------------------------------------
  !> calculation z-flux at XV
  subroutine ATMOS_DYN_FVM_fluxZ_XVZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J33G,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J33G
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J33G,GSQRT,num_diff) &
    !$omp shared(CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
#ifdef DEBUG
       call CHECK( __LINE__, mom(k,i,j) )
       call CHECK( __LINE__, mom(k,i,j+1) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k+1,i,j) )

       call CHECK( __LINE__, val(k-1,i,j) )
       call CHECK( __LINE__, val(k+2,i,j) )

       call CHECK( __LINE__, val(k-2,i,j) )
       call CHECK( __LINE__, val(k+3,i,j) )

#endif
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i,j+1) ) ) &
           / ( F2H(k,1,I_XVZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i,j+1) ) &
             + F2H(k,2,I_XVZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i,j+1) ) )
       flux(k,i,j) = J33G * vel &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,flux,J33G,GSQRT,num_diff,DENS,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
#ifdef DEBUG

       call CHECK( __LINE__, mom(KS,i  ,j) )
       call CHECK( __LINE__, mom(KS,i,j+1) )
       call CHECK( __LINE__, val(KS+1,i,j) )
       call CHECK( __LINE__, val(KS,i,j) )

       call CHECK( __LINE__, mom(KS+1,i  ,j) )
       call CHECK( __LINE__, mom(KS+1,i,j+1) )
       call CHECK( __LINE__, val(KS+3,i,j) )
       call CHECK( __LINE__, val(KS+2,i,j) )

#endif
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS-1.
       ! The flux at KS-1 can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP

       vel = ( 0.5_RP * ( mom(KS,i,j)+mom(KS,i,j+1) ) ) &
           / ( F2H(KS,1,I_XVZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i,j+1) ) &
             + F2H(KS,2,I_XVZ) &
             * 0.5_RP * ( DENS(KS,i,j)+DENS(KS,i,j+1) ) )
       flux(KS,i,j) = J33G * vel &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS,i,j) * num_diff(KS,i,j)
       vel = ( 0.5_RP * ( mom(KE-1,i,j)+mom(KE-1,i,j+1) ) ) &
           / ( F2H(KE-1,1,I_XVZ) &
             * 0.5_RP * ( DENS(KE,i,j)+DENS(KE,i,j+1) ) &
             + F2H(KE-1,2,I_XVZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i,j+1) ) )
       flux(KE-1,i,j) = J33G * vel &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-1,i,j) * num_diff(KE-1,i,j)

       vel = ( 0.5_RP * ( mom(KS+1,i,j)+mom(KS+1,i,j+1) ) ) &
           / ( F2H(KS+1,1,I_XVZ) &
             * 0.5_RP * ( DENS(KS+2,i,j)+DENS(KS+2,i,j+1) ) &
             + F2H(KS+1,2,I_XVZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i,j+1) ) )
       flux(KS+1,i,j) = J33G * vel &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KS+1,i,j) * num_diff(KS+1,i,j)
       vel = ( 0.5_RP * ( mom(KE-2,i,j)+mom(KE-2,i,j+1) ) ) &
           / ( F2H(KE-2,1,I_XVZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i,j+1) ) &
             + F2H(KE-2,2,I_XVZ) &
             * 0.5_RP * ( DENS(KE-2,i,j)+DENS(KE-2,i,j+1) ) )
       flux(KE-2,i,j) = J33G * vel &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) ) &
                   + GSQRT(KE-2,i,j) * num_diff(KE-2,i,j)

       flux(KE,i,j) = 0.0_RP
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxZ_XVZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation J13-flux at XVZ
  subroutine ATMOS_DYN_FVM_fluxJ13_XVZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J13G, MAPF, &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J13G    (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J13G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
       vel = ( F2H(k,1,I_XVZ) &
             * 0.25_RP * ( mom(k+1,i,j)+mom(k+1,i-1,j)+mom(k+1,i,j+1)+mom(k+1,i-1,j+1) ) &
             + F2H(k,2,I_XVZ) &
             * 0.25_RP * ( mom(k,i,j)+mom(k,i-1,j)+mom(k,i,j+1)+mom(k,i-1,j+1) ) ) &
           / ( F2H(k,1,I_XVZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i,j+1) ) &
             + F2H(k,2,I_XVZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i,j+1) ) )
       vel = vel * J13G(k,i,j)
       flux(k,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) )
    enddo
    enddo
    enddo

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J13G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS-1.
       ! The flux at KS-1 can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP

       vel = ( F2H(KS,1,I_XVZ) &
             * 0.25_RP * ( mom(KS+1,i,j)+mom(KS+1,i-1,j)+mom(KS+1,i,j+1)+mom(KS+1,i-1,j+1) ) &
             + F2H(KS,2,I_XVZ) &
             * 0.25_RP * ( mom(KS,i,j)+mom(KS,i-1,j)+mom(KS,i,j+1)+mom(KS,i-1,j+1) ) ) &
           / ( F2H(KS,1,I_XVZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i,j+1) ) &
             + F2H(KS,2,I_XVZ) &
             * 0.5_RP * ( DENS(KS,i,j)+DENS(KS,i,j+1) ) )
       vel = vel * J13G(KS,i,j)
       flux(KS,i,j) = vel / MAPF(i,j,+2) &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-1,1,I_XVZ) &
             * 0.25_RP * ( mom(KE,i,j)+mom(KE,i-1,j)+mom(KE,i,j+1)+mom(KE,i-1,j+1) ) &
             + F2H(KE-1,2,I_XVZ) &
             * 0.25_RP * ( mom(KE-1,i,j)+mom(KE-1,i-1,j)+mom(KE-1,i,j+1)+mom(KE-1,i-1,j+1) ) ) &
           / ( F2H(KE-1,1,I_XVZ) &
             * 0.5_RP * ( DENS(KE,i,j)+DENS(KE,i,j+1) ) &
             + F2H(KE-1,2,I_XVZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i,j+1) ) )
       vel = vel * J13G(KE-1,i,j)
       flux(KE-1,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KS+1,1,I_XVZ) &
             * 0.25_RP * ( mom(KS+2,i,j)+mom(KS+2,i-1,j)+mom(KS+2,i,j+1)+mom(KS+2,i-1,j+1) ) &
             + F2H(KS+1,2,I_XVZ) &
             * 0.25_RP * ( mom(KS+1,i,j)+mom(KS+1,i-1,j)+mom(KS+1,i,j+1)+mom(KS+1,i-1,j+1) ) ) &
           / ( F2H(KS+1,1,I_XVZ) &
             * 0.5_RP * ( DENS(KS+2,i,j)+DENS(KS+2,i,j+1) ) &
             + F2H(KS+1,2,I_XVZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i,j+1) ) )
       vel = vel * J13G(KS+1,i,j)
       flux(KS+1,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-2,1,I_XVZ) &
             * 0.25_RP * ( mom(KE-1,i,j)+mom(KE-1,i-1,j)+mom(KE-1,i,j+1)+mom(KE-1,i-1,j+1) ) &
             + F2H(KE-2,2,I_XVZ) &
             * 0.25_RP * ( mom(KE-2,i,j)+mom(KE-2,i-1,j)+mom(KE-2,i,j+1)+mom(KE-2,i-1,j+1) ) ) &
           / ( F2H(KE-2,1,I_XVZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i,j+1) ) &
             + F2H(KE-2,2,I_XVZ) &
             * 0.5_RP * ( DENS(KE-2,i,j)+DENS(KE-2,i,j+1) ) )
       vel = vel * J13G(KE-2,i,j)
       flux(KE-2,i,j) = vel / MAPF(i,j,+2) &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       flux(KE  ,i,j) = 0.0_RP
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxJ13_XVZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation J23-flux at XVZ
  subroutine ATMOS_DYN_FVM_fluxJ23_XVZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, J23G, MAPF, &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: J23G    (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J23G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
    do k = KS+2, KE-3
       vel = ( F2H(k,1,I_XVZ) &
             * mom(k+1,i,j) &
             + F2H(k,2,I_XVZ) &
             * mom(k,i,j) ) &
           / ( F2H(k,1,I_XVZ) &
             * 0.5_RP * ( DENS(k+1,i,j)+DENS(k+1,i,j+1) ) &
             + F2H(k,2,I_XVZ) &
             * 0.5_RP * ( DENS(k,i,j)+DENS(k,i,j+1) ) )
       vel = vel * J23G(k,i,j)
       flux(k,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( F51 * ( val(k+3,i,j)+val(k-2,i,j) ) &
                       + F52 * ( val(k+2,i,j)+val(k-1,i,j) ) &
                       + F53 * ( val(k+1,i,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k+3,i,j)-val(k-2,i,j) ) &
                       + F54 * ( val(k+2,i,j)-val(k-1,i,j) ) &
                       + F55 * ( val(k+1,i,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) )
    enddo
    enddo
    enddo

    !$omp parallel do default(none) private(i,j) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,J23G,MAPF) &
    !$omp shared(GSQRT,CDZ)
    do j = JJS, JJE
    do i = IIS, IIE
       ! The boundary condition is qflx_hi + qflxJ13 + qfluxJ23 = 0 at KS-1.
       ! The flux at KS-1 can be non-zero.
       ! To reduce calculations, all the fluxes are set to zero.
       flux(KS-1,i,j) = 0.0_RP

       vel = ( F2H(KS,1,I_XVZ) &
             * mom(KS+1,i,j) &
             + F2H(KS,2,I_XVZ) &
             * mom(KS,i,j) ) &
           / ( F2H(KS,1,I_XVZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i,j+1) ) &
             + F2H(KS,2,I_XVZ) &
             * 0.5_RP * ( DENS(KS,i,j)+DENS(KS,i,j+1) ) )
       vel = vel * J23G(KS,i,j)
       flux(KS,i,j) = vel / MAPF(i,j,+1) &
                   * ( F2 * ( val(KS+1,i,j)+val(KS,i,j) ) &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KS,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS+2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-1,1,I_XVZ) &
             * mom(KE,i,j) &
             + F2H(KE-1,2,I_XVZ) &
             * mom(KE-1,i,j) ) &
           / ( F2H(KE-1,1,I_XVZ) &
             * 0.5_RP * ( DENS(KE,i,j)+DENS(KE,i,j+1) ) &
             + F2H(KE-1,2,I_XVZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i,j+1) ) )
       vel = vel * J23G(KE-1,i,j)
       flux(KE-1,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( 2.0_RP * val(KE,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE-2,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + F2 * ( val(KE,i,j)+val(KE-1,i,j) ) &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KS+1,1,I_XVZ) &
             * mom(KS+2,i,j) &
             + F2H(KS+1,2,I_XVZ) &
             * mom(KS+1,i,j) ) &
           / ( F2H(KS+1,1,I_XVZ) &
             * 0.5_RP * ( DENS(KS+2,i,j)+DENS(KS+2,i,j+1) ) &
             + F2H(KS+1,2,I_XVZ) &
             * 0.5_RP * ( DENS(KS+1,i,j)+DENS(KS+1,i,j+1) ) )
       vel = vel * J23G(KS+1,i,j)
       flux(KS+1,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( 2.0_RP * val(KS+2,i,j) + 5.0_RP * val(KS+1,i,j) - val(KS,i,j) ) / 6.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( -  3.0_RP * val(KS,i,j)  &
                         + 27.0_RP * val(KS+1,i,j)  &
                         + 47.0_RP * val(KS+2,i,j)  &
                         - 13.0_RP * val(KS+3,i,j) &
                         + 2.0_RP * val(KS+4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       vel = ( F2H(KE-2,1,I_XVZ) &
             * mom(KE-1,i,j) &
             + F2H(KE-2,2,I_XVZ) &
             * mom(KE-2,i,j) ) &
           / ( F2H(KE-2,1,I_XVZ) &
             * 0.5_RP * ( DENS(KE-1,i,j)+DENS(KE-1,i,j+1) ) &
             + F2H(KE-2,2,I_XVZ) &
             * 0.5_RP * ( DENS(KE-2,i,j)+DENS(KE-2,i,j+1) ) )
       vel = vel * J23G(KE-2,i,j)
       flux(KE-2,i,j) = vel / MAPF(i,j,+1) &
                   * ( ( -  3.0_RP * val(KE,i,j)  &
                         + 27.0_RP * val(KE-1,i,j)  &
                         + 47.0_RP * val(KE-2,i,j)  &
                         - 13.0_RP * val(KE-3,i,j) &
                         + 2.0_RP * val(KE-4,i,j) ) / 60.0_RP &
                     * ( 0.5_RP + sign(0.5_RP,vel) ) &
                + ( 2.0_RP * val(KE-2,i,j) + 5.0_RP * val(KE-1,i,j) - val(KE,i,j) ) / 6.0_RP &
                     * ( 0.5_RP - sign(0.5_RP,vel) ) )

       flux(KE  ,i,j) = 0.0_RP
    enddo
    enddo

    return
  end subroutine ATMOS_DYN_FVM_fluxJ23_XVZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation X-flux at XV
  subroutine ATMOS_DYN_FVM_fluxX_XVZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, MAPF,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,GSQRT,MAPF,num_diff)
    do j = JJS, JJE
    do i = IIS-1, IIE
    do k = KS, KE
#ifdef DEBUG
       call CHECK( __LINE__, mom(k,i  ,j) )
       call CHECK( __LINE__, mom(k,i,j-1) )

       call CHECK( __LINE__, val(k,i,j) )
       call CHECK( __LINE__, val(k,i+1,j) )

       call CHECK( __LINE__, val(k,i-1,j) )
       call CHECK( __LINE__, val(k,i+2,j) )

       call CHECK( __LINE__, val(k,i-2,j) )
       call CHECK( __LINE__, val(k,i+3,j) )

#endif
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i,j+1) ) ) &
           / ( 0.25_RP * ( DENS(k,i,j)+DENS(k,i+1,j)+DENS(k,i,j+1)+DENS(k,i+1,j+1) ) )
       flux(k,i,j) = GSQRT(k,i,j) / MAPF(i,j,+2) * vel &
                   * ( ( F51 * ( val(k,i+3,j)+val(k,i-2,j) ) &
                       + F52 * ( val(k,i+2,j)+val(k,i-1,j) ) &
                       + F53 * ( val(k,i+1,j)+val(k,i,j) ) ) &
                     - ( F51 * ( val(k,i+3,j)-val(k,i-2,j) ) &
                       + F54 * ( val(k,i+2,j)-val(k,i-1,j) ) &
                       + F55 * ( val(k,i+1,j)-val(k,i,j) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxX_XVZ_ud5

  !-----------------------------------------------------------------------------
  !> calculation Y-flux at XV
  subroutine ATMOS_DYN_FVM_fluxY_XVZ_ud5( &
       flux,              &
       mom, val, DENS,    &
       GSQRT, MAPF,       &
       num_diff,          &
       CDZ,               &
       IIS, IIE, JJS, JJE )
    implicit none

    real(RP), intent(inout) :: flux    (KA,IA,JA)
    real(RP), intent(in)  :: mom     (KA,IA,JA)
    real(RP), intent(in)  :: val     (KA,IA,JA)
    real(RP), intent(in)  :: DENS    (KA,IA,JA)
    real(RP), intent(in)  :: GSQRT   (KA,IA,JA)
    real(RP), intent(in)  :: MAPF    (   IA,JA,2)
    real(RP), intent(in)  :: num_diff(KA,IA,JA)
    real(RP), intent(in)  :: CDZ     (KA)
    integer,  intent(in)  :: IIS, IIE, JJS, JJE

    real(RP) :: vel
    integer  :: k, i, j
    !---------------------------------------------------------------------------

    ! note that y-index is added by -1

    !$omp parallel do default(none) private(i,j,k) OMP_SCHEDULE_ collapse(2) &
    !$omp private(vel) &
    !$omp shared(JJS,JJE,IIS,IIE,KS,KE,mom,val,DENS,flux,GSQRT,MAPF,num_diff)
    do j = JJS, JJE+1
    do i = IIS, IIE
    do k = KS, KE
#ifdef DEBUG
       call CHECK( __LINE__, mom(k,i  ,j) )
       call CHECK( __LINE__, mom(k,i,j-1) )

       call CHECK( __LINE__, val(k,i,j-1) )
       call CHECK( __LINE__, val(k,i,j) )

       call CHECK( __LINE__, val(k,i,j-2) )
       call CHECK( __LINE__, val(k,i,j+1) )

       call CHECK( __LINE__, val(k,i,j-3) )
       call CHECK( __LINE__, val(k,i,j+2) )

#endif
       vel = ( 0.5_RP * ( mom(k,i,j)+mom(k,i,j-1) ) ) &
           / ( DENS(k,i,j) )
       flux(k,i,j-1) = GSQRT(k,i,j) / MAPF(i,j,+1) * vel &
                   * ( ( F51 * ( val(k,i,j+2)+val(k,i,j-3) ) &
                       + F52 * ( val(k,i,j+1)+val(k,i,j-2) ) &
                       + F53 * ( val(k,i,j)+val(k,i,j-1) ) ) &
                     - ( F51 * ( val(k,i,j+2)-val(k,i,j-3) ) &
                       + F54 * ( val(k,i,j+1)-val(k,i,j-2) ) &
                       + F55 * ( val(k,i,j)-val(k,i,j-1) ) ) * sign(1.0_RP,vel) ) &
                   + GSQRT(k,i,j) * num_diff(k,i,j)
    enddo
    enddo
    enddo
#ifdef DEBUG
    k = IUNDEF; i = IUNDEF; j = IUNDEF
#endif

    return
  end subroutine ATMOS_DYN_FVM_fluxY_XVZ_ud5







end module scale_atmos_dyn_fvm_flux_ud5

!--
! vi:set readonly sw=4 ts=8
!
!Local Variables:
!mode: f90
!buffer-read-only: t
!End:
!
!++
