!-------------------------------------------------------------------------------------------
!> module NET2G vars
!!
!! @par Description
!!          Variables module for post-process of scale
!!
!! @author Team SCALE
!!
!! @par History
!! @li  2015-02-03 (R.Yoshida)  original
!!
!<
!-------------------------------------------------------------------------------------------
module mod_net2g_vars
  !-----------------------------------------------------------------------------------------
  !
  !++ used modules
  !
  !-----------------------------------------------------------------------------------------
  implicit none
  private
  !++ included parameters
#include "inc_net2g.h"
  !-----------------------------------------------------------------------------------------
  !
  !++ Public procedure
  !
  !-----------------------------------------------------------------------------------------
  !
  !++ Public parameters & variables
  !
  integer,         public :: START_TSTEP    = 1
  integer,         public :: END_TSTEP      = 1
  integer,         public :: INC_TSTEP      = 1
  integer,         public :: DOMAIN_NUM     = 1
  integer,         public :: VCOUNT         = 1
  integer,         public :: ZCOUNT         = 0
  integer,         public :: ZSTART         = 1
  real,            public :: TARGET_ZLEV(max_zcount) = -1.
  real(DP),        public :: EXTRA_TINTERVAL = -9.999
  character(5),    public :: EXTRA_TUNIT    = ""
  character(CLNG), public :: IDIR           = "./"
  character(CLNG), public :: ODIR           = "."
  character(CLNG), public :: CONFFILE       = "./run.conf"
  character(CMID), public :: VNAME(max_vcount) = ""
  character(CSHT), public :: Z_LEV_TYPE     = "original"
  character(5),    public :: DELT           = "1mn"
  character(15),   public :: STIME          = "00:00Z01JAN2000"
  character(15),   public :: FTIME          = "200001010000"
  character(15),   public :: FTIME_SAVE     = "200001010000"
  character(CLNG), public :: LOG_BASENAME   = "LOG"
  logical,         public :: LOG_ALL_OUTPUT = .false.
  logical,         public :: LOG_DBUG       = .false.
  integer,         public :: LOG_LEVEL      = 1
  logical,         public :: Z_LEV_LIST     = .false.
  logical,         public :: Z_MERGE_OUT    = .true.  ! only for slice and conv
  logical,         public :: T_MERGE_OUT    = .true.
  logical,         public :: MAPPROJ_ctl    = .true.

  character(CSHT), public :: ANALYSIS       = "ave" ! max, min, sum, ave

  integer,         public :: PRC_NUM_X
  integer,         public :: PRC_NUM_Y
  integer,         public :: TIME_STARTDATE(6)

  real(DP),            public :: MAPPROJECTION_basepoint_lon               !> position of base point (domain center) in real world [deg]
  real(DP),            public :: MAPPROJECTION_basepoint_lat               !> position of base point (domain center) in real world [deg]
  character(len=CSHT), public :: MAPPROJECTION_type             = 'NONE'   !> map projection type
  real(DP),            public :: MAPPROJECTION_LC_lat1                     !> standard latitude1 for L.C. projection [deg]
  real(DP),            public :: MAPPROJECTION_LC_lat2                     !> standard latitude2 for L.C. projection [deg]

  character(len=CLNG), public :: FILE_HISTORY_DEFAULT_BASENAME  = ''       !> Base name of the file
  real(DP),            public :: FILE_HISTORY_DEFAULT_TINTERVAL = -1.0_DP  !> Time interval
  character(len=CSHT), public :: FILE_HISTORY_DEFAULT_TUNIT     = ''       !> Time unit

  character(len=CSHT), public :: FILE_HISTORY_DEFAULT_ZDIM      = 'native'

  logical,             public :: FILE_HISTORY_CARTESC_BOUNDARY  = .false.

  integer,         public :: FID_LOG        = 22
  logical,         public :: LOUT           = .false.

  character(CLNG), public :: fname_bank(max_fcount)

end module mod_net2g_vars
