!-------------------------------------------------------------------------------
!> module TIME
!!
!! @par Description
!!          Calendar date and time module
!!
!! @author Team SCALE
!!
!! @par History
!! @li      2012-07-19 (S.Nishizawa) [new] imported from SCALE scale_time
!!
!<
!-------------------------------------------------------------------------------
!  Warning: This file was generated from dc_calendar.f90.erb.
!           Do not edit this file.
!-------------------------------------------------------------------------------
module dc_calendar
  !-----------------------------------------------------------------------------
  !
  !++ used modules
  !
  use dc_log, only: &
     LOG_LMSG, &
     Log
  use dc_types, only: &
     SP, &
     DP
  !-----------------------------------------------------------------------------
  implicit none
  private
  !-----------------------------------------------------------------------------
  !
  !++ Public procedure
  !
  public :: CalendarInit
  public :: CalendarYmdhms2sec
  public :: CalendarSec2ymdhms

  interface CalendarYmdhms2sec
     module procedure CalendarYmdhms2secSP
     module procedure CalendarYmdhms2secDP
  end interface CalendarYmdhms2sec

  interface CalendarSec2ymdhms
     module procedure CalendarSec2ymdhmsSP
     module procedure CalendarSec2ymdhmsDP
  end interface CalendarSec2ymdhms

  !-----------------------------------------------------------------------------
  !
  !++ Public parameters & variables
  !
  !-----------------------------------------------------------------------------
  !
  !++ Private procedure
  !
  !-----------------------------------------------------------------------------
  !
  !++ Private parameters & variables
  !
  real(DP), private, parameter :: TIME_HOUR    =  24.D0
  real(DP), private, parameter :: TIME_MIN     =  60.D0
  real(DP), private, parameter :: TIME_SEC     =  60.D0

  character(len=LOG_LMSG), private :: message
  !-----------------------------------------------------------------------------
contains

  !-----------------------------------------------------------------------------
  !> Setup time
  !-----------------------------------------------------------------------------
  subroutine CalendarInit
    implicit none

    return
  end subroutine CalendarInit

  !-----------------------------------------------------------------------------
  ! interface CalendarYmdhms2sec
  !-----------------------------------------------------------------------------
  !> convert several units to second
  !@todo fit to gregorian calendar
  !-----------------------------------------------------------------------------
  subroutine CalendarYmdhms2secSP( &
     second, &
     value,  &
     unit    )
    implicit none

    real(SP),         intent(out) :: second
    real(SP),         intent( in) :: value
    character(len=*), intent( in) :: unit
    !---------------------------------------------------------------------------

    select case(trim(unit))
    case('MSEC','msec')
       second = value * 1.0E-3_SP
    case('SEC','sec','s')
       second = value
    case('MIN','min')
       second = value * TIME_SEC
    case('HOUR','hour','h')
       second = value * TIME_SEC * TIME_MIN
    case('DAY','day')
       second = value * TIME_SEC * TIME_MIN * TIME_HOUR
    case default
       write(message,*) ' xxx Unsupported UNIT:', trim(unit), value
       call Log('E', message)
    endselect

    return
  end subroutine CalendarYmdhms2secSP
  subroutine CalendarYmdhms2secDP( &
     second, &
     value,  &
     unit    )
    implicit none

    real(DP),         intent(out) :: second
    real(DP),         intent( in) :: value
    character(len=*), intent( in) :: unit
    !---------------------------------------------------------------------------

    select case(trim(unit))
    case('MSEC','msec')
       second = value * 1.0E-3_DP
    case('SEC','sec','s')
       second = value
    case('MIN','min')
       second = value * TIME_SEC
    case('HOUR','hour','h')
       second = value * TIME_SEC * TIME_MIN
    case('DAY','day')
       second = value * TIME_SEC * TIME_MIN * TIME_HOUR
    case default
       write(message,*) ' xxx Unsupported UNIT:', trim(unit), value
       call Log('E', message)
    endselect

    return
  end subroutine CalendarYmdhms2secDP

  !-----------------------------------------------------------------------------
  ! interface CalendarSec2ymdhms
  !-----------------------------------------------------------------------------
  !> convert second to several units
  !@todo fit to gregorian calendar
  !-----------------------------------------------------------------------------
  subroutine CalendarSec2ymdhmsSP( &
     value,  &
     second, &
     unit    )
    implicit none

    real(SP),         intent(out) :: value
    real(SP),         intent( in) :: second
    character(len=*), intent( in) :: unit
    !---------------------------------------------------------------------------

    select case(trim(unit))
    case('MSEC', 'msec')
       value = second / 1.0E-3_SP
    case('SEC', 'seconds', 'sec', 's')
       value = second
    case('MIN', 'mins', 'min')
       value = second / TIME_SEC
    case('HOUR', 'hours', 'hour', 'h')
       value = second / (TIME_SEC * TIME_MIN)
    case('DAY', 'days', 'day')
       value = second / (TIME_SEC * TIME_MIN * TIME_HOUR)
    case default
       write(message,*) ' xxx Unsupported UNIT:', trim(unit), value
       call Log('E', message)
    endselect

    return
  end subroutine CalendarSec2ymdhmsSP
  subroutine CalendarSec2ymdhmsDP( &
     value,  &
     second, &
     unit    )
    implicit none

    real(DP),         intent(out) :: value
    real(DP),         intent( in) :: second
    character(len=*), intent( in) :: unit
    !---------------------------------------------------------------------------

    select case(trim(unit))
    case('MSEC', 'msec')
       value = second / 1.0E-3_DP
    case('SEC', 'seconds', 'sec', 's')
       value = second
    case('MIN', 'mins', 'min')
       value = second / TIME_SEC
    case('HOUR', 'hours', 'hour', 'h')
       value = second / (TIME_SEC * TIME_MIN)
    case('DAY', 'days', 'day')
       value = second / (TIME_SEC * TIME_MIN * TIME_HOUR)
    case default
       write(message,*) ' xxx Unsupported UNIT:', trim(unit), value
       call Log('E', message)
    endselect

    return
  end subroutine CalendarSec2ymdhmsDP

  !-----------------------------------------------------------------------------
end module dc_calendar
!-------------------------------------------------------------------------------


!--
! vi:set readonly sw=4 ts=8
!
!Local Variables:
!mode: f90
!buffer-read-only: t
!End:
!
!++
