package tmp;

import java.util.Arrays;
import java.util.List;

import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntExpression;
import kodkod.ast.Relation;
import kodkod.ast.Variable;
import kodkod.ast.operator.FormulaOperator;
import kodkod.engine.Solution;
import kodkod.engine.Solver;
import kodkod.engine.config.Options;
import kodkod.engine.satlab.SATFactory;
import kodkod.instance.Bounds;
import kodkod.instance.TupleFactory;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;

/*
  ==================================================
    kodkod formula:
  ==================================================
    nat/Zero in nat/Natural &&
    nat/One in nat/Natural &&
    one nat/Zero &&
    lone nat/One &&
    (nat/ord/Ord . (nat/ord/Ord -> nat/ord/Ord.First)) in nat/Natural &&
    (nat/ord/Ord . (nat/ord/Ord -> nat/ord/Ord.Next)) in (nat/Natural ->
    nat/Natural) &&
    ord[nat/ord/Ord.Next, nat/Natural, nat/ord/Ord.First, ] &&
    nat/ord/Ord.First in nat/Zero &&
    (nat/ord/Ord.First . nat/ord/Ord.Next) in nat/One &&
    (some showExpectSum10_x: nat/Natural |
      showExpectSum10_x in {setsum_n: nat/Natural | #(setsum_n . ^~
      nat/ord/Ord.Next) = (sum setsum_x: {showExpectSum10_n: nat/Natural |
      showExpectSum10_n in ({add_n: nat/Natural | #(add_n . ^~nat/ord/Ord.Next) =
      (#({add_n: nat/Natural | #(add_n . ^~nat/ord/Ord.Next) = (#({add_n:
      nat/Natural | #(add_n . ^~nat/ord/Ord.Next) = (#(nat/One . ^~
      nat/ord/Ord.Next) + #(nat/One . ^~nat/ord/Ord.Next))} . ^~nat/ord/Ord.Next
      ) + #({add_n: nat/Natural | #(add_n . ^~nat/ord/Ord.Next) = (#(nat/One . ^
      ~nat/ord/Ord.Next) + #(nat/One . ^~nat/ord/Ord.Next))} . ^~
      nat/ord/Ord.Next))} . ^~nat/ord/Ord.Next) + #(nat/One . ^~nat/ord/Ord.Next
      ))} . ^~nat/ord/Ord.Next)} | #(setsum_x . ^~nat/ord/Ord.Next))}) &&
    Int/next = Int/next &&
    seq/Int = seq/Int &&
    String = String &&
    this/Univ = this/Univ &&
    nat/Natural = nat/Natural &&
    nat/ord/Ord = nat/ord/Ord &&
    nat/Zero = nat/Zero &&
    nat/One = nat/One &&
    nat/ord/Ord.First = nat/ord/Ord.First &&
    nat/ord/Ord.Next = nat/ord/Ord.Next &&
     =
  ==================================================
*/
public final class OldNatCorrect {

public static void main(String[] args) throws Exception {

Relation x0 = Relation.nary("Int/next", 2);
Relation x1 = Relation.unary("seq/Int");
Relation x2 = Relation.unary("String");
Relation x3 = Relation.unary("this/Univ");
Relation x4 = Relation.unary("nat/Natural");
Relation x5 = Relation.unary("nat/ord/Ord");
Relation x6 = Relation.unary("nat/Zero");
Relation x7 = Relation.unary("nat/One");
Relation x8 = Relation.unary("nat/ord/Ord.First");
Relation x9 = Relation.nary("nat/ord/Ord.Next", 2);
Relation x10 = Relation.unary("");

List<String> atomlist = Arrays.asList(
 "nat/Natural$0", "nat/Natural$1", "nat/Natural$10", "nat/Natural$11", "nat/Natural$12",
 "nat/Natural$13", "nat/Natural$14", "nat/Natural$15", "nat/Natural$16", "nat/Natural$17", "nat/Natural$18",
 "nat/Natural$2", "nat/Natural$3", "nat/Natural$4", "nat/Natural$5", "nat/Natural$6", "nat/Natural$7",
 "nat/Natural$8", "nat/Natural$9", "nat/ord/Ord$0", "unused0"
);

Universe universe = new Universe(atomlist);
TupleFactory factory = universe.factory();
Bounds bounds = new Bounds(universe);

TupleSet x0_upper = factory.noneOf(2);
bounds.boundExactly(x0, x0_upper);

TupleSet x1_upper = factory.noneOf(1);
bounds.boundExactly(x1, x1_upper);

TupleSet x2_upper = factory.noneOf(1);
bounds.boundExactly(x2, x2_upper);

TupleSet x3_upper = factory.noneOf(1);
x3_upper.add(factory.tuple("unused0"));
bounds.bound(x3, x3_upper);

TupleSet x4_upper = factory.noneOf(1);
x4_upper.add(factory.tuple("nat/Natural$0"));
x4_upper.add(factory.tuple("nat/Natural$1"));
x4_upper.add(factory.tuple("nat/Natural$2"));
x4_upper.add(factory.tuple("nat/Natural$3"));
x4_upper.add(factory.tuple("nat/Natural$4"));
x4_upper.add(factory.tuple("nat/Natural$5"));
x4_upper.add(factory.tuple("nat/Natural$6"));
x4_upper.add(factory.tuple("nat/Natural$7"));
x4_upper.add(factory.tuple("nat/Natural$8"));
x4_upper.add(factory.tuple("nat/Natural$9"));
x4_upper.add(factory.tuple("nat/Natural$10"));
x4_upper.add(factory.tuple("nat/Natural$11"));
x4_upper.add(factory.tuple("nat/Natural$12"));
x4_upper.add(factory.tuple("nat/Natural$13"));
x4_upper.add(factory.tuple("nat/Natural$14"));
x4_upper.add(factory.tuple("nat/Natural$15"));
x4_upper.add(factory.tuple("nat/Natural$16"));
x4_upper.add(factory.tuple("nat/Natural$17"));
x4_upper.add(factory.tuple("nat/Natural$18"));
bounds.boundExactly(x4, x4_upper);

TupleSet x5_upper = factory.noneOf(1);
x5_upper.add(factory.tuple("nat/ord/Ord$0"));
bounds.boundExactly(x5, x5_upper);

TupleSet x6_upper = factory.noneOf(1);
x6_upper.add(factory.tuple("nat/Natural$0"));
x6_upper.add(factory.tuple("nat/Natural$1"));
x6_upper.add(factory.tuple("nat/Natural$2"));
x6_upper.add(factory.tuple("nat/Natural$3"));
x6_upper.add(factory.tuple("nat/Natural$4"));
x6_upper.add(factory.tuple("nat/Natural$5"));
x6_upper.add(factory.tuple("nat/Natural$6"));
x6_upper.add(factory.tuple("nat/Natural$7"));
x6_upper.add(factory.tuple("nat/Natural$8"));
x6_upper.add(factory.tuple("nat/Natural$9"));
x6_upper.add(factory.tuple("nat/Natural$10"));
x6_upper.add(factory.tuple("nat/Natural$11"));
x6_upper.add(factory.tuple("nat/Natural$12"));
x6_upper.add(factory.tuple("nat/Natural$13"));
x6_upper.add(factory.tuple("nat/Natural$14"));
x6_upper.add(factory.tuple("nat/Natural$15"));
x6_upper.add(factory.tuple("nat/Natural$16"));
x6_upper.add(factory.tuple("nat/Natural$17"));
x6_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x6, x6_upper);

TupleSet x7_upper = factory.noneOf(1);
x7_upper.add(factory.tuple("nat/Natural$0"));
x7_upper.add(factory.tuple("nat/Natural$1"));
x7_upper.add(factory.tuple("nat/Natural$2"));
x7_upper.add(factory.tuple("nat/Natural$3"));
x7_upper.add(factory.tuple("nat/Natural$4"));
x7_upper.add(factory.tuple("nat/Natural$5"));
x7_upper.add(factory.tuple("nat/Natural$6"));
x7_upper.add(factory.tuple("nat/Natural$7"));
x7_upper.add(factory.tuple("nat/Natural$8"));
x7_upper.add(factory.tuple("nat/Natural$9"));
x7_upper.add(factory.tuple("nat/Natural$10"));
x7_upper.add(factory.tuple("nat/Natural$11"));
x7_upper.add(factory.tuple("nat/Natural$12"));
x7_upper.add(factory.tuple("nat/Natural$13"));
x7_upper.add(factory.tuple("nat/Natural$14"));
x7_upper.add(factory.tuple("nat/Natural$15"));
x7_upper.add(factory.tuple("nat/Natural$16"));
x7_upper.add(factory.tuple("nat/Natural$17"));
x7_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x7, x7_upper);

TupleSet x8_upper = factory.noneOf(1);
x8_upper.add(factory.tuple("nat/Natural$0"));
x8_upper.add(factory.tuple("nat/Natural$1"));
x8_upper.add(factory.tuple("nat/Natural$2"));
x8_upper.add(factory.tuple("nat/Natural$3"));
x8_upper.add(factory.tuple("nat/Natural$4"));
x8_upper.add(factory.tuple("nat/Natural$5"));
x8_upper.add(factory.tuple("nat/Natural$6"));
x8_upper.add(factory.tuple("nat/Natural$7"));
x8_upper.add(factory.tuple("nat/Natural$8"));
x8_upper.add(factory.tuple("nat/Natural$9"));
x8_upper.add(factory.tuple("nat/Natural$10"));
x8_upper.add(factory.tuple("nat/Natural$11"));
x8_upper.add(factory.tuple("nat/Natural$12"));
x8_upper.add(factory.tuple("nat/Natural$13"));
x8_upper.add(factory.tuple("nat/Natural$14"));
x8_upper.add(factory.tuple("nat/Natural$15"));
x8_upper.add(factory.tuple("nat/Natural$16"));
x8_upper.add(factory.tuple("nat/Natural$17"));
x8_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x8, x8_upper);

TupleSet x9_upper = factory.noneOf(2);
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$18")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$0")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$1")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$2")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$3")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$4")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$5")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$6")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$7")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$8")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$9")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$10")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$11")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$12")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$13")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$14")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$15")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$16")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$17")));
x9_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$18")));
bounds.bound(x9, x9_upper);

TupleSet x10_upper = factory.noneOf(1);
x10_upper.add(factory.tuple("nat/Natural$0"));
x10_upper.add(factory.tuple("nat/Natural$1"));
x10_upper.add(factory.tuple("nat/Natural$2"));
x10_upper.add(factory.tuple("nat/Natural$3"));
x10_upper.add(factory.tuple("nat/Natural$4"));
x10_upper.add(factory.tuple("nat/Natural$5"));
x10_upper.add(factory.tuple("nat/Natural$6"));
x10_upper.add(factory.tuple("nat/Natural$7"));
x10_upper.add(factory.tuple("nat/Natural$8"));
x10_upper.add(factory.tuple("nat/Natural$9"));
x10_upper.add(factory.tuple("nat/Natural$10"));
x10_upper.add(factory.tuple("nat/Natural$11"));
x10_upper.add(factory.tuple("nat/Natural$12"));
x10_upper.add(factory.tuple("nat/Natural$13"));
x10_upper.add(factory.tuple("nat/Natural$14"));
x10_upper.add(factory.tuple("nat/Natural$15"));
x10_upper.add(factory.tuple("nat/Natural$16"));
x10_upper.add(factory.tuple("nat/Natural$17"));
x10_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x10, x10_upper);


Formula x12=x6.in(x4);
Formula x13=x7.in(x4);
Formula x14=x6.one();
Formula x15=x7.lone();
Expression x18=x5.product(x8);
Expression x17=x5.join(x18);
Formula x16=x17.in(x4);
Expression x21=x5.product(x9);
Expression x20=x5.join(x21);
Expression x22=x4.product(x4);
Formula x19=x20.in(x22);
Formula x23=x9.totalOrder(x4,x8,x10);
Formula x24=x8.in(x6);
Expression x26=x8.join(x9);
Formula x25=x26.in(x7);
Variable x29=Variable.unary("showExpectSum10_x");
Decls x28=x29.oneOf(x4);
Variable x33=Variable.unary("setsum_n");
Decls x32=x33.oneOf(x4);
Expression x38=x9.transpose();
Expression x37=x38.closure();
Expression x36=x33.join(x37);
IntExpression x35=x36.count();
Variable x41=Variable.unary("setsum_x");
Variable x44=Variable.unary("showExpectSum10_n");
Decls x43=x44.oneOf(x4);
Variable x49=Variable.unary("add_n");
Decls x48=x49.oneOf(x4);
Expression x54=x9.transpose();
Expression x53=x54.closure();
Expression x52=x49.join(x53);
IntExpression x51=x52.count();
Variable x60=Variable.unary("add_n");
Decls x59=x60.oneOf(x4);
Expression x65=x9.transpose();
Expression x64=x65.closure();
Expression x63=x60.join(x64);
IntExpression x62=x63.count();
Variable x71=Variable.unary("add_n");
Decls x70=x71.oneOf(x4);
Expression x76=x9.transpose();
Expression x75=x76.closure();
Expression x74=x71.join(x75);
IntExpression x73=x74.count();
Expression x81=x9.transpose();
Expression x80=x81.closure();
Expression x79=x7.join(x80);
IntExpression x78=x79.count();
Expression x85=x9.transpose();
Expression x84=x85.closure();
Expression x83=x7.join(x84);
IntExpression x82=x83.count();
IntExpression x77=x78.plus(x82);
Formula x72=x73.eq(x77);
Expression x69=x72.comprehension(x70);
Expression x87=x9.transpose();
Expression x86=x87.closure();
Expression x68=x69.join(x86);
IntExpression x67=x68.count();
Variable x92=Variable.unary("add_n");
Decls x91=x92.oneOf(x4);
Expression x97=x9.transpose();
Expression x96=x97.closure();
Expression x95=x92.join(x96);
IntExpression x94=x95.count();
Expression x102=x9.transpose();
Expression x101=x102.closure();
Expression x100=x7.join(x101);
IntExpression x99=x100.count();
Expression x106=x9.transpose();
Expression x105=x106.closure();
Expression x104=x7.join(x105);
IntExpression x103=x104.count();
IntExpression x98=x99.plus(x103);
Formula x93=x94.eq(x98);
Expression x90=x93.comprehension(x91);
Expression x108=x9.transpose();
Expression x107=x108.closure();
Expression x89=x90.join(x107);
IntExpression x88=x89.count();
IntExpression x66=x67.plus(x88);
Formula x61=x62.eq(x66);
Expression x58=x61.comprehension(x59);
Expression x110=x9.transpose();
Expression x109=x110.closure();
Expression x57=x58.join(x109);
IntExpression x56=x57.count();
Expression x114=x9.transpose();
Expression x113=x114.closure();
Expression x112=x7.join(x113);
IntExpression x111=x112.count();
IntExpression x55=x56.plus(x111);
Formula x50=x51.eq(x55);
Expression x47=x50.comprehension(x48);
Expression x116=x9.transpose();
Expression x115=x116.closure();
Expression x46=x47.join(x115);
Formula x45=x44.in(x46);
Expression x42=x45.comprehension(x43);
Decls x40=x41.oneOf(x42);
Expression x120=x9.transpose();
Expression x119=x120.closure();
Expression x118=x41.join(x119);
IntExpression x117=x118.count();
IntExpression x39=x117.sum(x40);
Formula x34=x35.eq(x39);
Expression x31=x34.comprehension(x32);
Formula x30=x29.in(x31);
Formula x27=x30.forSome(x28);
Formula x121=x0.eq(x0);
Formula x122=x1.eq(x1);
Formula x123=x2.eq(x2);
Formula x124=x3.eq(x3);
Formula x125=x4.eq(x4);
Formula x126=x5.eq(x5);
Formula x127=x6.eq(x6);
Formula x128=x7.eq(x7);
Formula x129=x8.eq(x8);
Formula x130=x9.eq(x9);
Formula x131=x10.eq(x10);
Formula x11=Formula.compose(FormulaOperator.AND, x12, x13, x14, x15, x16, x19, x23, x24, x25, x27, x121, x122, x123, x124, x125, x126, x127, x128, x129, x130, x131);

Solver solver = new Solver();
solver.options().setSolver(SATFactory.DefaultSAT4J);
solver.options().setBitwidth(1);
//solver.options().setFlatten(false);
solver.options().setIntEncoding(Options.IntEncoding.TWOSCOMPLEMENT);
solver.options().setSymmetryBreaking(20);
solver.options().setSkolemDepth(0);
System.out.println("Solving...");
System.out.flush();
Solution sol = solver.solve(x11,bounds);
System.out.println(sol.toString());
}}

