package tmp;

import java.util.Arrays;
import java.util.List;

import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntExpression;
import kodkod.ast.Relation;
import kodkod.ast.Variable;
import kodkod.ast.operator.FormulaOperator;
import kodkod.engine.Solution;
import kodkod.engine.Solver;
import kodkod.engine.config.Options;
import kodkod.engine.satlab.SATFactory;
import kodkod.instance.Bounds;
import kodkod.instance.TupleFactory;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;

/*
  ==================================================
    kodkod formula:
  ==================================================
    nat/Zero in nat/Natural &&
    nat/One in nat/Natural &&
    one nat/Zero &&
    lone nat/One &&
    (nat/ord/Ord . (nat/ord/Ord -> nat/ord/Ord.First)) in nat/Natural &&
    (nat/ord/Ord . (nat/ord/Ord -> nat/ord/Ord.Next)) in (nat/Natural ->
    nat/Natural) &&
    ord[nat/ord/Ord.Next, nat/Natural, nat/ord/Ord.First, ] &&
    nat/ord/Ord.First in nat/Zero &&
    (nat/ord/Ord.First . nat/ord/Ord.Next) in nat/One &&
    (some showExpectSum10_x: nat/Natural |
      showExpectSum10_x in {setsum_n: nat/Natural | #(setsum_n . ^~
      nat/ord/Ord.Next) = (sum setsum_x: {showExpectSum10_n: nat/Natural |
      showExpectSum10_n in ({add_n: nat/Natural | #(add_n . ^~nat/ord/Ord.Next) =
      (#({add_n: nat/Natural | #(add_n . ^~nat/ord/Ord.Next) = (#({add_n:
      nat/Natural | #(add_n . ^~nat/ord/Ord.Next) = (#(nat/One . ^~
      nat/ord/Ord.Next) + #(nat/One . ^~nat/ord/Ord.Next))} . ^~nat/ord/Ord.Next
      ) + #({add_n: nat/Natural | #(add_n . ^~nat/ord/Ord.Next) = (#(nat/One . ^
      ~nat/ord/Ord.Next) + #(nat/One . ^~nat/ord/Ord.Next))} . ^~
      nat/ord/Ord.Next))} . ^~nat/ord/Ord.Next) + #(nat/One . ^~nat/ord/Ord.Next
      ))} . ^~nat/ord/Ord.Next)} | #(setsum_x . ^~nat/ord/Ord.Next))}) &&
    Int/next = Int/next &&
    seq/Int = seq/Int &&
    String = String &&
    nat/Natural = nat/Natural &&
    nat/ord/Ord = nat/ord/Ord &&
    nat/Zero = nat/Zero &&
    nat/One = nat/One &&
    nat/ord/Ord.First = nat/ord/Ord.First &&
    nat/ord/Ord.Next = nat/ord/Ord.Next &&
     =
  ==================================================
*/
public final class NewNatIncorrect {

public static void main(String[] args) throws Exception {

Relation x0 = Relation.nary("Int/next", 2);
Relation x1 = Relation.unary("seq/Int");
Relation x2 = Relation.unary("String");
Relation x3 = Relation.unary("nat/Natural");
Relation x4 = Relation.unary("nat/ord/Ord");
Relation x5 = Relation.unary("nat/Zero");
Relation x6 = Relation.unary("nat/One");
Relation x7 = Relation.unary("nat/ord/Ord.First");
Relation x8 = Relation.nary("nat/ord/Ord.Next", 2);
Relation x9 = Relation.unary("");

List<String> atomlist = Arrays.asList(
 "nat/Natural$0", "nat/Natural$1", "nat/Natural$10", "nat/Natural$11", "nat/Natural$12",
 "nat/Natural$13", "nat/Natural$14", "nat/Natural$15", "nat/Natural$16", "nat/Natural$17", "nat/Natural$18",
 "nat/Natural$2", "nat/Natural$3", "nat/Natural$4", "nat/Natural$5", "nat/Natural$6", "nat/Natural$7",
 "nat/Natural$8", "nat/Natural$9", "nat/ord/Ord$0"
);

Universe universe = new Universe(atomlist);
TupleFactory factory = universe.factory();
Bounds bounds = new Bounds(universe);

TupleSet x0_upper = factory.noneOf(2);
bounds.boundExactly(x0, x0_upper);

TupleSet x1_upper = factory.noneOf(1);
bounds.boundExactly(x1, x1_upper);

TupleSet x2_upper = factory.noneOf(1);
bounds.boundExactly(x2, x2_upper);

TupleSet x3_upper = factory.noneOf(1);
x3_upper.add(factory.tuple("nat/Natural$0"));
x3_upper.add(factory.tuple("nat/Natural$1"));
x3_upper.add(factory.tuple("nat/Natural$2"));
x3_upper.add(factory.tuple("nat/Natural$3"));
x3_upper.add(factory.tuple("nat/Natural$4"));
x3_upper.add(factory.tuple("nat/Natural$5"));
x3_upper.add(factory.tuple("nat/Natural$6"));
x3_upper.add(factory.tuple("nat/Natural$7"));
x3_upper.add(factory.tuple("nat/Natural$8"));
x3_upper.add(factory.tuple("nat/Natural$9"));
x3_upper.add(factory.tuple("nat/Natural$10"));
x3_upper.add(factory.tuple("nat/Natural$11"));
x3_upper.add(factory.tuple("nat/Natural$12"));
x3_upper.add(factory.tuple("nat/Natural$13"));
x3_upper.add(factory.tuple("nat/Natural$14"));
x3_upper.add(factory.tuple("nat/Natural$15"));
x3_upper.add(factory.tuple("nat/Natural$16"));
x3_upper.add(factory.tuple("nat/Natural$17"));
x3_upper.add(factory.tuple("nat/Natural$18"));
bounds.boundExactly(x3, x3_upper);

TupleSet x4_upper = factory.noneOf(1);
x4_upper.add(factory.tuple("nat/ord/Ord$0"));
bounds.boundExactly(x4, x4_upper);

TupleSet x5_upper = factory.noneOf(1);
x5_upper.add(factory.tuple("nat/Natural$0"));
x5_upper.add(factory.tuple("nat/Natural$1"));
x5_upper.add(factory.tuple("nat/Natural$2"));
x5_upper.add(factory.tuple("nat/Natural$3"));
x5_upper.add(factory.tuple("nat/Natural$4"));
x5_upper.add(factory.tuple("nat/Natural$5"));
x5_upper.add(factory.tuple("nat/Natural$6"));
x5_upper.add(factory.tuple("nat/Natural$7"));
x5_upper.add(factory.tuple("nat/Natural$8"));
x5_upper.add(factory.tuple("nat/Natural$9"));
x5_upper.add(factory.tuple("nat/Natural$10"));
x5_upper.add(factory.tuple("nat/Natural$11"));
x5_upper.add(factory.tuple("nat/Natural$12"));
x5_upper.add(factory.tuple("nat/Natural$13"));
x5_upper.add(factory.tuple("nat/Natural$14"));
x5_upper.add(factory.tuple("nat/Natural$15"));
x5_upper.add(factory.tuple("nat/Natural$16"));
x5_upper.add(factory.tuple("nat/Natural$17"));
x5_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x5, x5_upper);

TupleSet x6_upper = factory.noneOf(1);
x6_upper.add(factory.tuple("nat/Natural$0"));
x6_upper.add(factory.tuple("nat/Natural$1"));
x6_upper.add(factory.tuple("nat/Natural$2"));
x6_upper.add(factory.tuple("nat/Natural$3"));
x6_upper.add(factory.tuple("nat/Natural$4"));
x6_upper.add(factory.tuple("nat/Natural$5"));
x6_upper.add(factory.tuple("nat/Natural$6"));
x6_upper.add(factory.tuple("nat/Natural$7"));
x6_upper.add(factory.tuple("nat/Natural$8"));
x6_upper.add(factory.tuple("nat/Natural$9"));
x6_upper.add(factory.tuple("nat/Natural$10"));
x6_upper.add(factory.tuple("nat/Natural$11"));
x6_upper.add(factory.tuple("nat/Natural$12"));
x6_upper.add(factory.tuple("nat/Natural$13"));
x6_upper.add(factory.tuple("nat/Natural$14"));
x6_upper.add(factory.tuple("nat/Natural$15"));
x6_upper.add(factory.tuple("nat/Natural$16"));
x6_upper.add(factory.tuple("nat/Natural$17"));
x6_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x6, x6_upper);

TupleSet x7_upper = factory.noneOf(1);
x7_upper.add(factory.tuple("nat/Natural$0"));
x7_upper.add(factory.tuple("nat/Natural$1"));
x7_upper.add(factory.tuple("nat/Natural$2"));
x7_upper.add(factory.tuple("nat/Natural$3"));
x7_upper.add(factory.tuple("nat/Natural$4"));
x7_upper.add(factory.tuple("nat/Natural$5"));
x7_upper.add(factory.tuple("nat/Natural$6"));
x7_upper.add(factory.tuple("nat/Natural$7"));
x7_upper.add(factory.tuple("nat/Natural$8"));
x7_upper.add(factory.tuple("nat/Natural$9"));
x7_upper.add(factory.tuple("nat/Natural$10"));
x7_upper.add(factory.tuple("nat/Natural$11"));
x7_upper.add(factory.tuple("nat/Natural$12"));
x7_upper.add(factory.tuple("nat/Natural$13"));
x7_upper.add(factory.tuple("nat/Natural$14"));
x7_upper.add(factory.tuple("nat/Natural$15"));
x7_upper.add(factory.tuple("nat/Natural$16"));
x7_upper.add(factory.tuple("nat/Natural$17"));
x7_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x7, x7_upper);

TupleSet x8_upper = factory.noneOf(2);
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$0").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$1").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$2").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$3").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$4").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$5").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$6").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$7").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$8").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$9").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$10").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$11").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$12").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$13").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$14").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$15").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$16").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$17").product(factory.tuple("nat/Natural$18")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$0")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$1")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$2")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$3")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$4")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$5")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$6")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$7")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$8")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$9")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$10")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$11")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$12")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$13")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$14")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$15")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$16")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$17")));
x8_upper.add(factory.tuple("nat/Natural$18").product(factory.tuple("nat/Natural$18")));
bounds.bound(x8, x8_upper);

TupleSet x9_upper = factory.noneOf(1);
x9_upper.add(factory.tuple("nat/Natural$0"));
x9_upper.add(factory.tuple("nat/Natural$1"));
x9_upper.add(factory.tuple("nat/Natural$2"));
x9_upper.add(factory.tuple("nat/Natural$3"));
x9_upper.add(factory.tuple("nat/Natural$4"));
x9_upper.add(factory.tuple("nat/Natural$5"));
x9_upper.add(factory.tuple("nat/Natural$6"));
x9_upper.add(factory.tuple("nat/Natural$7"));
x9_upper.add(factory.tuple("nat/Natural$8"));
x9_upper.add(factory.tuple("nat/Natural$9"));
x9_upper.add(factory.tuple("nat/Natural$10"));
x9_upper.add(factory.tuple("nat/Natural$11"));
x9_upper.add(factory.tuple("nat/Natural$12"));
x9_upper.add(factory.tuple("nat/Natural$13"));
x9_upper.add(factory.tuple("nat/Natural$14"));
x9_upper.add(factory.tuple("nat/Natural$15"));
x9_upper.add(factory.tuple("nat/Natural$16"));
x9_upper.add(factory.tuple("nat/Natural$17"));
x9_upper.add(factory.tuple("nat/Natural$18"));
bounds.bound(x9, x9_upper);


Formula x11=x5.in(x3);
Formula x12=x6.in(x3);
Formula x13=x5.one();
Formula x14=x6.lone();
Expression x17=x4.product(x7);
Expression x16=x4.join(x17);
Formula x15=x16.in(x3);
Expression x20=x4.product(x8);
Expression x19=x4.join(x20);
Expression x21=x3.product(x3);
Formula x18=x19.in(x21);
Formula x22=x8.totalOrder(x3,x7,x9);
Formula x23=x7.in(x5);
Expression x25=x7.join(x8);
Formula x24=x25.in(x6);
Variable x28=Variable.unary("showExpectSum10_x");
Decls x27=x28.oneOf(x3);
Variable x32=Variable.unary("setsum_n");
Decls x31=x32.oneOf(x3);
Expression x37=x8.transpose();
Expression x36=x37.closure();
Expression x35=x32.join(x36);
IntExpression x34=x35.count();
Variable x40=Variable.unary("setsum_x");
Variable x43=Variable.unary("showExpectSum10_n");
Decls x42=x43.oneOf(x3);
Variable x48=Variable.unary("add_n");
Decls x47=x48.oneOf(x3);
Expression x53=x8.transpose();
Expression x52=x53.closure();
Expression x51=x48.join(x52);
IntExpression x50=x51.count();
Variable x59=Variable.unary("add_n");
Decls x58=x59.oneOf(x3);
Expression x64=x8.transpose();
Expression x63=x64.closure();
Expression x62=x59.join(x63);
IntExpression x61=x62.count();
Variable x70=Variable.unary("add_n");
Decls x69=x70.oneOf(x3);
Expression x75=x8.transpose();
Expression x74=x75.closure();
Expression x73=x70.join(x74);
IntExpression x72=x73.count();
Expression x80=x8.transpose();
Expression x79=x80.closure();
Expression x78=x6.join(x79);
IntExpression x77=x78.count();
Expression x84=x8.transpose();
Expression x83=x84.closure();
Expression x82=x6.join(x83);
IntExpression x81=x82.count();
IntExpression x76=x77.plus(x81);
Formula x71=x72.eq(x76);
Expression x68=x71.comprehension(x69);
Expression x86=x8.transpose();
Expression x85=x86.closure();
Expression x67=x68.join(x85);
IntExpression x66=x67.count();
Variable x91=Variable.unary("add_n");
Decls x90=x91.oneOf(x3);
Expression x96=x8.transpose();
Expression x95=x96.closure();
Expression x94=x91.join(x95);
IntExpression x93=x94.count();
Expression x101=x8.transpose();
Expression x100=x101.closure();
Expression x99=x6.join(x100);
IntExpression x98=x99.count();
Expression x105=x8.transpose();
Expression x104=x105.closure();
Expression x103=x6.join(x104);
IntExpression x102=x103.count();
IntExpression x97=x98.plus(x102);
Formula x92=x93.eq(x97);
Expression x89=x92.comprehension(x90);
Expression x107=x8.transpose();
Expression x106=x107.closure();
Expression x88=x89.join(x106);
IntExpression x87=x88.count();
IntExpression x65=x66.plus(x87);
Formula x60=x61.eq(x65);
Expression x57=x60.comprehension(x58);
Expression x109=x8.transpose();
Expression x108=x109.closure();
Expression x56=x57.join(x108);
IntExpression x55=x56.count();
Expression x113=x8.transpose();
Expression x112=x113.closure();
Expression x111=x6.join(x112);
IntExpression x110=x111.count();
IntExpression x54=x55.plus(x110);
Formula x49=x50.eq(x54);
Expression x46=x49.comprehension(x47);
Expression x115=x8.transpose();
Expression x114=x115.closure();
Expression x45=x46.join(x114);
Formula x44=x43.in(x45);
Expression x41=x44.comprehension(x42);
Decls x39=x40.oneOf(x41);
Expression x119=x8.transpose();
Expression x118=x119.closure();
Expression x117=x40.join(x118);
IntExpression x116=x117.count();
IntExpression x38=x116.sum(x39);
Formula x33=x34.eq(x38);
Expression x30=x33.comprehension(x31);
Formula x29=x28.in(x30);
Formula x26=x29.forSome(x27);
Formula x120=x0.eq(x0);
Formula x121=x1.eq(x1);
Formula x122=x2.eq(x2);
Formula x123=x3.eq(x3);
Formula x124=x4.eq(x4);
Formula x125=x5.eq(x5);
Formula x126=x6.eq(x6);
Formula x127=x7.eq(x7);
Formula x128=x8.eq(x8);
Formula x129=x9.eq(x9);
Formula x10=Formula.compose(FormulaOperator.AND, x11, x12, x13, x14, x15, x18, x22, x23, x24, x26, x120, x121, x122, x123, x124, x125, x126, x127, x128, x129);

Solver solver = new Solver();
solver.options().setSolver(SATFactory.DefaultSAT4J);
solver.options().setBitwidth(1);
//solver.options().setFlatten(1);
solver.options().setIntEncoding(Options.IntEncoding.TWOSCOMPLEMENT);
solver.options().setSymmetryBreaking(20);
solver.options().setSkolemDepth(0);
solver.options().setNoOverflow(true);
System.out.println("Solving...");
System.out.flush();
Solution sol = solver.solve(x10,bounds);
System.out.println(sol.toString());
}}
