/* The following code was generated by JFlex 1.4.1 on 1/31/15 4:47 PM */

// Alloy Analyzer 4 -- Copyright (c) 2006-2008, Felix Chang
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify,
// merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package edu.mit.csail.sdg.alloy4compiler.parser;

import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorSyntax;
import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.Version;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprConstant;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprVar;
import java.util.List;
import java_cup.runtime.*;

/** Autogenerated by JFlex 1.4.1 */


public final class CompLexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\100\1\102\1\70\1\0\1\102\1\101\16\100\4\0\1\102\1\1"+
    "\1\66\1\2\1\77\1\0\1\3\1\71\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\13\1\14\1\72\11\75\1\15\1\0\1\16\1\17"+
    "\1\12\1\0\1\20\1\74\1\46\4\74\2\77\1\62\11\77\1\65"+
    "\2\77\1\47\1\77\1\73\2\77\1\21\1\67\1\22\1\23\1\63"+
    "\1\0\1\30\1\31\1\35\1\40\1\41\1\61\1\45\1\51\1\44"+
    "\1\54\1\53\1\36\1\43\1\37\1\42\1\60\1\64\1\34\1\32"+
    "\1\33\1\52\1\57\1\50\1\55\1\56\1\77\1\24\1\25\1\26"+
    "\1\27\41\100\2\0\4\76\4\0\1\76\2\0\1\100\7\0\1\76"+
    "\4\0\1\76\5\0\27\76\1\0\37\76\1\0\u01ca\76\4\0\14\76"+
    "\16\0\5\76\7\0\1\76\1\0\1\76\21\0\160\100\5\76\1\0"+
    "\2\76\2\0\4\76\10\0\1\76\1\0\3\76\1\0\1\76\1\0"+
    "\24\76\1\0\123\76\1\0\213\76\1\0\5\100\2\0\236\76\11\0"+
    "\46\76\2\0\1\76\7\0\47\76\11\0\55\100\1\0\1\100\1\0"+
    "\2\100\1\0\2\100\1\0\1\100\10\0\33\76\5\0\3\76\15\0"+
    "\4\100\7\0\1\76\4\0\13\100\5\0\53\76\37\100\4\0\2\76"+
    "\1\100\143\76\1\0\1\76\10\100\1\0\6\100\2\76\2\100\1\0"+
    "\4\100\2\76\12\100\3\76\2\0\1\76\17\0\1\100\1\76\1\100"+
    "\36\76\33\100\2\0\131\76\13\100\1\76\16\0\12\100\41\76\11\100"+
    "\2\76\4\0\1\76\5\0\26\76\4\100\1\76\11\100\1\76\3\100"+
    "\1\76\5\100\22\0\31\76\3\100\244\0\4\100\66\76\3\100\1\76"+
    "\22\100\1\76\7\100\12\76\2\100\2\0\12\100\1\0\7\76\1\0"+
    "\7\76\1\0\3\100\1\0\10\76\2\0\2\76\2\0\26\76\1\0"+
    "\7\76\1\0\1\76\3\0\4\76\2\0\1\100\1\76\7\100\2\0"+
    "\2\100\2\0\3\100\1\76\10\0\1\100\4\0\2\76\1\0\3\76"+
    "\2\100\2\0\12\100\4\76\7\0\1\76\5\0\3\100\1\0\6\76"+
    "\4\0\2\76\2\0\26\76\1\0\7\76\1\0\2\76\1\0\2\76"+
    "\1\0\2\76\2\0\1\100\1\0\5\100\4\0\2\100\2\0\3\100"+
    "\3\0\1\100\7\0\4\76\1\0\1\76\7\0\14\100\3\76\1\100"+
    "\13\0\3\100\1\0\11\76\1\0\3\76\1\0\26\76\1\0\7\76"+
    "\1\0\2\76\1\0\5\76\2\0\1\100\1\76\10\100\1\0\3\100"+
    "\1\0\3\100\2\0\1\76\17\0\2\76\2\100\2\0\12\100\1\0"+
    "\1\76\17\0\3\100\1\0\10\76\2\0\2\76\2\0\26\76\1\0"+
    "\7\76\1\0\2\76\1\0\5\76\2\0\1\100\1\76\7\100\2\0"+
    "\2\100\2\0\3\100\10\0\2\100\4\0\2\76\1\0\3\76\2\100"+
    "\2\0\12\100\1\0\1\76\20\0\1\100\1\76\1\0\6\76\3\0"+
    "\3\76\1\0\4\76\3\0\2\76\1\0\1\76\1\0\2\76\3\0"+
    "\2\76\3\0\3\76\3\0\14\76\4\0\5\100\3\0\3\100\1\0"+
    "\4\100\2\0\1\76\6\0\1\100\16\0\12\100\11\0\1\76\7\0"+
    "\3\100\1\0\10\76\1\0\3\76\1\0\27\76\1\0\12\76\1\0"+
    "\5\76\3\0\1\76\7\100\1\0\3\100\1\0\4\100\7\0\2\100"+
    "\1\0\2\76\6\0\2\76\2\100\2\0\12\100\22\0\2\100\1\0"+
    "\10\76\1\0\3\76\1\0\27\76\1\0\12\76\1\0\5\76\2\0"+
    "\1\100\1\76\7\100\1\0\3\100\1\0\4\100\7\0\2\100\7\0"+
    "\1\76\1\0\2\76\2\100\2\0\12\100\1\0\2\76\17\0\2\100"+
    "\1\0\10\76\1\0\3\76\1\0\51\76\2\0\1\76\7\100\1\0"+
    "\3\100\1\0\4\100\1\76\10\0\1\100\10\0\2\76\2\100\2\0"+
    "\12\100\12\0\6\76\2\0\2\100\1\0\22\76\3\0\30\76\1\0"+
    "\11\76\1\0\1\76\2\0\7\76\3\0\1\100\4\0\6\100\1\0"+
    "\1\100\1\0\10\100\22\0\2\100\15\0\60\76\1\100\2\76\7\100"+
    "\4\0\10\76\10\100\1\0\12\100\47\0\2\76\1\0\1\76\2\0"+
    "\2\76\1\0\1\76\2\0\1\76\6\0\4\76\1\0\7\76\1\0"+
    "\3\76\1\0\1\76\1\0\1\76\2\0\2\76\1\0\4\76\1\100"+
    "\2\76\6\100\1\0\2\100\1\76\2\0\5\76\1\0\1\76\1\0"+
    "\6\100\2\0\12\100\2\0\2\76\42\0\1\76\27\0\2\100\6\0"+
    "\12\100\13\0\1\100\1\0\1\100\1\0\1\100\4\0\2\100\10\76"+
    "\1\0\44\76\4\0\24\100\1\0\2\100\5\76\13\100\1\0\44\100"+
    "\11\0\1\100\71\0\53\76\24\100\1\76\12\100\6\0\6\76\4\100"+
    "\4\76\3\100\1\76\3\100\2\76\7\100\3\76\4\100\15\76\14\100"+
    "\1\76\17\100\2\0\46\76\12\0\53\76\1\0\1\76\3\0\u0149\76"+
    "\1\0\4\76\2\0\7\76\1\0\1\76\1\0\4\76\2\0\51\76"+
    "\1\0\4\76\2\0\41\76\1\0\4\76\2\0\7\76\1\0\1\76"+
    "\1\0\4\76\2\0\17\76\1\0\71\76\1\0\4\76\2\0\103\76"+
    "\2\0\3\100\40\0\20\76\20\0\125\76\14\0\u026c\76\2\0\21\76"+
    "\1\0\32\76\5\0\113\76\3\0\3\76\17\0\15\76\1\0\4\76"+
    "\3\100\13\0\22\76\3\100\13\0\22\76\2\100\14\0\15\76\1\0"+
    "\3\76\1\0\2\100\14\0\64\76\40\100\3\0\1\76\3\0\2\76"+
    "\1\100\2\0\12\100\41\0\3\100\2\0\12\100\6\0\130\76\10\0"+
    "\51\76\1\100\1\76\5\0\106\76\12\0\35\76\3\0\14\100\4\0"+
    "\14\100\12\0\12\100\36\76\2\0\5\76\13\0\54\76\4\0\21\100"+
    "\7\76\2\100\6\0\12\100\46\0\27\76\5\100\4\0\65\76\12\100"+
    "\1\0\35\100\2\0\13\100\6\0\12\100\15\0\1\76\130\0\5\100"+
    "\57\76\21\100\7\76\4\0\12\100\21\0\11\100\14\0\3\100\36\76"+
    "\12\100\3\0\2\76\12\100\6\0\46\76\16\100\14\0\44\76\24\100"+
    "\10\0\12\100\3\0\3\76\12\100\44\76\122\0\3\100\1\0\25\100"+
    "\4\76\1\100\4\76\1\100\15\0\300\76\47\100\25\0\4\100\u0116\76"+
    "\2\0\6\76\2\0\46\76\2\0\6\76\2\0\10\76\1\0\1\76"+
    "\1\0\1\76\1\0\1\76\1\0\37\76\2\0\65\76\1\0\7\76"+
    "\1\0\1\76\3\0\3\76\1\0\7\76\3\0\4\76\2\0\6\76"+
    "\4\0\15\76\5\0\3\76\1\0\7\76\16\0\5\100\32\0\5\100"+
    "\20\0\2\76\23\0\1\76\13\0\5\100\5\0\6\100\1\0\1\76"+
    "\15\0\1\76\20\0\15\76\3\0\32\76\26\0\15\100\4\0\1\100"+
    "\3\0\14\100\21\0\1\76\4\0\1\76\2\0\12\76\1\0\1\76"+
    "\3\0\5\76\6\0\1\76\1\0\1\76\1\0\1\76\1\0\4\76"+
    "\1\0\13\76\2\0\4\76\5\0\5\76\4\0\1\76\21\0\51\76"+
    "\u0a77\0\57\76\1\0\57\76\1\0\205\76\6\0\4\76\3\100\16\0"+
    "\46\76\12\0\66\76\11\0\1\76\17\0\1\100\27\76\11\0\7\76"+
    "\1\0\7\76\1\0\7\76\1\0\7\76\1\0\7\76\1\0\7\76"+
    "\1\0\7\76\1\0\7\76\1\0\40\100\57\0\1\76\u01d5\0\3\76"+
    "\31\0\11\76\6\100\1\0\5\76\2\0\5\76\4\0\126\76\2\0"+
    "\2\100\2\0\3\76\1\0\132\76\1\0\4\76\5\0\51\76\3\0"+
    "\136\76\21\0\33\76\65\0\20\76\u0200\0\u19b6\76\112\0\u51cc\76\64\0"+
    "\u048d\76\103\0\56\76\2\0\u010d\76\3\0\20\76\12\100\2\76\24\0"+
    "\57\76\1\100\14\0\2\100\1\0\31\76\10\0\120\76\2\100\45\0"+
    "\11\76\2\0\147\76\2\0\4\76\1\0\2\76\16\0\12\76\120\0"+
    "\10\76\1\100\3\76\1\100\4\76\1\100\27\76\5\100\20\0\1\76"+
    "\7\0\64\76\14\0\2\100\62\76\21\100\13\0\12\100\6\0\22\100"+
    "\6\76\3\0\1\76\4\0\12\100\34\76\10\100\2\0\27\76\15\100"+
    "\14\0\35\76\3\0\4\100\57\76\16\100\16\0\1\76\12\100\46\0"+
    "\51\76\16\100\11\0\3\76\1\100\10\76\2\100\2\0\12\100\6\0"+
    "\27\76\3\0\1\76\1\100\4\0\60\76\1\100\1\76\3\100\2\76"+
    "\2\100\5\76\2\100\1\76\1\100\1\76\30\0\3\76\43\0\6\76"+
    "\2\0\6\76\2\0\6\76\11\0\7\76\1\0\7\76\221\0\43\76"+
    "\10\100\1\0\2\100\2\0\12\100\6\0\u2ba4\76\14\0\27\76\4\0"+
    "\61\76\u2104\0\u012e\76\2\0\76\76\2\0\152\76\46\0\7\76\14\0"+
    "\5\76\5\0\1\76\1\100\12\76\1\0\15\76\1\0\5\76\1\0"+
    "\1\76\1\0\2\76\1\0\2\76\1\0\154\76\41\0\u016b\76\22\0"+
    "\100\76\2\0\66\76\50\0\15\76\3\0\20\100\20\0\7\100\14\0"+
    "\2\76\30\0\3\76\31\0\1\76\6\0\5\76\1\0\207\76\2\0"+
    "\1\100\4\0\1\76\13\0\12\100\7\0\32\76\4\0\1\76\1\0"+
    "\32\76\13\0\131\76\3\0\6\76\2\0\6\76\2\0\6\76\2\0"+
    "\3\76\3\0\2\76\3\0\2\76\22\0\3\100\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\25\31\1\32\1\33\2\34\1\35\1\36\1\33"+
    "\1\37\1\40\1\41\1\0\1\42\1\43\1\44\1\45"+
    "\1\46\1\45\1\47\1\31\1\50\4\31\1\51\13\31"+
    "\1\52\4\31\1\47\4\31\1\53\16\31\1\54\2\0"+
    "\2\55\1\56\2\0\1\57\3\31\1\60\1\35\1\31"+
    "\1\61\1\62\1\63\1\31\1\64\1\65\1\31\1\66"+
    "\1\31\1\67\2\31\1\2\6\31\1\70\1\31\1\71"+
    "\3\31\1\72\2\31\1\57\11\31\1\73\1\74\1\75"+
    "\1\76\1\31\1\77\2\100\1\0\1\33\4\31\1\101"+
    "\1\102\1\31\1\103\1\31\1\104\1\105\1\106\1\107"+
    "\4\31\1\110\2\31\1\111\2\31\1\112\2\31\1\113"+
    "\1\114\1\115\1\31\1\116\3\31\1\117\1\31\1\120"+
    "\6\31\1\121\3\31\1\122\1\123\4\31\1\124\7\31"+
    "\1\125\1\126\4\31\1\127\1\31\1\130\3\31\1\131"+
    "\1\132\1\31\1\46\2\31\1\133\1\134\1\135\1\136"+
    "\1\105\4\31\1\137\1\114\1\70";

  private static int [] zzUnpackAction() {
    int [] result = new int[261];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\103\0\103\0\206\0\103\0\103\0\103"+
    "\0\311\0\103\0\u010c\0\u014f\0\103\0\u0192\0\u01d5\0\u0218"+
    "\0\u025b\0\103\0\103\0\103\0\103\0\103\0\u029e\0\103"+
    "\0\103\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed\0\u0430\0\u0473"+
    "\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2\0\u0605\0\u0648\0\u068b"+
    "\0\u06ce\0\u0711\0\u0754\0\u0797\0\u07da\0\u081d\0\u0860\0\103"+
    "\0\u08a3\0\u08e6\0\103\0\103\0\u0929\0\103\0\u096c\0\103"+
    "\0\u09af\0\103\0\103\0\103\0\u09f2\0\103\0\103\0\103"+
    "\0\u0a35\0\u0a78\0\u0abb\0\u0afe\0\u0b41\0\u0b84\0\u0648\0\u0bc7"+
    "\0\u0c0a\0\u0c4d\0\u0c90\0\u0cd3\0\u0d16\0\u0d59\0\u0d9c\0\u0ddf"+
    "\0\u0e22\0\u0e65\0\u0ea8\0\u0eeb\0\u0f2e\0\u0f71\0\u0fb4\0\u0648"+
    "\0\u0ff7\0\u103a\0\u107d\0\u10c0\0\u1103\0\u1146\0\u1189\0\u11cc"+
    "\0\u120f\0\u1252\0\u1295\0\u12d8\0\u131b\0\u135e\0\u13a1\0\u13e4"+
    "\0\u1427\0\u146a\0\u14ad\0\u14f0\0\u1533\0\u1576\0\u15b9\0\u15fc"+
    "\0\103\0\u163f\0\u1682\0\103\0\u16c5\0\u1708\0\u174b\0\u0648"+
    "\0\u0648\0\u178e\0\u0648\0\u0648\0\u0648\0\u17d1\0\u0648\0\u0648"+
    "\0\u1814\0\u0648\0\u1857\0\u0648\0\u189a\0\u18dd\0\u0648\0\u1920"+
    "\0\u1963\0\u19a6\0\u19e9\0\u1a2c\0\u1a6f\0\u1ab2\0\u1af5\0\u0648"+
    "\0\u1b38\0\u1b7b\0\u1bbe\0\u0648\0\u1c01\0\u1c44\0\u0648\0\u1c87"+
    "\0\u1cca\0\u1d0d\0\u1d50\0\u1d93\0\u1dd6\0\u1e19\0\u1e5c\0\u1e9f"+
    "\0\u0648\0\u0648\0\u0648\0\u0648\0\u1ee2\0\u14f0\0\u1576\0\u15fc"+
    "\0\u1f25\0\u163f\0\u1f68\0\u1fab\0\u1fee\0\u2031\0\u0648\0\u0648"+
    "\0\u2074\0\u0648\0\u20b7\0\u0648\0\u20fa\0\u0648\0\u0648\0\u213d"+
    "\0\u2180\0\u21c3\0\u2206\0\u0648\0\u2249\0\u228c\0\u0648\0\u22cf"+
    "\0\u2312\0\u0648\0\u2355\0\u2398\0\u0648\0\u23db\0\u0648\0\u241e"+
    "\0\u0648\0\u2461\0\u24a4\0\u24e7\0\u252a\0\u256d\0\u0648\0\u25b0"+
    "\0\u25f3\0\u2636\0\u2679\0\u26bc\0\u26ff\0\u0648\0\u2742\0\u2785"+
    "\0\u27c8\0\u0648\0\u0648\0\u280b\0\u284e\0\u2891\0\u28d4\0\u0648"+
    "\0\u2917\0\u295a\0\u299d\0\u29e0\0\u2a23\0\u2a66\0\u2aa9\0\u0648"+
    "\0\u0648\0\u2aec\0\u2b2f\0\u2b72\0\u2bb5\0\u0648\0\u2bf8\0\u0648"+
    "\0\u2c3b\0\u2c7e\0\u2cc1\0\u0648\0\u0648\0\u2d04\0\u0648\0\u2d47"+
    "\0\u2d8a\0\u0648\0\u0648\0\u0648\0\u0648\0\u0648\0\u2dcd\0\u2e10"+
    "\0\u2e53\0\u2e96\0\u0648\0\u0648\0\u0648";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[261];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\45\1\46\1\47\1\50\1\47"+
    "\1\51\1\47\1\52\5\47\1\53\1\54\1\55\2\47"+
    "\1\56\1\57\1\2\1\60\1\2\1\61\2\47\1\62"+
    "\2\47\1\2\2\60\106\0\1\63\106\0\1\64\104\0"+
    "\1\65\1\66\102\0\1\67\4\0\1\70\71\0\1\71"+
    "\5\0\1\65\100\0\1\72\2\0\1\15\102\0\1\73"+
    "\1\74\1\75\75\0\1\76\3\0\1\77\111\0\1\100"+
    "\105\0\1\47\1\101\1\102\1\103\2\47\1\104\1\105"+
    "\27\47\2\0\10\47\32\0\14\47\1\106\3\47\1\107"+
    "\1\47\1\110\14\47\2\0\10\47\32\0\11\47\1\111"+
    "\1\112\1\47\1\113\5\47\1\114\14\47\2\0\10\47"+
    "\32\0\21\47\1\115\15\47\2\0\10\47\32\0\22\47"+
    "\1\116\14\47\2\0\10\47\32\0\21\47\1\117\15\47"+
    "\2\0\10\47\32\0\11\47\1\120\1\121\1\47\1\122"+
    "\22\47\2\0\10\47\32\0\12\47\1\123\24\47\2\0"+
    "\10\47\32\0\14\47\1\124\22\47\2\0\10\47\32\0"+
    "\6\47\1\125\1\126\15\47\1\127\11\47\2\0\10\47"+
    "\32\0\4\47\1\130\2\47\1\131\20\47\1\132\1\133"+
    "\5\47\2\0\10\47\32\0\12\47\1\134\24\47\2\0"+
    "\10\47\32\0\7\47\1\135\1\136\2\47\1\137\15\47"+
    "\1\140\5\47\2\0\10\47\32\0\37\47\2\0\10\47"+
    "\32\0\14\47\1\141\22\47\2\0\10\47\32\0\21\47"+
    "\1\142\15\47\2\0\10\47\32\0\7\47\1\143\27\47"+
    "\2\0\10\47\32\0\1\144\3\47\1\145\32\47\2\0"+
    "\10\47\32\0\1\146\11\47\1\147\1\47\1\150\5\47"+
    "\1\151\14\47\2\0\10\47\32\0\7\47\1\152\27\47"+
    "\2\0\10\47\32\0\3\47\1\153\33\47\2\0\10\47"+
    "\2\0\66\57\1\154\1\155\13\57\2\0\1\156\25\0"+
    "\25\157\1\160\11\157\2\0\1\157\1\62\1\160\1\157"+
    "\1\62\1\0\1\157\33\0\37\157\2\0\1\157\1\62"+
    "\2\157\1\62\1\0\1\157\3\0\70\65\1\60\10\65"+
    "\1\60\1\65\12\0\1\161\70\0\6\162\1\163\74\162"+
    "\12\0\1\164\120\0\2\47\1\165\34\47\2\0\10\47"+
    "\32\0\2\47\1\166\34\47\2\0\10\47\32\0\12\47"+
    "\1\167\24\47\2\0\10\47\32\0\6\47\1\170\30\47"+
    "\2\0\10\47\32\0\10\47\1\171\26\47\2\0\10\47"+
    "\32\0\3\47\1\172\33\47\2\0\10\47\32\0\3\47"+
    "\1\173\33\47\2\0\10\47\32\0\3\47\1\174\30\47"+
    "\1\175\2\47\2\0\10\47\32\0\13\47\1\176\23\47"+
    "\2\0\10\47\32\0\15\47\1\177\21\47\2\0\10\47"+
    "\32\0\13\47\1\200\23\47\2\0\10\47\32\0\14\47"+
    "\1\201\22\47\2\0\10\47\32\0\7\47\1\202\27\47"+
    "\2\0\10\47\32\0\11\47\1\203\25\47\2\0\10\47"+
    "\32\0\3\47\1\204\33\47\2\0\10\47\32\0\7\47"+
    "\1\205\27\47\2\0\10\47\32\0\3\47\1\206\33\47"+
    "\2\0\10\47\32\0\3\47\1\207\3\47\1\210\27\47"+
    "\2\0\10\47\32\0\2\47\1\211\34\47\2\0\10\47"+
    "\32\0\2\47\1\212\34\47\2\0\10\47\32\0\22\47"+
    "\1\213\14\47\2\0\10\47\32\0\1\214\2\47\1\215"+
    "\15\47\1\216\6\47\1\217\6\47\2\0\10\47\32\0"+
    "\11\47\1\220\25\47\2\0\10\47\32\0\11\47\1\221"+
    "\25\47\2\0\10\47\32\0\33\47\1\222\3\47\2\0"+
    "\10\47\32\0\10\47\1\223\26\47\2\0\10\47\32\0"+
    "\3\47\1\224\33\47\2\0\10\47\32\0\11\47\1\225"+
    "\25\47\2\0\10\47\32\0\30\47\1\226\6\47\2\0"+
    "\10\47\32\0\31\47\1\227\5\47\2\0\10\47\32\0"+
    "\3\47\1\230\33\47\2\0\10\47\32\0\11\47\1\231"+
    "\2\47\1\232\22\47\2\0\10\47\32\0\3\47\1\233"+
    "\10\47\1\234\22\47\2\0\10\47\32\0\4\47\1\235"+
    "\32\47\2\0\10\47\32\0\11\47\1\236\2\47\1\237"+
    "\22\47\2\0\10\47\32\0\5\47\1\240\31\47\2\0"+
    "\10\47\32\0\4\47\1\241\32\47\2\0\10\47\32\0"+
    "\25\47\1\242\11\47\2\0\10\47\32\0\7\47\1\243"+
    "\27\47\2\0\10\47\32\0\3\47\1\244\33\47\2\0"+
    "\10\47\32\0\4\47\1\245\32\47\2\0\10\47\32\0"+
    "\37\246\2\0\5\246\1\0\1\246\3\0\70\57\1\0"+
    "\12\57\30\0\2\247\3\0\1\247\2\0\2\247\4\0"+
    "\1\247\12\0\1\247\10\0\1\247\1\0\2\247\35\0"+
    "\37\157\2\0\5\157\1\0\1\157\33\0\2\250\3\157"+
    "\1\250\2\157\2\250\4\157\1\250\12\157\1\250\5\157"+
    "\2\0\1\157\1\250\1\157\2\250\1\0\1\157\3\0"+
    "\6\162\1\251\102\162\1\251\5\162\1\252\66\162\30\0"+
    "\3\47\1\253\33\47\2\0\10\47\32\0\11\47\1\254"+
    "\25\47\2\0\10\47\32\0\13\47\1\255\23\47\2\0"+
    "\10\47\32\0\20\47\1\256\16\47\2\0\10\47\32\0"+
    "\11\47\1\257\25\47\2\0\10\47\32\0\2\47\1\260"+
    "\34\47\2\0\10\47\32\0\5\47\1\261\31\47\2\0"+
    "\10\47\32\0\11\47\1\262\25\47\2\0\10\47\32\0"+
    "\11\47\1\263\25\47\2\0\10\47\32\0\11\47\1\264"+
    "\25\47\2\0\10\47\32\0\24\47\1\265\12\47\2\0"+
    "\10\47\32\0\11\47\1\266\25\47\2\0\10\47\32\0"+
    "\13\47\1\267\23\47\2\0\10\47\32\0\5\47\1\270"+
    "\31\47\2\0\10\47\32\0\11\47\1\271\25\47\2\0"+
    "\10\47\32\0\1\272\36\47\2\0\10\47\32\0\11\47"+
    "\1\273\25\47\2\0\10\47\32\0\7\47\1\274\27\47"+
    "\2\0\10\47\32\0\1\47\1\275\35\47\2\0\10\47"+
    "\32\0\22\47\1\276\14\47\2\0\10\47\32\0\7\47"+
    "\1\277\27\47\2\0\10\47\32\0\6\47\1\300\30\47"+
    "\2\0\10\47\32\0\17\47\1\301\17\47\2\0\10\47"+
    "\32\0\7\47\1\302\27\47\2\0\10\47\32\0\6\47"+
    "\1\303\30\47\2\0\10\47\32\0\14\47\1\304\22\47"+
    "\2\0\10\47\32\0\27\47\1\305\7\47\2\0\10\47"+
    "\32\0\3\47\1\306\33\47\2\0\10\47\32\0\10\47"+
    "\1\307\26\47\2\0\10\47\32\0\27\47\1\310\7\47"+
    "\2\0\10\47\32\0\3\47\1\311\33\47\2\0\10\47"+
    "\32\0\14\47\1\312\22\47\2\0\10\47\2\0\6\162"+
    "\1\251\5\162\1\60\66\162\30\0\4\47\1\313\32\47"+
    "\2\0\10\47\32\0\4\47\1\314\32\47\2\0\10\47"+
    "\32\0\2\47\1\315\34\47\2\0\10\47\32\0\14\47"+
    "\1\316\22\47\2\0\10\47\32\0\23\47\1\317\13\47"+
    "\2\0\10\47\32\0\4\47\1\320\32\47\2\0\10\47"+
    "\32\0\12\47\1\321\24\47\2\0\10\47\32\0\3\47"+
    "\1\322\33\47\2\0\10\47\32\0\7\47\1\323\27\47"+
    "\2\0\10\47\32\0\22\47\1\324\14\47\2\0\10\47"+
    "\32\0\5\47\1\325\31\47\2\0\10\47\32\0\20\47"+
    "\1\326\16\47\2\0\10\47\32\0\6\47\1\327\30\47"+
    "\2\0\10\47\32\0\14\47\1\330\22\47\2\0\10\47"+
    "\32\0\11\47\1\331\25\47\2\0\10\47\32\0\11\47"+
    "\1\332\25\47\2\0\10\47\32\0\6\47\1\333\30\47"+
    "\2\0\10\47\32\0\14\47\1\334\22\47\2\0\10\47"+
    "\32\0\1\335\36\47\2\0\10\47\32\0\7\47\1\336"+
    "\27\47\2\0\10\47\32\0\1\337\36\47\2\0\10\47"+
    "\32\0\3\47\1\340\33\47\2\0\10\47\32\0\14\47"+
    "\1\341\22\47\2\0\10\47\32\0\10\47\1\342\26\47"+
    "\2\0\10\47\32\0\1\343\36\47\2\0\10\47\32\0"+
    "\14\47\1\344\22\47\2\0\10\47\32\0\6\47\1\345"+
    "\30\47\2\0\10\47\32\0\10\47\1\346\26\47\2\0"+
    "\10\47\32\0\2\47\1\347\34\47\2\0\10\47\32\0"+
    "\3\47\1\350\33\47\2\0\10\47\32\0\11\47\1\351"+
    "\25\47\2\0\10\47\32\0\11\47\1\352\25\47\2\0"+
    "\10\47\32\0\5\47\1\353\31\47\2\0\10\47\32\0"+
    "\3\47\1\354\33\47\2\0\10\47\32\0\3\47\1\355"+
    "\33\47\2\0\10\47\32\0\15\47\1\356\21\47\2\0"+
    "\10\47\32\0\5\47\1\357\31\47\2\0\10\47\32\0"+
    "\15\47\1\360\21\47\2\0\10\47\32\0\3\47\1\361"+
    "\33\47\2\0\10\47\32\0\6\47\1\362\30\47\2\0"+
    "\10\47\32\0\7\47\1\363\27\47\2\0\10\47\32\0"+
    "\26\47\1\364\10\47\2\0\10\47\32\0\2\47\1\365"+
    "\34\47\2\0\10\47\32\0\3\47\1\366\33\47\2\0"+
    "\10\47\32\0\2\47\1\367\34\47\2\0\10\47\32\0"+
    "\3\47\1\370\33\47\2\0\10\47\32\0\14\47\1\371"+
    "\22\47\2\0\10\47\32\0\11\47\1\372\25\47\2\0"+
    "\10\47\32\0\3\47\1\373\33\47\2\0\10\47\32\0"+
    "\21\47\1\374\15\47\2\0\10\47\32\0\2\47\1\375"+
    "\34\47\2\0\10\47\32\0\3\47\1\376\33\47\2\0"+
    "\10\47\32\0\14\47\1\377\22\47\2\0\10\47\32\0"+
    "\12\47\1\u0100\24\47\2\0\10\47\32\0\12\47\1\u0101"+
    "\24\47\2\0\10\47\32\0\27\47\1\u0102\7\47\2\0"+
    "\10\47\32\0\4\47\1\u0103\32\47\2\0\10\47\32\0"+
    "\7\47\1\u0104\27\47\2\0\10\47\32\0\11\47\1\u0105"+
    "\25\47\2\0\10\47\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[11993];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\3\11\1\1\3\11\1\1\1\11\2\1\1\11"+
    "\4\1\5\11\1\1\2\11\26\1\1\11\2\1\2\11"+
    "\1\1\1\11\1\1\1\11\1\0\3\11\1\1\3\11"+
    "\54\1\2\0\2\1\1\11\2\0\1\11\64\1\1\0"+
    "\134\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[261];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
 public String alloy_filename="";
 public int alloy_lineoffset=0; // If not zero, it is added to the current LINE NUMBER
 public List<Object> alloy_seenDollar;
 public CompModule alloy_module;
 private final Pos alloy_here(String txt) {
    return new Pos(alloy_filename,yycolumn+1,yyline+1+alloy_lineoffset,yycolumn+txt.length(),yyline+1);
 }
 private final Symbol alloy_sym(String txt, int type) {
    Pos p = alloy_here(txt); return new Symbol(type, p, p);
 }
 private final Symbol alloy_string(String txt) throws Err {
    Pos p = alloy_here(txt);
    if (!Version.experimental) throw new ErrorSyntax(p, "String literal is not currently supported.");
    StringBuilder sb = new StringBuilder(txt.length());
    for(int i=0; i<txt.length(); i++) {
       char c = txt.charAt(i);
       if (c=='\r' || c=='\n') throw new ErrorSyntax(p, "String literal cannot span multiple lines; use \\n instead.");
       if (c=='\\') {
          i++;
          if (i>=txt.length()) throw new ErrorSyntax(p, "String literal cannot end with a single \\");
          c = txt.charAt(i);
          if (c=='n') c='\n'; else if (c!='\'' && c!='\"' && c!='\\') throw new ErrorSyntax(p, "String literal currenty only supports\nfour escape sequences: \\\\, \\n, \\\', and \\\"");
       }
       sb.append(c);
    }
    txt = sb.toString();
    if (txt.length()==2) throw new ErrorSyntax(p, "Empty string is not allowed; try rewriting your model to use an empty set instead.");
    return new Symbol(CompSym.STR, p, ExprConstant.Op.STRING.make(p, txt));
 }
 private final Symbol alloy_id(String txt) throws Err {
    Pos p=alloy_here(txt);
    if (alloy_seenDollar.size()==0 && txt.indexOf('$')>=0) alloy_seenDollar.add(null);
    return new Symbol(CompSym.ID, p, ExprVar.make(p,txt));
 }
 private static final long maxint = new java.math.BigInteger(Integer.toString(Integer.MAX_VALUE), 10).longValue();
 private static final long maxuint = new java.math.BigInteger("FFFFFFFF", 16).longValue();
 private final Symbol alloy_hexnum(String txt) throws Err {
    Pos p=alloy_here(txt);
    long val = new java.math.BigInteger(txt, 16).longValue();
    if (val <= maxint)
      return decimalStringToNumberSym(p, Long.toString(val));
    else if (val <= maxuint) 
      return decimalStringToNumberSym(p, Long.toString(val-(maxuint+1)));
    else
      throw new ErrorSyntax(p, "The number "+txt+" is too large to be stored in a Java integer");
 }
 private final Symbol alloy_num(String txt) throws Err {
    Pos p=alloy_here(txt);
    return decimalStringToNumberSym(p, txt);    
 }
 private final Symbol decimalStringToNumberSym(Pos p, String txt) throws Err {
   try {
       int n = Integer.parseInt(txt);
       return new Symbol(CompSym.NUMBER, p, ExprConstant.Op.NUMBER.make(p, n));
   } catch(NumberFormatException ex) {
       throw new ErrorSyntax(p, "The number "+txt+" is too large to be stored in a Java integer");
   }
 }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CompLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CompLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2236) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException, Err {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 4: 
          { return alloy_sym(yytext(), CompSym.AMPERSAND   );
          }
        case 96: break;
        case 81: 
          { return alloy_sym(yytext(), CompSym.OF_BW       );
          }
        case 97: break;
        case 51: 
          { return alloy_sym(yytext(), CompSym.SEQ         );
          }
        case 98: break;
        case 38: 
          { return alloy_sym(yytext(), CompSym.IMPLIES     );
          }
        case 99: break;
        case 23: 
          { return alloy_sym(yytext(), CompSym.RBRACE      );
          }
        case 100: break;
        case 89: 
          { return alloy_sym(yytext(), CompSym.EXACTLY     );
          }
        case 101: break;
        case 54: 
          { return alloy_sym(yytext(), CompSym.RUN         );
          }
        case 102: break;
        case 36: 
          { return alloy_sym(yytext(), CompSym.SHL         );
          }
        case 103: break;
        case 35: 
          { return alloy_sym(yytext(), CompSym.DOMAIN      );
          }
        case 104: break;
        case 62: 
          { return alloy_sym(yytext(), CompSym.SIGINT      );
          }
        case 105: break;
        case 24: 
          { return alloy_sym(yytext(), CompSym.TILDE       );
          }
        case 106: break;
        case 21: 
          { return alloy_sym(yytext(), CompSym.LBRACE      );
          }
        case 107: break;
        case 7: 
          { return alloy_sym(yytext(), CompSym.STAR        );
          }
        case 108: break;
        case 30: 
          { return alloy_sym(yytext(), CompSym.PLUSPLUS    );
          }
        case 109: break;
        case 61: 
          { return alloy_sym(yytext(), CompSym.FUN         );
          }
        case 110: break;
        case 87: 
          { return alloy_sym(yytext(), CompSym.STRING      );
          }
        case 111: break;
        case 56: 
          { return alloy_sym(yytext(), CompSym.EXH         );
          }
        case 112: break;
        case 58: 
          { return alloy_sym(yytext(), CompSym.INT         );
          }
        case 113: break;
        case 52: 
          { return alloy_sym(yytext(), CompSym.SIG         );
          }
        case 114: break;
        case 77: 
          { return alloy_sym(yytext(), CompSym.PRED        );
          }
        case 115: break;
        case 25: 
          { return alloy_id  (yytext());
          }
        case 116: break;
        case 67: 
          { return alloy_sym(yytext(), CompSym.LONE        );
          }
        case 117: break;
        case 42: 
          { return alloy_sym(yytext(), CompSym.NO          );
          }
        case 118: break;
        case 9: 
          { return alloy_sym(yytext(), CompSym.COMMA       );
          }
        case 119: break;
        case 40: 
          { return alloy_sym(yytext(), CompSym.AS          );
          }
        case 120: break;
        case 66: 
          { return alloy_sym(yytext(), CompSym.THIS        );
          }
        case 121: break;
        case 95: 
          { return alloy_sym(yytext(), CompSym.BITVECTOR   );
          }
        case 122: break;
        case 13: 
          { return alloy_sym(yytext(), CompSym.SLASH       );
          }
        case 123: break;
        case 49: 
          { return alloy_sym(yytext(), CompSym.BUT         );
          }
        case 124: break;
        case 44: 
          { return alloy_string(yytext());
          }
        case 125: break;
        case 69: 
          { return alloy_sym(yytext(), CompSym.DISJ        );
          }
        case 126: break;
        case 32: 
          { return alloy_sym(yytext(), CompSym.SHA         );
          }
        case 127: break;
        case 39: 
          { return alloy_sym(yytext(), CompSym.OR          );
          }
        case 128: break;
        case 46: 
          { return alloy_sym(yytext(), CompSym.SHR         );
          }
        case 129: break;
        case 91: 
          { return alloy_sym(yytext(), CompSym.PRIVATE     );
          }
        case 130: break;
        case 31: 
          { return alloy_sym(yytext(), CompSym.ARROW       );
          }
        case 131: break;
        case 33: 
          { return alloy_sym(yytext(), CompSym.GTE         );
          }
        case 132: break;
        case 20: 
          { return alloy_sym(yytext(), CompSym.CARET       );
          }
        case 133: break;
        case 47: 
          { return alloy_sym(yytext(), CompSym.IFF         );
          }
        case 134: break;
        case 70: 
          { return alloy_sym(yytext(), CompSym.ELSE        );
          }
        case 135: break;
        case 94: 
          { return alloy_sym(yytext(), CompSym.LITERALS    );
          }
        case 136: break;
        case 3: 
          { return alloy_sym(yytext(), CompSym.HASH        );
          }
        case 137: break;
        case 12: 
          { return alloy_sym(yytext(), CompSym.DOT         );
          }
        case 138: break;
        case 22: 
          { return alloy_sym(yytext(), CompSym.BAR         );
          }
        case 139: break;
        case 85: 
          { return alloy_sym(yytext(), CompSym.EXPECT      );
          }
        case 140: break;
        case 82: 
          { return alloy_sym(yytext(), CompSym.WHILE       );
          }
        case 141: break;
        case 8: 
          { return alloy_sym(yytext(), CompSym.PLUS        );
          }
        case 142: break;
        case 83: 
          { return alloy_sym(yytext(), CompSym.UNTIL       );
          }
        case 143: break;
        case 37: 
          { return alloy_sym(yytext(), CompSym.LTE         );
          }
        case 144: break;
        case 57: 
          { return alloy_sym(yytext(), CompSym.ONE         );
          }
        case 145: break;
        case 72: 
          { return alloy_sym(yytext(), CompSym.OPEN        );
          }
        case 146: break;
        case 11: 
          { return alloy_sym(yytext(), CompSym.GT          );
          }
        case 147: break;
        case 86: 
          { return alloy_sym(yytext(), CompSym.MODULE      );
          }
        case 148: break;
        case 14: 
          { return alloy_sym(yytext(), CompSym.COLON       );
          }
        case 149: break;
        case 53: 
          { return alloy_sym(yytext(), CompSym.SUM         );
          }
        case 150: break;
        case 79: 
          { return alloy_sym(yytext(), CompSym.ATOMS       );
          }
        case 151: break;
        case 76: 
          { return alloy_sym(yytext(), CompSym.PART        );
          }
        case 152: break;
        case 60: 
          { return alloy_sym(yytext(), CompSym.FIX         );
          }
        case 153: break;
        case 16: 
          { return alloy_sym(yytext(), CompSym.EQUALS      );
          }
        case 154: break;
        case 90: 
          { return alloy_sym(yytext(), CompSym.EXTENDS     );
          }
        case 155: break;
        case 1: 
          { throw new ErrorSyntax(alloy_here(" "), "Syntax error at the "+yytext()+" character.");
          }
        case 156: break;
        case 26: 
          { throw new ErrorSyntax(alloy_here(yytext()),"String literal is missing its closing \" character");
          }
        case 157: break;
        case 59: 
          { return alloy_sym(yytext(), CompSym.FOR         );
          }
        case 158: break;
        case 28: 
          { return alloy_num (yytext());
          }
        case 159: break;
        case 73: 
          { return alloy_sym(yytext(), CompSym.IDEN        );
          }
        case 160: break;
        case 15: 
          { return alloy_sym(yytext(), CompSym.LT          );
          }
        case 161: break;
        case 41: 
          { return alloy_sym(yytext(), CompSym.BW          );
          }
        case 162: break;
        case 17: 
          { return alloy_sym(yytext(), CompSym.AT          );
          }
        case 163: break;
        case 34: 
          { return alloy_sym(yytext(), CompSym.RANGE       );
          }
        case 164: break;
        case 88: 
          { return alloy_sym(yytext(), CompSym.ATOM        );
          }
        case 165: break;
        case 75: 
          { return alloy_sym(yytext(), CompSym.UNIV        );
          }
        case 166: break;
        case 2: 
          { return alloy_sym(yytext(), CompSym.NOT         );
          }
        case 167: break;
        case 64: 
          { String txt = yytext(); return alloy_hexnum(txt.substring(2, txt.length()));
          }
        case 168: break;
        case 50: 
          { return alloy_sym(yytext(), CompSym.SET         );
          }
        case 169: break;
        case 6: 
          { return alloy_sym(yytext(), CompSym.RPAREN      );
          }
        case 170: break;
        case 43: 
          { return alloy_sym(yytext(), CompSym.IN          );
          }
        case 171: break;
        case 80: 
          { return alloy_sym(yytext(), CompSym.CHECK       );
          }
        case 172: break;
        case 93: 
          { return alloy_sym(yytext(), CompSym.BITWIDTH    );
          }
        case 173: break;
        case 29: 
          { return alloy_sym(yytext(), CompSym.AND         );
          }
        case 174: break;
        case 65: 
          { return alloy_sym(yytext(), CompSym.SOME        );
          }
        case 175: break;
        case 78: 
          { return alloy_sym(yytext(), CompSym.FACT        );
          }
        case 176: break;
        case 10: 
          { return alloy_sym(yytext(), CompSym.MINUS       );
          }
        case 177: break;
        case 5: 
          { return alloy_sym(yytext(), CompSym.LPAREN      );
          }
        case 178: break;
        case 74: 
          { return alloy_sym(yytext(), CompSym.WHEN        );
          }
        case 179: break;
        case 68: 
          { return alloy_sym(yytext(), CompSym.NONE        );
          }
        case 180: break;
        case 18: 
          { return alloy_sym(yytext(), CompSym.LBRACKET    );
          }
        case 181: break;
        case 19: 
          { return alloy_sym(yytext(), CompSym.RBRACKET    );
          }
        case 182: break;
        case 71: 
          { return alloy_sym(yytext(), CompSym.ENUM        );
          }
        case 183: break;
        case 48: 
          { return alloy_sym(yytext(), CompSym.ALL         );
          }
        case 184: break;
        case 92: 
          { return alloy_sym(yytext(), CompSym.ABSTRACT    );
          }
        case 185: break;
        case 84: 
          { return alloy_sym(yytext(), CompSym.ASSERT      );
          }
        case 186: break;
        case 63: 
          { throw new ErrorSyntax(alloy_here(yytext()),"String literal cannot be followed by a legal identifier character.");
          }
        case 187: break;
        case 55: 
          { return alloy_sym(yytext(), CompSym.LET         );
          }
        case 188: break;
        case 27: 
          { 
          }
        case 189: break;
        case 45: 
          { throw new ErrorSyntax(alloy_here(yytext()),"Name cannot start with a number.");
          }
        case 190: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {   return new Symbol(CompSym.EOF, alloy_here(" "), alloy_here(" "));
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
